# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Metric(Model):
    """A set of metric values in a time range.

    :param id: the id, resourceId, of the metric.
    :type id: str
    :param type: the resource type of the metric resource.
    :type type: str
    :param name: the name and the display name of the metric, i.e. it is
     localizable string.
    :type name: :class:`LocalizableString
     <azure.monitor.models.LocalizableString>`
    :param unit: the unit of the metric. Possible values include: 'Count',
     'Bytes', 'Seconds', 'CountPerSecond', 'BytesPerSecond', 'Percent',
     'MilliSeconds'
    :type unit: str or :class:`Unit <azure.monitor.models.Unit>`
    :param data: Array of data points representing the metric values.
    :type data: list of :class:`MetricValue
     <azure.monitor.models.MetricValue>`
    """

    _validation = {
        'name': {'required': True},
        'unit': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'unit': {'key': 'unit', 'type': 'Unit'},
        'data': {'key': 'data', 'type': '[MetricValue]'},
    }

    def __init__(self, name, unit, data, id=None, type=None):
        self.id = id
        self.type = type
        self.name = name
        self.unit = unit
        self.data = data
