package net.noderunner.amazon.s3;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.junit.Test;

public class BucketTest {

	@Test
	public void testBucket() {
		Bucket bucket = new Bucket("name");
		assertEquals(true, bucket.specified());
		Date d = new Date();
		bucket.setCreationDate(d);
		assertEquals(d, bucket.getCreationDate());
		
		assertEquals(true, Bucket.validateBucketName("0Az._A", CallingFormat.PATH));
		assertEquals(false, Bucket.validateBucketName("0A#._A", CallingFormat.PATH));
		assertEquals(false, Bucket.validateBucketName("F", CallingFormat.PATH));
		assertEquals(false, Bucket.validateBucketName(null, CallingFormat.PATH));
		
		assertEquals(false, Bucket.validateBucketName("0Az._A", CallingFormat.SUBDOMAIN));
		assertEquals(true, Bucket.validateBucketName("foo.00", CallingFormat.SUBDOMAIN));
		assertEquals(true, Bucket.validateBucketName("jo.jo.jo", CallingFormat.SUBDOMAIN));
		assertEquals(false, Bucket.validateBucketName("0A#._A", CallingFormat.SUBDOMAIN));
		assertEquals(false, Bucket.validateBucketName("F", CallingFormat.SUBDOMAIN));
		assertEquals(false, Bucket.validateBucketName(null, CallingFormat.SUBDOMAIN));
	}

}
