.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP TEXT SEARCH CONFIGURATION" "" "2011-04-15" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TEXT SEARCH CONFIGURATION \- remove a text search configuration

.SH SYNOPSIS
.sp
.nf
DROP TEXT SEARCH CONFIGURATION [ IF EXISTS ] \fIname\fR [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP TEXT SEARCH CONFIGURATION\fR drops an existing text
search configuration. To execute this command you must be the owner of the
configuration.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the text search configuration does not exist.
A notice is issued in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing text search
configuration.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the text search configuration.
.TP
\fBRESTRICT\fR
Refuse to drop the text search configuration if any objects depend on it.
This is the default.
.SH "EXAMPLES"
.PP
Remove the text search configuration my_english:
.sp
.nf
DROP TEXT SEARCH CONFIGURATION my_english;
.sp
.fi
This command will not succeed if there are any existing indexes
that reference the configuration in \fBto_tsvector\fR calls.
Add CASCADE to
drop such indexes along with the text search configuration.
.SH "COMPATIBILITY"
.PP
There is no \fBDROP TEXT SEARCH CONFIGURATION\fR statement in
the SQL standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH CONFIGURATION [\fBalter_text_search_configuration\fR(l)], CREATE TEXT SEARCH CONFIGURATION [\fBcreate_text_search_configuration\fR(l)]
