/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_CONTINUE = 265,
     SQL_COUNT = 266,
     SQL_CURRENT = 267,
     SQL_DATA = 268,
     SQL_DATETIME_INTERVAL_CODE = 269,
     SQL_DATETIME_INTERVAL_PRECISION = 270,
     SQL_DESCRIBE = 271,
     SQL_DESCRIPTOR = 272,
     SQL_DISCONNECT = 273,
     SQL_ENUM = 274,
     SQL_FOUND = 275,
     SQL_FREE = 276,
     SQL_GO = 277,
     SQL_GOTO = 278,
     SQL_IDENTIFIED = 279,
     SQL_INDICATOR = 280,
     SQL_KEY_MEMBER = 281,
     SQL_LENGTH = 282,
     SQL_LONG = 283,
     SQL_NAME = 284,
     SQL_NULLABLE = 285,
     SQL_OCTET_LENGTH = 286,
     SQL_OPEN = 287,
     SQL_OUTPUT = 288,
     SQL_REFERENCE = 289,
     SQL_RETURNED_LENGTH = 290,
     SQL_RETURNED_OCTET_LENGTH = 291,
     SQL_SCALE = 292,
     SQL_SECTION = 293,
     SQL_SHORT = 294,
     SQL_SIGNED = 295,
     SQL_SQL = 296,
     SQL_SQLERROR = 297,
     SQL_SQLPRINT = 298,
     SQL_SQLWARNING = 299,
     SQL_START = 300,
     SQL_STOP = 301,
     SQL_STRUCT = 302,
     SQL_UNSIGNED = 303,
     SQL_VALUE = 304,
     SQL_VAR = 305,
     SQL_WHENEVER = 306,
     S_ADD = 307,
     S_AND = 308,
     S_ANYTHING = 309,
     S_AUTO = 310,
     S_CONST = 311,
     S_DEC = 312,
     S_DIV = 313,
     S_DOTPOINT = 314,
     S_EQUAL = 315,
     S_EXTERN = 316,
     S_INC = 317,
     S_LSHIFT = 318,
     S_MEMPOINT = 319,
     S_MEMBER = 320,
     S_MOD = 321,
     S_MUL = 322,
     S_NEQUAL = 323,
     S_OR = 324,
     S_REGISTER = 325,
     S_RSHIFT = 326,
     S_STATIC = 327,
     S_SUB = 328,
     S_VOLATILE = 329,
     S_TYPEDEF = 330,
     TYPECAST = 331,
     ABORT_P = 332,
     ABSOLUTE_P = 333,
     ACCESS = 334,
     ACTION = 335,
     ADD = 336,
     ADMIN = 337,
     AFTER = 338,
     AGGREGATE = 339,
     ALL = 340,
     ALSO = 341,
     ALTER = 342,
     ANALYSE = 343,
     ANALYZE = 344,
     AND = 345,
     ANY = 346,
     ARRAY = 347,
     AS = 348,
     ASC = 349,
     ASSERTION = 350,
     ASSIGNMENT = 351,
     ASYMMETRIC = 352,
     AT = 353,
     AUTHORIZATION = 354,
     BACKWARD = 355,
     BEFORE = 356,
     BEGIN_P = 357,
     BETWEEN = 358,
     BIGINT = 359,
     BINARY = 360,
     BIT = 361,
     BOOLEAN_P = 362,
     BOTH = 363,
     BY = 364,
     CACHE = 365,
     CALLED = 366,
     CASCADE = 367,
     CASE = 368,
     CAST = 369,
     CHAIN = 370,
     CHAR_P = 371,
     CHARACTER = 372,
     CHARACTERISTICS = 373,
     CHECK = 374,
     CHECKPOINT = 375,
     CLASS = 376,
     CLOSE = 377,
     CLUSTER = 378,
     COALESCE = 379,
     COLLATE = 380,
     COLUMN = 381,
     COMMENT = 382,
     COMMIT = 383,
     COMMITTED = 384,
     CONNECTION = 385,
     CONSTRAINT = 386,
     CONSTRAINTS = 387,
     CONVERSION_P = 388,
     CONVERT = 389,
     COPY = 390,
     CREATE = 391,
     CREATEDB = 392,
     CREATEROLE = 393,
     CREATEUSER = 394,
     CROSS = 395,
     CSV = 396,
     CURRENT_DATE = 397,
     CURRENT_ROLE = 398,
     CURRENT_TIME = 399,
     CURRENT_TIMESTAMP = 400,
     CURRENT_USER = 401,
     CURSOR = 402,
     CYCLE = 403,
     DATABASE = 404,
     DAY_P = 405,
     DEALLOCATE = 406,
     DEC = 407,
     DECIMAL_P = 408,
     DECLARE = 409,
     DEFAULT = 410,
     DEFAULTS = 411,
     DEFERRABLE = 412,
     DEFERRED = 413,
     DEFINER = 414,
     DELETE_P = 415,
     DELIMITER = 416,
     DELIMITERS = 417,
     DESC = 418,
     DISABLE_P = 419,
     DISTINCT = 420,
     DO = 421,
     DOMAIN_P = 422,
     DOUBLE_P = 423,
     DROP = 424,
     EACH = 425,
     ELSE = 426,
     ENABLE_P = 427,
     ENCODING = 428,
     ENCRYPTED = 429,
     END_P = 430,
     ESCAPE = 431,
     EXCEPT = 432,
     EXCLUSIVE = 433,
     EXCLUDING = 434,
     EXECUTE = 435,
     EXISTS = 436,
     EXPLAIN = 437,
     EXTERNAL = 438,
     EXTRACT = 439,
     FALSE_P = 440,
     FETCH = 441,
     FIRST_P = 442,
     FLOAT_P = 443,
     FOR = 444,
     FORCE = 445,
     FOREIGN = 446,
     FORWARD = 447,
     FREEZE = 448,
     FROM = 449,
     FULL = 450,
     FUNCTION = 451,
     GET = 452,
     GLOBAL = 453,
     GRANT = 454,
     GRANTED = 455,
     GREATEST = 456,
     GROUP_P = 457,
     HANDLER = 458,
     HAVING = 459,
     HEADER = 460,
     HOLD = 461,
     HOUR_P = 462,
     ILIKE = 463,
     IMMEDIATE = 464,
     IMMUTABLE = 465,
     IMPLICIT_P = 466,
     IN_P = 467,
     INCLUDING = 468,
     INCREMENT = 469,
     INDEX = 470,
     INHERIT = 471,
     INHERITS = 472,
     INITIALLY = 473,
     INNER_P = 474,
     INOUT = 475,
     INPUT_P = 476,
     INSENSITIVE = 477,
     INSERT = 478,
     INSTEAD = 479,
     INT_P = 480,
     INTEGER = 481,
     INTERSECT = 482,
     INTERVAL = 483,
     INTO = 484,
     INVOKER = 485,
     IS = 486,
     ISNULL = 487,
     ISOLATION = 488,
     JOIN = 489,
     KEY = 490,
     LANCOMPILER = 491,
     LANGUAGE = 492,
     LARGE_P = 493,
     LAST_P = 494,
     LEADING = 495,
     LEAST = 496,
     LEFT = 497,
     LEVEL = 498,
     LIKE = 499,
     LIMIT = 500,
     LISTEN = 501,
     LOAD = 502,
     LOCAL = 503,
     LOCALTIME = 504,
     LOCALTIMESTAMP = 505,
     LOCATION = 506,
     LOCK_P = 507,
     LOGIN_P = 508,
     MATCH = 509,
     MAXVALUE = 510,
     MINUTE_P = 511,
     MINVALUE = 512,
     MODE = 513,
     MONTH_P = 514,
     MOVE = 515,
     NAMES = 516,
     NATIONAL = 517,
     NATURAL = 518,
     NCHAR = 519,
     NEW = 520,
     NEXT = 521,
     NO = 522,
     NOCREATEDB = 523,
     NOCREATEROLE = 524,
     NOCREATEUSER = 525,
     NOINHERIT = 526,
     NOLOGIN_P = 527,
     NONE = 528,
     NOSUPERUSER = 529,
     NOT = 530,
     NOTHING = 531,
     NOTIFY = 532,
     NOTNULL = 533,
     NOWAIT = 534,
     NULL_P = 535,
     NULLIF = 536,
     NUMERIC = 537,
     OBJECT_P = 538,
     OF = 539,
     OFF = 540,
     OFFSET = 541,
     OIDS = 542,
     OLD = 543,
     ON = 544,
     ONLY = 545,
     OPERATOR = 546,
     OPTION = 547,
     OR = 548,
     ORDER = 549,
     OUT_P = 550,
     OUTER_P = 551,
     OVERLAPS = 552,
     OVERLAY = 553,
     OWNER = 554,
     PARTIAL = 555,
     PASSWORD = 556,
     PLACING = 557,
     POSITION = 558,
     PRECISION = 559,
     PRESERVE = 560,
     PREPARE = 561,
     PREPARED = 562,
     PRIMARY = 563,
     PRIOR = 564,
     PRIVILEGES = 565,
     PROCEDURAL = 566,
     PROCEDURE = 567,
     QUOTE = 568,
     READ = 569,
     REAL = 570,
     RECHECK = 571,
     REFERENCES = 572,
     REINDEX = 573,
     RELATIVE_P = 574,
     RELEASE = 575,
     RENAME = 576,
     REPEATABLE = 577,
     REPLACE = 578,
     RESET = 579,
     RESTART = 580,
     RESTRICT = 581,
     RETURNS = 582,
     REVOKE = 583,
     RIGHT = 584,
     ROLE = 585,
     ROLLBACK = 586,
     ROW = 587,
     ROWS = 588,
     RULE = 589,
     SAVEPOINT = 590,
     SCHEMA = 591,
     SCROLL = 592,
     SECOND_P = 593,
     SECURITY = 594,
     SELECT = 595,
     SEQUENCE = 596,
     SERIALIZABLE = 597,
     SESSION = 598,
     SESSION_USER = 599,
     SET = 600,
     SETOF = 601,
     SHARE = 602,
     SHOW = 603,
     SIMILAR = 604,
     SIMPLE = 605,
     SMALLINT = 606,
     SOME = 607,
     STABLE = 608,
     START = 609,
     STATEMENT = 610,
     STATISTICS = 611,
     STDIN = 612,
     STDOUT = 613,
     STORAGE = 614,
     STRICT_P = 615,
     SUBSTRING = 616,
     SUPERUSER_P = 617,
     SYMMETRIC = 618,
     SYSID = 619,
     SYSTEM_P = 620,
     TABLE = 621,
     TABLESPACE = 622,
     TEMP = 623,
     TEMPLATE = 624,
     TEMPORARY = 625,
     THEN = 626,
     TIME = 627,
     TIMESTAMP = 628,
     TO = 629,
     TOAST = 630,
     TRAILING = 631,
     TRANSACTION = 632,
     TREAT = 633,
     TRIGGER = 634,
     TRIM = 635,
     TRUE_P = 636,
     TRUNCATE = 637,
     TRUSTED = 638,
     TYPE_P = 639,
     UNCOMMITTED = 640,
     UNENCRYPTED = 641,
     UNION = 642,
     UNIQUE = 643,
     UNKNOWN = 644,
     UNLISTEN = 645,
     UNTIL = 646,
     UPDATE = 647,
     USER = 648,
     USING = 649,
     VACUUM = 650,
     VALID = 651,
     VALIDATOR = 652,
     VALUES = 653,
     VARCHAR = 654,
     VARYING = 655,
     VERBOSE = 656,
     VIEW = 657,
     VOLATILE = 658,
     WHEN = 659,
     WHERE = 660,
     WITH = 661,
     WITHOUT = 662,
     WORK = 663,
     WRITE = 664,
     YEAR_P = 665,
     ZONE = 666,
     UNIONJOIN = 667,
     IDENT = 668,
     SCONST = 669,
     Op = 670,
     CSTRING = 671,
     CVARIABLE = 672,
     CPP_LINE = 673,
     IP = 674,
     BCONST = 675,
     XCONST = 676,
     ICONST = 677,
     PARAM = 678,
     FCONST = 679,
     POSTFIXOP = 680,
     UMINUS = 681
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_CONTINUE 265
#define SQL_COUNT 266
#define SQL_CURRENT 267
#define SQL_DATA 268
#define SQL_DATETIME_INTERVAL_CODE 269
#define SQL_DATETIME_INTERVAL_PRECISION 270
#define SQL_DESCRIBE 271
#define SQL_DESCRIPTOR 272
#define SQL_DISCONNECT 273
#define SQL_ENUM 274
#define SQL_FOUND 275
#define SQL_FREE 276
#define SQL_GO 277
#define SQL_GOTO 278
#define SQL_IDENTIFIED 279
#define SQL_INDICATOR 280
#define SQL_KEY_MEMBER 281
#define SQL_LENGTH 282
#define SQL_LONG 283
#define SQL_NAME 284
#define SQL_NULLABLE 285
#define SQL_OCTET_LENGTH 286
#define SQL_OPEN 287
#define SQL_OUTPUT 288
#define SQL_REFERENCE 289
#define SQL_RETURNED_LENGTH 290
#define SQL_RETURNED_OCTET_LENGTH 291
#define SQL_SCALE 292
#define SQL_SECTION 293
#define SQL_SHORT 294
#define SQL_SIGNED 295
#define SQL_SQL 296
#define SQL_SQLERROR 297
#define SQL_SQLPRINT 298
#define SQL_SQLWARNING 299
#define SQL_START 300
#define SQL_STOP 301
#define SQL_STRUCT 302
#define SQL_UNSIGNED 303
#define SQL_VALUE 304
#define SQL_VAR 305
#define SQL_WHENEVER 306
#define S_ADD 307
#define S_AND 308
#define S_ANYTHING 309
#define S_AUTO 310
#define S_CONST 311
#define S_DEC 312
#define S_DIV 313
#define S_DOTPOINT 314
#define S_EQUAL 315
#define S_EXTERN 316
#define S_INC 317
#define S_LSHIFT 318
#define S_MEMPOINT 319
#define S_MEMBER 320
#define S_MOD 321
#define S_MUL 322
#define S_NEQUAL 323
#define S_OR 324
#define S_REGISTER 325
#define S_RSHIFT 326
#define S_STATIC 327
#define S_SUB 328
#define S_VOLATILE 329
#define S_TYPEDEF 330
#define TYPECAST 331
#define ABORT_P 332
#define ABSOLUTE_P 333
#define ACCESS 334
#define ACTION 335
#define ADD 336
#define ADMIN 337
#define AFTER 338
#define AGGREGATE 339
#define ALL 340
#define ALSO 341
#define ALTER 342
#define ANALYSE 343
#define ANALYZE 344
#define AND 345
#define ANY 346
#define ARRAY 347
#define AS 348
#define ASC 349
#define ASSERTION 350
#define ASSIGNMENT 351
#define ASYMMETRIC 352
#define AT 353
#define AUTHORIZATION 354
#define BACKWARD 355
#define BEFORE 356
#define BEGIN_P 357
#define BETWEEN 358
#define BIGINT 359
#define BINARY 360
#define BIT 361
#define BOOLEAN_P 362
#define BOTH 363
#define BY 364
#define CACHE 365
#define CALLED 366
#define CASCADE 367
#define CASE 368
#define CAST 369
#define CHAIN 370
#define CHAR_P 371
#define CHARACTER 372
#define CHARACTERISTICS 373
#define CHECK 374
#define CHECKPOINT 375
#define CLASS 376
#define CLOSE 377
#define CLUSTER 378
#define COALESCE 379
#define COLLATE 380
#define COLUMN 381
#define COMMENT 382
#define COMMIT 383
#define COMMITTED 384
#define CONNECTION 385
#define CONSTRAINT 386
#define CONSTRAINTS 387
#define CONVERSION_P 388
#define CONVERT 389
#define COPY 390
#define CREATE 391
#define CREATEDB 392
#define CREATEROLE 393
#define CREATEUSER 394
#define CROSS 395
#define CSV 396
#define CURRENT_DATE 397
#define CURRENT_ROLE 398
#define CURRENT_TIME 399
#define CURRENT_TIMESTAMP 400
#define CURRENT_USER 401
#define CURSOR 402
#define CYCLE 403
#define DATABASE 404
#define DAY_P 405
#define DEALLOCATE 406
#define DEC 407
#define DECIMAL_P 408
#define DECLARE 409
#define DEFAULT 410
#define DEFAULTS 411
#define DEFERRABLE 412
#define DEFERRED 413
#define DEFINER 414
#define DELETE_P 415
#define DELIMITER 416
#define DELIMITERS 417
#define DESC 418
#define DISABLE_P 419
#define DISTINCT 420
#define DO 421
#define DOMAIN_P 422
#define DOUBLE_P 423
#define DROP 424
#define EACH 425
#define ELSE 426
#define ENABLE_P 427
#define ENCODING 428
#define ENCRYPTED 429
#define END_P 430
#define ESCAPE 431
#define EXCEPT 432
#define EXCLUSIVE 433
#define EXCLUDING 434
#define EXECUTE 435
#define EXISTS 436
#define EXPLAIN 437
#define EXTERNAL 438
#define EXTRACT 439
#define FALSE_P 440
#define FETCH 441
#define FIRST_P 442
#define FLOAT_P 443
#define FOR 444
#define FORCE 445
#define FOREIGN 446
#define FORWARD 447
#define FREEZE 448
#define FROM 449
#define FULL 450
#define FUNCTION 451
#define GET 452
#define GLOBAL 453
#define GRANT 454
#define GRANTED 455
#define GREATEST 456
#define GROUP_P 457
#define HANDLER 458
#define HAVING 459
#define HEADER 460
#define HOLD 461
#define HOUR_P 462
#define ILIKE 463
#define IMMEDIATE 464
#define IMMUTABLE 465
#define IMPLICIT_P 466
#define IN_P 467
#define INCLUDING 468
#define INCREMENT 469
#define INDEX 470
#define INHERIT 471
#define INHERITS 472
#define INITIALLY 473
#define INNER_P 474
#define INOUT 475
#define INPUT_P 476
#define INSENSITIVE 477
#define INSERT 478
#define INSTEAD 479
#define INT_P 480
#define INTEGER 481
#define INTERSECT 482
#define INTERVAL 483
#define INTO 484
#define INVOKER 485
#define IS 486
#define ISNULL 487
#define ISOLATION 488
#define JOIN 489
#define KEY 490
#define LANCOMPILER 491
#define LANGUAGE 492
#define LARGE_P 493
#define LAST_P 494
#define LEADING 495
#define LEAST 496
#define LEFT 497
#define LEVEL 498
#define LIKE 499
#define LIMIT 500
#define LISTEN 501
#define LOAD 502
#define LOCAL 503
#define LOCALTIME 504
#define LOCALTIMESTAMP 505
#define LOCATION 506
#define LOCK_P 507
#define LOGIN_P 508
#define MATCH 509
#define MAXVALUE 510
#define MINUTE_P 511
#define MINVALUE 512
#define MODE 513
#define MONTH_P 514
#define MOVE 515
#define NAMES 516
#define NATIONAL 517
#define NATURAL 518
#define NCHAR 519
#define NEW 520
#define NEXT 521
#define NO 522
#define NOCREATEDB 523
#define NOCREATEROLE 524
#define NOCREATEUSER 525
#define NOINHERIT 526
#define NOLOGIN_P 527
#define NONE 528
#define NOSUPERUSER 529
#define NOT 530
#define NOTHING 531
#define NOTIFY 532
#define NOTNULL 533
#define NOWAIT 534
#define NULL_P 535
#define NULLIF 536
#define NUMERIC 537
#define OBJECT_P 538
#define OF 539
#define OFF 540
#define OFFSET 541
#define OIDS 542
#define OLD 543
#define ON 544
#define ONLY 545
#define OPERATOR 546
#define OPTION 547
#define OR 548
#define ORDER 549
#define OUT_P 550
#define OUTER_P 551
#define OVERLAPS 552
#define OVERLAY 553
#define OWNER 554
#define PARTIAL 555
#define PASSWORD 556
#define PLACING 557
#define POSITION 558
#define PRECISION 559
#define PRESERVE 560
#define PREPARE 561
#define PREPARED 562
#define PRIMARY 563
#define PRIOR 564
#define PRIVILEGES 565
#define PROCEDURAL 566
#define PROCEDURE 567
#define QUOTE 568
#define READ 569
#define REAL 570
#define RECHECK 571
#define REFERENCES 572
#define REINDEX 573
#define RELATIVE_P 574
#define RELEASE 575
#define RENAME 576
#define REPEATABLE 577
#define REPLACE 578
#define RESET 579
#define RESTART 580
#define RESTRICT 581
#define RETURNS 582
#define REVOKE 583
#define RIGHT 584
#define ROLE 585
#define ROLLBACK 586
#define ROW 587
#define ROWS 588
#define RULE 589
#define SAVEPOINT 590
#define SCHEMA 591
#define SCROLL 592
#define SECOND_P 593
#define SECURITY 594
#define SELECT 595
#define SEQUENCE 596
#define SERIALIZABLE 597
#define SESSION 598
#define SESSION_USER 599
#define SET 600
#define SETOF 601
#define SHARE 602
#define SHOW 603
#define SIMILAR 604
#define SIMPLE 605
#define SMALLINT 606
#define SOME 607
#define STABLE 608
#define START 609
#define STATEMENT 610
#define STATISTICS 611
#define STDIN 612
#define STDOUT 613
#define STORAGE 614
#define STRICT_P 615
#define SUBSTRING 616
#define SUPERUSER_P 617
#define SYMMETRIC 618
#define SYSID 619
#define SYSTEM_P 620
#define TABLE 621
#define TABLESPACE 622
#define TEMP 623
#define TEMPLATE 624
#define TEMPORARY 625
#define THEN 626
#define TIME 627
#define TIMESTAMP 628
#define TO 629
#define TOAST 630
#define TRAILING 631
#define TRANSACTION 632
#define TREAT 633
#define TRIGGER 634
#define TRIM 635
#define TRUE_P 636
#define TRUNCATE 637
#define TRUSTED 638
#define TYPE_P 639
#define UNCOMMITTED 640
#define UNENCRYPTED 641
#define UNION 642
#define UNIQUE 643
#define UNKNOWN 644
#define UNLISTEN 645
#define UNTIL 646
#define UPDATE 647
#define USER 648
#define USING 649
#define VACUUM 650
#define VALID 651
#define VALIDATOR 652
#define VALUES 653
#define VARCHAR 654
#define VARYING 655
#define VERBOSE 656
#define VIEW 657
#define VOLATILE 658
#define WHEN 659
#define WHERE 660
#define WITH 661
#define WITHOUT 662
#define WORK 663
#define WRITE 664
#define YEAR_P 665
#define ZONE 666
#define UNIONJOIN 667
#define IDENT 668
#define SCONST 669
#define Op 670
#define CSTRING 671
#define CVARIABLE 672
#define CPP_LINE 673
#define IP 674
#define BCONST 675
#define XCONST 676
#define ICONST 677
#define PARAM 678
#define FCONST 679
#define POSTFIXOP 680
#define UMINUS 681




/* Copy the first part of user declarations.  */
#line 4 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
int ecpg_informix_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	QueryIsRule = 0, FoundInto = 0;
static int	initializer = 0;
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, 0L, NULL, {NULL}};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, 0L, NULL, {NULL}};

static struct inf_compat_col
{
	char *name;
	char *indirection;
	struct inf_compat_col *next;
} *informix_col;

static struct inf_compat_val
{
	char *val;
	struct inf_compat_val *next;
} *informix_val;

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, char * error, ...)
{
	va_list ap;
	
	fprintf(stderr, "%s:%d: ", input_filename, yylineno);
	
	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, "WARNING: ");
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, "ERROR: ");
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);
	
	fprintf(stderr, "\n");
	
	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	char * name = (char *)mm_alloc(yyleng + 1);

	strncpy(name, yytext, yyleng);
	name[yyleng] = '\0';
	return(name);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct 
	 * An array is only allowed together with an element argument 
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else 
	 * so we don't have to worry here. */
	
	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
		result = cat2_str(result, make_str("? , "));

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_informix(struct arguments *list)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
 	 * for instance you can declare variables in a function, and then subsequently use them
	 * { 
	 *      declare_vars();
	 *      exec sql ... which uses vars declared in the above function
	 *
	 * This breaks standard and leads to some very dangerous programming. 
	 * Since they do, we have to work around and accept their syntax as well.
	 * But we will do so ONLY in Informix mode.
	 * We have to change the variables to our own struct and just store the pointer instead of the variable 
	 */

	 struct arguments *ptr;
	 char *result = make_str("");

	 for (ptr = list; ptr != NULL; ptr = ptr->next)
	 {
	 	char temp[20]; /* this should be sufficient unless you have 8 byte integers */
		char *original_var;
		
	 	/* change variable name to "ECPG_informix_get_var(<counter>)" */
		original_var = ptr->variable->name;
		sprintf(temp, "%d))", ecpg_informix_var);
		
		if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1")), ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char) && atoi(ptr->variable->type->size) > 1)
		{
			ptr->variable = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, (", ecpg_informix_var++);
		}
		else
		{
			ptr->variable = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->variable->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size), 0);
			sprintf(temp, "%d, &(", ecpg_informix_var++);
		}
		
		/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
		result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		
		/* now the indicator if there is one */
		if (ptr->indicator->type->type != ECPGt_NO_INDICATOR)
		{
			/* change variable name to "ECPG_informix_get_var(<counter>)" */
			original_var = ptr->indicator->name;
			sprintf(temp, "%d))", ecpg_informix_var);
			
			/* create call to "ECPG_informix_set_var(<counter>, <pointer>. <linen number>)" */
			if (atoi(ptr->indicator->type->size) > 1)
			{
				ptr->indicator = new_variable(cat_str(4, make_str("("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, (", ecpg_informix_var++);
			}
			else
			{
				ptr->indicator = new_variable(cat_str(4, make_str("*("), mm_strdup(ECPGtype_name(ptr->indicator->type->type)), make_str(" *)(ECPG_informix_get_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size), 0);
				sprintf(temp, "%d, &(", ecpg_informix_var++);
			}
			result = cat_str(5, result, make_str("ECPG_informix_set_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
		}
	 }

	 return result;
}

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "trying to access an undeclared cursor %s\n", name);
		return NULL;
	}
	if (insert)
	{
		/* add all those input variables that were given earlier 
		 * note that we have to append here but have to keep the existing order */
		for (p = ptr->argsinsert; p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = ptr->argsresult; p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);
	
	return ptr;
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 311 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1248 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1260 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   56276

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  447
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  528
/* YYNRULES -- Number of rules. */
#define YYNRULES  2026
/* YYNRULES -- Number of states. */
#define YYNSTATES  3361

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   682

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   433,     2,     2,
     438,   439,   431,   429,   445,   430,   440,   432,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   446,   441,
     426,   425,   427,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   436,     2,   437,   434,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   442,     2,   443,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     428,   435,   444
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     6,     9,    14,    18,    21,    23,
      25,    27,    29,    31,    34,    36,    38,    40,    42,    44,
      46,    48,    50,    52,    54,    56,    58,    60,    62,    64,
      66,    68,    70,    72,    74,    76,    78,    80,    82,    84,
      86,    88,    90,    92,    94,    96,    98,   100,   102,   104,
     106,   108,   110,   112,   114,   116,   118,   120,   122,   124,
     126,   128,   130,   132,   134,   136,   138,   140,   142,   144,
     146,   148,   150,   152,   154,   156,   158,   160,   162,   164,
     166,   168,   170,   172,   174,   176,   178,   180,   182,   184,
     186,   188,   190,   192,   194,   196,   198,   200,   202,   204,
     206,   208,   210,   212,   214,   216,   218,   220,   222,   224,
     226,   228,   230,   232,   234,   240,   242,   243,   246,   250,
     254,   256,   258,   260,   262,   264,   266,   268,   270,   272,
     274,   278,   282,   285,   288,   291,   294,   298,   302,   308,
     314,   320,   325,   331,   337,   342,   346,   350,   356,   363,
     365,   367,   371,   378,   383,   385,   386,   389,   390,   392,
     394,   396,   398,   400,   402,   405,   409,   413,   417,   421,
     425,   428,   434,   437,   440,   444,   448,   450,   454,   456,
     458,   460,   464,   467,   470,   473,   475,   477,   479,   481,
     483,   485,   487,   489,   491,   493,   497,   504,   506,   508,
     510,   512,   513,   515,   517,   520,   524,   529,   533,   536,
     539,   543,   548,   552,   555,   560,   562,   564,   566,   568,
     570,   575,   580,   582,   586,   590,   595,   602,   609,   616,
     623,   628,   635,   638,   643,   647,   651,   655,   659,   663,
     667,   671,   675,   679,   683,   685,   689,   693,   697,   701,
     704,   706,   708,   709,   712,   713,   716,   726,   728,   730,
     732,   734,   736,   739,   740,   742,   744,   748,   752,   754,
     756,   760,   764,   768,   773,   775,   776,   779,   780,   784,
     785,   787,   788,   800,   813,   815,   817,   820,   823,   826,
     829,   830,   832,   833,   835,   839,   841,   843,   845,   849,
     852,   853,   857,   859,   861,   864,   866,   869,   873,   878,
     881,   887,   889,   892,   895,   898,   902,   905,   908,   909,
     913,   915,   920,   926,   933,   945,   949,   950,   954,   956,
     958,   961,   964,   965,   967,   969,   972,   975,   976,   980,
     984,   987,   989,   991,   994,   997,  1002,  1003,  1006,  1009,
    1010,  1014,  1019,  1024,  1025,  1028,  1029,  1034,  1035,  1036,
    1045,  1049,  1053,  1055,  1059,  1060,  1064,  1066,  1068,  1074,
    1079,  1082,  1083,  1086,  1088,  1091,  1095,  1098,  1101,  1104,
    1107,  1111,  1115,  1117,  1118,  1124,  1134,  1136,  1137,  1139,
    1142,  1145,  1146,  1149,  1150,  1156,  1158,  1159,  1166,  1169,
    1170,  1174,  1189,  1209,  1211,  1213,  1215,  1219,  1225,  1227,
    1229,  1231,  1235,  1236,  1238,  1239,  1241,  1243,  1245,  1249,
    1250,  1252,  1254,  1255,  1258,  1260,  1263,  1265,  1268,  1271,
    1273,  1276,  1279,  1286,  1295,  1299,  1304,  1309,  1314,  1320,
    1324,  1328,  1330,  1334,  1338,  1340,  1342,  1344,  1346,  1359,
    1361,  1365,  1370,  1378,  1383,  1386,  1388,  1389,  1391,  1392,
    1400,  1405,  1407,  1409,  1411,  1413,  1415,  1417,  1419,  1421,
    1423,  1427,  1429,  1432,  1435,  1439,  1443,  1449,  1454,  1459,
    1463,  1468,  1472,  1476,  1479,  1484,  1487,  1489,  1491,  1493,
    1495,  1498,  1501,  1503,  1505,  1507,  1510,  1513,  1515,  1518,
    1521,  1523,  1525,  1532,  1542,  1550,  1560,  1569,  1578,  1585,
    1595,  1603,  1614,  1622,  1624,  1626,  1628,  1630,  1632,  1634,
    1636,  1638,  1640,  1642,  1644,  1646,  1654,  1662,  1673,  1676,
    1678,  1680,  1682,  1686,  1688,  1690,  1692,  1694,  1696,  1699,
    1702,  1705,  1708,  1711,  1714,  1716,  1720,  1722,  1725,  1729,
    1730,  1732,  1736,  1739,  1746,  1753,  1757,  1758,  1762,  1763,
    1776,  1778,  1779,  1782,  1783,  1785,  1789,  1792,  1795,  1800,
    1802,  1805,  1806,  1816,  1824,  1827,  1828,  1832,  1835,  1837,
    1841,  1845,  1849,  1852,  1855,  1857,  1859,  1861,  1863,  1866,
    1868,  1872,  1874,  1876,  1878,  1883,  1885,  1888,  1893,  1899,
    1901,  1903,  1905,  1907,  1911,  1915,  1918,  1921,  1924,  1927,
    1929,  1932,  1933,  1939,  1941,  1944,  1946,  1947,  1953,  1961,
    1963,  1965,  1973,  1975,  1979,  1983,  1987,  1989,  1993,  2005,
    2016,  2019,  2020,  2029,  2034,  2039,  2044,  2046,  2048,  2050,
    2051,  2061,  2068,  2075,  2083,  2090,  2097,  2107,  2114,  2121,
    2128,  2137,  2146,  2153,  2160,  2162,  2163,  2173,  2180,  2188,
    2195,  2202,  2209,  2219,  2226,  2233,  2240,  2248,  2258,  2268,
    2275,  2282,  2289,  2290,  2305,  2307,  2309,  2313,  2317,  2319,
    2321,  2323,  2325,  2327,  2329,  2331,  2332,  2334,  2336,  2338,
    2340,  2342,  2344,  2345,  2352,  2355,  2358,  2361,  2364,  2367,
    2371,  2375,  2378,  2381,  2384,  2387,  2391,  2394,  2400,  2405,
    2409,  2413,  2417,  2419,  2421,  2422,  2426,  2429,  2432,  2434,
    2438,  2441,  2443,  2444,  2452,  2462,  2465,  2471,  2475,  2477,
    2480,  2484,  2488,  2492,  2496,  2500,  2504,  2508,  2512,  2517,
    2521,  2525,  2527,  2528,  2534,  2540,  2545,  2548,  2549,  2554,
    2558,  2565,  2570,  2577,  2584,  2590,  2598,  2600,  2601,  2612,
    2617,  2620,  2622,  2627,  2633,  2639,  2642,  2647,  2649,  2651,
    2653,  2654,  2656,  2657,  2659,  2660,  2664,  2665,  2670,  2672,
    2674,  2676,  2678,  2680,  2682,  2683,  2688,  2693,  2696,  2698,
    2706,  2711,  2715,  2717,  2720,  2726,  2729,  2730,  2736,  2740,
    2741,  2744,  2747,  2750,  2754,  2756,  2760,  2762,  2765,  2767,
    2768,  2775,  2783,  2784,  2787,  2790,  2793,  2797,  2798,  2801,
    2804,  2806,  2808,  2812,  2816,  2818,  2821,  2826,  2831,  2833,
    2835,  2844,  2849,  2854,  2859,  2862,  2864,  2865,  2869,  2873,
    2878,  2883,  2888,  2893,  2896,  2898,  2900,  2901,  2903,  2904,
    2906,  2912,  2914,  2915,  2917,  2918,  2922,  2924,  2928,  2932,
    2935,  2938,  2940,  2945,  2950,  2953,  2956,  2961,  2963,  2964,
    2966,  2968,  2970,  2974,  2975,  2978,  2979,  2984,  2989,  2993,
    2995,  2996,  2999,  3000,  3003,  3004,  3008,  3010,  3012,  3015,
    3017,  3020,  3026,  3033,  3039,  3041,  3044,  3046,  3051,  3055,
    3060,  3064,  3070,  3075,  3081,  3086,  3092,  3095,  3100,  3102,
    3105,  3108,  3111,  3113,  3115,  3116,  3121,  3124,  3126,  3129,
    3132,  3137,  3139,  3142,  3143,  3145,  3149,  3152,  3155,  3159,
    3165,  3172,  3176,  3181,  3182,  3184,  3188,  3192,  3196,  3200,
    3204,  3208,  3210,  3212,  3214,  3216,  3218,  3220,  3222,  3225,
    3231,  3234,  3236,  3238,  3240,  3242,  3244,  3246,  3248,  3250,
    3252,  3254,  3256,  3259,  3262,  3265,  3268,  3271,  3273,  3277,
    3278,  3284,  3288,  3289,  3295,  3299,  3300,  3302,  3304,  3306,
    3308,  3314,  3317,  3319,  3321,  3323,  3325,  3331,  3334,  3337,
    3340,  3342,  3346,  3350,  3353,  3355,  3356,  3360,  3361,  3367,
    3370,  3376,  3379,  3381,  3385,  3389,  3390,  3392,  3394,  3396,
    3398,  3400,  3402,  3406,  3410,  3414,  3418,  3422,  3426,  3430,
    3431,  3433,  3437,  3443,  3446,  3449,  3453,  3457,  3461,  3465,
    3469,  3473,  3477,  3481,  3485,  3489,  3492,  3495,  3499,  3503,
    3506,  3510,  3516,  3521,  3528,  3532,  3538,  3543,  3550,  3555,
    3562,  3568,  3576,  3579,  3583,  3586,  3591,  3595,  3600,  3604,
    3609,  3613,  3618,  3624,  3631,  3639,  3646,  3654,  3661,  3669,
    3673,  3678,  3683,  3690,  3693,  3695,  3699,  3702,  3706,  3710,
    3714,  3718,  3722,  3726,  3730,  3734,  3738,  3742,  3745,  3748,
    3754,  3761,  3769,  3771,  3773,  3776,  3781,  3783,  3785,  3787,
    3790,  3793,  3796,  3798,  3802,  3807,  3813,  3819,  3824,  3826,
    3828,  3833,  3835,  3840,  3842,  3847,  3849,  3854,  3856,  3858,
    3860,  3862,  3869,  3874,  3879,  3884,  3889,  3896,  3902,  3908,
    3914,  3919,  3926,  3931,  3938,  3943,  3948,  3953,  3958,  3962,
    3968,  3970,  3972,  3974,  3976,  3978,  3980,  3982,  3984,  3986,
    3988,  3990,  3992,  3994,  3996,  3998,  4003,  4005,  4010,  4012,
    4017,  4019,  4022,  4024,  4027,  4029,  4033,  4037,  4038,  4042,
    4044,  4046,  4050,  4054,  4058,  4060,  4062,  4064,  4066,  4068,
    4070,  4072,  4074,  4079,  4083,  4086,  4090,  4091,  4095,  4099,
    4102,  4105,  4107,  4108,  4111,  4114,  4118,  4121,  4123,  4125,
    4129,  4135,  4138,  4140,  4145,  4148,  4149,  4151,  4152,  4154,
    4157,  4160,  4163,  4167,  4173,  4175,  4178,  4179,  4182,  4184,
    4185,  4189,  4191,  4195,  4197,  4199,  4203,  4211,  4213,  4216,
    4221,  4223,  4227,  4232,  4237,  4241,  4243,  4245,  4247,  4249,
    4251,  4253,  4257,  4259,  4262,  4264,  4268,  4270,  4272,  4274,
    4276,  4278,  4280,  4282,  4285,  4287,  4290,  4294,  4301,  4303,
    4305,  4307,  4309,  4311,  4313,  4315,  4317,  4319,  4321,  4323,
    4325,  4328,  4330,  4332,  4334,  4336,  4339,  4342,  4344,  4346,
    4348,  4350,  4352,  4354,  4356,  4358,  4361,  4364,  4366,  4368,
    4370,  4372,  4374,  4376,  4378,  4380,  4382,  4384,  4386,  4388,
    4394,  4398,  4401,  4404,  4408,  4416,  4418,  4420,  4423,  4426,
    4428,  4429,  4431,  4435,  4437,  4440,  4441,  4444,  4445,  4448,
    4449,  4451,  4455,  4460,  4464,  4466,  4468,  4470,  4473,  4474,
    4482,  4486,  4489,  4491,  4493,  4495,  4496,  4502,  4503,  4508,
    4511,  4513,  4516,  4517,  4519,  4523,  4527,  4531,  4535,  4536,
    4541,  4547,  4553,  4554,  4556,  4558,  4560,  4562,  4565,  4568,
    4571,  4573,  4576,  4577,  4585,  4586,  4592,  4593,  4598,  4601,
    4604,  4606,  4608,  4610,  4612,  4614,  4616,  4618,  4620,  4622,
    4624,  4626,  4632,  4635,  4637,  4641,  4644,  4647,  4651,  4652,
    4658,  4660,  4661,  4667,  4670,  4673,  4675,  4677,  4679,  4682,
    4685,  4689,  4691,  4694,  4697,  4701,  4705,  4710,  4713,  4715,
    4718,  4720,  4722,  4725,  4728,  4732,  4734,  4736,  4738,  4740,
    4741,  4743,  4747,  4752,  4753,  4756,  4757,  4759,  4762,  4766,
    4769,  4771,  4773,  4775,  4776,  4778,  4780,  4784,  4785,  4790,
    4793,  4796,  4798,  4800,  4801,  4803,  4805,  4807,  4809,  4812,
    4816,  4817,  4819,  4822,  4824,  4829,  4834,  4835,  4837,  4840,
    4842,  4844,  4848,  4850,  4852,  4857,  4862,  4867,  4872,  4874,
    4875,  4879,  4883,  4888,  4890,  4894,  4898,  4903,  4905,  4909,
    4913,  4915,  4922,  4924,  4928,  4932,  4939,  4941,  4945,  4949,
    4951,  4953,  4955,  4957,  4959,  4961,  4963,  4965,  4967,  4969,
    4971,  4973,  4975,  4977,  4979,  4984,  4989,  4991,  4993,  4998,
    5003,  5007,  5008,  5016,  5018,  5019,  5020,  5028,  5032,  5037,
    5041,  5043,  5045,  5047,  5050,  5054,  5060,  5063,  5069,  5072,
    5074,  5076,  5078,  5080,  5082,  5084,  5086,  5088,  5090,  5092,
    5094,  5096,  5098,  5100,  5102,  5104,  5106,  5108,  5110,  5112,
    5114,  5116,  5118,  5120,  5122,  5124,  5126,  5128,  5130,  5132,
    5134,  5136,  5138,  5140,  5142,  5144,  5146,  5148,  5150,  5152,
    5154,  5156,  5158,  5160,  5162,  5164,  5166,  5168,  5170,  5172,
    5174,  5176,  5178,  5180,  5182,  5184,  5186,  5188,  5190,  5192,
    5194,  5196,  5198,  5200,  5202,  5204,  5206,  5208,  5210,  5212,
    5214,  5216,  5218,  5220,  5222,  5224,  5226,  5228,  5230,  5232,
    5234,  5236,  5238,  5240,  5242,  5244,  5246,  5248,  5250,  5252,
    5254,  5256,  5258,  5260,  5262,  5264,  5266,  5268,  5270,  5272,
    5274,  5276,  5278,  5280,  5282,  5284,  5286,  5288,  5290,  5292,
    5294,  5296,  5298,  5300,  5302,  5304,  5306,  5308,  5310,  5312,
    5314,  5316,  5318,  5320,  5322,  5324,  5326,  5328,  5330,  5332,
    5334,  5336,  5338,  5340,  5342,  5344,  5346,  5348,  5350,  5352,
    5354,  5356,  5358,  5360,  5362,  5364,  5366,  5368,  5370,  5372,
    5374,  5376,  5378,  5380,  5382,  5384,  5386,  5388,  5390,  5392,
    5394,  5396,  5398,  5400,  5402,  5404,  5406,  5408,  5410,  5412,
    5414,  5416,  5418,  5420,  5422,  5424,  5426,  5428,  5430,  5432,
    5434,  5436,  5438,  5440,  5442,  5444,  5446,  5448,  5450,  5452,
    5454,  5456,  5458,  5460,  5462,  5464,  5466,  5468,  5470,  5472,
    5474,  5476,  5478,  5480,  5482,  5484,  5486,  5488,  5490,  5492,
    5494,  5496,  5498,  5500,  5502,  5504,  5506,  5508,  5510,  5512,
    5514,  5516,  5518,  5520,  5522,  5524,  5526,  5528,  5530,  5532,
    5534,  5536,  5538,  5540,  5542,  5544,  5546,  5548,  5550,  5552,
    5554,  5556,  5558,  5560,  5562,  5564,  5566,  5568,  5570,  5572,
    5574,  5576,  5578,  5580,  5582,  5584,  5586,  5588,  5590,  5592,
    5594,  5596,  5598,  5600,  5602,  5604,  5606,  5608,  5610,  5612,
    5614,  5616,  5618,  5620,  5622,  5624,  5626,  5628,  5630,  5632,
    5634,  5636,  5638,  5640,  5642,  5644,  5646,  5648,  5650,  5652,
    5654,  5656,  5658,  5660,  5662,  5664,  5666,  5668,  5670,  5672,
    5674,  5676,  5678,  5680,  5682,  5684,  5686,  5688,  5690,  5692,
    5694,  5696,  5698,  5700,  5702,  5704,  5706,  5708,  5710,  5712,
    5714,  5716,  5718,  5720,  5722,  5724,  5726,  5728,  5730,  5732,
    5734,  5736,  5738,  5740,  5742,  5744,  5746,  5748,  5750,  5752,
    5754,  5756,  5758,  5760,  5762,  5764,  5766,  5768,  5770,  5772,
    5774,  5776,  5778,  5780,  5782,  5784,  5786,  5788,  5790,  5792,
    5794,  5796,  5798,  5800,  5802,  5804,  5806,  5808,  5810,  5812,
    5814,  5816,  5818,  5820,  5822,  5824,  5826,  5828,  5830,  5832,
    5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,  5852,
    5854,  5856,  5858,  5860,  5862,  5864,  5866,  5868,  5870,  5872,
    5874,  5876,  5878,  5880,  5882,  5884,  5886,  5888,  5890,  5892,
    5894,  5896,  5900,  5902,  5903,  5905,  5908,  5910,  5913,  5915,
    5917,  5920,  5923,  5925,  5927,  5929,  5931,  5933,  5935,  5938,
    5942,  5944,  5947,  5949,  5953,  5955,  5959,  5961,  5963,  5965,
    5967,  5969,  5971,  5973,  5975,  5977,  5979,  5981,  5983,  5985,
    5987,  5989,  5991,  5993,  5995,  5997,  5999,  6001,  6003,  6005,
    6007,  6009,  6011,  6013,  6015,  6017,  6019,  6021,  6023,  6025,
    6027,  6029,  6031,  6033,  6035,  6037,  6039,  6041,  6043,  6045,
    6047,  6049,  6051,  6053,  6055,  6057,  6059,  6061,  6063,  6065,
    6067,  6069,  6071,  6073,  6075,  6077,  6079
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     448,     0,    -1,   449,    -1,    -1,   449,   450,    -1,   960,
     451,   452,   441,    -1,   960,   452,   441,    -1,   960,   851,
      -1,   859,    -1,   973,    -1,   418,    -1,   442,    -1,   443,
      -1,    98,   837,    -1,   670,    -1,   671,    -1,   676,    -1,
     628,    -1,   463,    -1,   645,    -1,   646,    -1,   539,    -1,
     487,    -1,   458,    -1,   457,    -1,   459,    -1,   681,    -1,
     486,    -1,   495,    -1,   679,    -1,   590,    -1,   483,    -1,
     496,    -1,   532,    -1,   567,    -1,   637,    -1,   678,    -1,
     675,    -1,   614,    -1,   462,    -1,   543,    -1,   575,    -1,
     453,    -1,   466,    -1,   538,    -1,   505,    -1,   550,    -1,
     553,    -1,   456,    -1,   666,    -1,   701,    -1,   569,    -1,
     694,    -1,   568,    -1,   639,    -1,   465,    -1,   580,    -1,
     548,    -1,   460,    -1,   655,    -1,   581,    -1,   552,    -1,
     566,    -1,   461,    -1,   674,    -1,   687,    -1,   587,    -1,
     593,    -1,   604,    -1,   608,    -1,   690,    -1,   657,    -1,
     665,    -1,   696,    -1,   656,    -1,   640,    -1,   632,    -1,
     634,    -1,   631,    -1,   643,    -1,   594,    -1,   605,    -1,
     647,    -1,   704,    -1,   659,    -1,   586,    -1,   658,    -1,
     700,    -1,   680,    -1,   470,    -1,   481,    -1,   482,    -1,
     664,    -1,   913,    -1,   836,    -1,   849,    -1,   850,    -1,
     914,    -1,   891,    -1,   911,    -1,   892,    -1,   895,    -1,
     900,    -1,   922,    -1,   915,    -1,   901,    -1,   910,    -1,
     929,    -1,   931,    -1,   925,    -1,   918,    -1,   932,    -1,
     935,    -1,   937,    -1,   136,   330,   834,   454,   455,    -1,
     406,    -1,    -1,   301,   824,    -1,   174,   301,   824,    -1,
     386,   301,   824,    -1,   362,    -1,   274,    -1,   216,    -1,
     271,    -1,   137,    -1,   268,    -1,   138,    -1,   269,    -1,
     253,    -1,   272,    -1,   130,   245,   826,    -1,   396,   391,
     824,    -1,   393,   811,    -1,   364,   825,    -1,    82,   811,
      -1,   330,   811,    -1,   212,   330,   811,    -1,   212,   202,
     811,    -1,   136,   393,   834,   454,   455,    -1,    87,   330,
     834,   454,   455,    -1,    87,   330,   834,   345,   471,    -1,
      87,   330,   834,   482,    -1,    87,   393,   834,   454,   455,
      -1,    87,   393,   834,   345,   471,    -1,    87,   393,   834,
     482,    -1,   169,   330,   811,    -1,   169,   393,   811,    -1,
     136,   202,   834,   454,   455,    -1,    87,   202,   834,   464,
     393,   811,    -1,    81,    -1,   169,    -1,   169,   202,   811,
      -1,   136,   336,   467,    99,   834,   468,    -1,   136,   336,
     945,   468,    -1,   945,    -1,    -1,   468,   469,    -1,    -1,
     505,    -1,   608,    -1,   538,    -1,   553,    -1,   593,    -1,
     664,    -1,   345,   471,    -1,   345,   248,   471,    -1,   345,
     343,   471,    -1,   472,   374,   473,    -1,   472,   444,   473,
      -1,   372,   411,   478,    -1,   377,   662,    -1,   343,   118,
      93,   377,   662,    -1,   261,   479,    -1,   330,   480,    -1,
     343,    99,   480,    -1,   343,    99,   155,    -1,   944,    -1,
     472,   440,   945,    -1,   474,    -1,   155,    -1,   476,    -1,
     474,   445,   476,    -1,   314,   385,    -1,   314,   129,    -1,
     322,   314,    -1,   342,    -1,   477,    -1,   832,    -1,   945,
      -1,   381,    -1,   185,    -1,   289,    -1,   285,    -1,   832,
      -1,   967,    -1,   762,   829,   764,    -1,   762,   438,   825,
     439,   829,   764,    -1,   155,    -1,   248,    -1,   829,    -1,
     155,    -1,    -1,   945,    -1,   829,    -1,   348,   472,    -1,
     348,   372,   411,    -1,   348,   377,   233,   243,    -1,   348,
     343,    99,    -1,   348,    85,    -1,   324,   472,    -1,   324,
     372,   411,    -1,   324,   377,   233,   243,    -1,   324,   343,
      99,    -1,   324,    85,    -1,   345,   132,   484,   485,    -1,
      85,    -1,   811,    -1,   158,    -1,   209,    -1,   120,    -1,
      87,   366,   735,   488,    -1,    87,   215,   735,   490,    -1,
     489,    -1,   488,   445,   489,    -1,    81,   644,   510,    -1,
      87,   644,   945,   492,    -1,    87,   644,   945,   169,   275,
     280,    -1,    87,   644,   945,   345,   275,   280,    -1,    87,
     644,   945,   345,   356,   825,    -1,    87,   644,   945,   345,
     359,   945,    -1,   169,   644,   945,   493,    -1,    87,   644,
     945,   384,   740,   494,    -1,    81,   517,    -1,   169,   131,
     812,   493,    -1,   345,   407,   287,    -1,   136,   375,   366,
      -1,   123,   289,   812,    -1,   345,   407,   123,    -1,   172,
     379,   812,    -1,   172,   379,    85,    -1,   172,   379,   393,
      -1,   164,   379,   812,    -1,   164,   379,    85,    -1,   164,
     379,   393,    -1,   491,    -1,   490,   445,   491,    -1,   299,
     374,   834,    -1,   345,   367,   812,    -1,   345,   155,   765,
      -1,   169,   155,    -1,   112,    -1,   326,    -1,    -1,   394,
     765,    -1,    -1,   122,   812,    -1,   135,   501,   810,   502,
     497,   498,   503,   454,   499,    -1,   374,    -1,   194,    -1,
     829,    -1,   357,    -1,   358,    -1,   499,   500,    -1,    -1,
     105,    -1,   287,    -1,   161,   677,   829,    -1,   280,   677,
     829,    -1,   141,    -1,   205,    -1,   313,   677,   824,    -1,
     176,   677,   824,    -1,   190,   313,   520,    -1,   190,   275,
     280,   520,    -1,   105,    -1,    -1,   406,   287,    -1,    -1,
     504,   162,   829,    -1,    -1,   394,    -1,    -1,   136,   506,
     366,   810,   438,   507,   439,   527,   528,   529,   530,    -1,
     136,   506,   366,   810,   284,   810,   438,   507,   439,   528,
     529,   530,    -1,   370,    -1,   368,    -1,   248,   370,    -1,
     248,   368,    -1,   198,   370,    -1,   198,   368,    -1,    -1,
     508,    -1,    -1,   509,    -1,   508,   445,   509,    -1,   510,
      -1,   515,    -1,   517,    -1,   945,   740,   511,    -1,   511,
     512,    -1,    -1,   131,   812,   513,    -1,   513,    -1,   514,
      -1,   275,   280,    -1,   280,    -1,   388,   531,    -1,   308,
     235,   531,    -1,   119,   438,   765,   439,    -1,   155,   766,
      -1,   317,   810,   519,   522,   523,    -1,   157,    -1,   275,
     157,    -1,   218,   158,    -1,   218,   209,    -1,   244,   810,
     516,    -1,   213,   156,    -1,   179,   156,    -1,    -1,   131,
     812,   518,    -1,   518,    -1,   119,   438,   765,   439,    -1,
     388,   438,   520,   439,   531,    -1,   308,   235,   438,   520,
     439,   531,    -1,   191,   235,   438,   520,   439,   317,   810,
     519,   522,   523,   563,    -1,   438,   520,   439,    -1,    -1,
     520,   445,   521,    -1,   521,    -1,   945,    -1,   254,   195,
      -1,   254,   300,    -1,    -1,   524,    -1,   525,    -1,   524,
     525,    -1,   525,   524,    -1,    -1,   289,   160,   526,    -1,
     289,   392,   526,    -1,   267,    80,    -1,   326,    -1,   112,
      -1,   345,   155,    -1,   345,   280,    -1,   217,   438,   809,
     439,    -1,    -1,   406,   287,    -1,   407,   287,    -1,    -1,
     289,   128,   169,    -1,   289,   128,   160,   333,    -1,   289,
     128,   305,   333,    -1,    -1,   367,   812,    -1,    -1,   394,
     215,   367,   812,    -1,    -1,    -1,   136,   506,   366,   810,
     535,   534,   533,   704,    -1,   406,   287,    93,    -1,   407,
     287,    93,    -1,    93,    -1,   438,   536,   439,    -1,    -1,
     536,   445,   537,    -1,   537,    -1,   945,    -1,   136,   506,
     341,   810,   540,    -1,    87,   341,   810,   540,    -1,   540,
     541,    -1,    -1,   110,   831,    -1,   148,    -1,   267,   148,
      -1,   214,   542,   831,    -1,   255,   831,    -1,   257,   831,
      -1,   267,   255,    -1,   267,   257,    -1,   354,   454,   831,
      -1,   325,   454,   831,    -1,   109,    -1,    -1,   136,   544,
     549,   237,   480,    -1,   136,   544,   549,   237,   480,   203,
     545,   546,   547,    -1,   383,    -1,    -1,   812,    -1,   812,
     585,    -1,   397,   545,    -1,    -1,   236,   829,    -1,    -1,
     169,   549,   237,   829,   493,    -1,   311,    -1,    -1,   136,
     367,   812,   551,   251,   824,    -1,   299,   812,    -1,    -1,
     169,   367,   812,    -1,   136,   379,   812,   554,   555,   289,
     810,   557,   180,   312,   812,   438,   560,   439,    -1,   136,
     131,   379,   812,    83,   555,   289,   810,   562,   563,   189,
     170,   332,   180,   312,   818,   438,   560,   439,    -1,   101,
      -1,    83,    -1,   556,    -1,   556,   293,   556,    -1,   556,
     293,   556,   293,   556,    -1,   223,    -1,   160,    -1,   392,
      -1,   189,   558,   559,    -1,    -1,   170,    -1,    -1,   332,
      -1,   355,    -1,   561,    -1,   560,   445,   561,    -1,    -1,
     833,    -1,   945,    -1,    -1,   194,   810,    -1,   564,    -1,
     564,   565,    -1,   565,    -1,   565,   564,    -1,   275,   157,
      -1,   157,    -1,   218,   209,    -1,   218,   158,    -1,   169,
     379,   812,   289,   810,   493,    -1,   136,    95,   812,   119,
     438,   765,   439,   563,    -1,   169,    95,   812,    -1,   136,
      84,   818,   571,    -1,   136,   291,   771,   571,    -1,   136,
     384,   584,   571,    -1,   136,   384,   584,    93,   570,    -1,
     438,   738,   439,    -1,   438,   572,   439,    -1,   573,    -1,
     572,   445,   573,    -1,   948,   425,   574,    -1,   948,    -1,
     623,    -1,   774,    -1,   832,    -1,   136,   291,   121,   584,
     578,   189,   384,   740,   394,   814,    93,   576,    -1,   577,
      -1,   576,   445,   577,    -1,   291,   825,   636,   579,    -1,
     291,   825,   636,   438,   635,   439,   579,    -1,   196,   825,
     818,   616,    -1,   359,   740,    -1,   155,    -1,    -1,   316,
      -1,    -1,   169,   291,   121,   584,   394,   814,   493,    -1,
     169,   582,   583,   493,    -1,   366,    -1,   341,    -1,   402,
      -1,   215,    -1,   384,    -1,   167,    -1,   133,    -1,   336,
      -1,   584,    -1,   583,   445,   584,    -1,   945,    -1,   945,
     585,    -1,   440,   815,    -1,   585,   440,   815,    -1,   382,
     711,   809,    -1,   186,   588,   589,   812,   907,    -1,   186,
     588,   812,   907,    -1,   186,   589,   812,   907,    -1,   186,
     812,   907,    -1,   186,   588,   589,   812,    -1,   186,   588,
     812,    -1,   186,   589,   812,    -1,   186,   812,    -1,   260,
     588,   589,   812,    -1,   260,   812,    -1,   266,    -1,   309,
      -1,   187,    -1,   239,    -1,    78,   826,    -1,   319,   826,
      -1,   826,    -1,    85,    -1,   192,    -1,   192,   826,    -1,
     192,    85,    -1,   100,    -1,   100,   826,    -1,   100,    85,
      -1,   212,    -1,   194,    -1,   127,   289,   591,   812,   231,
     592,    -1,   127,   289,    84,   818,   438,   633,   439,   231,
     592,    -1,   127,   289,   196,   818,   616,   231,   592,    -1,
     127,   289,   291,   771,   438,   635,   439,   231,   592,    -1,
     127,   289,   379,   812,   289,   584,   231,   592,    -1,   127,
     289,   334,   812,   289,   584,   231,   592,    -1,   127,   289,
     334,   812,   231,   592,    -1,   127,   289,   291,   121,   584,
     394,   814,   231,   592,    -1,   127,   289,   238,   283,   831,
     231,   592,    -1,   127,   289,   114,   438,   740,    93,   740,
     439,   231,   592,    -1,   127,   289,   549,   237,   584,   231,
     592,    -1,   126,    -1,   149,    -1,   336,    -1,   215,    -1,
     341,    -1,   366,    -1,   167,    -1,   384,    -1,   402,    -1,
     133,    -1,   829,    -1,   280,    -1,   199,   595,   289,   598,
     374,   599,   601,    -1,   328,   595,   289,   598,   194,   599,
     493,    -1,   328,   199,   292,   189,   595,   289,   598,   194,
     599,   493,    -1,    85,   310,    -1,    85,    -1,   596,    -1,
     597,    -1,   596,   445,   597,    -1,   340,    -1,   317,    -1,
     136,    -1,   945,    -1,   809,    -1,   366,   809,    -1,   196,
     602,    -1,   149,   811,    -1,   237,   811,    -1,   336,   811,
      -1,   367,   811,    -1,   600,    -1,   599,   445,   600,    -1,
     834,    -1,   202,   834,    -1,   406,   199,   292,    -1,    -1,
     603,    -1,   602,   445,   603,    -1,   818,   616,    -1,   199,
     596,   374,   811,   606,   607,    -1,   328,   596,   194,   811,
     607,   493,    -1,   406,    82,   292,    -1,    -1,   200,   109,
     834,    -1,    -1,   136,   609,   215,   816,   289,   810,   610,
     438,   611,   439,   530,   737,    -1,   388,    -1,    -1,   394,
     814,    -1,    -1,   612,    -1,   611,   445,   612,    -1,   945,
     613,    -1,   768,   613,    -1,   438,   765,   439,   613,    -1,
     584,    -1,   394,   584,    -1,    -1,   136,   615,   196,   818,
     616,   327,   622,   624,   627,    -1,   136,   615,   196,   818,
     616,   624,   627,    -1,   293,   323,    -1,    -1,   438,   617,
     439,    -1,   438,   439,    -1,   618,    -1,   617,   445,   618,
      -1,   619,   621,   623,    -1,   621,   619,   623,    -1,   621,
     623,    -1,   619,   623,    -1,   623,    -1,   212,    -1,   295,
      -1,   220,    -1,   212,   295,    -1,   829,    -1,   829,   445,
     829,    -1,   947,    -1,   623,    -1,   740,    -1,   946,   585,
     433,   384,    -1,   626,    -1,   624,   626,    -1,   111,   289,
     280,   221,    -1,   327,   280,   289,   280,   221,    -1,   360,
      -1,   210,    -1,   353,    -1,   403,    -1,   183,   339,   159,
      -1,   183,   339,   230,    -1,   339,   159,    -1,   339,   230,
      -1,    93,   620,    -1,   237,   480,    -1,   625,    -1,   406,
     571,    -1,    -1,    87,   196,   603,   629,   630,    -1,   625,
      -1,   629,   625,    -1,   326,    -1,    -1,   169,   196,   818,
     616,   493,    -1,   169,    84,   818,   438,   633,   439,   493,
      -1,   740,    -1,   431,    -1,   169,   291,   771,   438,   635,
     439,   493,    -1,   740,    -1,   740,   445,   740,    -1,   273,
     445,   740,    -1,   740,   445,   273,    -1,   771,    -1,   945,
     440,   636,    -1,   136,   114,   438,   740,    93,   740,   439,
     406,   196,   603,   638,    -1,   136,   114,   438,   740,    93,
     740,   439,   407,   196,   638,    -1,    93,    96,    -1,    -1,
     169,   114,   438,   740,    93,   740,   439,   493,    -1,   318,
     641,   810,   642,    -1,   318,   365,   812,   642,    -1,   318,
     149,   812,   642,    -1,   215,    -1,   366,    -1,   190,    -1,
      -1,    87,    84,   818,   438,   633,   439,   321,   374,   812,
      -1,    87,   133,   584,   321,   374,   812,    -1,    87,   149,
     813,   321,   374,   813,    -1,    87,   196,   818,   616,   321,
     374,   812,    -1,    87,   202,   834,   321,   374,   834,    -1,
      87,   237,   812,   321,   374,   812,    -1,    87,   291,   121,
     584,   394,   814,   321,   374,   812,    -1,    87,   336,   812,
     321,   374,   812,    -1,    87,   366,   735,   321,   374,   812,
      -1,    87,   215,   735,   321,   374,   812,    -1,    87,   366,
     735,   321,   644,   812,   374,   812,    -1,    87,   379,   812,
     289,   735,   321,   374,   812,    -1,    87,   393,   834,   321,
     374,   834,    -1,    87,   367,   812,   321,   374,   812,    -1,
     126,    -1,    -1,    87,    84,   818,   438,   633,   439,   345,
     336,   812,    -1,    87,   167,   584,   345,   336,   812,    -1,
      87,   196,   818,   616,   345,   336,   812,    -1,    87,   341,
     735,   345,   336,   812,    -1,    87,   366,   735,   345,   336,
     812,    -1,    87,   384,   584,   345,   336,   812,    -1,    87,
      84,   818,   438,   633,   439,   299,   374,   834,    -1,    87,
     133,   584,   299,   374,   834,    -1,    87,   149,   813,   299,
     374,   834,    -1,    87,   167,   813,   299,   374,   834,    -1,
      87,   196,   818,   616,   299,   374,   834,    -1,    87,   291,
     636,   438,   635,   439,   299,   374,   834,    -1,    87,   291,
     121,   584,   394,   814,   299,   374,   834,    -1,    87,   336,
     812,   299,   374,   834,    -1,    87,   384,   584,   299,   374,
     834,    -1,    87,   367,   812,   299,   374,   834,    -1,    -1,
     136,   615,   334,   812,    93,   648,   289,   653,   374,   810,
     737,   166,   654,   649,    -1,   276,    -1,   651,    -1,   438,
     650,   439,    -1,   650,   441,   652,    -1,   652,    -1,   704,
      -1,   690,    -1,   700,    -1,   694,    -1,   656,    -1,   651,
      -1,    -1,   340,    -1,   392,    -1,   160,    -1,   223,    -1,
     224,    -1,    86,    -1,    -1,   169,   334,   812,   289,   810,
     493,    -1,   277,   810,    -1,   246,   810,    -1,   390,   810,
      -1,   390,   431,    -1,    77,   660,    -1,   102,   660,   663,
      -1,   354,   377,   663,    -1,   128,   660,    -1,   175,   660,
      -1,   331,   660,    -1,   335,   945,    -1,   320,   335,   945,
      -1,   320,   945,    -1,   331,   660,   374,   335,   945,    -1,
     331,   660,   374,   945,    -1,   306,   377,   829,    -1,   128,
     307,   829,    -1,   331,   307,   829,    -1,   408,    -1,   377,
      -1,    -1,   233,   243,   475,    -1,   314,   290,    -1,   314,
     409,    -1,   661,    -1,   662,   445,   661,    -1,   662,   661,
      -1,   662,    -1,    -1,   136,   506,   402,   810,   519,    93,
     704,    -1,   136,   293,   323,   506,   402,   810,   519,    93,
     704,    -1,   247,   817,    -1,   136,   149,   813,   406,   667,
      -1,   136,   149,   813,    -1,   668,    -1,   667,   668,    -1,
     367,   669,   812,    -1,   367,   669,   155,    -1,   251,   669,
     829,    -1,   251,   669,   155,    -1,   369,   669,   812,    -1,
     369,   669,   155,    -1,   173,   669,   830,    -1,   173,   669,
     155,    -1,   130,   245,   669,   825,    -1,   299,   669,   812,
      -1,   299,   669,   155,    -1,   425,    -1,    -1,    87,   149,
     813,   454,   672,    -1,    87,   149,   813,   345,   471,    -1,
      87,   149,   813,   482,    -1,   672,   673,    -1,    -1,   130,
     245,   669,   825,    -1,   169,   149,   813,    -1,   136,   167,
     584,   677,   740,   511,    -1,    87,   167,   584,   492,    -1,
      87,   167,   584,   169,   275,   280,    -1,    87,   167,   584,
     345,   275,   280,    -1,    87,   167,   584,    81,   517,    -1,
      87,   167,   584,   169,   131,   812,   493,    -1,    93,    -1,
      -1,   136,   578,   133,   584,   189,   829,   374,   829,   194,
     584,    -1,   123,   816,   289,   810,    -1,   123,   810,    -1,
     123,    -1,   395,   684,   685,   683,    -1,   395,   684,   685,
     683,   810,    -1,   395,   684,   685,   683,   681,    -1,   682,
     683,    -1,   682,   683,   810,   686,    -1,    89,    -1,    88,
      -1,   401,    -1,    -1,   195,    -1,    -1,   193,    -1,    -1,
     438,   811,   439,    -1,    -1,   182,   689,   683,   688,    -1,
     704,    -1,   690,    -1,   700,    -1,   694,    -1,   701,    -1,
     682,    -1,    -1,   223,   229,   810,   691,    -1,   398,   438,
     806,   439,    -1,   155,   398,    -1,   704,    -1,   438,   692,
     439,   398,   438,   806,   439,    -1,   438,   692,   439,   704,
      -1,   692,   445,   693,    -1,   693,    -1,   945,   798,    -1,
     160,   194,   735,   695,   737,    -1,   394,   728,    -1,    -1,
     252,   711,   809,   697,   699,    -1,   212,   698,   258,    -1,
      -1,    79,   347,    -1,   332,   347,    -1,   332,   178,    -1,
     347,   392,   178,    -1,   347,    -1,   347,   332,   178,    -1,
     178,    -1,    79,   178,    -1,   279,    -1,    -1,   392,   735,
     345,   802,   727,   737,    -1,   154,   812,   702,   147,   703,
     189,   704,    -1,    -1,   702,   105,    -1,   702,   222,    -1,
     702,   337,    -1,   702,   267,   337,    -1,    -1,   406,   206,
      -1,   407,   206,    -1,   706,    -1,   705,    -1,   438,   706,
     439,    -1,   438,   705,   439,    -1,   708,    -1,   707,   715,
      -1,   707,   714,   724,   719,    -1,   707,   714,   718,   725,
      -1,   708,    -1,   705,    -1,   340,   713,   800,   709,   727,
     737,   722,   723,    -1,   707,   387,   712,   707,    -1,   707,
     227,   712,   707,    -1,   707,   177,   712,   707,    -1,   229,
     710,    -1,   907,    -1,    -1,   370,   711,   810,    -1,   368,
     711,   810,    -1,   248,   370,   711,   810,    -1,   248,   368,
     711,   810,    -1,   198,   370,   711,   810,    -1,   198,   368,
     711,   810,    -1,   366,   810,    -1,   810,    -1,   366,    -1,
      -1,    85,    -1,    -1,   165,    -1,   165,   289,   438,   776,
     439,    -1,    85,    -1,    -1,   715,    -1,    -1,   294,   109,
     716,    -1,   717,    -1,   716,   445,   717,    -1,   765,   394,
     774,    -1,   765,    94,    -1,   765,   163,    -1,   765,    -1,
     245,   720,   286,   721,    -1,   286,   721,   245,   720,    -1,
     245,   720,    -1,   286,   721,    -1,   245,   720,   445,   721,
      -1,   718,    -1,    -1,   765,    -1,    85,    -1,   765,    -1,
     202,   109,   776,    -1,    -1,   204,   765,    -1,    -1,   189,
     392,   726,   699,    -1,   189,   347,   726,   699,    -1,   189,
     314,   290,    -1,   724,    -1,    -1,   284,   811,    -1,    -1,
     194,   728,    -1,    -1,   728,   445,   729,    -1,   729,    -1,
     735,    -1,   735,   731,    -1,   736,    -1,   736,   731,    -1,
     736,    93,   438,   738,   439,    -1,   736,    93,   945,   438,
     738,   439,    -1,   736,   945,   438,   738,   439,    -1,   705,
      -1,   705,   731,    -1,   730,    -1,   438,   730,   439,   731,
      -1,   438,   730,   439,    -1,   729,   140,   234,   729,    -1,
     729,   412,   729,    -1,   729,   732,   234,   729,   734,    -1,
     729,   234,   729,   734,    -1,   729,   263,   732,   234,   729,
      -1,   729,   263,   234,   729,    -1,    93,   945,   438,   811,
     439,    -1,    93,   945,    -1,   945,   438,   811,   439,    -1,
     945,    -1,   195,   733,    -1,   242,   733,    -1,   329,   733,
      -1,   219,    -1,   296,    -1,    -1,   394,   438,   811,   439,
      -1,   289,   765,    -1,   810,    -1,   810,   431,    -1,   290,
     810,    -1,   290,   438,   810,   439,    -1,   768,    -1,   405,
     765,    -1,    -1,   739,    -1,   738,   445,   739,    -1,   945,
     740,    -1,   743,   741,    -1,   346,   743,   741,    -1,   743,
      92,   436,   825,   437,    -1,   346,   743,    92,   436,   825,
     437,    -1,   436,   437,   741,    -1,   436,   742,   437,   741,
      -1,    -1,   825,    -1,   438,   742,   439,    -1,   742,   429,
     742,    -1,   742,   430,   742,    -1,   742,   431,   742,    -1,
     742,   432,   742,    -1,   742,   433,   742,    -1,   824,    -1,
     945,    -1,   745,    -1,   761,    -1,   746,    -1,   750,    -1,
     754,    -1,   762,   764,    -1,   762,   438,   825,   439,   764,
      -1,   946,   585,    -1,   745,    -1,   761,    -1,   746,    -1,
     751,    -1,   755,    -1,   946,    -1,   225,    -1,   226,    -1,
     351,    -1,   104,    -1,   315,    -1,   188,   747,    -1,   168,
     304,    -1,   153,   749,    -1,   152,   749,    -1,   282,   748,
      -1,   107,    -1,   438,   825,   439,    -1,    -1,   438,   825,
     445,   825,   439,    -1,   438,   825,   439,    -1,    -1,   438,
     825,   445,   825,   439,    -1,   438,   825,   439,    -1,    -1,
     752,    -1,   753,    -1,   752,    -1,   753,    -1,   106,   759,
     438,   825,   439,    -1,   106,   759,    -1,   756,    -1,   757,
      -1,   756,    -1,   757,    -1,   758,   438,   825,   439,   760,
      -1,   758,   760,    -1,   117,   759,    -1,   116,   759,    -1,
     399,    -1,   262,   117,   759,    -1,   262,   116,   759,    -1,
     264,   759,    -1,   400,    -1,    -1,   117,   345,   945,    -1,
      -1,   373,   438,   825,   439,   763,    -1,   373,   763,    -1,
     372,   438,   825,   439,   763,    -1,   372,   763,    -1,   228,
      -1,   406,   372,   411,    -1,   407,   372,   411,    -1,    -1,
     410,    -1,   259,    -1,   150,    -1,   207,    -1,   256,    -1,
     338,    -1,   410,   374,   259,    -1,   150,   374,   207,    -1,
     150,   374,   256,    -1,   150,   374,   338,    -1,   207,   374,
     256,    -1,   256,   374,   338,    -1,   207,   374,   338,    -1,
      -1,   767,    -1,   765,    76,   740,    -1,   765,    98,   372,
     411,   765,    -1,   429,   765,    -1,   430,   765,    -1,   765,
     429,   765,    -1,   765,   430,   765,    -1,   765,   431,   765,
      -1,   765,   432,   765,    -1,   765,   433,   765,    -1,   765,
     434,   765,    -1,   765,   426,   765,    -1,   765,   427,   765,
      -1,   765,   425,   765,    -1,   765,   773,   765,    -1,   773,
     765,    -1,   765,   773,    -1,   765,    90,   765,    -1,   765,
     293,   765,    -1,   275,   765,    -1,   765,   244,   765,    -1,
     765,   244,   765,   176,   765,    -1,   765,   275,   244,   765,
      -1,   765,   275,   244,   765,   176,   765,    -1,   765,   208,
     765,    -1,   765,   208,   765,   176,   765,    -1,   765,   275,
     208,   765,    -1,   765,   275,   208,   765,   176,   765,    -1,
     765,   349,   374,   765,    -1,   765,   349,   374,   765,   176,
     765,    -1,   765,   275,   349,   374,   765,    -1,   765,   275,
     349,   374,   765,   176,   765,    -1,   765,   232,    -1,   765,
     231,   280,    -1,   765,   278,    -1,   765,   231,   275,   280,
      -1,   765,   231,   381,    -1,   765,   231,   275,   381,    -1,
     765,   231,   185,    -1,   765,   231,   275,   185,    -1,   765,
     231,   389,    -1,   765,   231,   275,   389,    -1,   765,   231,
     165,   194,   765,    -1,   765,   231,   284,   438,   778,   439,
      -1,   765,   231,   275,   284,   438,   778,   439,    -1,   765,
     103,   799,   766,    90,   766,    -1,   765,   275,   103,   799,
     766,    90,   766,    -1,   765,   103,   363,   766,    90,   766,
      -1,   765,   275,   103,   363,   766,    90,   766,    -1,   765,
     212,   789,    -1,   765,   275,   212,   789,    -1,   765,   775,
     770,   705,    -1,   765,   775,   770,   438,   765,   439,    -1,
     388,   705,    -1,   767,    -1,   766,    76,   740,    -1,   430,
     766,    -1,   766,   429,   766,    -1,   766,   430,   766,    -1,
     766,   431,   766,    -1,   766,   432,   766,    -1,   766,   433,
     766,    -1,   766,   434,   766,    -1,   766,   426,   766,    -1,
     766,   427,   766,    -1,   766,   425,   766,    -1,   766,   415,
     766,    -1,   773,   766,    -1,   766,   773,    -1,   766,   231,
     165,   194,   766,    -1,   766,   231,   284,   438,   766,   439,
      -1,   766,   231,   275,   284,   438,   766,   439,    -1,   795,
      -1,   819,    -1,   423,   798,    -1,   438,   765,   439,   798,
      -1,   790,    -1,   768,    -1,   705,    -1,   181,   705,    -1,
      92,   705,    -1,    92,   780,    -1,   769,    -1,   818,   438,
     439,    -1,   818,   438,   776,   439,    -1,   818,   438,    85,
     776,   439,    -1,   818,   438,   165,   776,   439,    -1,   818,
     438,   431,   439,    -1,   142,    -1,   144,    -1,   144,   438,
     825,   439,    -1,   145,    -1,   145,   438,   825,   439,    -1,
     249,    -1,   249,   438,   825,   439,    -1,   250,    -1,   250,
     438,   825,   439,    -1,   143,    -1,   146,    -1,   344,    -1,
     393,    -1,   114,   438,   765,    93,   740,   439,    -1,   184,
     438,   777,   439,    -1,   298,   438,   782,   439,    -1,   303,
     438,   784,   439,    -1,   361,   438,   785,   439,    -1,   378,
     438,   765,    93,   740,   439,    -1,   380,   438,   108,   788,
     439,    -1,   380,   438,   240,   788,   439,    -1,   380,   438,
     376,   788,   439,    -1,   380,   438,   788,   439,    -1,   134,
     438,   765,   394,   584,   439,    -1,   134,   438,   776,   439,
      -1,   281,   438,   765,   445,   765,   439,    -1,   124,   438,
     776,   439,    -1,   201,   438,   776,   439,    -1,   241,   438,
     776,   439,    -1,   332,   438,   776,   439,    -1,   332,   438,
     439,    -1,   438,   776,   445,   765,   439,    -1,    91,    -1,
     352,    -1,    85,    -1,   415,    -1,   772,    -1,   429,    -1,
     430,    -1,   431,    -1,   433,    -1,   434,    -1,   432,    -1,
     426,    -1,   427,    -1,   425,    -1,   415,    -1,   291,   438,
     636,   439,    -1,   771,    -1,   291,   438,   636,   439,    -1,
     771,    -1,   291,   438,   636,   439,    -1,   244,    -1,   275,
     244,    -1,   208,    -1,   275,   208,    -1,   765,    -1,   776,
     445,   765,    -1,   781,   194,   765,    -1,    -1,   778,   445,
     740,    -1,   740,    -1,   780,    -1,   779,   445,   780,    -1,
     436,   776,   437,    -1,   436,   779,   437,    -1,   967,    -1,
     410,    -1,   259,    -1,   150,    -1,   207,    -1,   256,    -1,
     338,    -1,   829,    -1,   765,   783,   786,   787,    -1,   765,
     783,   786,    -1,   302,   765,    -1,   766,   212,   766,    -1,
      -1,   765,   786,   787,    -1,   765,   787,   786,    -1,   765,
     786,    -1,   765,   787,    -1,   776,    -1,    -1,   194,   765,
      -1,   189,   765,    -1,   765,   194,   776,    -1,   194,   776,
      -1,   776,    -1,   705,    -1,   438,   776,   439,    -1,   113,
     794,   791,   793,   175,    -1,   791,   792,    -1,   792,    -1,
     404,   765,   371,   765,    -1,   171,   765,    -1,    -1,   765,
      -1,    -1,   808,    -1,   808,   797,    -1,   440,   815,    -1,
     440,   431,    -1,   436,   765,   437,    -1,   436,   765,   446,
     765,   437,    -1,   796,    -1,   797,   796,    -1,    -1,   798,
     796,    -1,    97,    -1,    -1,   800,   445,   801,    -1,   801,
      -1,   765,    93,   948,    -1,   765,    -1,   431,    -1,   802,
     445,   805,    -1,   438,   803,   439,   425,   438,   804,   439,
      -1,   805,    -1,   945,   798,    -1,   945,   798,   445,   803,
      -1,   765,    -1,   765,   445,   804,    -1,   945,   798,   425,
     765,    -1,   945,   798,   425,   155,    -1,   806,   445,   807,
      -1,   807,    -1,   765,    -1,   155,    -1,   835,    -1,   945,
      -1,   810,    -1,   809,   445,   810,    -1,   808,    -1,   808,
     797,    -1,   812,    -1,   811,   445,   812,    -1,   945,    -1,
     945,    -1,   945,    -1,   948,    -1,   945,    -1,   829,    -1,
     947,    -1,   808,   797,    -1,   833,    -1,   744,   829,    -1,
     762,   829,   764,    -1,   762,   438,   825,   439,   829,   764,
      -1,   381,    -1,   185,    -1,   280,    -1,   963,    -1,   422,
      -1,   424,    -1,   420,    -1,   421,    -1,   414,    -1,   820,
      -1,   964,    -1,   825,    -1,   430,   825,    -1,   820,    -1,
     966,    -1,   821,    -1,   827,    -1,   430,   821,    -1,   430,
     820,    -1,   824,    -1,   824,    -1,   964,    -1,   820,    -1,
     824,    -1,   964,    -1,   821,    -1,   820,    -1,   430,   821,
      -1,   430,   820,    -1,   964,    -1,   824,    -1,   831,    -1,
     824,    -1,   821,    -1,   820,    -1,   822,    -1,   823,    -1,
     964,    -1,   945,    -1,   288,    -1,   265,    -1,     9,   374,
     837,   843,   844,    -1,     9,   374,   155,    -1,     9,   845,
      -1,   149,   837,    -1,   813,   840,   842,    -1,   838,   446,
     839,   842,   432,   813,   848,    -1,   824,    -1,   847,    -1,
     967,   966,    -1,   415,   841,    -1,   839,    -1,    -1,   945,
      -1,   945,   440,   841,    -1,   419,    -1,   446,   825,    -1,
      -1,    93,   837,    -1,    -1,   393,   845,    -1,    -1,   846,
      -1,   846,   432,   846,    -1,   846,    24,   109,   846,    -1,
     846,   394,   846,    -1,   834,    -1,   829,    -1,   966,    -1,
     415,   945,    -1,    -1,   154,   812,   702,   147,   703,   189,
     899,    -1,   151,   306,   899,    -1,   151,   899,    -1,   852,
      -1,   866,    -1,   853,    -1,    -1,   871,   874,   854,   887,
     441,    -1,    -1,   874,   855,   887,   441,    -1,   877,   441,
      -1,   831,    -1,   445,   831,    -1,    -1,   764,    -1,   410,
     374,   256,    -1,   410,   374,   338,    -1,   150,   374,   150,
      -1,   259,   374,   259,    -1,    -1,   861,   860,   863,   862,
      -1,   960,   102,   154,    38,   441,    -1,   960,   175,   154,
      38,   441,    -1,    -1,   864,    -1,   418,    -1,   868,    -1,
     866,    -1,   864,   868,    -1,   864,   866,    -1,   864,   418,
      -1,   868,    -1,   865,   868,    -1,    -1,    75,   867,   874,
     890,   949,   741,   441,    -1,    -1,   871,   874,   869,   887,
     441,    -1,    -1,   874,   870,   887,   441,    -1,   877,   441,
      -1,   872,   873,    -1,   872,    -1,   873,    -1,    61,    -1,
      72,    -1,    70,    -1,    55,    -1,    56,    -1,    74,    -1,
     883,    -1,   879,    -1,   875,    -1,   949,   438,   856,   857,
     439,    -1,   949,   858,    -1,   881,    -1,    19,   943,   876,
      -1,    19,   876,    -1,    19,   943,    -1,   442,   971,   443,
      -1,    -1,   881,   878,   442,   865,   443,    -1,   877,    -1,
      -1,   882,   880,   442,   865,   443,    -1,    47,   943,    -1,
     387,   943,    -1,    47,    -1,   387,    -1,   884,    -1,   886,
     885,    -1,    48,    39,    -1,    48,    39,   225,    -1,    48,
      -1,    48,   225,    -1,    48,    28,    -1,    48,    28,   225,
      -1,    48,    28,    28,    -1,    48,    28,    28,   225,    -1,
      48,   116,    -1,    39,    -1,    39,   225,    -1,   225,    -1,
      28,    -1,    28,   225,    -1,    28,    28,    -1,    28,    28,
     225,    -1,     5,    -1,   116,    -1,   168,    -1,    40,    -1,
      -1,   888,    -1,   887,   445,   888,    -1,   890,   950,   741,
     889,    -1,    -1,   425,   972,    -1,    -1,   431,    -1,   431,
     431,    -1,   154,   355,   967,    -1,    18,   893,    -1,   894,
      -1,    12,    -1,    85,    -1,    -1,   837,    -1,   155,    -1,
     180,   209,   898,    -1,    -1,   180,   899,   896,   897,    -1,
     903,   907,    -1,   907,   903,    -1,   903,    -1,   907,    -1,
      -1,   847,    -1,   416,    -1,   812,    -1,   847,    -1,    21,
     812,    -1,    32,   812,   902,    -1,    -1,   903,    -1,   394,
     908,    -1,   904,    -1,   394,   906,    17,   968,    -1,   229,
     906,    17,   968,    -1,    -1,    41,    -1,   229,   959,    -1,
     905,    -1,   909,    -1,   909,   445,   908,    -1,   832,    -1,
     963,    -1,   306,   899,   194,   898,    -1,    16,   221,   812,
     904,    -1,    16,   912,   812,   904,    -1,    16,   912,   812,
     905,    -1,    33,    -1,    -1,     3,    17,   968,    -1,   151,
      17,   968,    -1,   197,    17,   968,   916,    -1,   917,    -1,
     916,   445,   917,    -1,   966,   425,   921,    -1,   345,    17,
     968,   919,    -1,   920,    -1,   919,   445,   920,    -1,   921,
     425,   827,    -1,    11,    -1,   197,    17,   968,    49,   827,
     923,    -1,   924,    -1,   923,   445,   924,    -1,   966,   425,
     928,    -1,   345,    17,   968,    49,   827,   926,    -1,   927,
      -1,   926,   445,   927,    -1,   928,   425,   828,    -1,     8,
      -1,    13,    -1,    14,    -1,    15,    -1,    25,    -1,    26,
      -1,    27,    -1,    29,    -1,    30,    -1,    31,    -1,   304,
      -1,    35,    -1,    36,    -1,    37,    -1,   384,    -1,   345,
       4,   425,   930,    -1,   345,     4,   374,   930,    -1,   289,
      -1,   285,    -1,   345,   130,   374,   894,    -1,   345,   130,
     425,   894,    -1,   345,   130,   894,    -1,    -1,   384,   933,
     949,   231,   874,   741,   934,    -1,    34,    -1,    -1,    -1,
      50,   936,   948,   231,   874,   741,   934,    -1,    51,    42,
     938,    -1,    51,   275,    20,   938,    -1,    51,    44,   938,
      -1,    10,    -1,    43,    -1,    46,    -1,    23,   812,    -1,
      22,   374,   812,    -1,   166,   812,   438,   961,   439,    -1,
     166,     6,    -1,     7,   812,   438,   961,   439,    -1,     7,
     812,    -1,   940,    -1,   941,    -1,     6,    -1,     7,    -1,
       8,    -1,    10,    -1,    11,    -1,    13,    -1,    14,    -1,
      15,    -1,    20,    -1,    22,    -1,    23,    -1,    24,    -1,
      25,    -1,    26,    -1,    27,    -1,    29,    -1,    30,    -1,
      31,    -1,    35,    -1,    36,    -1,    37,    -1,    38,    -1,
      42,    -1,    43,    -1,    44,    -1,    46,    -1,    49,    -1,
       9,    -1,    16,    -1,    18,    -1,    32,    -1,    50,    -1,
      51,    -1,     5,    -1,    28,    -1,    33,    -1,    39,    -1,
      47,    -1,    40,    -1,    48,    -1,   948,    -1,   967,    -1,
     953,    -1,   955,    -1,   956,    -1,   939,    -1,   951,    -1,
     116,    -1,   967,    -1,   952,    -1,   956,    -1,   939,    -1,
     951,    -1,   116,    -1,   967,    -1,   952,    -1,   939,    -1,
     942,    -1,   951,    -1,   967,    -1,   952,    -1,   957,    -1,
     939,    -1,   951,    -1,   950,    -1,   942,    -1,   116,    -1,
     221,    -1,   225,    -1,   387,    -1,   374,    -1,   951,    -1,
     953,    -1,   967,    -1,   956,    -1,   957,    -1,   940,    -1,
     949,    -1,   958,    -1,   954,    -1,   941,    -1,    55,    -1,
      56,    -1,    61,    -1,    70,    -1,    72,    -1,    75,    -1,
      74,    -1,   953,    -1,   954,    -1,   150,    -1,   207,    -1,
     256,    -1,   259,    -1,   338,    -1,   410,    -1,   955,    -1,
     130,    -1,    77,    -1,    78,    -1,    79,    -1,    80,    -1,
      81,    -1,    82,    -1,    83,    -1,    84,    -1,    86,    -1,
      87,    -1,    95,    -1,    96,    -1,    98,    -1,   100,    -1,
     101,    -1,   102,    -1,   109,    -1,   110,    -1,   112,    -1,
     115,    -1,   118,    -1,   120,    -1,   121,    -1,   122,    -1,
     123,    -1,   127,    -1,   128,    -1,   129,    -1,   132,    -1,
     133,    -1,   135,    -1,   137,    -1,   138,    -1,   139,    -1,
     141,    -1,   147,    -1,   148,    -1,   149,    -1,   151,    -1,
     154,    -1,   156,    -1,   158,    -1,   160,    -1,   161,    -1,
     162,    -1,   164,    -1,   167,    -1,   168,    -1,   169,    -1,
     170,    -1,   172,    -1,   173,    -1,   174,    -1,   176,    -1,
     179,    -1,   178,    -1,   180,    -1,   182,    -1,   186,    -1,
     187,    -1,   190,    -1,   192,    -1,   196,    -1,   198,    -1,
     200,    -1,   203,    -1,   205,    -1,   206,    -1,   209,    -1,
     210,    -1,   211,    -1,   213,    -1,   214,    -1,   215,    -1,
     216,    -1,   217,    -1,   222,    -1,   223,    -1,   224,    -1,
     233,    -1,   235,    -1,   236,    -1,   237,    -1,   238,    -1,
     239,    -1,   243,    -1,   246,    -1,   247,    -1,   248,    -1,
     251,    -1,   252,    -1,   253,    -1,   254,    -1,   255,    -1,
     257,    -1,   258,    -1,   260,    -1,   261,    -1,   266,    -1,
     267,    -1,   268,    -1,   269,    -1,   270,    -1,   271,    -1,
     272,    -1,   274,    -1,   276,    -1,   277,    -1,   279,    -1,
     283,    -1,   284,    -1,   287,    -1,   291,    -1,   292,    -1,
     299,    -1,   300,    -1,   301,    -1,   306,    -1,   307,    -1,
     305,    -1,   309,    -1,   310,    -1,   311,    -1,   312,    -1,
     313,    -1,   314,    -1,   316,    -1,   318,    -1,   319,    -1,
     320,    -1,   321,    -1,   322,    -1,   323,    -1,   324,    -1,
     325,    -1,   326,    -1,   327,    -1,   328,    -1,   330,    -1,
     331,    -1,   333,    -1,   334,    -1,   335,    -1,   336,    -1,
     337,    -1,   341,    -1,   342,    -1,   343,    -1,   345,    -1,
     347,    -1,   348,    -1,   350,    -1,   353,    -1,   354,    -1,
     355,    -1,   356,    -1,   357,    -1,   358,    -1,   359,    -1,
     362,    -1,   360,    -1,   365,    -1,   364,    -1,   367,    -1,
     368,    -1,   369,    -1,   370,    -1,   375,    -1,   377,    -1,
     379,    -1,   382,    -1,   383,    -1,   384,    -1,   385,    -1,
     386,    -1,   389,    -1,   390,    -1,   391,    -1,   392,    -1,
     395,    -1,   396,    -1,   398,    -1,   400,    -1,   402,    -1,
     406,    -1,   407,    -1,   408,    -1,   409,    -1,   411,    -1,
     104,    -1,   106,    -1,   117,    -1,   124,    -1,   134,    -1,
     152,    -1,   153,    -1,   181,    -1,   184,    -1,   188,    -1,
     201,    -1,   220,    -1,   226,    -1,   228,    -1,   241,    -1,
     262,    -1,   264,    -1,   273,    -1,   281,    -1,   282,    -1,
     295,    -1,   298,    -1,   303,    -1,   304,    -1,   315,    -1,
     332,    -1,   346,    -1,   351,    -1,   361,    -1,   372,    -1,
     373,    -1,   378,    -1,   380,    -1,   399,    -1,    99,    -1,
     103,    -1,   105,    -1,   140,    -1,   193,    -1,   195,    -1,
     208,    -1,   219,    -1,   231,    -1,   232,    -1,   234,    -1,
     242,    -1,   244,    -1,   263,    -1,   278,    -1,   296,    -1,
     297,    -1,   329,    -1,   349,    -1,   401,    -1,    85,    -1,
      88,    -1,    89,    -1,    90,    -1,    91,    -1,    92,    -1,
      93,    -1,    94,    -1,    97,    -1,   108,    -1,   113,    -1,
     114,    -1,   119,    -1,   125,    -1,   126,    -1,   131,    -1,
     136,    -1,   142,    -1,   144,    -1,   145,    -1,   143,    -1,
     146,    -1,   155,    -1,   157,    -1,   163,    -1,   165,    -1,
     166,    -1,   171,    -1,   175,    -1,   177,    -1,   185,    -1,
     189,    -1,   191,    -1,   194,    -1,   199,    -1,   202,    -1,
     204,    -1,   212,    -1,   218,    -1,   227,    -1,   229,    -1,
     240,    -1,   245,    -1,   265,    -1,   275,    -1,   280,    -1,
     285,    -1,   286,    -1,   288,    -1,   289,    -1,   290,    -1,
     293,    -1,   294,    -1,   308,    -1,   317,    -1,   340,    -1,
     344,    -1,   352,    -1,   363,    -1,   366,    -1,   371,    -1,
     376,    -1,   381,    -1,   388,    -1,   393,    -1,   394,    -1,
     404,    -1,   405,    -1,   962,    -1,   959,   445,   962,    -1,
      45,    -1,    -1,   971,    -1,   966,   965,    -1,   966,    -1,
     966,   965,    -1,   966,    -1,   966,    -1,    25,   966,    -1,
      25,   812,    -1,   417,    -1,   413,    -1,   416,    -1,   812,
      -1,   847,    -1,   974,    -1,   438,   439,    -1,   438,   970,
     439,    -1,   969,    -1,   970,   969,    -1,   972,    -1,   971,
     445,   972,    -1,   970,    -1,   442,   971,   443,    -1,   974,
      -1,   438,    -1,   439,    -1,   445,    -1,   441,    -1,   413,
      -1,   416,    -1,   820,    -1,   821,    -1,   824,    -1,   431,
      -1,   429,    -1,   430,    -1,   432,    -1,   433,    -1,   280,
      -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,    56,
      -1,    57,    -1,    58,    -1,    59,    -1,    60,    -1,    61,
      -1,    62,    -1,    63,    -1,    65,    -1,    64,    -1,    66,
      -1,    67,    -1,    68,    -1,    69,    -1,    70,    -1,    71,
      -1,    72,    -1,    73,    -1,    75,    -1,    74,    -1,     5,
      -1,    19,    -1,   207,    -1,   225,    -1,    28,    -1,   256,
      -1,   259,    -1,   338,    -1,    39,    -1,    40,    -1,    47,
      -1,    48,    -1,   410,    -1,   116,    -1,   188,    -1,   374,
      -1,   387,    -1,   399,    -1,   436,    -1,   437,    -1,   425,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   603,   603,   605,   606,   609,   610,   611,   617,   618,
     619,   620,   621,   624,   636,   637,   638,   639,   640,   641,
     642,   643,   644,   645,   646,   647,   648,   649,   650,   672,
     673,   674,   675,   676,   677,   678,   679,   680,   681,   682,
     683,   684,   685,   686,   687,   688,   689,   690,   691,   692,
     694,   695,   696,   697,   698,   699,   700,   701,   702,   703,
     704,   705,   706,   707,   708,   709,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   721,   722,   723,   724,   725,
     726,   727,   728,   729,   730,   736,   737,   738,   739,   740,
     741,   742,   743,   744,   750,   760,   764,   772,   780,   784,
     795,   805,   809,   816,   823,   829,   837,   847,   853,   862,
     869,   875,   884,   891,   912,   916,   917,   926,   927,   928,
     929,   930,   931,   932,   933,   934,   935,   936,   937,   938,
     939,   940,   941,   942,   943,   944,   945,   946,   956,   970,
     974,   976,   986,   989,   991,  1001,  1011,  1021,  1031,  1035,
    1036,  1045,  1056,  1058,  1062,  1063,  1066,  1067,  1074,  1075,
    1076,  1077,  1078,  1079,  1092,  1094,  1096,  1100,  1102,  1104,
    1106,  1108,  1110,  1112,  1114,  1116,  1120,  1121,  1125,  1127,
    1131,  1133,  1137,  1138,  1139,  1140,  1143,  1144,  1145,  1148,
    1149,  1150,  1151,  1161,  1162,  1163,  1165,  1167,  1169,  1173,
    1174,  1175,  1178,  1179,  1182,  1184,  1186,  1188,  1190,  1194,
    1196,  1198,  1200,  1202,  1206,  1210,  1212,  1216,  1217,  1223,
    1234,  1236,  1242,  1243,  1247,  1251,  1254,  1257,  1260,  1263,
    1266,  1269,  1272,  1275,  1278,  1281,  1284,  1287,  1290,  1293,
    1296,  1299,  1302,  1305,  1309,  1310,  1316,  1319,  1324,  1325,
    1328,  1329,  1330,  1333,  1334,  1344,  1358,  1363,  1364,  1372,
    1373,  1374,  1377,  1378,  1381,  1382,  1383,  1385,  1387,  1388,
    1389,  1391,  1393,  1395,  1400,  1401,  1404,  1405,  1412,  1415,
    1418,  1419,  1429,  1432,  1442,  1443,  1444,  1445,  1446,  1447,
    1448,  1452,  1455,  1457,  1459,  1463,  1464,  1465,  1468,  1474,
    1475,  1478,  1480,  1481,  1495,  1497,  1499,  1501,  1503,  1505,
    1507,  1522,  1523,  1524,  1525,  1528,  1535,  1536,  1537,  1544,
    1546,  1550,  1552,  1554,  1556,  1561,  1562,  1565,  1567,  1571,
    1574,  1576,  1582,  1585,  1586,  1587,  1588,  1589,  1592,  1596,
    1600,  1601,  1602,  1603,  1604,  1607,  1610,  1613,  1614,  1615,
    1618,  1619,  1620,  1621,  1624,  1625,  1628,  1629,  1638,  1637,
    1655,  1656,  1657,  1661,  1664,  1667,  1669,  1673,  1684,  1688,
    1692,  1693,  1696,  1698,  1700,  1702,  1704,  1706,  1708,  1710,
    1712,  1714,  1718,  1719,  1730,  1732,  1737,  1738,  1745,  1746,
    1749,  1752,  1754,  1757,  1760,  1764,  1765,  1775,  1779,  1780,
    1794,  1805,  1810,  1818,  1819,  1822,  1824,  1826,  1830,  1831,
    1832,  1835,  1838,  1841,  1842,  1845,  1846,  1849,  1851,  1854,
    1857,  1858,  1861,  1862,  1865,  1866,  1873,  1874,  1883,  1885,
    1889,  1891,  1895,  1906,  1914,  1929,  1931,  1933,  1935,  1939,
    1943,  1947,  1948,  1951,  1952,  1956,  1957,  1958,  1961,  1968,
    1969,  1972,  1974,  1976,  1978,  1982,  1983,  1986,  1987,  1990,
    2002,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2016,
    2018,  2022,  2023,  2026,  2027,  2036,  2051,  2056,  2061,  2066,
    2071,  2076,  2081,  2086,  2091,  2093,  2097,  2098,  2099,  2100,
    2101,  2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,
    2113,  2114,  2117,  2119,  2121,  2123,  2125,  2127,  2129,  2131,
    2133,  2135,  2137,  2141,  2142,  2143,  2144,  2145,  2146,  2147,
    2148,  2149,  2150,  2153,  2154,  2164,  2168,  2172,  2179,  2180,
    2181,  2184,  2186,  2190,  2191,  2192,  2193,  2196,  2198,  2200,
    2202,  2204,  2206,  2208,  2212,  2214,  2218,  2219,  2222,  2227,
    2230,  2232,  2236,  2245,  2250,  2254,  2255,  2258,  2259,  2271,
    2276,  2277,  2280,  2283,  2286,  2287,  2290,  2292,  2294,  2298,
    2299,  2300,  2303,  2306,  2311,  2312,  2315,  2317,  2321,  2323,
    2327,  2328,  2329,  2330,  2331,  2334,  2335,  2336,  2337,  2340,
    2342,  2346,  2348,  2358,  2360,  2365,  2367,  2372,  2374,  2376,
    2378,  2380,  2382,  2384,  2386,  2388,  2390,  2393,  2395,  2397,
    2401,  2402,  2406,  2410,  2411,  2414,  2415,  2428,  2432,  2436,
    2437,  2441,  2445,  2447,  2449,  2451,  2456,  2458,  2462,  2465,
    2470,  2471,  2475,  2486,  2488,  2490,  2494,  2495,  2498,  2499,
    2510,  2512,  2514,  2516,  2518,  2520,  2522,  2524,  2526,  2528,
    2530,  2532,  2534,  2536,  2540,  2541,  2551,  2553,  2555,  2557,
    2559,  2561,  2571,  2573,  2575,  2577,  2579,  2581,  2583,  2585,
    2587,  2589,  2601,  2600,  2610,  2611,  2612,  2616,  2618,  2622,
    2623,  2624,  2625,  2626,  2629,  2630,  2634,  2635,  2636,  2637,
    2640,  2641,  2642,  2645,  2657,  2661,  2665,  2667,  2680,  2681,
    2682,  2683,  2684,  2685,  2686,  2687,  2688,  2689,  2690,  2691,
    2692,  2693,  2696,  2697,  2698,  2702,  2704,  2705,  2709,  2710,
    2711,  2715,  2716,  2726,  2728,  2740,  2752,  2754,  2758,  2760,
    2764,  2766,  2768,  2770,  2772,  2774,  2776,  2778,  2780,  2782,
    2784,  2788,  2789,  2800,  2804,  2806,  2811,  2812,  2816,  2826,
    2837,  2844,  2846,  2848,  2850,  2852,  2856,  2857,  2861,  2875,
    2877,  2879,  2892,  2894,  2896,  2900,  2902,  2906,  2907,  2910,
    2911,  2914,  2915,  2918,  2919,  2922,  2925,  2936,  2941,  2942,
    2943,  2944,  2945,  2949,  2950,  2999,  3003,  3005,  3007,  3009,
    3011,  3015,  3017,  3021,  3033,  3037,  3038,  3041,  3045,  3048,
    3051,  3052,  3053,  3054,  3055,  3056,  3057,  3058,  3061,  3062,
    3072,  3086,  3117,  3118,  3119,  3120,  3121,  3124,  3128,  3129,
    3139,  3141,  3145,  3147,  3151,  3153,  3155,  3157,  3161,  3162,
    3165,  3169,  3171,  3173,  3177,  3182,  3183,  3193,  3195,  3197,
    3199,  3201,  3203,  3205,  3207,  3211,  3212,  3215,  3216,  3219,
    3221,  3223,  3226,  3229,  3230,  3233,  3237,  3238,  3241,  3243,
    3245,  3247,  3251,  3253,  3255,  3257,  3259,  3263,  3264,  3267,
    3268,  3271,  3281,  3284,  3287,  3290,  3293,  3295,  3297,  3301,
    3302,  3306,  3307,  3318,  3319,  3322,  3323,  3333,  3335,  3337,
    3339,  3341,  3343,  3345,  3347,  3349,  3351,  3353,  3374,  3376,
    3378,  3380,  3382,  3384,  3386,  3390,  3392,  3394,  3396,  3400,
    3401,  3402,  3403,  3407,  3408,  3418,  3420,  3424,  3426,  3428,
    3430,  3434,  3437,  3438,  3441,  3443,  3447,  3460,  3462,  3464,
    3466,  3471,  3477,  3484,  3491,  3492,  3493,  3494,  3495,  3496,
    3497,  3498,  3499,  3502,  3503,  3504,  3505,  3506,  3507,  3509,
    3511,  3515,  3516,  3517,  3518,  3519,  3522,  3530,  3532,  3534,
    3536,  3538,  3540,  3542,  3544,  3546,  3548,  3550,  3554,  3557,
    3560,  3562,  3565,  3568,  3570,  3573,  3581,  3582,  3585,  3586,
    3589,  3593,  3602,  3603,  3606,  3607,  3610,  3614,  3618,  3620,
    3622,  3624,  3626,  3628,  3632,  3635,  3638,  3641,  3644,  3646,
    3648,  3650,  3654,  3658,  3660,  3663,  3666,  3667,  3668,  3669,
    3670,  3671,  3672,  3673,  3674,  3675,  3676,  3677,  3678,  3679,
    3705,  3707,  3709,  3720,  3722,  3724,  3726,  3728,  3730,  3732,
    3734,  3736,  3738,  3740,  3742,  3744,  3746,  3748,  3750,  3752,
    3754,  3756,  3758,  3760,  3762,  3764,  3766,  3768,  3770,  3772,
    3774,  3776,  3778,  3780,  3782,  3784,  3795,  3797,  3799,  3801,
    3803,  3805,  3807,  3809,  3811,  3813,  3815,  3817,  3819,  3821,
    3823,  3825,  3827,  3829,  3841,  3843,  3845,  3847,  3849,  3851,
    3853,  3855,  3857,  3859,  3861,  3863,  3865,  3867,  3869,  3871,
    3873,  3875,  3887,  3889,  3891,  3893,  3895,  3897,  3899,  3901,
    3903,  3905,  3907,  3919,  3921,  3923,  3925,  3927,  3929,  3931,
    3933,  3935,  3937,  3939,  3941,  3943,  3945,  3947,  3949,  3951,
    3953,  3955,  3957,  3959,  3961,  3963,  3965,  3968,  3970,  3972,
    3974,  3976,  3978,  3980,  3982,  3984,  3986,  3991,  3993,  3995,
    3999,  4000,  4001,  4004,  4005,  4008,  4009,  4010,  4011,  4012,
    4013,  4014,  4015,  4016,  4019,  4020,  4023,  4024,  4027,  4028,
    4029,  4030,  4031,  4032,  4035,  4037,  4041,  4044,  4047,  4049,
    4053,  4054,  4058,  4059,  4065,  4066,  4067,  4068,  4069,  4070,
    4071,  4072,  4076,  4078,  4083,  4087,  4090,  4093,  4095,  4097,
    4099,  4101,  4104,  4107,  4111,  4115,  4117,  4119,  4123,  4125,
    4132,  4136,  4138,  4142,  4146,  4149,  4152,  4153,  4156,  4157,
    4161,  4162,  4163,  4164,  4167,  4168,  4172,  4173,  4176,  4177,
    4186,  4188,  4193,  4195,  4197,  4202,  4204,  4228,  4232,  4241,
    4252,  4260,  4270,  4272,  4276,  4278,  4282,  4283,  4293,  4294,
    4297,  4299,  4303,  4305,  4309,  4311,  4316,  4317,  4318,  4319,
    4320,  4322,  4324,  4326,  4334,  4336,  4338,  4340,  4342,  4344,
    4346,  4348,  4352,  4353,  4354,  4355,  4356,  4367,  4368,  4371,
    4372,  4375,  4383,  4386,  4394,  4395,  4404,  4413,  4425,  4426,
    4429,  4430,  4431,  4434,  4435,  4436,  4437,  4438,  4441,  4442,
    4445,  4446,  4447,  4448,  4449,  4450,  4453,  4455,  4462,  4478,
    4480,  4483,  4485,  4489,  4497,  4513,  4520,  4526,  4538,  4547,
    4548,  4551,  4552,  4553,  4556,  4557,  4560,  4561,  4564,  4565,
    4568,  4570,  4572,  4574,  4578,  4585,  4608,  4640,  4650,  4657,
    4697,  4699,  4706,  4708,  4709,  4714,  4712,  4727,  4726,  4739,
    4745,  4747,  4748,  4751,  4752,  4753,  4754,  4755,  4762,  4761,
    4771,  4773,  4775,  4776,  4777,  4780,  4781,  4782,  4783,  4784,
    4787,  4788,  4792,  4791,  4852,  4850,  4865,  4864,  4877,  4883,
    4887,  4891,  4897,  4898,  4899,  4900,  4903,  4904,  4907,  4915,
    4932,  4940,  4963,  5057,  5091,  5093,  5095,  5099,  5103,  5102,
    5153,  5155,  5154,  5169,  5175,  5182,  5187,  5190,  5191,  5194,
    5195,  5196,  5197,  5198,  5199,  5200,  5208,  5216,  5219,  5220,
    5221,  5222,  5223,  5224,  5232,  5240,  5241,  5242,  5245,  5246,
    5249,  5251,  5255,  5326,  5327,  5334,  5335,  5336,  5342,  5351,
    5354,  5355,  5356,  5357,  5360,  5361,  5367,  5381,  5380,  5398,
    5399,  5400,  5401,  5402,  5405,  5407,  5411,  5412,  5419,  5424,
    5426,  5427,  5430,  5431,  5434,  5441,  5448,  5448,  5450,  5451,
    5454,  5454,  5456,  5466,  5475,  5481,  5487,  5493,  5501,  5502,
    5514,  5524,  5535,  5539,  5540,  5543,  5548,  5552,  5553,  5556,
    5563,  5570,  5574,  5575,  5578,  5581,  5585,  5586,  5589,  5596,
    5597,  5598,  5599,  5600,  5601,  5602,  5603,  5604,  5605,  5606,
    5607,  5608,  5609,  5610,  5640,  5641,  5644,  5645,  5652,  5653,
    5654,  5661,  5660,  5719,  5720,  5727,  5726,  5795,  5801,  5807,
    5815,  5821,  5827,  5833,  5839,  5845,  5851,  5857,  5863,  5874,
    5875,  5878,  5879,  5880,  5881,  5882,  5883,  5884,  5885,  5886,
    5887,  5888,  5889,  5890,  5891,  5892,  5893,  5894,  5895,  5896,
    5897,  5898,  5899,  5900,  5901,  5902,  5903,  5904,  5907,  5908,
    5909,  5910,  5911,  5912,  5916,  5917,  5918,  5919,  5920,  5921,
    5922,  5925,  5939,  5940,  5941,  5942,  5943,  5944,  5945,  5949,
    5950,  5951,  5952,  5953,  5954,  5959,  5960,  5961,  5962,  5963,
    5968,  5969,  5970,  5971,  5972,  5978,  5979,  5980,  5981,  5982,
    5983,  5984,  5985,  5986,  5989,  5990,  5991,  5992,  5995,  5996,
    5997,  5998,  6001,  6002,  6003,  6004,  6005,  6006,  6007,  6025,
    6025,  6027,  6028,  6029,  6030,  6031,  6032,  6039,  6040,  6043,
    6044,  6045,  6046,  6047,  6048,  6049,  6050,  6051,  6052,  6053,
    6054,  6055,  6056,  6057,  6058,  6059,  6060,  6061,  6062,  6063,
    6064,  6065,  6066,  6067,  6068,  6069,  6070,  6072,  6073,  6074,
    6075,  6076,  6077,  6078,  6079,  6080,  6081,  6083,  6084,  6085,
    6086,  6087,  6088,  6089,  6090,  6091,  6092,  6093,  6094,  6095,
    6096,  6097,  6098,  6099,  6100,  6101,  6102,  6103,  6104,  6105,
    6106,  6107,  6108,  6109,  6110,  6111,  6112,  6114,  6115,  6116,
    6117,  6118,  6119,  6120,  6121,  6122,  6123,  6124,  6125,  6126,
    6127,  6128,  6129,  6130,  6131,  6132,  6133,  6134,  6135,  6136,
    6137,  6138,  6139,  6141,  6142,  6144,  6145,  6146,  6147,  6148,
    6149,  6150,  6151,  6152,  6153,  6154,  6155,  6156,  6157,  6158,
    6159,  6160,  6161,  6162,  6163,  6164,  6165,  6166,  6167,  6168,
    6169,  6170,  6171,  6172,  6173,  6174,  6175,  6176,  6177,  6178,
    6179,  6180,  6181,  6182,  6183,  6184,  6185,  6186,  6187,  6188,
    6189,  6190,  6191,  6192,  6194,  6195,  6196,  6197,  6198,  6199,
    6200,  6201,  6202,  6203,  6204,  6205,  6206,  6207,  6208,  6209,
    6210,  6211,  6212,  6213,  6214,  6215,  6216,  6217,  6218,  6219,
    6220,  6221,  6222,  6223,  6224,  6225,  6226,  6227,  6228,  6229,
    6230,  6231,  6232,  6233,  6234,  6235,  6236,  6238,  6252,  6253,
    6257,  6258,  6259,  6260,  6261,  6262,  6263,  6264,  6265,  6266,
    6270,  6271,  6272,  6273,  6274,  6275,  6276,  6277,  6278,  6279,
    6280,  6281,  6282,  6283,  6284,  6285,  6286,  6287,  6288,  6289,
    6290,  6291,  6305,  6306,  6307,  6308,  6309,  6310,  6311,  6312,
    6313,  6314,  6315,  6316,  6317,  6318,  6319,  6320,  6321,  6322,
    6323,  6324,  6334,  6335,  6336,  6337,  6338,  6339,  6340,  6341,
    6342,  6343,  6344,  6345,  6346,  6347,  6348,  6349,  6350,  6351,
    6352,  6353,  6354,  6355,  6356,  6357,  6358,  6359,  6360,  6361,
    6362,  6363,  6364,  6365,  6366,  6367,  6368,  6369,  6370,  6371,
    6372,  6373,  6374,  6375,  6376,  6377,  6378,  6379,  6380,  6381,
    6382,  6383,  6384,  6385,  6386,  6387,  6388,  6389,  6390,  6391,
    6392,  6393,  6394,  6398,  6399,  6403,  6404,  6405,  6406,  6407,
    6411,  6411,  6414,  6417,  6418,  6421,  6423,  6428,  6438,  6445,
    6446,  6447,  6450,  6479,  6480,  6483,  6485,  6493,  6494,  6495,
    6499,  6500,  6504,  6505,  6508,  6509,  6512,  6513,  6514,  6515,
    6516,  6519,  6520,  6521,  6522,  6523,  6524,  6525,  6526,  6527,
    6528,  6529,  6530,  6531,  6532,  6533,  6534,  6535,  6536,  6537,
    6538,  6539,  6540,  6541,  6542,  6543,  6544,  6545,  6546,  6547,
    6548,  6549,  6550,  6551,  6552,  6553,  6554,  6555,  6556,  6557,
    6558,  6559,  6560,  6561,  6562,  6563,  6564,  6565,  6566,  6567,
    6568,  6569,  6570,  6571,  6572,  6573,  6574
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_CONTINUE", "SQL_COUNT", "SQL_CURRENT", "SQL_DATA", 
  "SQL_DATETIME_INTERVAL_CODE", "SQL_DATETIME_INTERVAL_PRECISION", 
  "SQL_DESCRIBE", "SQL_DESCRIPTOR", "SQL_DISCONNECT", "SQL_ENUM", 
  "SQL_FOUND", "SQL_FREE", "SQL_GO", "SQL_GOTO", "SQL_IDENTIFIED", 
  "SQL_INDICATOR", "SQL_KEY_MEMBER", "SQL_LENGTH", "SQL_LONG", "SQL_NAME", 
  "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN", "SQL_OUTPUT", 
  "SQL_REFERENCE", "SQL_RETURNED_LENGTH", "SQL_RETURNED_OCTET_LENGTH", 
  "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", "SQL_SIGNED", "SQL_SQL", 
  "SQL_SQLERROR", "SQL_SQLPRINT", "SQL_SQLWARNING", "SQL_START", 
  "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", "SQL_VALUE", "SQL_VAR", 
  "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", "S_CONST", 
  "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", "S_INC", 
  "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", "S_NEQUAL", 
  "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", "S_VOLATILE", 
  "S_TYPEDEF", "TYPECAST", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ANALYSE", 
  "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION", 
  "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", "BACKWARD", "BEFORE", 
  "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN_P", "BOTH", 
  "BY", "CACHE", "CALLED", "CASCADE", "CASE", "CAST", "CHAIN", "CHAR_P", 
  "CHARACTER", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", 
  "CLUSTER", "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMIT", 
  "COMMITTED", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONVERSION_P", 
  "CONVERT", "COPY", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", 
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", 
  "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", 
  "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", 
  "DELIMITER", "DELIMITERS", "DESC", "DISABLE_P", "DISTINCT", "DO", 
  "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", "ENABLE_P", "ENCODING", 
  "ENCRYPTED", "END_P", "ESCAPE", "EXCEPT", "EXCLUSIVE", "EXCLUDING", 
  "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", 
  "FETCH", "FIRST_P", "FLOAT_P", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "GET", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER", "HOLD", 
  "HOUR_P", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT_P", "IN_P", 
  "INCLUDING", "INCREMENT", "INDEX", "INHERIT", "INHERITS", "INITIALLY", 
  "INNER_P", "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", 
  "INT_P", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", 
  "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", 
  "LARGE_P", "LAST_P", "LEADING", "LEAST", "LEFT", "LEVEL", "LIKE", 
  "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", 
  "LOCATION", "LOCK_P", "LOGIN_P", "MATCH", "MAXVALUE", "MINUTE_P", 
  "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAMES", "NATIONAL", "NATURAL", 
  "NCHAR", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEROLE", 
  "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", "NOSUPERUSER", "NOT", 
  "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NUMERIC", 
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", 
  "OPERATOR", "OPTION", "OR", "ORDER", "OUT_P", "OUTER_P", "OVERLAPS", 
  "OVERLAY", "OWNER", "PARTIAL", "PASSWORD", "PLACING", "POSITION", 
  "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY", "PRIOR", 
  "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "READ", "REAL", 
  "RECHECK", "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "RESET", "RESTART", "RESTRICT", "RETURNS", 
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE", 
  "SAVEPOINT", "SCHEMA", "SCROLL", "SECOND_P", "SECURITY", "SELECT", 
  "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", 
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "STABLE", 
  "START", "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", 
  "STRICT_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", 
  "SYSTEM_P", "TABLE", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "THEN", "TIME", "TIMESTAMP", "TO", "TOAST", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", 
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", 
  "VALUES", "VARCHAR", "VARYING", "VERBOSE", "VIEW", "VOLATILE", "WHEN", 
  "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR_P", "ZONE", 
  "UNIONJOIN", "IDENT", "SCONST", "Op", "CSTRING", "CVARIABLE", 
  "CPP_LINE", "IP", "BCONST", "XCONST", "ICONST", "PARAM", "FCONST", 
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", 
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "';'", "'{'", "'}'", 
  "\"=\"", "','", "':'", "$accept", "prog", "statements", "statement", 
  "opt_at", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "CreateUserStmt", "AlterRoleStmt", "AlterRoleSetStmt", "AlterUserStmt", 
  "DropRoleStmt", "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", 
  "add_drop", "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list_or_default", "var_list", "iso_level", "var_value", 
  "opt_boolean", "zone_value", "opt_encoding", "ColId_or_Sconst", 
  "VariableShowStmt", "VariableResetStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_rel_cmds", "alter_rel_cmd", "alter_column_default", 
  "opt_drop_behavior", "alter_using", "ClosePortalStmt", "CopyStmt", 
  "copy_from", "copy_file_name", "copy_opt_list", "copy_opt_item", 
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using", "CreateStmt", 
  "OptTemp", "OptTableElementList", "TableElementList", "TableElement", 
  "columnDef", "ColQualList", "ColConstraint", "ColConstraintElem", 
  "ConstraintAttr", "TableLikeClause", "like_including_defaults", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "key_actions", "key_delete", "key_update", 
  "key_action", "OptInherit", "OptWithOids", "OnCommitOption", 
  "OptTableSpace", "OptConsTableSpace", "CreateAsStmt", "@1", 
  "WithOidsAs", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "CreateSeqStmt", "AlterSeqStmt", "OptSeqList", "OptSeqElem", "opt_by", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_validator", 
  "opt_lancompiler", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents", 
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", "TriggerForType", 
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable", 
  "ConstraintAttributeSpec", "ConstraintDeferrabilitySpec", 
  "ConstraintTimeSpec", "DropTrigStmt", "CreateAssertStmt", 
  "DropAssertStmt", "DefineStmt", "rowdefinition", "definition", 
  "def_list", "def_elem", "def_arg", "CreateOpClassStmt", 
  "opclass_item_list", "opclass_item", "opt_default", "opt_recheck", 
  "DropOpClassStmt", "DropStmt", "drop_type", "any_name_list", "any_name", 
  "attrs", "TruncateStmt", "FetchStmt", "fetch_direction", "from_in", 
  "CommentStmt", "comment_type", "comment_text", "GrantStmt", 
  "RevokeStmt", "privileges", "privilege_list", "privilege", 
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option", 
  "function_with_argtypes_list", "function_with_argtypes", 
  "GrantRoleStmt", "RevokeRoleStmt", "opt_grant_admin_option", 
  "opt_granted_by", "IndexStmt", "index_opt_unique", 
  "access_method_clause", "index_params", "index_elem", "opt_class", 
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list", 
  "func_arg", "arg_class", "func_as", "param_name", "func_return", 
  "func_type", "createfunc_opt_list", "common_func_opt_item", 
  "createfunc_opt_item", "opt_definition", "AlterFunctionStmt", 
  "alterfunc_opt_list", "opt_restrict", "RemoveFuncStmt", 
  "RemoveAggrStmt", "aggr_argtype", "RemoveOperStmt", "oper_argtypes", 
  "any_operator", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "ReindexStmt", "reindex_type", "opt_force", "RenameStmt", "opt_column", 
  "AlterObjectSchemaStmt", "AlterOwnerStmt", "RuleStmt", "@2", 
  "RuleActionList", "RuleActionMulti", "RuleActionStmt", 
  "RuleActionStmtOrEmpty", "event", "opt_instead", "DropRuleStmt", 
  "NotifyStmt", "ListenStmt", "UnlistenStmt", "TransactionStmt", 
  "opt_transaction", "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "LoadStmt", 
  "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", "opt_equal", 
  "AlterDatabaseStmt", "AlterDatabaseSetStmt", "alterdb_opt_list", 
  "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt", "AlterDomainStmt", 
  "opt_as", "CreateConversionStmt", "ClusterStmt", "VacuumStmt", 
  "AnalyzeStmt", "analyze_keyword", "opt_verbose", "opt_full", 
  "opt_freeze", "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "opt_analyze", "InsertStmt", "insert_rest", "insert_column_list", 
  "insert_column_item", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", 
  "DeclareCursorStmt", "cursor_options", "opt_hold", "SelectStmt", 
  "select_with_parens", "select_no_parens", "select_clause", 
  "simple_select", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "select_limit_value", "select_offset_value", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "locked_rels_list", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "func_table", "where_clause", "TableFuncElementList", 
  "TableFuncElement", "Typename", "opt_array_bounds", "Iresult", 
  "SimpleTypename", "ConstTypename", "GenericType", "Numeric", 
  "opt_float", "opt_numeric", "opt_decimal", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "a_expr", "b_expr", "c_expr", 
  "func_expr", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "extract_list", "type_list", 
  "array_expr_list", "array_expr", "extract_arg", "overlay_list", 
  "overlay_placing", "position_list", "substr_list", "substr_from", 
  "substr_for", "trim_list", "in_expr", "case_expr", "when_clause_list", 
  "when_clause", "case_default", "case_arg", "columnref", 
  "indirection_el", "indirection", "opt_indirection", "opt_asymmetric", 
  "target_list", "target_el", "update_target_list", "inf_col_list", 
  "inf_val_list", "update_target_el", "insert_target_list", 
  "insert_target_el", "relation_name", "qualified_name_list", 
  "qualified_name", "name_list", "name", "database_name", "access_method", 
  "attr_name", "index_name", "file_name", "func_name", "AexprConst", 
  "Iconst", "Fconst", "Bconst", "Xconst", "Sconst", "PosIntConst", 
  "IntConst", "IntConstVar", "AllConstVar", "StringConst", 
  "PosIntStringConst", "NumConst", "AllConst", "PosAllConst", "RoleId", 
  "SpecialRuleRelation", "ECPGConnect", "connection_target", "db_prefix", 
  "server", "opt_server", "server_name", "opt_port", 
  "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "ECPGCursorStmt", "ECPGDeallocate", 
  "ECPGVarDeclaration", "single_vt_declaration", "single_var_declaration", 
  "@3", "@4", "precision", "opt_scale", "ecpg_interval", 
  "ECPGDeclaration", "@5", "sql_startdeclare", "sql_enddeclare", 
  "var_type_declarations", "vt_declarations", "variable_declarations", 
  "type_declaration", "@6", "var_declaration", "@7", "@8", 
  "storage_declaration", "storage_clause", "storage_modifier", "var_type", 
  "enum_type", "enum_definition", "struct_union_type_with_symbol", "@9", 
  "struct_union_type", "@10", "s_struct_union_symbol", "s_struct_union", 
  "simple_type", "unsigned_type", "signed_type", "opt_signed", 
  "variable_list", "variable", "opt_initializer", "opt_pointer", 
  "ECPGDeclare", "ECPGDisconnect", "dis_name", "connection_object", 
  "ECPGExecute", "@11", "execute_rest", "execstring", "prepared_name", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "opt_sql", "ecpg_into", 
  "using_list", "UsingConst", "ECPGPrepare", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "desc_header_item", "ECPGGetDescriptor", 
  "ECPGGetDescItems", "ECPGGetDescItem", "ECPGSetDescriptor", 
  "ECPGSetDescItems", "ECPGSetDescItem", "descriptor_item", 
  "ECPGSetAutocommit", "on_off", "ECPGSetConnection", "ECPGTypedef", 
  "@12", "opt_reference", "ECPGVar", "@13", "ECPGWhenever", "action", 
  "ECPGKeywords", "ECPGKeywords_vanames", "ECPGKeywords_rest", 
  "ECPGTypeName", "symbol", "ECPGColId", "ColId", "type_name", 
  "function_name", "ColLabel", "ECPGColLabelCommon", "ECPGColLabel", 
  "ECPGCKeywords", "unreserved_keyword", "ECPGunreserved_interval", 
  "ECPGunreserved", "ECPGunreserved_con", "col_name_keyword", 
  "func_name_keyword", "reserved_keyword", "into_list", "ecpgstart", 
  "c_args", "coutputvariable", "civarind", "civar", "indicator", 
  "cvariable", "ident", "quoted_ident_stringvar", "c_stuff_item", 
  "c_stuff", "c_list", "c_term", "c_thing", "c_anything", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,    61,    60,    62,   680,    43,
      45,    42,    47,    37,    94,   681,    91,    93,    40,    41,
      46,    59,   123,   125,   682,    44,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   447,   448,   449,   449,   450,   450,   450,   450,   450,
     450,   450,   450,   451,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   452,   452,   452,   452,   452,   452,
     452,   452,   452,   452,   453,   454,   454,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   455,   455,   455,   455,
     455,   455,   455,   455,   455,   455,   455,   455,   456,   457,
     458,   458,   459,   458,   458,   460,   461,   462,   463,   464,
     464,   465,   466,   466,   467,   467,   468,   468,   469,   469,
     469,   469,   469,   469,   470,   470,   470,   471,   471,   471,
     471,   471,   471,   471,   471,   471,   472,   472,   473,   473,
     474,   474,   475,   475,   475,   475,   476,   476,   476,   477,
     477,   477,   477,   478,   478,   478,   478,   478,   478,   479,
     479,   479,   480,   480,   481,   481,   481,   481,   481,   482,
     482,   482,   482,   482,   483,   484,   484,   485,   485,   486,
     487,   487,   488,   488,   489,   489,   489,   489,   489,   489,
     489,   489,   489,   489,   489,   489,   489,   489,   489,   489,
     489,   489,   489,   489,   490,   490,   491,   491,   492,   492,
     493,   493,   493,   494,   494,   495,   496,   497,   497,   498,
     498,   498,   499,   499,   500,   500,   500,   500,   500,   500,
     500,   500,   500,   500,   501,   501,   502,   502,   503,   503,
     504,   504,   505,   505,   506,   506,   506,   506,   506,   506,
     506,   507,   507,   508,   508,   509,   509,   509,   510,   511,
     511,   512,   512,   512,   513,   513,   513,   513,   513,   513,
     513,   514,   514,   514,   514,   515,   516,   516,   516,   517,
     517,   518,   518,   518,   518,   519,   519,   520,   520,   521,
     522,   522,   522,   523,   523,   523,   523,   523,   524,   525,
     526,   526,   526,   526,   526,   527,   527,   528,   528,   528,
     529,   529,   529,   529,   530,   530,   531,   531,   533,   532,
     534,   534,   534,   535,   535,   536,   536,   537,   538,   539,
     540,   540,   541,   541,   541,   541,   541,   541,   541,   541,
     541,   541,   542,   542,   543,   543,   544,   544,   545,   545,
     546,   546,   547,   547,   548,   549,   549,   550,   551,   551,
     552,   553,   553,   554,   554,   555,   555,   555,   556,   556,
     556,   557,   557,   558,   558,   559,   559,   560,   560,   560,
     561,   561,   562,   562,   563,   563,   563,   563,   564,   564,
     565,   565,   566,   567,   568,   569,   569,   569,   569,   570,
     571,   572,   572,   573,   573,   574,   574,   574,   575,   576,
     576,   577,   577,   577,   577,   578,   578,   579,   579,   580,
     581,   582,   582,   582,   582,   582,   582,   582,   582,   583,
     583,   584,   584,   585,   585,   586,   587,   587,   587,   587,
     587,   587,   587,   587,   587,   587,   588,   588,   588,   588,
     588,   588,   588,   588,   588,   588,   588,   588,   588,   588,
     589,   589,   590,   590,   590,   590,   590,   590,   590,   590,
     590,   590,   590,   591,   591,   591,   591,   591,   591,   591,
     591,   591,   591,   592,   592,   593,   594,   594,   595,   595,
     595,   596,   596,   597,   597,   597,   597,   598,   598,   598,
     598,   598,   598,   598,   599,   599,   600,   600,   601,   601,
     602,   602,   603,   604,   605,   606,   606,   607,   607,   608,
     609,   609,   610,   610,   611,   611,   612,   612,   612,   613,
     613,   613,   614,   614,   615,   615,   616,   616,   617,   617,
     618,   618,   618,   618,   618,   619,   619,   619,   619,   620,
     620,   621,   622,   623,   623,   624,   624,   625,   625,   625,
     625,   625,   625,   625,   625,   625,   625,   626,   626,   626,
     627,   627,   628,   629,   629,   630,   630,   631,   632,   633,
     633,   634,   635,   635,   635,   635,   636,   636,   637,   637,
     638,   638,   639,   640,   640,   640,   641,   641,   642,   642,
     643,   643,   643,   643,   643,   643,   643,   643,   643,   643,
     643,   643,   643,   643,   644,   644,   645,   645,   645,   645,
     645,   645,   646,   646,   646,   646,   646,   646,   646,   646,
     646,   646,   648,   647,   649,   649,   649,   650,   650,   651,
     651,   651,   651,   651,   652,   652,   653,   653,   653,   653,
     654,   654,   654,   655,   656,   657,   658,   658,   659,   659,
     659,   659,   659,   659,   659,   659,   659,   659,   659,   659,
     659,   659,   660,   660,   660,   661,   661,   661,   662,   662,
     662,   663,   663,   664,   664,   665,   666,   666,   667,   667,
     668,   668,   668,   668,   668,   668,   668,   668,   668,   668,
     668,   669,   669,   670,   671,   671,   672,   672,   673,   674,
     675,   676,   676,   676,   676,   676,   677,   677,   678,   679,
     679,   679,   680,   680,   680,   681,   681,   682,   682,   683,
     683,   684,   684,   685,   685,   686,   686,   687,   688,   688,
     688,   688,   688,   689,   689,   690,   691,   691,   691,   691,
     691,   692,   692,   693,   694,   695,   695,   696,   697,   697,
     698,   698,   698,   698,   698,   698,   698,   698,   699,   699,
     700,   701,   702,   702,   702,   702,   702,   703,   703,   703,
     704,   704,   705,   705,   706,   706,   706,   706,   707,   707,
     708,   708,   708,   708,   709,   709,   709,   710,   710,   710,
     710,   710,   710,   710,   710,   711,   711,   712,   712,   713,
     713,   713,   713,   714,   714,   715,   716,   716,   717,   717,
     717,   717,   718,   718,   718,   718,   718,   719,   719,   720,
     720,   721,   722,   722,   723,   723,   724,   724,   724,   725,
     725,   726,   726,   727,   727,   728,   728,   729,   729,   729,
     729,   729,   729,   729,   729,   729,   729,   729,   730,   730,
     730,   730,   730,   730,   730,   731,   731,   731,   731,   732,
     732,   732,   732,   733,   733,   734,   734,   735,   735,   735,
     735,   736,   737,   737,   738,   738,   739,   740,   740,   740,
     740,   741,   741,   741,   742,   742,   742,   742,   742,   742,
     742,   742,   742,   743,   743,   743,   743,   743,   743,   743,
     743,   744,   744,   744,   744,   744,   745,   746,   746,   746,
     746,   746,   746,   746,   746,   746,   746,   746,   747,   747,
     748,   748,   748,   749,   749,   749,   750,   750,   751,   751,
     752,   753,   754,   754,   755,   755,   756,   757,   758,   758,
     758,   758,   758,   758,   759,   759,   760,   760,   761,   761,
     761,   761,   762,   763,   763,   763,   764,   764,   764,   764,
     764,   764,   764,   764,   764,   764,   764,   764,   764,   764,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   765,   765,   765,   765,   765,   765,
     765,   765,   765,   765,   766,   766,   766,   766,   766,   766,
     766,   766,   766,   766,   766,   766,   766,   766,   766,   766,
     766,   766,   767,   767,   767,   767,   767,   767,   767,   767,
     767,   767,   767,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   768,   768,   768,
     768,   768,   768,   768,   768,   768,   768,   769,   769,   769,
     770,   770,   770,   771,   771,   772,   772,   772,   772,   772,
     772,   772,   772,   772,   773,   773,   774,   774,   775,   775,
     775,   775,   775,   775,   776,   776,   777,   777,   778,   778,
     779,   779,   780,   780,   781,   781,   781,   781,   781,   781,
     781,   781,   782,   782,   783,   784,   784,   785,   785,   785,
     785,   785,   785,   786,   787,   788,   788,   788,   789,   789,
     790,   791,   791,   792,   793,   793,   794,   794,   795,   795,
     796,   796,   796,   796,   797,   797,   798,   798,   799,   799,
     800,   800,   801,   801,   801,   802,   802,   802,   803,   803,
     804,   804,   805,   805,   806,   806,   807,   807,   808,   808,
     809,   809,   810,   810,   811,   811,   812,   813,   814,   815,
     816,   817,   818,   818,   819,   819,   819,   819,   819,   819,
     819,   819,   820,   821,   822,   823,   824,   825,   825,   826,
     826,   827,   827,   828,   828,   828,   828,   828,   829,   829,
     830,   830,   830,   831,   831,   831,   831,   831,   832,   832,
     833,   833,   833,   833,   833,   833,   834,   835,   835,   836,
     836,   836,   836,   837,   837,   837,   837,   838,   839,   840,
     840,   841,   841,   841,   842,   842,   843,   843,   844,   844,
     845,   845,   845,   845,   846,   846,   847,   848,   848,   849,
     850,   850,   851,   852,   852,   854,   853,   855,   853,   853,
     856,   857,   857,   858,   858,   858,   858,   858,   860,   859,
     861,   862,   863,   863,   863,   864,   864,   864,   864,   864,
     865,   865,   867,   866,   869,   868,   870,   868,   868,   871,
     871,   871,   872,   872,   872,   872,   873,   873,   874,   874,
     874,   874,   874,   874,   875,   875,   875,   876,   878,   877,
     879,   880,   879,   881,   881,   882,   882,   883,   883,   884,
     884,   884,   884,   884,   884,   884,   884,   884,   885,   885,
     885,   885,   885,   885,   885,   885,   885,   885,   886,   886,
     887,   887,   888,   889,   889,   890,   890,   890,   891,   892,
     893,   893,   893,   893,   894,   894,   895,   896,   895,   897,
     897,   897,   897,   897,   898,   898,   899,   899,   900,   901,
     902,   902,   903,   903,   904,   905,   906,   906,   907,   907,
     908,   908,   909,   909,   910,   911,   911,   911,   912,   912,
     913,   914,   915,   916,   916,   917,   918,   919,   919,   920,
     921,   922,   923,   923,   924,   925,   926,   926,   927,   928,
     928,   928,   928,   928,   928,   928,   928,   928,   928,   928,
     928,   928,   928,   928,   929,   929,   930,   930,   931,   931,
     931,   933,   932,   934,   934,   936,   935,   937,   937,   937,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   939,
     939,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   940,   940,
     940,   940,   940,   940,   940,   940,   940,   940,   941,   941,
     941,   941,   941,   941,   942,   942,   942,   942,   942,   942,
     942,   943,   944,   944,   944,   944,   944,   944,   944,   945,
     945,   945,   945,   945,   945,   946,   946,   946,   946,   946,
     947,   947,   947,   947,   947,   948,   948,   948,   948,   948,
     948,   948,   948,   948,   949,   949,   949,   949,   950,   950,
     950,   950,   951,   951,   951,   951,   951,   951,   951,   952,
     952,   953,   953,   953,   953,   953,   953,   954,   954,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   955,   955,
     955,   955,   955,   955,   955,   955,   955,   955,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   956,   956,   956,   956,   956,   956,   956,   956,
     956,   956,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   957,   957,   957,   957,   957,   957,   957,   957,
     957,   957,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     958,   958,   958,   958,   958,   958,   958,   958,   958,   958,
     959,   959,   960,   961,   961,   962,   962,   963,   964,   965,
     965,   965,   966,   967,   967,   968,   968,   969,   969,   969,
     970,   970,   971,   971,   972,   972,   973,   973,   973,   973,
     973,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974,   974,   974,   974,
     974,   974,   974,   974,   974,   974,   974
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     0,     2,     4,     3,     2,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     5,     1,     0,     2,     3,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     2,     2,     2,     2,     3,     3,     5,     5,
       5,     4,     5,     5,     4,     3,     3,     5,     6,     1,
       1,     3,     6,     4,     1,     0,     2,     0,     1,     1,
       1,     1,     1,     1,     2,     3,     3,     3,     3,     3,
       2,     5,     2,     2,     3,     3,     1,     3,     1,     1,
       1,     3,     2,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     6,     1,     1,     1,
       1,     0,     1,     1,     2,     3,     4,     3,     2,     2,
       3,     4,     3,     2,     4,     1,     1,     1,     1,     1,
       4,     4,     1,     3,     3,     4,     6,     6,     6,     6,
       4,     6,     2,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     1,     3,     3,     3,     3,     2,
       1,     1,     0,     2,     0,     2,     9,     1,     1,     1,
       1,     1,     2,     0,     1,     1,     3,     3,     1,     1,
       3,     3,     3,     4,     1,     0,     2,     0,     3,     0,
       1,     0,    11,    12,     1,     1,     2,     2,     2,     2,
       0,     1,     0,     1,     3,     1,     1,     1,     3,     2,
       0,     3,     1,     1,     2,     1,     2,     3,     4,     2,
       5,     1,     2,     2,     2,     3,     2,     2,     0,     3,
       1,     4,     5,     6,    11,     3,     0,     3,     1,     1,
       2,     2,     0,     1,     1,     2,     2,     0,     3,     3,
       2,     1,     1,     2,     2,     4,     0,     2,     2,     0,
       3,     4,     4,     0,     2,     0,     4,     0,     0,     8,
       3,     3,     1,     3,     0,     3,     1,     1,     5,     4,
       2,     0,     2,     1,     2,     3,     2,     2,     2,     2,
       3,     3,     1,     0,     5,     9,     1,     0,     1,     2,
       2,     0,     2,     0,     5,     1,     0,     6,     2,     0,
       3,    14,    19,     1,     1,     1,     3,     5,     1,     1,
       1,     3,     0,     1,     0,     1,     1,     1,     3,     0,
       1,     1,     0,     2,     1,     2,     1,     2,     2,     1,
       2,     2,     6,     8,     3,     4,     4,     4,     5,     3,
       3,     1,     3,     3,     1,     1,     1,     1,    12,     1,
       3,     4,     7,     4,     2,     1,     0,     1,     0,     7,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     2,     2,     3,     3,     5,     4,     4,     3,
       4,     3,     3,     2,     4,     2,     1,     1,     1,     1,
       2,     2,     1,     1,     1,     2,     2,     1,     2,     2,
       1,     1,     6,     9,     7,     9,     8,     8,     6,     9,
       7,    10,     7,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     7,     7,    10,     2,     1,
       1,     1,     3,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     2,     2,     1,     3,     1,     2,     3,     0,
       1,     3,     2,     6,     6,     3,     0,     3,     0,    12,
       1,     0,     2,     0,     1,     3,     2,     2,     4,     1,
       2,     0,     9,     7,     2,     0,     3,     2,     1,     3,
       3,     3,     2,     2,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     1,     4,     1,     2,     4,     5,     1,
       1,     1,     1,     3,     3,     2,     2,     2,     2,     1,
       2,     0,     5,     1,     2,     1,     0,     5,     7,     1,
       1,     7,     1,     3,     3,     3,     1,     3,    11,    10,
       2,     0,     8,     4,     4,     4,     1,     1,     1,     0,
       9,     6,     6,     7,     6,     6,     9,     6,     6,     6,
       8,     8,     6,     6,     1,     0,     9,     6,     7,     6,
       6,     6,     9,     6,     6,     6,     7,     9,     9,     6,
       6,     6,     0,    14,     1,     1,     3,     3,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     0,     6,     2,     2,     2,     2,     2,     3,
       3,     2,     2,     2,     2,     3,     2,     5,     4,     3,
       3,     3,     1,     1,     0,     3,     2,     2,     1,     3,
       2,     1,     0,     7,     9,     2,     5,     3,     1,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     4,     3,
       3,     1,     0,     5,     5,     4,     2,     0,     4,     3,
       6,     4,     6,     6,     5,     7,     1,     0,    10,     4,
       2,     1,     4,     5,     5,     2,     4,     1,     1,     1,
       0,     1,     0,     1,     0,     3,     0,     4,     1,     1,
       1,     1,     1,     1,     0,     4,     4,     2,     1,     7,
       4,     3,     1,     2,     5,     2,     0,     5,     3,     0,
       2,     2,     2,     3,     1,     3,     1,     2,     1,     0,
       6,     7,     0,     2,     2,     2,     3,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     1,     1,
       8,     4,     4,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     0,     1,
       5,     1,     0,     1,     0,     3,     1,     3,     3,     2,
       2,     1,     4,     4,     2,     2,     4,     1,     0,     1,
       1,     1,     3,     0,     2,     0,     4,     4,     3,     1,
       0,     2,     0,     2,     0,     3,     1,     1,     2,     1,
       2,     5,     6,     5,     1,     2,     1,     4,     3,     4,
       3,     5,     4,     5,     4,     5,     2,     4,     1,     2,
       2,     2,     1,     1,     0,     4,     2,     1,     2,     2,
       4,     1,     2,     0,     1,     3,     2,     2,     3,     5,
       6,     3,     4,     0,     1,     3,     3,     3,     3,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     2,     5,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     2,     2,     2,     1,     3,     0,
       5,     3,     0,     5,     3,     0,     1,     1,     1,     1,
       5,     2,     1,     1,     1,     1,     5,     2,     2,     2,
       1,     3,     3,     2,     1,     0,     3,     0,     5,     2,
       5,     2,     1,     3,     3,     0,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     3,     3,     3,     0,
       1,     3,     5,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     3,     3,     2,
       3,     5,     4,     6,     3,     5,     4,     6,     4,     6,
       5,     7,     2,     3,     2,     4,     3,     4,     3,     4,
       3,     4,     5,     6,     7,     6,     7,     6,     7,     3,
       4,     4,     6,     2,     1,     3,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     2,     2,     5,
       6,     7,     1,     1,     2,     4,     1,     1,     1,     2,
       2,     2,     1,     3,     4,     5,     5,     4,     1,     1,
       4,     1,     4,     1,     4,     1,     4,     1,     1,     1,
       1,     6,     4,     4,     4,     4,     6,     5,     5,     5,
       4,     6,     4,     6,     4,     4,     4,     4,     3,     5,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     1,     4,     1,     4,
       1,     2,     1,     2,     1,     3,     3,     0,     3,     1,
       1,     3,     3,     3,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     3,     2,     3,     0,     3,     3,     2,
       2,     1,     0,     2,     2,     3,     2,     1,     1,     3,
       5,     2,     1,     4,     2,     0,     1,     0,     1,     2,
       2,     2,     3,     5,     1,     2,     0,     2,     1,     0,
       3,     1,     3,     1,     1,     3,     7,     1,     2,     4,
       1,     3,     4,     4,     3,     1,     1,     1,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     3,     6,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     5,
       3,     2,     2,     3,     7,     1,     1,     2,     2,     1,
       0,     1,     3,     1,     2,     0,     2,     0,     2,     0,
       1,     3,     4,     3,     1,     1,     1,     2,     0,     7,
       3,     2,     1,     1,     1,     0,     5,     0,     4,     2,
       1,     2,     0,     1,     3,     3,     3,     3,     0,     4,
       5,     5,     0,     1,     1,     1,     1,     2,     2,     2,
       1,     2,     0,     7,     0,     5,     0,     4,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     5,     2,     1,     3,     2,     2,     3,     0,     5,
       1,     0,     5,     2,     2,     1,     1,     1,     2,     2,
       3,     1,     2,     2,     3,     3,     4,     2,     1,     2,
       1,     1,     2,     2,     3,     1,     1,     1,     1,     0,
       1,     3,     4,     0,     2,     0,     1,     2,     3,     2,
       1,     1,     1,     0,     1,     1,     3,     0,     4,     2,
       2,     1,     1,     0,     1,     1,     1,     1,     2,     3,
       0,     1,     2,     1,     4,     4,     0,     1,     2,     1,
       1,     3,     1,     1,     4,     4,     4,     4,     1,     0,
       3,     3,     4,     1,     3,     3,     4,     1,     3,     3,
       1,     6,     1,     3,     3,     6,     1,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     4,     1,     1,     4,     4,
       3,     0,     7,     1,     0,     0,     7,     3,     4,     3,
       1,     1,     1,     2,     3,     5,     2,     5,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     0,     1,     2,     1,     2,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     2,     3,
       1,     2,     1,     3,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
       3,     0,     2,     1,  2006,  2007,  2010,  2014,  2015,  1942,
    2016,  2017,  1982,  1983,  1984,  1985,  1986,  1987,  1988,  1989,
    1990,  1991,  1992,  1993,  1995,  1994,  1996,  1997,  1998,  1999,
    2000,  2001,  2002,  2003,  2005,  2004,  2019,  2020,  2008,  2009,
    2011,  2012,  1981,  2013,  2021,  2022,  2023,  2018,  1971,  1266,
    1972,    10,  1262,  1263,  2026,  1977,  1978,  1976,  1979,  1980,
    2024,  2025,  1967,  1968,  1970,    11,    12,  1969,     4,  1973,
    1974,  1975,     8,  1348,  1419,     9,  1966,  1419,     0,  1531,
    1532,  1533,     0,  1534,  1535,  1536,  1537,  1538,  1469,  1433,
       0,  1539,     0,  1540,  1541,  1542,  1543,  1544,  1545,  1546,
    1547,  1548,     0,  1549,  1550,  1551,  1552,  1418,  1553,  1554,
    1555,  1556,  1395,  1401,  1557,  1515,     0,  1375,  1376,  1372,
    1374,  1373,  1377,  1362,   714,     0,   768,   767,     0,  1852,
     714,  1853,  1818,  1854,  1819,  1820,   219,     0,   761,  1821,
       0,   714,  1822,   275,   290,  1855,     0,     0,  1823,  1824,
       0,     0,   396,   714,     0,  1825,   784,  1826,     0,  1827,
    1856,  1857,     0,     0,  1828,  1858,  1859,  1829,     0,  1830,
    1831,  1860,  1861,  1862,  1832,  1863,  1864,     0,     0,   846,
       0,  1833,  1865,  1834,  1835,     0,  1866,  1836,  1837,  1838,
    1867,  1868,  1839,  1840,  1841,     0,  1842,     0,     0,     0,
       0,  1869,   714,  1843,     0,   852,     0,  1844,     0,  1870,
    1845,     0,  1846,  1847,  1848,  1849,  1850,   846,  1511,  1396,
       0,     0,   772,  1851,  1871,  1953,  1954,     0,     0,     0,
      42,    48,    24,    23,    25,    58,    63,    39,    18,    55,
      43,    89,    90,    91,    31,    27,    22,    28,    32,    45,
      33,    44,    21,    40,    57,    46,    61,    47,    62,    34,
      53,    51,    41,    56,    60,    85,    66,    30,    67,    80,
      68,    81,    69,    38,    17,    78,    76,    77,    35,    54,
      75,    79,    19,    20,    82,    59,    74,    71,    86,    84,
      92,    72,    49,    14,    15,    64,    37,    16,    36,    29,
      88,    26,   770,    65,    70,    52,    73,    87,    50,    83,
     829,   820,   854,   828,    94,    95,    96,     7,  1332,  1334,
    1333,  1419,  1370,  1371,  1337,  1380,  1390,  1379,  1383,  1391,
    1378,  1397,     0,    98,   100,   101,   102,   105,   106,    99,
      93,    97,   104,   110,   103,   109,   107,   108,   111,   112,
     113,  1607,  1019,  1605,  1606,  1604,  1354,     0,  1419,  1356,
    1355,  1419,  1366,  1390,     0,  1558,  1559,  1560,  1561,  1562,
    1563,  1612,  1613,  1614,  1615,  1616,  1618,  1617,  1629,  1630,
    1631,  1632,  1633,  1634,  1635,  1636,  1637,  1638,  1639,  1640,
    1641,  1642,  1643,  1644,  1645,  1646,  1647,  1648,  1584,  1649,
    1650,  1651,  1652,  1653,  1654,  1655,  1656,  1628,  1657,  1658,
    1659,  1660,  1661,  1662,  1663,  1664,  1665,  1666,  1621,  1667,
    1668,  1669,  1670,  1671,  1672,  1673,  1674,  1675,  1676,  1677,
    1678,  1679,  1680,  1681,  1682,  1684,  1683,  1685,  1686,  1687,
    1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,  1696,  1622,
    1697,  1698,  1699,  1700,  1701,  1702,  1703,  1704,  1705,  1706,
    1707,  1708,  1709,  1710,  1711,  1712,  1713,  1714,  1715,  1716,
    1717,  1718,  1719,  1720,  1721,  1722,  1623,  1723,  1724,  1624,
    1725,  1726,  1727,  1728,  1729,  1730,  1731,  1732,  1733,  1734,
    1735,  1736,  1737,  1738,  1739,  1740,  1741,  1742,  1743,  1744,
    1745,  1748,  1746,  1747,  1749,  1750,  1751,  1752,  1753,  1754,
    1755,  1756,  1757,  1758,  1759,  1760,  1761,  1762,  1763,  1764,
    1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1625,
    1774,  1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,  1783,
    1784,  1785,  1786,  1787,  1789,  1788,  1791,  1790,  1792,  1793,
    1794,  1795,     0,  1796,  1797,  1798,  1799,  1800,  1801,  1802,
    1803,  1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,
    1813,  1814,  1815,  1816,  1626,  1817,  1952,  1278,  1325,  1324,
    1301,  1320,  1582,  1529,  1530,  1296,  1583,  1580,  1619,  1620,
    1627,  1581,  1279,  1948,  1579,  1468,     0,     0,  1431,  1432,
    1435,  1310,  1305,  1434,     0,  1306,  1429,  1430,  1247,  1326,
    1579,  1564,  1565,  1566,  1567,  1569,  1568,  1570,  1872,  1873,
    1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,  1882,  1883,
    1597,  1884,  1885,  1886,  1887,  1888,  1889,  1892,  1890,  1891,
    1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,
    1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,  1598,  1599,
    1911,  1912,  1913,  1914,  1915,  1916,  1917,  1918,  1919,  1920,
    1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,  1930,
    1931,  1932,  1601,  1933,  1934,  1600,  1935,  1936,  1937,  1938,
    1939,     0,  1385,  1611,  1596,  1386,  1571,  1608,  1595,  1602,
    1603,  1610,  1609,  1448,  1246,  1450,  1393,  1403,  1399,  1407,
    1402,     0,     0,     0,     0,  1419,   713,   712,   698,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    13,     0,   722,   255,
    1298,  1297,  1242,   760,     0,  1238,  1239,   396,     0,   701,
     274,     0,     0,     0,     0,     0,     0,   455,     0,     0,
       0,     0,     0,     0,     0,   155,     0,   285,   284,     0,
     386,     0,   560,     0,     0,   396,     0,     0,     0,  1302,
       0,  1746,  1446,  1447,  1331,  1783,   812,     0,     0,     0,
       0,   467,     0,   466,     0,     0,   464,     0,   395,     0,
       0,   468,   462,   461,     0,     0,   465,     0,   463,     0,
       0,   702,  1697,  1437,   783,   770,  1630,   493,   497,   488,
     494,   501,   500,   489,   486,   487,  1757,     0,     0,     0,
     483,  1267,  1269,   492,  1268,     0,   529,   535,   534,   533,
       0,   530,   531,   536,     0,   695,  1239,   725,  1251,   845,
       0,     0,   485,   694,  1797,     0,     0,   636,     0,   637,
       0,  1771,   706,   213,  1578,  1776,  1847,  1797,   209,  1576,
     176,  1577,  1573,  1574,  1575,  1572,     0,     0,   530,     0,
     703,   704,   851,   849,     0,     0,     0,     0,  1657,  1717,
    1726,  1767,  1776,  1847,  1797,   164,     0,   208,  1776,  1847,
    1797,   204,   722,     0,     0,  1394,   697,   696,     0,     0,
     917,   771,   774,   829,     0,   714,     0,     6,   769,   765,
     848,   848,     0,   848,     0,   825,  1335,  1390,  1369,  1425,
    1339,     0,     0,  1415,  1411,  1408,  1416,  1417,  1410,  1398,
    1008,  1009,  1010,  1007,  1011,  1006,     0,  1343,  1382,  1349,
       0,  1359,  1358,  1357,  1364,  1425,  1368,  1955,  1956,  1470,
    1300,  1317,     0,     0,     0,     0,     0,     0,  1309,  1315,
       0,  1307,     0,     0,  1960,  1964,     0,  1962,  1957,  1384,
    1456,  1449,  1451,  1453,  1405,  1404,  1400,     0,     0,  1520,
       0,     0,  1521,  1522,     0,  1517,  1519,     0,  1425,     0,
       0,  1582,  1252,  1583,  1580,  1592,  1579,     0,   471,   116,
       0,     0,   471,     0,     0,     0,     0,     0,  1651,  1143,
    1153,  1151,  1152,  1145,  1146,  1147,  1150,  1148,  1149,     0,
     626,  1144,     0,   116,     0,     0,   371,     0,     0,     0,
       0,   116,     0,     0,     0,   718,   721,   699,     0,     0,
    1214,  1243,     0,     0,     0,   513,   522,   514,   519,     0,
     516,     0,     0,     0,   515,   517,   518,     0,   520,   521,
       0,     0,   710,   277,     0,     0,     0,     0,   727,   757,
     289,   288,   116,   287,   286,     0,     0,   574,   116,     0,
     157,   399,     0,     0,   116,     0,     0,     0,     0,     0,
       0,     0,     0,  1471,  1330,  1428,     0,   796,     0,   434,
       0,   749,     0,   151,  1244,     0,     0,   145,     0,   400,
       0,   146,     0,   252,   469,  1445,  1444,  1436,  1443,     0,
     490,   499,   498,   496,   495,   491,  1270,     0,   481,   482,
    1456,  1459,   479,     0,   528,     0,     0,     0,     0,   799,
    1240,     0,   709,     0,   639,   639,   639,   705,   212,   210,
       0,     0,     0,     0,     0,   711,     0,     0,     0,  1818,
    1819,   967,  1207,     0,  1584,  1820,  1821,  1822,  1108,  1117,
    1109,  1111,  1118,  1823,  1824,  1676,  1825,  1826,  1259,  1827,
    1828,   957,  1830,  1831,  1832,  1113,  1115,  1833,  1834,     0,
    1260,  1836,  1837,  1741,  1839,  1840,  1842,  1843,  1119,  1845,
    1846,  1847,  1848,  1849,  1850,  1258,     0,  1120,  1851,  1154,
    1264,  1265,  1216,     0,     0,  1224,     0,  1098,     0,   951,
     953,   954,   978,   979,   955,   984,   985,   997,   952,     0,
    1223,  1020,  1097,  1102,     0,  1096,  1092,   836,  1221,  1208,
       0,  1093,  1292,  1291,  1293,  1294,  1290,  1254,  1582,  1588,
     956,  1583,  1580,  1261,  1295,  1948,  1579,     0,     0,     0,
       0,     0,  1510,   215,     0,   216,  1776,   165,   200,   172,
     199,   173,   203,   202,     0,  1649,   166,     0,   170,     0,
       0,   207,   205,     0,   700,   475,     0,     0,   919,     0,
     918,   773,   770,   823,   822,     5,   776,   847,     0,     0,
       0,     0,     0,     0,     0,   880,   868,  1425,  1426,     0,
    1420,     0,  1419,  1419,  1413,  1412,  1409,     0,     0,     0,
       0,     0,     0,  1284,  1283,  1340,  1342,  1287,     0,  1425,
       0,     0,  1319,     0,  1323,  1321,  1456,  1465,  1456,  1466,
    1467,  1313,  1308,  1311,     0,  1303,  1315,  1958,     0,     0,
    1961,  1387,     0,  1457,  1288,  1289,  1462,     0,  1452,  1460,
    1463,  1406,  1419,  1528,     0,  1523,  1526,     0,  1518,     0,
    1253,     0,     0,     0,     0,   472,     0,     0,     0,   115,
     747,   745,     0,     0,     0,   751,     0,     0,     0,   600,
       0,     0,   601,   599,   602,   613,   616,     0,   552,   149,
     150,     0,     0,     0,     0,     0,   221,   244,     0,     0,
       0,     0,     0,     0,   141,     0,     0,     0,   369,   655,
     655,     0,     0,     0,   655,     0,   655,     0,   220,   222,
       0,     0,     0,     0,     0,     0,     0,     0,   144,  1350,
       0,   716,   717,     0,   720,     0,  1211,  1210,  1249,  1215,
     759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   435,     0,   960,   995,   995,   995,
     975,   975,   969,   958,  1002,     0,   995,   972,   961,     0,
     959,  1005,  1005,   990,     0,   933,   943,   945,   946,   976,
     977,   947,   982,   983,   944,  1019,  1587,   956,  1589,  1586,
    1585,     0,     0,   756,     0,     0,   456,   436,     0,     0,
       0,   153,     0,     0,   404,   403,     0,     0,   437,     0,
     371,   364,   326,     0,     0,     0,  1250,     0,     0,   813,
     817,   814,     0,   815,     0,   923,     0,     0,   252,     0,
       0,     0,     0,     0,   252,   250,   251,     0,   460,  1438,
    1441,  1442,     0,   777,   779,   781,   780,   782,   778,   480,
     477,   478,     0,  1458,  1940,  1946,     0,  1472,  1473,     0,
    1666,  1691,  1711,  1772,     0,  1792,     0,   537,   556,   532,
       0,     0,     0,   785,   788,     0,     0,   809,   484,  1464,
     638,   635,   634,   633,   211,   177,     0,     0,   558,  1771,
     708,     0,     0,  1100,  1101,   994,   981,  1206,     0,     0,
     989,   988,     0,     0,     0,     0,     0,   965,   964,   963,
    1099,  1167,     0,   962,     0,     0,     0,     0,   995,   995,
     993,  1039,     0,     0,   966,     0,     0,  1186,     0,  1192,
       0,     0,     0,  1001,     0,   999,     0,     0,  1073,  1094,
    1023,  1024,  1098,  1164,     0,  1255,     0,     0,   987,     0,
    1019,     0,     0,     0,     0,  1219,  1162,     0,     0,  1052,
    1160,     0,  1054,     0,     0,     0,  1154,  1153,  1151,  1152,
    1145,  1146,  1147,  1150,  1148,  1149,  1158,  1036,     0,  1035,
    1456,     0,   884,   835,  1209,     0,     0,  1947,  1949,  1507,
    1506,  1505,  1504,  1480,     0,  1476,  1477,     0,  1508,  1509,
     217,   218,   214,     0,   175,   174,     0,   197,   198,   169,
       0,   193,   194,   179,   190,   192,   191,   189,   167,   178,
     180,   186,   187,   188,   168,   206,  1419,     0,     0,   884,
    1227,  1216,   762,     0,   766,   829,   833,   828,   832,   855,
     856,   861,   831,     0,   882,   882,   870,   864,   869,   865,
     871,   879,   827,   867,   826,     0,  1427,  1338,  1425,   933,
    1419,  1360,  1419,  1414,  1346,  1013,  1014,  1015,  1016,  1018,
    1017,  1347,  1344,  1012,  1345,  1286,  1285,     0,     0,     0,
       0,  1367,  1316,     0,  1299,  1322,     0,  1314,     0,  1959,
    1965,  1963,     0,     0,   933,  1943,  1524,  1943,   933,   620,
       0,   619,     0,     0,   473,     0,     0,     0,   744,   743,
       0,     0,     0,     0,     0,   754,   320,     0,   249,     0,
       0,     0,     0,     0,     0,     0,     0,   605,   606,   615,
     614,   612,   585,   587,   586,   577,     0,   578,     0,     0,
     584,   593,  1593,   956,   591,  1594,  1591,  1590,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   622,   627,   140,     0,     0,   124,   126,     0,     0,
     122,   128,   125,   127,   123,   129,   121,     0,     0,   120,
       0,     0,     0,     0,   139,     0,     0,     0,     0,   373,
     383,     0,     0,     0,   116,   116,   370,   654,   232,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   143,   142,
       0,     0,   185,   715,   719,  1212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   276,   258,
     257,     0,     0,   441,   444,     0,   933,     0,     0,     0,
     927,  1008,  1007,  1006,     0,   948,   950,     0,     0,   742,
     742,   742,   742,   742,   726,   728,   300,   147,     0,     0,
     114,   157,   290,     0,   156,   158,   160,   161,   162,   159,
     163,   398,     0,   409,   408,   410,     0,   405,     0,   438,
     138,   368,     0,   292,     0,     0,     0,   384,     0,     0,
       0,   672,     0,     0,     0,   816,     0,   894,   795,   886,
     896,   887,   889,   921,  1242,     0,   794,     0,     0,   617,
    1245,     0,     0,   252,   252,   394,   470,  1439,  1440,   812,
     476,     0,     0,  1945,  1271,     0,  1272,     0,     0,   540,
     539,   550,     0,   541,   542,   538,   543,     0,     0,   558,
     787,     0,     0,   792,  1216,     0,   806,     0,   804,     0,
    1241,   808,   797,     0,   530,     0,     0,   252,   707,  1164,
       0,     0,     0,  1170,     0,     0,  1205,  1202,     0,     0,
    1164,     0,     0,     0,     0,  1177,  1178,  1179,  1176,  1180,
    1175,     0,     0,  1181,  1174,     0,     0,     0,     0,     0,
     992,   991,     0,     0,     0,     0,     0,     0,     0,  1074,
       0,     0,  1138,     0,  1164,  1191,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1164,  1197,     0,  1217,
    1216,     0,     0,     0,     0,  1256,  1021,  1037,  1222,     0,
    1218,     0,     0,  1044,     0,  1198,  1069,     0,  1058,     0,
    1053,     0,  1056,  1060,  1040,  1219,  1163,     0,  1161,     0,
       0,  1038,     0,  1033,  1031,  1032,  1025,  1026,  1027,  1028,
    1029,  1030,  1034,  1142,  1140,  1141,     0,  1692,  1717,     0,
     846,   846,   834,   844,  1220,     0,   923,     0,     0,     0,
    1103,     0,  1951,  1950,     0,     0,     0,     0,     0,  1019,
       0,   933,   920,     0,  1216,     0,   923,     0,   764,   763,
       0,     0,   859,   860,     0,   878,     0,   809,   809,     0,
       0,     0,  1336,  1421,  1423,  1389,  1361,  1392,  1341,  1381,
       0,  1365,  1318,  1312,     0,  1454,  1461,  1514,     0,  1944,
       0,     0,     0,   663,   641,   474,   664,   642,     0,   746,
       0,     0,     0,     0,     0,   252,   752,   248,   753,   657,
     665,     0,   603,   604,     0,   588,   576,     0,     0,   583,
       0,   582,   950,     0,     0,     0,   644,   148,   246,   649,
     247,   245,   645,     0,  1248,     0,     0,     0,   134,     0,
       0,     0,     0,   117,   135,   133,     0,   132,     0,   669,
     647,   659,   372,   382,     0,   376,   377,   374,   378,   379,
       0,     0,   224,     0,     0,   236,   235,   242,   243,   241,
     252,   252,   239,   240,   238,   648,     0,   660,   237,   234,
       0,   223,   671,   653,     0,   670,   661,   652,   183,   182,
     184,     0,     0,     0,     0,     0,     0,     0,   524,   508,
     523,     0,     0,     0,   502,   260,   261,   279,   259,   440,
       0,     0,     0,     0,   928,     0,     0,   933,     0,     0,
     941,   934,   942,     0,     0,     0,     0,   742,   741,     0,
       0,     0,     0,     0,   729,   750,     0,   326,   152,     0,
       0,   397,     0,     0,     0,   924,     0,     0,     0,     0,
     291,   293,   295,   296,   297,     0,   366,   367,   362,     0,
       0,   358,     0,   328,   329,     0,     0,     0,   563,     0,
       0,     0,   611,   609,   595,     0,   818,   819,     0,   894,
       0,   896,     0,   895,   908,     0,     0,   914,   912,     0,
     914,     0,   914,     0,     0,   888,     0,   890,   908,  1243,
     922,   252,     0,   252,   252,   693,   432,     0,  1455,  1941,
    1481,  1482,     0,  1474,  1475,     0,   552,     0,   549,   544,
     546,     0,   553,  1237,  1236,     0,  1235,     0,     0,   793,
     807,   800,   802,   801,     0,     0,   798,     0,   252,     0,
     554,   850,     0,  1172,  1173,     0,     0,     0,     0,  1201,
       0,     0,  1134,     0,  1132,  1110,  1112,   974,     0,  1122,
       0,   968,  1135,  1136,  1114,  1116,     0,   971,     0,  1155,
       0,     0,  1123,  1076,     0,     0,     0,     0,  1154,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1088,  1087,
    1124,  1137,     0,     0,  1189,  1190,  1125,  1003,  1004,  1005,
    1005,     0,     0,  1196,     0,     0,     0,  1130,  1095,  1165,
     996,   997,     0,     0,     0,     0,     0,     0,     0,  1059,
    1055,     0,  1057,  1061,     0,     0,     0,     0,  1046,  1070,
    1042,     0,     0,  1048,     0,  1071,   846,   846,   846,   846,
     843,     0,     0,   883,   873,     0,     0,  1107,  1104,  1489,
    1490,  1491,  1492,  1493,  1494,  1495,  1496,  1497,  1498,  1500,
    1501,  1502,  1499,  1503,  1485,  1486,     0,  1478,  1479,   171,
       0,   195,   181,  1514,     0,  1228,  1225,   810,     0,   775,
     857,     0,  1156,   858,   881,   877,   876,   862,   866,   863,
       0,  1422,  1351,  1328,  1513,  1516,  1527,  1525,  1363,     0,
       0,     0,   742,     0,   319,     0,     0,     0,   755,   597,
       0,   579,   580,   581,     0,   666,   643,   658,     0,     0,
     624,     0,   625,   623,   130,   118,   137,   136,   119,   131,
     375,   381,   380,   300,     0,     0,     0,   225,   233,   230,
       0,     0,  1213,     0,     0,   504,   510,     0,     0,     0,
       0,   512,   280,   116,     0,   442,  1741,  1146,   443,   445,
     446,   447,     0,     0,     0,     0,   931,     0,     0,     0,
       0,     0,     0,   933,  1019,     0,     0,   737,  1280,  1281,
     736,  1282,   733,   732,   740,   739,   731,   730,   735,   734,
       0,     0,     0,   311,     0,     0,   305,     0,     0,   357,
     299,   302,   303,     0,     0,   290,     0,   412,   406,   439,
       0,   926,   292,   318,   346,     0,   363,     0,     0,     0,
       0,   325,     0,   723,   391,   388,     0,     0,     0,   607,
     589,   608,     0,   592,     0,   596,   573,     0,   811,  1329,
     898,   906,     0,   885,     0,   913,   909,     0,   910,     0,
       0,   911,   900,     0,     0,   906,     0,   618,   252,   459,
     621,   817,     0,     0,   551,   547,     0,     0,   525,   555,
     786,     0,     0,   790,   791,   805,   803,     0,   526,   557,
    1165,  1171,   980,     0,  1204,  1200,     0,     0,     0,  1166,
       0,     0,  1184,  1183,  1075,  1185,     0,     0,     0,  1086,
    1085,  1083,  1084,  1077,  1078,  1079,  1080,  1081,  1082,  1194,
    1193,  1187,  1188,  1000,   998,     0,  1127,  1128,  1129,  1195,
    1139,   986,  1019,  1022,     0,     0,  1045,  1199,  1062,     0,
    1169,     0,  1041,     0,     0,     0,     0,  1050,  1155,     0,
       0,     0,     0,     0,     0,   838,   837,     0,   875,  1105,
    1106,     0,     0,     0,  1512,     0,     0,  1233,  1232,     0,
    1424,     0,  1304,     0,     0,     0,     0,   321,     0,     0,
     357,   598,   594,     0,     0,     0,   298,     0,     0,     0,
       0,   254,   650,   651,     0,     0,     0,     0,   507,   506,
     263,     0,   429,     0,     0,   433,   424,   426,     0,     0,
       0,   929,   935,   936,   937,   938,   939,   940,   932,   949,
     422,   738,     0,     0,   309,   313,   314,   312,   304,   357,
     326,     0,   306,     0,     0,     0,   414,     0,     0,   925,
       0,     0,     0,   315,     0,   349,   294,   365,   367,   360,
     361,   359,   327,     0,   393,   389,     0,   562,     0,     0,
     611,   610,   688,   689,   686,   687,     0,   897,     0,     0,
     899,     0,     0,   902,   904,     0,     0,     0,     0,     0,
    1246,   632,     0,  1483,  1484,     0,   545,  1234,     0,     0,
    1203,  1121,  1131,   973,  1133,   970,  1182,     0,     0,     0,
    1126,  1257,  1067,  1065,     0,  1063,     0,     0,     0,  1047,
    1043,     0,  1049,  1072,   842,   841,   840,   839,     0,     0,
     830,  1487,     0,  1273,  1277,  1274,  1488,  1019,     0,  1229,
       0,  1327,   662,   640,   656,   748,     0,   357,   322,   668,
     646,   667,   226,   227,   228,   229,     0,   231,   503,     0,
     509,   505,   256,   278,   431,   430,   428,   425,   427,   930,
       0,   631,     0,     0,     0,     0,   301,   307,   332,     0,
       0,   724,   292,   413,     0,     0,   407,   349,   317,   316,
       0,     0,     0,   353,   390,     0,   385,     0,     0,     0,
     564,   571,   571,   590,   572,     0,     0,   907,   916,     0,
     903,   901,   891,     0,   893,     0,   548,     0,   252,  1089,
       0,     0,  1064,  1168,  1068,  1066,  1051,   872,   874,  1276,
    1275,   196,  1230,     0,  1157,     0,   323,   253,   511,   264,
     268,   757,   757,     0,   269,   757,   265,   757,   262,   631,
       0,   629,   423,     0,   308,     0,   337,     0,     0,   415,
     416,   411,     0,   353,     0,   347,   348,     0,   355,   392,
     758,     0,   355,     0,     0,   569,   567,   566,   923,   905,
       0,   892,   789,   527,     0,  1090,     0,  1226,   326,     0,
       0,     0,     0,     0,     0,   628,   630,     0,   330,   331,
       0,   310,   333,   334,   356,     0,     0,   355,   345,     0,
       0,   282,   571,   923,   565,   570,     0,   915,  1091,  1231,
     332,   266,   271,     0,   272,   267,   270,     0,     0,     0,
       0,   335,     0,   336,     0,     0,     0,   448,   449,   419,
     283,     0,   350,     0,   354,   568,   559,   692,   337,   273,
       0,   342,     0,   341,     0,   338,   339,     0,     0,   454,
       0,     0,   417,   420,   421,   351,   352,   691,   690,     0,
       0,     0,   340,   343,   344,     0,   458,   450,   401,     0,
     674,   685,   673,   675,   683,   680,   682,   681,   679,   324,
       0,   453,   457,     0,   451,   418,     0,   684,   678,   829,
     820,     0,     0,   676,   685,   419,   458,   677,     0,   452,
     402
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     2,    68,   228,   229,   230,  1390,  1904,   231,
     232,   233,   234,   235,   236,   237,   238,  1412,   239,   240,
    1089,  1521,  1994,   241,   895,   896,  1738,  1739,  1943,  1740,
    1741,  1729,  1279,  1281,   242,   243,   244,  1274,  1722,   245,
     246,  1438,  1439,  1416,  1417,  1395,  1558,  3107,   247,   248,
    1961,  2377,  3112,  3198,   751,  1472,  2723,  2724,   249,  1518,
    2419,  2420,  2421,  2422,  2405,  2770,  2771,  2772,  2423,  3003,
    2424,  1836,  2016,  2432,  2433,  3206,  3251,  3252,  3253,  3305,
    3005,  3143,  3218,  3261,  2992,   250,  2790,  2431,  2014,  2425,
    2426,   251,   252,  1428,  1916,  2324,   253,   775,  2794,  3014,
    3146,   254,   809,   255,  1523,   256,   257,  1526,  2006,  2007,
    2997,  3134,  3211,  3311,  3312,  3123,  2965,  2966,  2967,   258,
     259,   260,   261,  2009,  1474,  1962,  1963,  2728,   262,  3287,
    3288,   776,  3344,   263,   264,   810,  1123,  3225,  1385,   265,
     266,   828,   829,   267,  1071,  2369,   268,   269,   840,  2084,
     842,  1586,  2488,  2489,  2838,  2060,  1013,   270,   271,  2069,
    2087,   272,   777,  2798,  3149,  3150,  3226,   273,   778,  1408,
    1856,  1857,  1858,  2799,  1859,  2802,  1860,  2442,  2443,  2444,
    2806,   274,  1406,  1851,   275,   276,  1820,   277,  1880,  1029,
     278,  3201,   279,   280,   860,  1601,   281,  1919,   282,   283,
     284,  2445,  3332,  3346,  3347,  3348,  3026,  3319,   285,  3334,
     287,   288,   289,   738,  1045,  1046,  1047,   290,   291,   292,
    1984,  1985,  2399,   293,   294,  1829,  2269,   295,   296,   297,
    1514,   298,   299,   300,   301,   302,   919,   912,  1302,  1754,
     303,  1563,   815,  3335,  1593,  2072,  2073,  3336,  1545,   306,
    1597,  2079,  2082,  3337,   308,  1106,  2024,  3338,  1227,   311,
     312,   313,  1702,  2202,   850,  1308,   884,   924,   925,  1759,
    1760,  1315,  1774,  1767,  1769,  2918,  3080,  1316,  1772,  2237,
    2206,  2028,  2029,  2030,  2453,  2464,  2816,  3033,  2031,  2032,
    2036,  2414,  2415,  1861,  1970,  2389,  1495,  1228,  1229,  1230,
    1633,  1644,  1627,  1498,  1231,  1232,  1233,  1501,  1234,  1235,
    1236,  1237,  1616,  1668,  1238,  1239,  1653,   947,  2089,  2128,
    1241,  1242,  1243,  2196,  1696,  1031,  1244,  2653,  1698,  2147,
    2111,  2901,  2092,  1614,  2112,  2126,  2541,  2131,  2136,  2564,
    2565,  2148,  2166,  1245,  2096,  2097,  2520,  1618,  1246,  2149,
    1051,  1659,  2162,  1247,  1248,  1749,  2223,  3183,  1750,  2495,
    2496,  1249,  1587,   910,  3029,  1114,   601,  2303,  1457,   744,
     847,  1250,  1251,  1252,  1253,  1254,  1255,  1256,   832,   833,
    2055,  3086,  2370,  2750,  1365,  1742,  1257,   579,   745,   314,
     603,   604,   968,   969,  1352,  1355,  1342,  1804,   580,   581,
     605,  2932,   315,   316,   317,   318,   319,  1317,   929,  1336,
    1798,   948,    72,    77,    73,   949,   357,   358,  1780,   320,
     715,  1781,  1339,   955,   361,   322,   323,   362,   325,   692,
     363,   931,   327,   932,   328,   329,   330,   331,   939,   332,
    1319,  1320,  2661,  1321,   333,   334,   606,   607,   335,  1128,
    1559,  1127,   784,   336,   337,   981,   982,   983,  1141,  1572,
    1142,  1368,  1369,   338,   339,   597,   340,   341,   342,  1577,
    1578,   343,  1715,  1716,  1717,   344,  2480,  2481,   345,  2634,
    2635,  2636,   346,  1711,   347,   348,   904,  2665,   349,   711,
     350,   995,   582,   583,   584,  1259,   695,   870,   846,  1260,
    1002,   696,   352,   698,   586,   587,   588,   589,   590,   591,
    1005,   702,  1573,    74,  2258,  1574,  1263,  1264,  1707,  1265,
     594,   959,   974,   975,  2259,   977,    75,   978
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -2915
static const int yypact[] =
{
   -2915,   306,  8805, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, 15122, -2915, -2915, 33663,   599, -2915,
   -2915, -2915, 36549, -2915, -2915, -2915, -2915, -2915,   290, 35725,
   13889, -2915, 51360, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 51360, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 34490,   198, -2915, -2915,   256, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915,   250,  3544, -2915, -2915, 38197, -2915,
      50, -2915, -2915, -2915, -2915, -2915, -2915, 51360, 46428, -2915,
     347,   541, -2915,   657,  7392, -2915, 38197, 38609, -2915, -2915,
   51771,   662,  4425,   250, 39021, -2915,  1106, -2915, 31170, -2915,
   -2915, -2915,   629, 44373, -2915, -2915, -2915, -2915,   544, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, 46428,  1100,   427,
   31588, -2915, -2915, -2915, -2915, 46428, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, 39433, -2915,   476, 52182, 52593,
   43962, -2915,   705, -2915, 51360,   190, 33252, -2915, 53004, -2915,
   -2915,   505, -2915, -2915, -2915, -2915, -2915,   427, -2915, 34490,
   29908, 45195,   702, -2915, -2915, -2915, -2915,   314, 11746,   518,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915,   594, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
      26, -2915,   833,    32, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, 55463,  1076, -2915, -2915, -2915,   567, -2915,   586, -2915,
   -2915, -2915,  1523, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915,   708, -2915, -2915, -2915, -2915,   997, 34076, -2915,
   -2915, 55463, -2915,   631, 39845, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, 36961, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915,    98, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, 51360, 51360, -2915, -2915,
   -2915,   693, -2915, -2915,   670, -2915, -2915, -2915, -2915, -2915,
     676, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, 10368, -2915, -2915, -2915,   699, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915,   780, -2915,   191,   991, -2915,
   -2915, 34490,  1778,  1778,  1255, 55463, -2915, -2915, -2915, 43140,
   51360, 51360, 51360, 43140, 51360, 45195, 51360, 28225, 51360, 51360,
   45195, 45195, 51360, 51360, 51360, 51360, -2915,  1229,   557, -2915,
   -2915, -2915,   724, -2915,  1016, -2915,  1055,  3927,  1100, -2915,
   -2915, 46428, 43140, 51360,   842,   931, 51360, -2915, 51360,   965,
   51360,  1042,   830,  1051, 51360, 51360, 51360, -2915, -2915, 51360,
   -2915, 51360, -2915, 51360,   677,  1014,  1224,  1170,   466, -2915,
   39845, 39845, -2915, -2915, -2915,  1032, -2915, 45195, 43140, 51360,
    1026, -2915, 51360, -2915, 43140, 51360, -2915,  1065, -2915, 51360,
   51360, -2915, -2915, -2915, 51360, 51360, -2915, 51360, -2915,  1157,
   51360, -2915,   815, -2915, -2915,   594,  -112, -2915,   315,   -30,
     316, -2915, -2915,    -7,    86,   170,  -112,   726, 46839, 51360,
    1205, -2915, -2915, -2915, -2915, 39845,  1194, -2915, -2915, -2915,
    1237,  -113, -2915, -2915, 46428, -2915, -2915, -2915, -2915, -2915,
   46428,   961, -2915, -2915,  1100,  1319, 51360, -2915, 51360, -2915,
   46428, 51360, -2915, -2915, -2915,  1435,  1107,  1314,  1130, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915,  1287,  1312,    -9,  1100,
    1239, -2915, -2915,  1338, 18079,   491, 39845, 32006, 48072, 54648,
      21, 38197, 53415,  1220,   557, -2915,   765, -2915,  1537,  1232,
    1428,  1130,   557, 46428, 55860, -2915, -2915, -2915, 25711,  1339,
    1257, -2915,  1502,  1263,  1284,   250,  1298, -2915, -2915, 46428,
    1642,  1642,  1633,  1642,   647,   710, -2915, -2915, -2915,  1316,
   -2915,  1308,  1315, -2915,   258,  1550, -2915, -2915, -2915, -2915,
    1415,  1420,  1424,  1432, -2915,  1436,  1227, -2915, -2915, -2915,
    1651, -2915, -2915, -2915, -2915,  1316, -2915, -2915, -2915, -2915,
   -2915,  1738,  1741, 38197, 38197,  1478,    14, 32838, -2915,  1438,
     693, -2915, 13256, 10368, -2915, 23177,  1111, -2915, -2915, -2915,
     183, -2915, -2915, -2915,  1664, -2915, -2915,  1665, 51360, -2915,
    1530, 51360, -2915, -2915, 53826, -2915, -2915,  1778,  1316,   724,
    1486,  1490, -2915,  1517,  1536, -2915,  1551,   584,  1476,  1236,
      85,  1641,   311,  1362,  1562,   169,   790,  1648, 51360, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1576,
   -2915, -2915,  1575,   -71,   639,  1673,   -86,  1261,   667,  1730,
     569,   -52,  1579,  1779,   339, -2915,   -17, -2915, 21077, 29084,
   -2915,   724, 46428, 43140,  1583, -2915, -2915, -2915, -2915, 43140,
   -2915,  1742,  1444, 51360, -2915, -2915, -2915, 51360, -2915, -2915,
    1789, 51360, -2915,  1631,  1603,  1921, 41906, 51360,  1636,  1950,
   -2915, -2915,  1640, -2915, -2915, 51360,  1603,  1041,  1640,  1948,
    1949,  1750,  1121,    53,  1640, 46428, 46428, 46428,  1815, 51360,
   51360, 43140, 51360, -2915, -2915, -2915,   572,  1660,  1629, -2915,
   41906, -2915,  1562,  1623, -2915, 51360,  1632,  1623,  1786, -2915,
    1788,  1623,  1100,    37, -2915, -2915, -2915, -2915,    18,   415,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, 51360,  1205,  1205,
      97, -2915, -2915,    81, -2915, 45606, 51360, 46017,   148,   -25,
   -2915, 51360, -2915,   815,  1889,  1889,  1889, -2915, -2915, -2915,
    1848, 51360,  1904, 45606, 51360, -2915, 54237,  1657,  1392,  1166,
    1021, -2915, 21077,  1658,   138,   138,  1661,  1662, -2915, -2915,
    1663,  1666, -2915,   789,   789,  1794,  1667,  1668, -2915,   899,
    1669, -2915,  1254,  1070,  1671,  1674,  1675,  1250,   138, 21077,
   -2915,  1676,  1135,  1678,  1682,  1683,  1286,  1684, -2915,  1318,
    1686,  1115,  1191,  1687,  1688, -2915,  1667, -2915,   254, -2915,
   -2915, -2915, -2915, 21077, 21077, -2915, 18513, -2915,  1100, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915,    36, -2915,  1149,
    6486, -2915, -2915, -2915, 21077, -2915, -2915,   -21, -2915,   724,
    1692, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1154, -2915,
   -2915,  1174,  1245, -2915, -2915,   115,  1252,   969,   969,   273,
   37373, 37373, -2915, -2915,   143,  1623,   193, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, 37785,  2009, -2915,  1002,   -17, 30320,
   30320, -2915, -2915,  1860, -2915,  1689,  1902, 46428, -2915, 26962,
   -2915, -2915,   594, -2915, -2915, -2915,  1697, -2915,   314,   314,
   21077,   314,   611, 18939, 21077,  1951,    63,  1316,  1706,   849,
   -2915, 42729, 55059, 55059,  1914, -2915, -2915,   540,    12,  1805,
    1885,   614,  1385, -2915, -2915, -2915,  1701, -2915,  1997,  1316,
     857, 38197,  1760, 38197, -2915, -2915,  2113, -2915,  2113, -2915,
   -2915, -2915, -2915,  1716,   726, -2915,  1438, -2915, 17218,  1458,
   -2915, -2915, 10368, -2915, -2915, -2915, -2915,  2140, -2915,  1713,
   -2915, -2915, 55463,  1721, 51360, -2915,  1722,  1723, -2915, 55860,
     724, 29496,  1790,  1791, 34490,  1726,  1793,  1795, 54648, -2915,
   -2915, -2915,   707,   736,   459, -2915,  1796,  1873,  1824, -2915,
    1891,   649, -2915, -2915, -2915, -2915,  1036, 16409,   854, -2915,
   -2915,  1798,  1781,  1807,  1810,  1818,  1745, -2915,  1812,  1797,
   40670, 28654, 54648,  5387, -2915,  1813,  1819,  1856,  1371,    69,
    2068,  1906,  1822,  1820,  1102,  1821,    70,   530,  1753, -2915,
    1827,  1828, 45195,  1830,  1869,  1834, 54648,  5387, -2915, -2915,
     -23, -2915, -2915,   557, -2915,  2375, -2915, -2915, -2915, -2915,
   -2915,  1775, 41906,  1562,  1227, 51360,  1777,   619,  1930, 51360,
    1989,  1934,    16, 34490, -2915,  1784, -2915,  1823,  1823,  1823,
    1808,  1808,  1809, -2915, -2915,  1250,  1823,  1811, -2915, 42318,
   -2915,   738,   985, -2915,  2142,    58, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915,   746, -2915,  1476, -2915, -2915,
   -2915,  2153,   992, -2915, 41906,  5387,  2090, -2915,  1846,  5387,
   51360,   128, 51360,  1999, -2915, -2915,   123,  1814, -2915,  5387,
   -2915,   -49,  1816, 38197,  2062,  1964, -2915,  1562,  2162, -2915,
     996, -2915,  1919, -2915, 24027,  1852, 29496,  2169,   120, 51360,
    1870, 40670, 46428, 46428,   120, -2915, -2915, 51360, -2915, -2915,
    1205,   780, 51360, -2915, -2915, -2915, -2915, -2915, -2915,  1205,
   -2915, -2915,  2246,  1825, -2915,   115,   726,  1826, -2915,  1840,
   51360, 43140, 51360, 51360, 46428, 51360,  1893,  1689,  -121, -2915,
    1874,  1835, 26545, -2915, -2915,    93, 46428,  1998, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, 44373,  2074,   -19, 51360,
   -2915, 21077, 19365, -2915, -2915, -2915,  1838,  9454,  1876, 21077,
   -2915, -2915, 21077, 21077,   726,   726,   726, -2915, -2915, -2915,
   -2915,  2002,   726, -2915, 21077, 21077,   726,   726,  1823,  1823,
   -2915,  3192, 21077,   726, -2915, 28654, 21077, 21503, 15974, 21077,
    1909,  1910,   726, -2915,   726, -2915, 21077, 17653, -2915,   724,
    2213,  2213,  1369,  3571,  1845, -2915,  1946,   726, -2915,   726,
     791, 41906, 21077, 34490,  1922,   121, 21077,  1858,  1275, -2915,
   21077,   527, -2915,  1859, 21077,  1927,    89, 21077, 21077, 21077,
   21077, 21077, 21077, 21077, 21077, 21077, -2915, 21929,   124,   401,
   36137, 18079,  2109, -2915,  1443, 15539, 39845, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915,   726,  1861, -2915,  1880, -2915, -2915,
   -2915, -2915, -2915,  2009, -2915, -2915,  1931, -2915, -2915, -2915,
    1280, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1864,
   -2915, -2915, -2915, -2915, -2915, -2915, 55463,  1871, 51360,     0,
   -2915, -2915, 44784, 51360, -2915, -2915,  2084, -2915, -2915,  1872,
   -2915,  5939,  2084,  2024,  2031,  2031, -2915,   -28,  9454,  2071,
    9454, -2915, -2915, -2915, -2915,   908, -2915, -2915,  1316,  1883,
   14303, -2915, 14707, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1227,  1884,  2287,
    1031, -2915, -2915, 38197, -2915, -2915, 32838, -2915,  1894, -2915,
   -2915, -2915, 39845,  1307,  1883, 10368, -2915, 10368,  1883, -2915,
    1888, -2915, 51360, 51360, -2915, 34490, 51360, 51360, -2915,  2201,
    1895, 51360,  2099,  2100,  1900, -2915, -2915, 51360, -2915,  2059,
   21077,  2061, 51360, 51360,  2064,   715,  2056, -2915, -2915, -2915,
   -2915, -2915,  2057, -2915, -2915, -2915,   772, -2915, 35314, 40258,
   -2915, -2915,   125,  1476, -2915,   248,   291,   383,  1977,  1979,
    2021, 51360, 51360, 51360, 51360, 51360,   675, 51360, 51360,  1913,
    1920,  1917, -2915, -2915, 51360,  2118, -2915, -2915,  2063,    39,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1953, 51360, -2915,
     726,  2070, 51360,  1982, -2915, 51360, 51360, 51360,  1227, -2915,
    2268,  1227,  1227,   109,  1640,  1640, -2915, -2915, -2915, 51360,
   51360, 51360,  2014, 47250, 51360, 51360, 47661, 51360, 51360, 51360,
     117,  1148, 51360, 51360,  2072, 51360, 51360, 51360, -2915, -2915,
      44,  2069, -2915, -2915, -2915, -2915, 21077, 29496,  2292,  2158,
    2160,  2000, 40670,   426, 51360, 51360,  2164,   426, -2915, -2915,
   -2915,   823,   838, -2915,  1973, 21077,    60, 41906,  1963, 24861,
   -2915,  2027, -2915,  2030,   726, -2915,  1726,   123,  2161,  1980,
    1980,  1980,  1980,  1980,   992, -2915, -2915, -2915,  2224, 46428,
   -2915, -2915,   809, 44373, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915,  1953, -2915, -2915, -2915,  2128,  2127, 51360, -2915,
   -2915,  1371, 46428, 43551,    72, 51360,  2331,  2223,  1100, 46428,
    1272, -2915,  2222,  2225,  2243, -2915, 23610, 48483,  1988,   618,
   -2915, 48483, 48894, -2915,   724, 21077, -2915,  1995, 41906, -2915,
   -2915, 51360,  1996,   120,   120, -2915, -2915, -2915, -2915, -2915,
   -2915, 39845,   676, -2915, -2915,   676, -2915,   676,  2427,  1623,
    1994, -2915,  1562,  1623,  1623,  1689,  1623, 49305,  2358,  2242,
   -2915, 19799,   956, -2915, -2915,   406, -2915,   418,   -55,  2185,
   -2915, -2915, -2915,  2155,  2003, 49305,  2336,   120, -2915,  9454,
     983,   458,   646, -2915,   726, 21077,   136, -2915,  7015,  1005,
    6855,  1062,  2011,  2017,  1067, -2915, -2915, -2915, -2915, -2915,
   -2915,  2019,  2265, -2915, -2915,  2022,  1088,  1145,  2023,  2028,
   -2915, -2915,  2412,  1265,  2029,  7642,  2035, 21503,  1561, -2915,
   21503,  2036, -2915,  1289,  6034,  2015,  2037,  2052,  2055,  2038,
    2045,  7921, 20225, 21077, 20225, 20225,  8012,  2015,  2048, -2915,
   -2915, 21077, 51360,  2050,  2051, -2915, -2915,  3192, -2915,  2081,
   -2915, 21503, 21503,  3675, 18513, -2915, -2915,  2276, -2915,   837,
   -2915,  2058, -2915, -2915,  4058,   130, 21077,  1858, 21077,  2119,
   28654,  6422, 21077,  2349,  3153,  3153,   147,   147,    61,    61,
      61,  1022,   401, -2915, -2915, -2915,  2060,  1568,  1628, 46428,
    6302,  6930, -2915, -2915, -2915, 24027,  1852, 21077, 21077,  2065,
   -2915,  1322, -2915, -2915,   176,  2427,   726,   557,   726,   791,
   30745,  1883, -2915,  2067, -2915, 51360,  1852,   785, -2915, -2915,
    1327, 21077, -2915, -2915,  1656, -2915, 51360,  1998,  1998, 21077,
   21077, 18939, -2915, -2915,  2075, -2915, -2915, -2915, -2915, -2915,
    2053, -2915, -2915, -2915, 51360, -2915, -2915,  2463,  2078,  2066,
    2080,  2073,  1001, -2915, -2915, -2915, -2915, -2915,  2256, -2915,
   21077,   211,  2083,  2085, 51360,   120, -2915,  9454, -2915, -2915,
   -2915,  2286, -2915, -2915,  2228, -2915, -2915, 34902, 41906, -2915,
   41906, -2915,  -131, 51360, 51360, 51360, -2915,  1623, -2915, -2915,
   -2915, -2915, -2915,   778, -2915, 41906,  2214, 41082,  1623,  -112,
    1953, 51360, 51360, -2915,  1623, -2915,  1953,  1623,  1953, -2915,
   -2915, -2915, -2915, -2915,  1227, -2915, -2915, -2915, -2915, -2915,
    1227,  1227, -2915, 41906,    29, -2915, -2915, -2915, -2915, -2915,
     120,   120, -2915, -2915, -2915, -2915,  2148, -2915, -2915, -2915,
    2117, -2915, -2915, -2915,  2154, -2915, -2915, -2915, -2915, -2915,
   -2915,  5554,  2088, 41906,   426,   426, 51360,  2092, -2915, -2915,
   -2915,  2298,  2301,   426, -2915, -2915, -2915,    20, -2915, -2915,
   34490, 27796,  3939,  2097, -2915,  2095,   726,  1883, 25294,  1411,
   -2915, -2915, -2915,   605,  2279,  2101,  2250,  1980, -2915,   225,
     171, 49716, 50127, 50538, -2915,  2147,  2159,  1816,   128,  2219,
     678, -2915, 46428,   123,  1345, -2915, 41906,  2106, 46428,  2107,
    2102, -2915, -2915, -2915, -2915,  1348, -2915, 41906, -2915,  2258,
    2261, -2915,  1352, -2915, -2915,   314, 51360,  2175,  2156,  1100,
   38197, 41494,  1670, -2915, -2915,  2263, -2915, -2915, 26128, 22781,
     618,  2114, 51360, -2915,  2116, 24027,  2321,  2262, -2915, 24027,
    2262,  1084,  2262, 24027,  2326, -2915, 27379, -2915,  2124,  1443,
    9454,   120,  2125,   120,   120, -2915, -2915,   799, -2915, -2915,
    2121, -2915,  2138, -2915, -2915, 43140, -2915, 51360,   212, -2915,
   -2915,  2277, -2915, -2915,  9454,  1357, -2915,   -73, 51360,   724,
   -2915, -2915, -2915, -2915,  2394,  2395, -2915, 45606,    65, 51360,
   -2915, -2915, 21077, -2915, -2915,  2146,  2139,  9250, 21077, -2915,
    2409, 41906, -2915, 51360, -2915, -2915, -2915, -2915,   726, -2915,
   21077, -2915, -2915, -2915, -2915, -2915, 21077, -2915,   726, -2915,
   21077,  2392, -2915,  2512, 41906, 21503,   579,  1678, 22355, 21503,
   21503, 21503, 21503, 21503, 21503, 21503, 21503, 21503, -2915,   271,
   -2915, -2915, 21077, 21077,  2400,  2392, -2915, -2915, -2915,  1247,
    1247, 41906,  2152,  2015,  2157,  2165, 21077, -2915,   724,  3969,
   -2915,  2475,  1100, 21077,  1602,  2285, 21077,  1375, 21077, -2915,
   -2915,  2167, -2915, -2915, 41906, 21077, 21503, 21503,  4954, -2915,
    5044, 21077,  2171,  5276, 18513, -2915,   427,   427,   427,   427,
   -2915, 46428, 46428,  1988,  2393,  1390,  1406, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915,  2163, -2915,  2172, -2915, -2915,   -17,
    2173, -2915, -2915,  2463,  2178,  1034, -2915, -2915, 20651, -2915,
   -2915,  2176, -2915, -2915,  1623, -2915, -2915, -2915, -2915, -2915,
   10368, -2915, -2915,  2179, -2915, -2915, -2915, -2915, -2915,  2239,
    2241,  2282,  1980,  4069, -2915, 51360, 51360,  1410, -2915, -2915,
    2401, -2915, -2915, -2915,  2237, -2915, -2915, -2915,  2251,  2252,
   -2915,  2254, -2915, -2915, -2915, -2915,  1623,  1623, -2915, -2915,
   -2915, -2915, -2915, -2915,   434,   408, 41906, -2915, -2915, -2915,
   51360, 51360, -2915,  2398,  2192, -2915, -2915,  2402,  2403,   426,
     426, -2915, -2915,  1640,  2470, -2915,  2176,  1385, -2915, -2915,
   -2915, -2915,   688,   726,  1266,  2198, -2915,  1347, 25294, 25294,
   25294, 25294, 25294,  1883,   791, 46428,   726, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
    2199, 51360, 21503, -2915,   704,    64, -2915,  2404, 46428,  2244,
   -2915, -2915, -2915, 41906,  2543,  1038, 46428,  2452,  2353, -2915,
   51360, -2915, 43551,   822,  2430, 43551, -2915, 51360,  2555,  2556,
     314, -2915, 51360, -2915,  2255,  1476,  1100, 51360,  2216, -2915,
    2206, -2915,  1712, -2915,  1603, -2915, -2915,   547, -2915, -2915,
   48483,  2217, 51360,   618, 24027, -2915, -2915,  1954, -2915, 24027,
    2423, -2915, -2915, 24027, 51360,  2221, 51360, -2915,   120, -2915,
   -2915,   996,   676,   176, -2915, -2915,  2461, 49305, -2915, -2915,
   -2915, 19799,  2226, -2915, -2915, -2915, -2915,  2467, -2915, -2915,
    9454, -2915, -2915, 21077,  9454, -2915,  2230,  2231,  2233,  9454,
    4355,  2234,  9454,  2400, -2915,  1630,  2468,  2383,  2236,   271,
    1630,   497,   497,   189,   189,    67,    67,    67,  2512,  9454,
    9454, -2915, -2915, -2915, -2915,  2238, -2915, -2915, -2915,  2015,
   -2915, -2915,   791,  2213, 21503, 21503,  1109, -2915,   219, 41906,
   -2915,  1418,  1109,  2623,  3224, 21077, 21077,  5487,   129, 21077,
    4456, 46428, 46428, 46428, 46428, -2915, -2915,  2566,  2472, -2915,
   -2915,   176,  1329,  1100, -2915,  2245, 51360, -2915,  9454, 28654,
   -2915, 51360, -2915, 51360, 51360, 51360,   726, -2915,  1419,  1421,
    2244, -2915, -2915, 51360, 51360, 51360,  2147,  2405,  2406,   726,
   51360,  2288, -2915, -2915,   426,  2453,   426,   426, -2915, -2915,
   -2915,  1100, -2915,   832,  2531, -2915,  2473,    95,  2259,  2496,
    2499, -2915, -2915,  1521,  1521, -2915, -2915, -2915, -2915, -2915,
    2503, -2915, 21077,    78,  1630, -2915, -2915, -2915, -2915,  2244,
    1816,  2486, -2915,  2308,   314,   228,  2534,  2540,   123, -2915,
    2283,  2565,  2571, -2915,  2290,  1412, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, 51360,  2494,  1726,  2538, -2915, 24444,  1100,
    1670, -2915, -2915, -2915, -2915, -2915,  2359, -2915, 51360,  1447,
   -2915, 21077,  2296, -2915, -2915, 24027,  1954,  1455, 51360,  1460,
   41906, -2915,  2546, -2915, -2915,  2450, -2915, -2915, 19799, 49305,
    9454, -2915, -2915, -2915, -2915, -2915, -2915, 21503,  2305, 21503,
   -2915, -2915,   346,   346,  1481, -2915, 41906, 21503, 21503,  1109,
    1109, 21077,  1109, -2915, -2915, -2915, -2915, -2915, 21077, 21077,
   -2915, -2915,  1385, -2915, -2915, -2915, -2915,   791, 21077, -2915,
    2309, -2915, -2915, -2915, -2915, -2915,  2432,  2244, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, 21077, -2915, -2915,   426,
   -2915, -2915,  2504, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   43140,  2657, 46428,   688,  4880,  2471, -2915, -2915,  2501,  2391,
   51360, -2915, 43551, -2915,   428,  2447, -2915,  1412, -2915, -2915,
   46428,  2476,  2478,  2477, -2915,  1100, -2915, 51360, 21077,  1484,
   -2915, 50949, 16820, -2915, -2915, 46428,  1494, -2915,  9454, 51360,
   -2915, -2915, -2915,  1496, -2915,   314, -2915,  1498,    65,   292,
   21503,   372, -2915, -2915,   346,   346,  1109,  2015,  9454, -2915,
   -2915, -2915,  2988,  2323, -2915, 46428, -2915,  9454, -2915, -2915,
   -2915,  1950,  1950,    15, -2915,  1950, -2915,  1950, -2915,  2657,
    2664, -2915, -2915,  2580, -2915,   395,  2481, 51360,  2679, -2915,
   -2915, -2915, 51360,  2477,  1506, -2915, -2915,  2645,  2410, -2915,
   -2915,  5392,  2410, 24444, 51360, -2915, -2915, -2915,  1852, -2915,
    1534, -2915, -2915, -2915,  1531, -2915, 21077, -2915,  1816,  1100,
    1953,  2505, 51360,  1100,  1953, -2915, -2915,  2616, -2915, -2915,
     144, -2915,  2498,  2500, -2915,   500,  2350,  2410, -2915,   580,
   51360, -2915, 50949,  1852, -2915, -2915,  2627, -2915, -2915, -2915,
    2501, -2915, -2915, 51360,  2351, -2915, -2915,  2462,   222,   222,
    2418, -2915,  2635, -2915,   726,   726, 41906,  2352, -2915, 32419,
   -2915,  2480, -2915,  2482, -2915, -2915, -2915,   195,  2481,  2351,
    2631, -2915,  2736, -2915,   101, -2915, -2915, 43140, 28654, -2915,
     500,  1538, -2915, -2915, -2915, -2915, -2915, -2915, -2915,    11,
     688,  2506, -2915, -2915, -2915,  1562,   -53, -2915, -2915, 32419,
   -2915,   452, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   43140, -2915, -2915, 40670, -2915, -2915,  1560, -2915, -2915,  1565,
    1284,  2381,  2384, -2915,   452, 32419,  2508, -2915,  1539, -2915,
   -2915
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -2915, -2915, -2915, -2915, -2915,  2592, -2915, -1004,  -165, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915,   831, -2915, -2915,  -782,  1039,  1535, -2915, -2915,   606,
   -2915, -2915, -2915, -1217, -2915,   469, -2915, -2915, -2915, -2915,
   -2915, -2915,   898, -2915,   957,   498, -1494, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -1452,  -127,
      52, -2915,    51,   916,   137, -2915,  -135, -2915, -2915, -2915,
    -788,   576, -2318, -2206,    59,  -421,  -448,  -401,  -397,  -420,
   -2915,  -279,  -353, -2596, -2220, -2915, -2915, -2915, -2915, -2915,
      74, -1426, -2915,  1332, -2915, -2915, -2915, -2915,  -150, -2915,
   -2915, -2915,    80, -2915, -2915, -2915, -1425, -2915,   888, -2316,
   -2915, -2915, -2915,  -489,  -451, -2915, -2766,   -88,   -85, -2915,
   -2915, -2915, -2915, -2915, -1063, -2915,   502, -2915, -2915, -2915,
    -430,  1367,  -472, -2915, -2915, -2915, -2915,  -706, -1457, -2915,
   -2915,  2705,   -62, -2915, -2915, -1831, -1423, -2915,  -157,   480,
    1739, -1119, -1994,    56, -2915, -2915, -1543, -2915, -2915, -2915,
     819, -1421, -2915, -2915, -2915,  -334, -2914, -2915, -2915, -1081,
   -2915,   603,  1035, -2915,  1037, -2915, -1747,    94,  -884, -2339,
    -123, -2915, -2915, -2915, -2915, -2915, -1429, -2915, -1531, -1406,
   -2915,  -301, -2915, -2915, -2915,   691, -2915,   251, -2915, -2915,
   -2915, -2915, -2915, -2915,  -419,  -452, -2915, -2915, -2915,   488,
   -2915, -2915, -2915,   795, -1006,  -846,  2001, -1419, -2915, -2915,
   -2915,   915, -1862, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -1437, -2915, -2915, -2915,  1152,  2749,  -700, -2915, -2915, -2915,
   -2915, -2915, -2915,     1, -2915, -2915,   410,     2, -2915, -2915,
   -2915, -2915,  -325,     8,  1783,   861,    75,   -61,   -67,  -222,
     177,   307, -2915, -2915,  -198,  1087, -2915, -2915, -2915, -2915,
     682,  1601, -2915,   680,  -258, -2915, -2915,  1604, -2915,  1153,
    1173,   718, -1939,   900, -1938,   464,  -455,  -108,  -172, -2915,
   -2121, -2578,   149,   604, -1670, -2027,  1441, -2915,  2149,  2390,
   -2915, -2915, -1009, -2915, -2915,  4339,  4377, -2915, -2915,  5993,
    6238, -2915, -1047,   350,  7051,   940, -1171, -1478, 10114,   440,
     319, -1487, -2915, -2915,  -723, -2915, 10689,   558, -2915, -1040,
   -2915,    41, -2915, -1540, -2915, -2915, -2915, -2915, -2915, -1967,
   -2410,  -542,   761, -2915, -2915,   846, -2915, -2915, -2915,  -720,
    -920, -1637,   769, -2915,  1244, -2915,    22,  -290,   725,   -97,
     111,  6950,  -841,   156,  -529,  7827,  -676, -1968, -1278,  1853,
   -2915,  -717, -2915,    -2,    19, -2915, -2915,  2854,  -454,  -765,
   -1648, -2915,   -70, -2915,  -863,  -944, -2201,  -368, -2915, -2915,
     -65, -2915,  1984, -2915,  1150,  1599, -2915, -2915,  1155,  -806,
    -136, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
   -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,  1634,   106,
   -2915,   -69, -2915, -2915,  2885, -2915,  2638,   -48, -2915,  2266,
     -41, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
    -831,  1184, -2915,  1965, -2915, -2915, -2915,  -745, -2915, -2915,
   -2915,  1817,  -153, -2915, -2915, -2915, -1005,  1047,  2005,  -839,
   -1003,  1151, -2915, -2915, -2915, -2915, -2915, -2915, -2915, -2915,
     909, -2915, -2915,   750,   911, -2915, -2915,   140, -2915, -2915,
      54,   141, -2915,  1705, -2915, -2915, -2915,   334, -2915, -2915,
   -2915,  -543,  8324,    57,   -56,   -80,   630, -2915,   305,  7606,
   -1337,  -687,   -87,  1677,  5327,  9885,    43,   -26,  -107,   298,
     596, -2915, -2915,  2622,  1167,   934,  -892,  6363,  1408,  2325,
    3719,  -722,  -830,  2032,  -512, -1315, -2915,  2985
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1796
static const short yytable[] =
{
      69,   813,  1000,   697,  1030,   914,  1014,   310,   360,  1149,
     694,   783,   578,   309,  1007,  1882,  1010,   774,   783,   903,
    2042,    70,  1050,  1517,   987,   697,   324,  1975,  1040,  1423,
    1528,  1548,   694,   326,   693,  1074,  1366,  1447,  2061,  1086,
    1454,  1655,   855,   877,  1607,  1009,  1011,  1811,  1288,   909,
    1976,  1130,  1079,  1132,  2039,  1134,   693,  2033,  1103,   783,
    2045,  1135,  1295,   736,   701,  1093,  2214,  1725,  2677,  1995,
    1864,  1108,  2093,  2473,  1116,   304,   305,  1112,  1515,  1380,
    1078,   779,   307,  1335,  1519,  2614,   701,  2450,  1370,  2774,
    1529,  2508,   873,  2465,  2467,  1996,  1997,  2778,  1998,   873,
    1999,   873,  2000,  2805,  1124,  2647,  1824,  1277,   848,  2244,
    1286,  2289,  2291,  1143,  2227,  1129,  1111,  2037,  2400,  2401,
    2402,  2403,   962,  1560,  1340,  1561,  2374,  1620,  1621,  1405,
    1576,   351,   697,   700,   351,  1570,  1571,  1671,  1363,   694,
    1706,  1367,  1272,  2544,  2257,  1360,  1527,   351,  2261,  1555,
    1968,  1640,  2383,  1666,  2881,   700,   831,  1344,  1345,  1674,
     913,   310,  -821,   693,  1269,  2428,  1392,   309,  -824,   351,
     996,   151,  2075,  2358, -1143,  1628,  1278,  1555,   831,   976,
   -1143,  2086,  -281,   359,  2619,  1164,  1664,  1595,  1830,  2620,
    2621,  2622,  2155,   701,  2205,  1917,  1917,  2760,  2704, -1688,
    1831,  2623,  2624,  2625,   737,  2626,  2627,  2628,  1700,  2193,
    1959,  2629,  2630,  2631, -1159,  2194,  1043, -1587,  2160,   984,
   -1159,  2987, -1713,  1671,  1363,  -821,   707,  2160,   958,   304,
     305,  -824,  1555,  2762,   168,  2012,   307,   708,  3227,  2124,
    2348,  2311,   872,  1348,  1703,  1674,  3037,  1140,  3039,   872,
    1409,   872,  2962,   199,  1393,  -995,  3323,  2327,  2239,  -917,
    1832,  1146,   700,  3342,  1992,  2544,  1113,   205,  1788,  1445,
    1117,  2076,   199,   926,  1422,   882,   351,  2504,  1121,  1050,
     927,  3317,  1454,  2003,  1713,  2068,  1324,  3330,   185,   953,
    3241,  1940,  1284,  1446,   743,  1671,  2384,  1044,   712,  1941,
     713,  1720,  2684,  1590,  3278,   576,     3,  2518,  1313,  1825,
      52,  1723,  1419,   954,   709, -1727,  2017,  1674,   827,  1942,
     927,  1655,  1714,   595,  1549,  2842,  2752,  1993,  3242,  1704,
    1830,  1459,  1147,   845,  3301,  1389,  1461,  2505,  1410,  1466,
   -1589,   853,  1463,  1731,  2988,  1300,  2004,  2544,  3295,  1314,
    1789,   205,  1721,  3125,  1389,   883,  1015,  3203,  2766,  1275,
    1033,  2737,  1458,  1556,  2328,   227,  2329,  1041,  2544,  2312,
    2964,  -990,   353,  1136,  2705,   353,   907,  1833,   351,  1516,
    2747,  3324,  1949, -1586,  1537,  3343,  2767,   585,   353,  2013,
    1960,  1556,  1082,  1534,   608,  2768,  1088,   704,  2717, -1749,
    1131,  1133,  1832,   221,  2349,  1094,  2292,   704,  1346,  1550,
     353, -1688,   980,  2706,  2722,   351,   985,  2240,   351,  3318,
    1596,  2367,  2544,   710,  1701,  2077,  1549,   716,  1453,  2359,
    1394,  1620,  1621,   608, -1713,    49,  1147,  2499,   576,  1640,
    2078, -1143,   704,   746,  1927,  2225,  1556,  1944,  2544,  3331,
   -1796,   608,   704,  3056,  1378,   704,  2020,  1834,   717,   704,
    3163,  1359,  -201,   704,   952,  -821,  2769,  -821,   843,  2938,
    2939,  -824,  1628,  -824,  1667, -1585,  2195,  1671,  2429,  2430,
    2632, -1159,  1557,  1325,  2161,   704,  1775,   961,   205,  3302,
    1411,  1473,   963,  2596,  1969,  1695,  1969,   874,   576,  1674,
     704,  2557,  2546,   862,   874,   843,   874,  1367,  1800,   881,
    2837,   596,  2012,  2578,   576,  2005,  2813,   353,  2362,  1833,
    2817,  1864,  1850, -1796,  2822,  1718,  1719, -1727,  1360,  1050,
     964,   714,   576,  2715,  2716,  2746,  3279,  1805,  1615,  2033,
    2095,  2682,  2721,  2683, -1642, -1690,  1591,  2265,  3303,  2475,
    2476,  2643,  -995,  1016,  3339,  -995,  2048,  2047,  1035,  1037,
    2633, -1587,   286,  1840, -1587, -1587,  2050,  3304,  2638,  1562,
   -1587,  2090,  2091,  2544,  2863,   151,  -995,  2546,  1692,  1693,
    1694,  1695,  2099,  2101,  2500,    49,  1592,  2645,   576,  1838,
    3248,  2120,  2121,  2510,  2116,  2117,  2502,    49,  2882,  1834,
     576,  1950,  1752,  2546,  1835,    52,  1828,    53,  2133,  2135,
   -1247, -1749,   151,  1332,  1840,  1107,   364,  1588,  2836,   353,
    2554,  2555,  2556,  2557,   697,   856,  3263,   716,  1104,  1451,
    2175,   694,  1678,  1679,  2729,  1608,   747,  2547,   168,    49,
    1883,  1918,   576,   841,   958,   783,   835,    52,  1690,  1691,
    1692,  1693,  1694,  1695,   205,   693,   353,  2837,   717,   353,
    1459,  3290,  1101,  2547,  1938,  2211,  3132,   998,  -990,   704,
     354,  -990,  3128,   354,   927,   168,  1126,  1539,  1072,  1682,
     878,  2805,  3136,  2948, -1589,   701,   354, -1589, -1589,    69,
    1784,   857,  -990, -1589,  2803,  3249,  3284,  1458,  1030,   958,
    2552,  2553,  2554,  2555,  2556,  2557,  2368,  3022,   354,  2947,
      70,  2973,  2974,  2975,  2976,  2977,   286,  2736,  2033,  1540,
    3098,  2552,  2553,  2554,  2555,  2556,  2557, -1586,  2546,   185,
   -1586, -1586,   576,   576,  1841,  2176, -1586,    52,    52,  2177,
    3291,  2641,   706,  2065,  2866,   827,   827,  1785,  1452,  3292,
     958,  1384,   227,  2501,   700,   205, -1642, -1690,  2456,  1951,
    3209,  2548,   750,  1956,  2949,  2503,  1137,  2950,   351,  3127,
    3023,  2178,   351,   844,  2602,  2552,  2553,  2554,  2555,  2556,
    2557,  2678,   873,  3210,  1152,   873,  1964,  2548,  2547,  1151,
    1043,  3285,   205,   849,  1541,  1842,  1786,  2549,  2550,  2551,
    1102,  2552,  2553,  2554,  2555,  2556,  2557,   221,  1847,  1165,
    2936,  3235,  1785,  2457,   831,   354,   831,  1296,   831, -1585,
    1280,  1282, -1585, -1585,   831,   831,  1830,  1070, -1585,  3017,
    1690,  1691,  1692,  1693,  1694,  1695,  1312,  2458,  1831,  1542,
      49,   858,   859,   576,   221,  2962,  2708,  2709,   748,   905,
    1953,  2046,  2459,   227,  2867,  1098,   787,   608,   940,  3286,
    2460,  1786,  2985,  2868,  2062,  1267,  1929,  1837,  1443,  1366,
    1792,  1044,  3027,  1793,  2282,  3030,  2179,  3186,  1787,  1848,
    3034,  2461,   902,  1382,  3036,  3293,  1036,  3024,  2958,  2959,
     227,  1838,  1313,   578,   578,  2513,  1971,   911,  1832,  -853,
    1807,   704,   704,  2512,  1539,  1383,  2963,  1073,  1954,  1543,
    2330,  2331,  2548,  2986,  1444,   941,  1268,   354,   716,   718,
    3270,  1370,  1030, -1796, -1796,  1763,  2552,  2553,  2554,  2555,
    2556,  2557,   872,  1314,  2248,   872,   749,  1930,  1425,  3025,
     755,  1971,  2834,  1787,  1333,  2283,  2831,  2462,   811,   717,
    1864,  1085,  1794,   941,   354,  -853,  1995,   354,  1764,   917,
    1426,   351,   697,  2964,   942,  1334,  1440,   943,  2033,   694,
      69,    69,  2033,    69,  1413,  2851,  2033,  2827,  1333,  2829,
    2830,  2486,  1996,  1997,  1459,  1998,  2158,  1999,  1441,  2000,
    3114,    70,    70,   693,    70,   918,  -853,   880,   941,  1334,
    1148,  3001,   942,  1765,   914,  1972,  1150,   759,   930,   353,
     920,  1839,   879,   353,  2848,  1833,  1156,  1126,  1095,  1095,
    1415,  1541,  2589,   701,  -561,  1008,   608,  1012, -1388,   585,
    2463,   704,  1032,   585,   704,  3002,  3274,   704,   704,  1008,
     585,  3115,     9,  1096,  2776,  2322,   944,   942,  2325,  2326,
    1972,  2059,  1554,  2063,  2064,  3168,  2066,   761,   704,  1150,
     921,   608,   310,  1008,  1298,   585,  1542,  3299,  1568,   585,
    1090,   704,   956,  2978,   704,  1306,  1008,  2688,   585,  1097,
    1097,   310,   716,  2514,   944,   704,   704,  1594,  3313,  1413,
    2255,  2515,   700,   576,   704,  1834,  3160,   608,  1671,  2689,
     704,  1613,  2409,  2573,   704,   704,   351,  3266,   967,   704,
     704,  1414,   704,   717,  2469,  1008,   970,  2590,   945,  1630,
    1674,  2591,  1978,  3108,  2587,  3110,  3111,   922,  3313,   944,
    1564,  1565,   118,   704,   704,  1415,  1543,  1566,  1458,  1289,
     704,   691,  3296,   576,  1650,  1651,   946,  1397,    52,  1658,
     122,  2267,  1991,  1868,  3313,   821,  1973,  1727,  1665,  1662,
    1048,   704,  3208,   704,  1049,  1979,  1157,  2615,  2616,  1670,
    2102,  2103,  2104,   822,   980,  1869,  1652,   767,  2115,   768,
    2375,  2376,  2118,  2119,  1974,  1671,  1115,   874,   769,  2123,
     874,   704,   608,   704,   126,   127,  1283,   772,  2139,  1870,
    2140,  1973,   353,  -975,  1524,  1161,  -975,  1674,  1460,  1290,
    2648,  2286,  1675,  2153,  1282,  2154,   986,  2287,  2592,  1398,
     923,  1048,  1525,  2801,  2230,  1049,  2593,  1626,  1917,  1429,
    1484,  1125,   576,  1924,   697,  1430,   759,    49,   868,   759,
     576,  1755,  1755,  1980,  1755,  1019,  1399,   901,  2371,  2372,
    1728,  1530,  1531,  1532,  1709,  1020,  1021,  1022,  1710,  1023,
    1024,  1025,  1026,  1027,  1028,   693,  2979,  1042,   585,   585,
    1934,  1431,  1353,   578,  3085,   997,  1802,  2379,  3188,  2457,
    1076,   873,  1939,  2380,  1432,  1333,   761,  1333,  1333,   761,
    1777,  1981,  1818,   704,  1778,   701,   704,   697,  1801,   704,
    2669,  1150,  1778,  2458,   694,  1052,  1334,   354,  1334,  1334,
    1077,   354,  1433,  -969,  1050,   873,  -969,  1434,  2819,  1150,
    1435,  1677,  2670,  1008,  1814,   798,  2460,  2033,   693,  2478,
    1795,   927,  2033,  1080,  3041,  1081,  2033,  1632,  3015,   873,
    1678,  1679,  1429,  2297, -1250,  2930,  2671,   353,  1430,  2242,
    1987,  1796,   831,  1778,  1990,  2308,    69,  1099,   701,  1982,
      69,  1983,  1849,  1400,  2010,  2439,  1638,  1639,   704,  2314,
     914,  2639,   704,  2317,  1087,  1401,   704,    70,   351,   351,
     351,    70,   704,  1397,  1431,  1100,   697,  1682,  2847,  1402,
    1008,  1650,  1651,   694,  1122,  2497,  1403,  1432,  2883,  2884,
    1683,  2498,  2022,  2023,  1008,  1536,   767,   704,   768,   767,
    1083,   768,  1084,  2462,  3061,   225,    49,   693,   226,   576,
    1008,  1615,  2511,  1654,    52,  1433,    53,   700,  2512,   351,
    1434,   872,  1332,  1435,  1140,  -995,   351,  2731,  -995,  1404,
    2167,   351,   704,  -290,  2522,   225,  2315,   701,   226,  2083,
    2512,   704,   843,  1747,  2263,  1398,   704,  1030,  2266,  -995,
    2168,  2700,  1333,  1282,  1110,   872,  1605,  2701,  2702,   704,
    1048,  1610,  2251,  1397,  1049,  2280,  1778,  2027,  1391,  2926,
    1019,  1908,  1399,  1334, -1002,  1756,  1758, -1002,  1762,   872,
    1020,  1021,  1022,  2350,  1023,  1024,  1025,  1026,  1027,  1028,
     354,  2524,  1424,  2296,  1144,  2298,  2527,  2512, -1002,  2440,
    1448,  2652,  2528,  1153,    49,  2391,   700,   576,  1159,  1909,
    2395,  1650,  1651,  3090,  1686,   913,  1145,  2532,   933, -1005,
     351,  3151, -1005,  2512,  1158,  1386,  2889,  2319,  1690,  1691,
    1692,  1693,  1694,  1695,  2694,  1398,  -829,  1160,  2033,  -972,
    2169,   934,  -972,  1652,  1361,  2170,  1362,  1387,  -829,  2171,
     199,  2113,   935,    49,  2352,  1465,   576,  2355, -1587,  2357,
    1161, -1587,  1399,  1643,  2054,   608,   608,  3199,  2663,  1162,
    -960,  1388,  1436,  -960,  2533,  1910,   697,  1669, -1589,  1283,
    2512, -1589, -1593,   694,  1743,  1743,  -829,  1650,  1651,  2441,
    2572,  1163,  2574,  2575,  1751, -1005,  1437,  2544, -1005,  3181,
    2165,  1401, -1594,  1166,  -829,  1757,  1757,   693,  1757,   353,
     353,   353,   831,   831,   831,  1402,  1911,  1167,  1912,  1654,
     831,  1287,  1403,  1454,   831,   831,  1291,  2544,  1913,   936,
    2516,   831,  1389,  1292,   576,   354,   608,   701,   585,    52,
     831,    53,   831,  1650,  1651,  -829,  2172,  1332,  2652, -1586,
    2219,  1293, -1586,  -829,  2173,   831, -1585,   831,  -958, -1585,
     353,  -958,  2969,  2970,  3233,  1404,   958,   353,  2544,   704,
    1494,  1920,   353, -1591,  1299,  1925,   874,  1928,  1300,  1400,
   -1590,   937,  2894,  1964,    49,  1301,  1914,   576,  2221,  2490,
    -961,  1401,  1303,  -961,  2537,   927,  2544,  2654,  2043,  2044,
    2538,  2246,  2054,  2246,  1547,  1402,   700,  2490,  2218,  2960,
     874,    49,  1403,  1304,   576,  1915,  1032,  1307,  2561,    52,
     351,    53,  -959,   578,  2512,  -959,  3151,  1332,   697,  1305,
    1150,  3021,  1310,    49,   874,   694,   576,  1318,   938,  1459,
    1322,    52,  2080,    53,  3239,  3240,  -829,  1323,  3243,  3082,
    3244,  2618,  2546,  2439,  2640,  1404,  2649,  2512,  2062,   693,
    1008,   353,  1549,  2545,  1008,  1326,  2738,  2739,  2740,  2741,
    2742,  1397,  2696,  2697,  2779,   988,  2972,  2786,   989,  1327,
    2780,  2791,  2546,  2787,  1328,  1333,  2840,  2792,  1329,   701,
     990,   991,  2841,   351,   914,  2439,  1330,    52,  1303,    53,
    1331,  1333,  3352,    69,  2897,    69,  1334,  2857,  3141,  3142,
    2512,   992,  2547,  1397,   993,   585,  1338,   704,  1612,  2919,
     227,  1341,  1334,  2546,    70,  2512,    70,   351,  1283,   351,
    2738,  2739,  2740,  2741,  2742,  2920,  1602,  1603,  2743,  2940,
    1343,  2512,  2547,  1398,   704,  2792,  2203,  3065,  3096,  1019,
    3097,  2546,  1008,  3066,  2792,  2410,  2792,   704,   700,  1020,
    1021,  1022,  1346,  1023,  1024,  1025,  1026,  1027,  1028,  1048,
    1399, -1253,   351,  1049,  1354,   704,  3157,   704,   704,  1371,
     704,  2378,  1549,  2547,  3162,  1398,  1372,  2074,   831,  3164,
    2780,  1810,  3326,  1362,  1374,  2780,  1333,  2440,  2229,  1333,
    1333,   843,  2655,  2656,  2088,   958,  1384,   354,   354,   354,
    3172,  2547,  1399,  3222,  1381,  2685,  3066,  1334, -1593,  3223,
    1334,  1334,  2735,  3229,  2391,  3231,  2606,  3232,  2607,  1549,
    1396,  2780,   914,  2841,   994,  3258,  2548,  2651,  2437,  2440,
    1032,  1596,  2740,  2741,  2742, -1594,  2549,  2550,  2551,  2449,
    2552,  2553,  2554,  2555,  2556,  2557,  2129,   831,   354,  1418,
    3268,   353,   831,  3267, -1591,   354,  2548,  3328,  3360,  1549,
     354,  2657,  2658,  3329,  3329,  1821,  2549,  2550,  2551, -1590,
    2552,  2553,  2554,  2555,  2556,  2557,  2608,  1400,  2609,  3353,
    1407,  3354,  2611,  2612,  1303,  2818,  -821,  2821,  1309,  1401,
    1311,   704,  1347,  1349,  1420,  1421,  1505,  2548,  1427,  1442,
    1449,  1462,  1450,  1402,  1881,  1464,  1469,  2549,  2550,  2551,
    1403,  2552,  2553,  2554,  2555,  2556,  2557,  1471,  3177,  1400,
    1475,  1473,  1512,  1513,   353,  2548,  1389,  1520,  -154,  1522,
    1505,  1401,  1533,  2224,  1544,  2549,  2550,  2551,   704,  2552,
    2553,  2554,  2555,  2556,  2557,  1402,  1948,  1546,  1549,   354,
    1551,  1019,  1403,  1404,  2858,  1552,  2804,  1553,   353,  1600,
     353,  1020,  1021,  1022,  2861,  1023,  1024,  1025,  1026,  1027,
    1028,  1604,   831,  1606,  2456,  1611,  1619,  1662,  1629,  1622,
    1623,  1624,  1726,  1745,  1625,   227,  1631,  1634,   585,  1635,
    2165,  1353,  1636,  1637,  1642,  1404,  1645,   704,  1986,  2835,
    1646,  1647,  1648,   353,  1649,  1656,  1657,   585,   704,  2605,
    1705,   585,   608,  1746,  1596,  1753,   704,  1776,  2027,  1783,
    1312,  2849,   704,  1790,  1791,  2407,  1797,   704,   585,  2457,
    1821,  1799,  2105,  1803,  1363,  1881,  1806,  1812,  1813,  1815,
   -1531,  1817,  1844,  1845,  1822,  1823,  1825,  1826,  2417,  1827,
    1843,  1846,  1871,  2458,  1872,  2438,   585,   704,   585,   704,
     704,  1873,   704,  2304,  1874,  1875,  1877,  1905,  2459,   704,
    1876,  1878,  1907,  1906,  1917,  1921,  2460,  1922,  1931,  1923,
    1926,  1932,  1933,   704,  1935,  1936,  1030,   704,  1937,  2106,
     585,   704,   704,  1947,  2054,  1952,   831,  2461,  1333,  1955,
    1957,  1958,  1965,  1615,  2333,  2334,   704,  1730,   704,   704,
    2341,   704,   704,   704,   704,  1967,  1977,   585,   704,  1334,
     585,   704,   585,  3031,  3341,   757,  1626,  1632,  1989,  1643,
    2002,  2018,  2008,  2019,  2015,  2021,  2025,  2035,  2107,  1008,
    1008,  2108,  2038,  2051,  2041,  2058,  2760,  2067,  2085,   354,
    2052,  2057,  2070,  2071,  2392,  2156,  2094,  2081,  2761,  2968,
    2095,  2137,  2138,  2462,  2391,  2391,  2391,  2391,  2391,  1671,
    2151,  2152,  2981,   697,  2159,  2809,  2164,  2180,   843,  3214,
     694,  2182,  2762,  2205,  2763,  2216,  2215,   831,  2217,  2220,
    2222,   921,   783,  2416,  2235,  2236,  2241,  2231,  2427,  1969,
    2434,  1505,  1333,  2249,   693,  2250,  2254,  2262,  1333,  1333,
    2753,  2268,  2454,  2270,  2272,  2273,  2454,  2468,  2274,  2276,
    2109,  2278,   354,  1334,  2281,  2284,  2304,  1505,  3032,  1334,
    1334,  2293,  2285,  2294,   701,  2610,   704,  2295,  2305,  2306,
    1505,  2544,  2307,  2309,  2310,  2764,  2463,    49,   310,  2800,
    1282,  2316,   585,  2318,  2793,  2895,   354,  2323,   354,  1333,
    2336,   310,   914,  2360,   831,  2363,   831,  2808,  2027,  2364,
     585,  2365,  2027,  2354,  2366,  2373,  2027,  2748,  2381,  2386,
    1334,  2393,  1505,  2062,  2394,  2398,  2397,   593,  2911,  2912,
    2913,  2914,  2110,  2406,   609,   225,    49,  2412,   226,   576,
    2413,   354,  2765,   700,  2435,  1671,  2436,  2766,  2446,  1505,
     310,  2447,  2448,  2455,  2471,  2474,  2843,   351,  1713,  2485,
    2491,  3220,  2086,  2506,  2507,  2509,  2129,  1674,  1147,  2129,
    2525,  1671,  1675,   609,  1505,  2767,  2526,  2580,  2529,  2530,
    2512,  2531,  2534,  2567,  2768,  1672,  2568,  2535,  2539,  2490,
    2588,   609,   609,  1674,  2542,  2560,  2566,  2569,  1675,   609,
    2129,  2129,  3095,   593,  2570,  1032,  1505,  2577,  1671,  2581,
    2582,  1505,  2583,  2601,  2662,  3104,  2594,  2664,  2604,  3156,
    2660,  2672,  1672,   593,  2617,   593,  2644,  2679,  2680,  3156,
    1674,  1362,  2892,  2691,  2668,  1675,  2546,  2666,  3265,  2667,
     609,  2675,  2710,  2676,  1930,  1743,   831,  2713,  2711,  2719,
    1751,  2718,  2720,  2733,  2734,  2769,   831,  1662,  1793,  2745,
    2744,   704,  2775,  2773,  2782,  2788,  2784,  2785,  2789,  2796,
    2797,  1821,  2807,  2810,  2812,  2814,  1881,  1676,  2815,   608,
    2823,  1677,  2826,  2833,  2828,  3092,  2832,  2543,  2777,  2839,
    2559,  2385,  2845,  2846,  2783,  3099,  2547,  3101,  2852,  2434,
    1678,  1679,  1612,  1676,  2855,  1030,  2563,  1677,  2544,  2562,
    3325,  2886,  1666,  1680,  2931,  2917,  2887,  2922,   585,   704,
     704,  2584,  2585,  2925,  2888,  2899,  1678,  1679,  2921,  3189,
    2908,  1505,  2923,  2933,  2929,  2934,   704,   704,  2935,  1680,
    1676,  2942,  2941,  3351,  1677,  2943,  2944,  1682,  2945,  2954,
    3230,  2955,  2961,  2956,  2957,  2971,  2994,  2982,  2991,  2989,
    1683,  2996,  2472,  1678,  1679,  3190,  2998,  3004,  3009,  3010,
    1681,  3019,  3013,  1682,  3018,  3028,  1680,  3035,    69,  3038,
    3045,  3049,  3057,  1150,  3048,  3191,  1683,  3058,  1684,  3051,
    3052,  2304,  3053,  3055,  3059,  3078,  3079,  3060,   353,    70,
    3192,  2490,  3106,  3088,  3109,  3102,  3103,  1681,  3116,   609,
    1682,  2963,  3120,  2392,  3193,  3121,  3119,  3122,  1685,  2544,
    2548,  3129,  3130,  1683,  3133,  1684,   704,   704,   704,  3194,
    2549,  2550,  2551,  3067,  2552,  2553,  2554,  2555,  2556,  2557,
    3135,  3138,  3137,   310,  1685,  1795,  3016,  3139,  3140,  3011,
    3145,   831,  3147,  3155,  3159,  3165,   831,   831,   831,   831,
     831,   704,  3166,  3170,   831,  1283,  1796,  2027,  3184,  3185,
    3200,  2988,  2027,   704,  2454,  3205,  2027,  2811,  3207,  3212,
    3246,  1685,  3237,  3215,  1686,  3216,  3217,  2915,  2916,  3247,
    3250,  2825,  3255,  3259,  1687,  1688,  1689,  3260,  1690,  1691,
    1692,  1693,  1694,  1695,  3195,  3273,  3277,  3280,  3289,  3282,
    1686,  3196,   585,  3297,  3300,  3278,  2792,  3310,  1505,  1505,
    1687,  1688,  1689,  2074,  1690,  1691,  1692,  1693,  1694,  1695,
    3279,  3321,  1945,  3315,   585,  3316,  3322,  3197,  3340,  3355,
     916,  1946,  2408,  3356,  3342,  1744,  2642,  1686,  1008,  2351,
    3307,  3308,  2707,  2301,  3000,  2332,  3006,  1687,  1688,  1689,
    2946,  1690,  1691,  1692,  1693,  1694,  1695,  2674,  3126,  3298,
    3320,  3012,  3283,  3087,  2546,  3281,    71,  2536,  3213,  3306,
    3257,  3007,  2011,  3144,  2129,  2396,  3358,  2129,  2129,  2129,
    2129,  2129,  2129,  2129,  2129,  2129,  2129,   609,  3345,  3118,
    3327,  3117,  2725,  1988,  3359,   851,  1589,  1505,  2492,  3264,
    2681,  3113,  1505,  3046,  2290,  2288,  3020,  3154,  3245,  2404,
    3333,  2980,  3357,  1294,  2228,   814,  3042,  1505,  2844,  2690,
    2477,  2693,  1567,  2650,  2547,  2129,  2129,  1773,  2238,  1771,
    2054,  2659,  2226,  2613,  2990,  2820,  2451,   310,  3161,  2999,
    1966,  2891,  2995,  3131,   831,   971,   577,  2703,  2599,  2730,
    3064,  3083,  2519,   602,  2597,  2204,  3269,   831,  3089,  3153,
    2646,  3167,  3047,  1535,  1356,  1808,  2253,  1782,  2252,   321,
     928,   979,  2243,  1379,  2256,  2637,  2483,  2714,  2027,  2484,
    1599,  1350,  3043,  1712,  3044,  3081,   354,  2924,  1505,   950,
    2434,  2434,   602,  2053,  2260,  2865,  2479,    76,  2869,  2870,
    2871,  2872,  2873,  2874,  2875,  2876,  2877,  2878,  1779,     0,
     602,     0,     0,     0,  1358,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   704,   704,     0,     0,     0,
    2781,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2703,   577,     0,     0,     0,  2903,  2904,  2548,     0,
       0,     0,     0,  2392,  2392,  2392,  2392,  2392,  2549,  2550,
    2551,     0,  2552,  2553,  2554,  2555,  2556,  2557,     0,     0,
       0,     0,     0,     0,  1671,     0,   704,  3074,  3075,  3076,
    3077,     0,     0,   593,     0,  3219,     0,     0,  1672,     0,
    3179,  2129,     0,     0,     0,  2416,  1674,  2333,     0,     0,
    2333,  1675,  3008,     0,     0,     0,     0,  2434,   310,     0,
       0,  3180,  2304,     0,  2808,   609,   609,     0,     0,  3350,
       0,     0,     0,     0,     0,  2454,     0,   704,     0,     0,
       0,     0,     0,     0,     0,  2856,     0,     0,     0,  2416,
       0,  3040,     0,     0,     0,     0,     0,   609,     0,     0,
       0,   593,   585,   593,     0,   593,     0,     0,  2864,     0,
       0,   593,   593,     0,     0,     0,     0,     0,     0,     0,
     609,     0,     0,     0,     0,     0,     0,     0,     0,  3271,
       0,     0,     0,  3275,     0,  2885,     0,     0,     0,   593,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1676,     0,  2900,     0,
    1677,     0,  2984,     0,   593,     0,     0,     0,     0,     0,
       0,   609,   609,  2129,  2129,   593,   593,     0,     0,  1678,
    1679,     0,     0,     0,     0,  1496,     0,  1505,  1505,  1671,
    1505,  2224,  1680,     0,  1032,     0,  3091,     0,   585,   704,
     704,     0,     0,     0,     0,  1505,     0,  1505,   585,   704,
     585,  1674,   310,     0,     0,  3105,  1675,     0,     0,  1496,
       0,     0,     0,  1681,  3349,     0,  1682,     0,  1671,     0,
       0,   593,     0,  1505,     0,     0,     0,     0,  3202,  1683,
       0,  1684,   831,   831,     0,     0,     0,   310,   593,   593,
    1674,     0,     0,     0,     0,  1675,  1150,     0,     0,     0,
    2544,     0,     0,  1505,     0,     0,     0,     0,     0,     0,
    2951,  3228,     0,     0,  3068,     0,     0,     0,   704,     0,
       0,  1505,     0,  3152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   704,  3062,  3063,     0,  1685,     0,     0,
       0,  3238,     0,  3040,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   585,     0,  1505,     0,     0,     0,
       0,  1676,     0,     0,     0,  1677,     0,  1505,     0,     0,
       0,     0,     0,     0,     0,     0,  2129,  2993,  2129,     0,
       0,  1505,     0,     0,  1678,  1679,  2129,  2129,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1680,     0,     0,
    1676,     0,     0,  1686,  1677,     0,   602,     0,     0,     0,
       0,     0,     0,  1687,  1688,  1689,     0,  1690,  1691,  1692,
    1693,  1694,  1695,  1678,  1679,     0,     0,     0,     0,     0,
       0,  1682,     0,  3236,     0,  2304,  1680,  2333,     0,     0,
       0,     0,     0,     0,  1683,     0,     0,   593,     0,     0,
       0,     0,  1008,     0,     0,  2546,  1008,  1008,     0,     0,
       0,  1505,     0,     0,   704,  1575,  1497,  1681,  1579,     0,
    1682,     0,     0,     0,     0,     0,     0,     0,   609,     0,
       0,     0,     0,  1683,  1505,     0,     0,     0,     0,  2129,
       0,     0,     0,     0,     0,     0,     0,  3169,     0,  3171,
    1497,     0,  1685,  2900,     0,     0,     0,  3174,  3175,     0,
       0,  1505,   704,     0,     0,  2547,     0,   704,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3152,  1008,
    1496,     0,     0,     0,  1505,     0,     0,     0,     0,     0,
       0,  1685,     0,     0,     0,    71,     0,  2434,     0,     0,
       0,     0,     0,   593,     0,     0,  1496,     0,     0,     0,
       0,     0,     0,     0,   593,   704,     0,  1008,  1686,  1496,
       0,     0,     0,     0,     0,     0,     0,     0,  2434, -1796,
   -1796,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,     0,
    1708,     0,     0,     0,  3314,   609,   609,     0,     0,     0,
       0,     0,   577,     0,     0,     0,     0,  1686,     0,   593,
    3234,  1496,   593,  1032,   593,   593,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,   719,     0,
       0,     0,     0,     0,  3314,     0,     0,     0,  1496,  2548,
       0,     0,     0,     0,  2781,     0,  1505,  1671,     0,  2549,
    2550,  2551,     0,  2552,  2553,  2554,  2555,  2556,  2557,     0,
    3314,  1672,     0,  1496,     0,     0,   609,     0,   593,  1674,
    3173,     0,     0,     0,  1675,     0,     0,   720,     0,   593,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   721,     0,  1496,     0,     0,     0,     0,
    1496,     0,     0,     0,     0,     0,     0,     0,   577,     0,
       0,   722,     0,  1505,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   577,     0,     0,     0,     0,     0,     0,
     723,   602,     0,     0,   577,   577,   724,     0,     0,     0,
       0,  1671,     0,     0,     0,     0,     0,     0,     0,   725,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1497,     0,  1674,     0,     0,     0,     0,  1675,  1676,
       0,   726,     0,  1677,     0,     0,     0,     0,     0,   593,
       0,     0,     0,   355,     0,     0,   355,  1497,     0,     0,
       0,     0,  1678,  1679,     0,     0,     0,     0,   610,   355,
    1497,     0,     0,     0,     0,  1680,     0,   577,   577,     0,
    1496,     0,     0,     0,     0,     0,    71,    71,     0,    71,
       0,   355,     0,     0,  1364,   727,     0,     0,     0,  1505,
       0,     0,     0,     0,     0,     0,  1681,   610,     0,  1682,
       0,  2586,  1497,     0,     0,     0,     0,     0,   593,     0,
       0,     0,  1683,     0,  1684,   610,     0,     0,     0,     0,
       0,     0,     0,     0,   728,     0,     0,     0,     0,  1497,
     729,     0,     0, -1796,     0,   730,     0,  1677,     0,     0,
    3309,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1708,  2056,     0,     0,  1497,     0,  1678,  1679,     0,     0,
     731,   732,     0,     0,     0,     0,     0,     0,   875, -1796,
    1685,     0,     0,   733,     0,   875,     0,   875,   734,     0,
       0,     0,     0,     0,     0,     0,  1497,   735,   355,     0,
       0,  1497,     0,     0,     0,     0,     0,  1881,     0,   593,
     593,   593,     0,  1682,     0,     0,   593,   593,     0,     0,
       0,   593,   593,     0,     0,     0,  1683,     0,   593,     0,
       0,     0,     0,     0,     0,     0,   577,   593,     0,   593,
    1505,     0,     0,     0,     0,     0,  1686,     0,     0,     0,
       0,     0,   593,     0,   593,     0,  1687,  1688,  1689,     0,
    1690,  1691,  1692,  1693,  1694,  1695,  1505,  1496,  1496,     0,
    2150,  1053,     0,     0,     0,  1671,     0,     0,     0,     0,
       0,     0,     0,     0, -1796,  1575,     0,     0,     0,  1672,
       0,  2213,     0,     0,     0,     0,     0,  1674,     0,  2056,
     355,  1054,  1675,     0,     0,  1671,     0,     0,     0,     0,
       0,     0,     0,  1055,     0,   593,     0,     0,     0,  1672,
    1056,  1497,     0,     0,     0,     0,     0,  1674,     0,     0,
       0,     0,  1675,     0,     0,     0,  1057,   355,     0,     0,
     355,     0,   577,     0,     0,     0,     0,     0,     0,     0,
    1686,     0,     0,   577,  1058,     0,  1496,     0,     0,     0,
       0,  1496,     0,     0,  1690,  1691,  1692,  1693,  1694,  1695,
       0,     0,     0,     0,     0,     0,  1496,     0,     0,     0,
       0,     0,   593,  1059,   602,   602,     0,     0,   593,     0,
       0,     0,     0,     0,  1671,     0,     0,   609,   577,     0,
       0,  1364,  1060,  1364,  1364,  1671,     0,  1676,     0,     0,
       0,  1677,     0,     0,     0,     0,  1674,     0,     0,  1672,
       0,  1675,     0,     0,     0,  1061,     0,  1674,     0,     0,
    1678,  1679,  1675,     0,     0,     0,     0,  1676,     0,     0,
       0,  1677,     0,  1680,     0,     0,     0,  1496,     0,     0,
       0,     0,     0,     0,     0,   602,     0,   577,     0,     0,
    1678,  1679,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    71,  1680,  1681,     0,    71,  1682,  1062,     0,
       0,     0,     0,     0,     0,   593,  1505,     0,     0,     0,
    1683,     0,  1684,   593,  2595,     0,   593,   593,   798,     0,
       0,     0,     0,     0,  1681,     0,     0,  1682,  1497,  1497,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1683,  1063,  1684,  1064,     0,     0, -1796,     0,  1065,     0,
    1677,   610,     0,     0,     0,     0,     0,  1676,   593,     0,
       0,  1677,   593,  1505,     0,     0,   593,     0,  1685,  1678,
    1679,     0,     0,  1066,   593,     0,     0,     0,     0,   593,
    1678,  1679, -1796,     0,     0,     0,  1067,     0,     0,     0,
       0,  1068,     0,  1680,     0,     0,     0,     0,  1685,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1069,
       0,     0,     0,     0,     0,     0,  1682,  1497,     0,     0,
       0,     0,  1497,   593,  1681,     0,     0,  1682,     0,  1683,
       0,     0,     0,     0,  1686,     0,     0,  1497,     0,     0,
    1683,     0,  1684,     0,  1687,  1688,  1689,     0,  1690,  1691,
    1692,  1693,  1694,  1695,     0,     0,   609,  1575,  2732,     0,
    2482,     0,  1579,     0,  1686,     0,     0,   577,     0,     0,
       0,     0,     0,     0,  1687,  1688,  1689,     0,  1690,  1691,
    1692,  1693,  1694,  1695,     0,     0,     0, -1796,  2890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1685,   593,
       0,     0,     0,     0,     0,     0,     0,     0,  1497,     0,
     355,  1671,     0,     0,   355,     0,  1496,  1496,  1006,  1496,
       0,     0,  1006,     0,     0,  1672,     0,     0,     0,     0,
       0,     0,     0,  1674,  1496,     0,  1496,     0,  1675,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1006,     0,  1686,     0,     0,     0,     0,     0,     0,
       0,     0,  1496,     0,  1686,   577,     0,  1690,  1691,  1692,
    1693,  1694,  1695,     0,  1687,  1688,  1689,     0,  1690,  1691,
    1692,  1693,  1694,  1695,  1105,     0,     0,  1006,  2937,   788,
       0,     0,  1496,  1006,     0,     0,     0,     0,     0,     0,
     789,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1496,     0,  1671,     0,     0,     0,     0,     0,     0,   790,
       0,  2056,     0,   593,     0,   593,  1672,     0,     0,     0,
       0,     0,     0,     0,  1674,     0,     0,     0,   791,  1675,
       0,     0,     0,  1676,     0,  1496,     0,  1677,     0,     0,
       0,     0,     0,     0,   792,     0,  1496,     0,     0,     0,
       0,     0,     0,     0,   577,     0,  1678,  1679,     0,     0,
    1496,     0,   793,     0,     0,     0,     0,     0,     0,  1680,
       0,     0,     0,  1266,     0,     0,   610,     0,   875,     0,
       0,   875,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   794,     0,   355,     0,     0,     0,   795,     0,     0,
    1681,     0,     0,  1682,   593,     0,     0,     0,     0,     0,
     796,     0,     0,     0,     0,     0,  1683,     0,  1684,   593,
       0,     0,     0,     0,     0,   593,   593,   577,     0,     0,
       0,     0,     0,     0,  1676,     0,     0,  1364,  1677,    71,
    1496,    71,     0,     0,     0,     0,     0,  1497,  1497,     0,
    1497,     0,     0,     0,     0,     0,     0,  1678,  1679,   593,
     593,     0,     0,  1496,     0,  1497,     0,  1497,   593,     0,
    1680,     0,     0,     0,  1685,     0,   593,     0,     0,     0,
       0,   593,     0,   593,     0,     0,   797,     0,     0,     0,
    1496,     0,     0,  1497,   593,   593,     0,     0,     0,     0,
       0,  1681,     0,     0,  1682,     0,   798,     0,     0,     0,
       0,     0,     0,  1496,     0,     0,     0,  1683,     0,  1684,
       0,  2313,     0,  1497,     0,   799,     0,     0,     0,   800,
       0,   801,     0,     0,   593,   593,   802,  1266,   355,     0,
    1686,  1497,  1006,   609,     0,     0,     0,     0,  1006,     0,
    1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,
       0,   803,   804,     0,  3054,  1510,     0,     0,     0,     0,
       0,     0,     0,     0,   805,  1685,  1497,   577,     0,   806,
       0,   577,     0,     0,     0,   577,     0,  1497,   807,     0,
    1006,     0,     0,  2390,     0,     0,     0,   808,     0,  1510,
       0,  1497,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   593,     0,  1496,  2411,     0,     0,     0,
       0,     0,     0,   593,     0,     0,     0,     0,     0,     0,
       0,  1686,   577,     0,     0,     0,     0,     0,     0,     0,
       0,  1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,
    1695,  1266,     0,     0,     0,  3073,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   593,     0,     0,
       0,  1497,     0,     0,     0,     0,     0,     0,  1266,     0,
       0,     0,  1496,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1497,     0,     0,     0,     0,     0,
       0,     0,  1266,  1266,     0,  1266,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1671,     0,     0,     0,
       0,  1497,     0,  1266,     0,     0,     0,     0,     0,     0,
    1672,     0,     0,     0,     0,     0,     0,     0,  1674,     0,
       0,     0,     0,  1675,  1497,     0,     0,     0,     0,   610,
     610,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1732,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1266,
    1671,     0,  1266,  1266,     0,     0,     0,     0,     0,     0,
     355,   355,   355,     0,   593,   593,     0,     0,  1496,     0,
       0,     0,  1674,     0,     0,     0,     0,  1675,   593,     0,
     610,     0,     0,   593,   593,   593,   593,   593,     0,     0,
       0,   593,     0,     0,  1364,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1676,     0,
       0,   355,  1677,     0,     0,     0,  1497,     0,   355,     0,
    1510,     0,     0,   355,     0,     0,     0,   875,     0,     0,
       0,  1678,  1679,     0,     0,     0,     0,     0,     0,     0,
    1671,   593,     0,     0,  1680,     0,  1867,     0,     0,     0,
    2905,     0,     0,     0,     0,     0,     0,     0,     0,  1510,
       0,   875,  1674,     0,     0,     0,     0,  1675,     0,     0,
       0,     0,     0,     0,     0,  1681,     0,  2482,  1682,     0,
       0,     0, -1796,  1497,  2695,   875,  1677,     0,     0,     0,
    2698,  1683,  2699,  1684,     0,     0,     0,     0,     0,     0,
       0,  1510,     0,     0,     0,  1678,  1679,     0,     0,  1496,
       0,     0,   355,     0,     0,     0,     0,     0, -1796,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1510,     0,
       0,     0,     0,     0,     0,  1496,     0,     0,   577,   577,
    2906,     0,     0,     0,     0,     0,     0,   577,     0,  1685,
       0,     0,  1682,  1510,     0,  1364,     0,     0,     0,     0,
       0,     0,  2390,     0,     0,  1683,     0,  2056,   593,     0,
       0,     0, -1796,  2749,   577,     0,  1677,     0,     0,     0,
       0,   593,     0,  1006,     0,  1510,     0,     0,     0,     0,
    1510,     0,     0,     0,   593,  1678,  1679,     0,     0,   593,
       0,   593,   593,     0,     0,     0,   593,     0, -1796,  1497,
       0,     0,     0,   577,   577,  1686,     0,     0,     0,     0,
    1006,     0,     0, -1796,     0,  1687,  1688,  1689,     0,  1690,
    1691,  1692,  1693,  1694,  1695,     0,     0,     0,     0,  3204,
       0,     0,  1682,     0,     0,     0,     0,     0,     0,     0,
    1266,  1266,     0,     0,     0,  1683,     0,     0,  1266,     0,
       0,  1266,  1266,     0,   593,     0,     0,     0,     0,     0,
    2114,     0,  1671,  1266,  1266,     0,     0,     0,     0,     0,
       0,  1266,     0,     0,     0,  1266,  1266,  1266,  1266,  1686,
       0,     0,     0,     0,  1674,  1266,  1266,     0,     0,  1675,
       0,     0,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,
    1510,  1266,   355, -1796,     0,  1266,     0,     0,     0,  1266,
       0,     0,     0,  1266,     0,     0,  1266,  1266,  1266,  1266,
    1266,  1266,  1266,  1266,  1266,  1499,  1266,   699,     0,     0,
    1266,     0,     0,     0,  1266,     0,     0,     0,     0,     0,
    1497,     0,     0,     0,   593,  1496,   577,     0,     0,   699,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1499,
       0,     0,  2909,  1500,     0,     0,  1497,     0,     0,  1686,
       0,     0,     0,     0,     0,   355,     0,     0,  1671,  1884,
     593,     0,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,
       0,     0,  1672,     0, -1796,     0,     0,  1500,  1677,     0,
    1674,     0,  1496,     0,     0,  1675,     0,     0,     0,   355,
       0,   355,     0,     0,     0,     0,     0,  1678,  1679,     0,
       0,     0,     0,     0,    71,     0,     0,  1885,     0,     0,
   -1796,     0,     0,     0,  1886,  1887,   871,     0,     0,     0,
       0,     0,     0,   871,     0,   871,     0,     0,     0,     0,
       0,     0,     0,     0,   355,     0,   699,     0,     0,     0,
       0,     0,     0,     0,  1682,     0,     0,     0,     0,  1266,
       0,  1888,     0,  1671,   593,     0,     0,  1683,   593,     0,
       0,     0,     0,   577,   577,     0,     0,  1867,  1510,     0,
       0,     0,     0,     0,     0,  1674,     0,     0,     0,     0,
    1675,     0,  2390,  2390,  2390,  2390,  2390,     0,     0,  1889,
    1676,     0,     0,  1890,  1677,     0,     0,     0,     0,   593,
     593,     0,     0,     0,   593,     0,     0,     0,     0,     0,
       0,     0,     0,  1678,  1679, -1796,     0,     0,     0,     0,
    1671,     0,     0,     0,     0,     0,  1680,     0,     0,     0,
    1891,     0,     0,     0,  1672,     0,     0,     0,     0,     0,
     577,     0,  1674,     0,   593,  1892,  1893,  1675,  1894,  1895,
       0,  1896,     0,  3071,     0,  1266,  1510,  1681,     0,     0,
    1682,  1510,     0,     0,     0,     0,  1497,     0,     0,     0,
     593,     0,     0,  1683,  1266,  1684,  1510,     0,  1897,     0,
       0,  1686,     0,     0,     0, -1796,     0,     0,     0,  1677,
       0,     0,     0,     0,     0,  1690,  1691,  1692,  1693,  1694,
    1695,     0,     0,     0,     0,     0,     0,  1898,  1678,  1679,
    1499,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1796,     0,  1497,     0,     0,     0,     0,     0,     0,
       0,  1685,     0,     0,     0,  1006,  1499,     0,     0,  1899,
       0,  1900,     0,     0,  1266,     0,     0,  1510,  1500,  1499,
       0,     0,  1676,     0,     0,  1682,  1677,     0,     0,     0,
       0,     0,     0,  1901,     0,     0,  3084,   577,  1683,     0,
    1902,     0,     0,  1903,  1500,  1678,  1679,     0,     0,     0,
    1266,     0,     0,     0,     0,     0,     0,  1500,  1680,     0,
       0,  1499,     0,     0,     0,     0,     0,  1686,   577,     0,
     577,   577,     0,     0,  1266,   577,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,  1499,  1681,
       0,  3262,  1682,     0,     0,     0, -1796,     0,     0,  1500,
       0,     0,     0,     0,     0,  1683,  1266,  1684,     0,  1266,
       0,     0,     0,  1499,     0,     0,     0,     0,     0,     0,
       0,  1266,  1266,  1266,  1266,     0,  1500,     0,     0,     0,
    1266,     0,     0,   577,     0,     0,     0,     0,     0,     0,
    1266,  1266,     0,  1266,     0,  1499,     0,     0,     0,     0,
    1499,  1500,     0,     0,     0,  1266,     0,  1266,     0,     0,
       0,  1266,  1686,  1685,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1690,  1691,  1692,  1693,
    1694,  1695,     0,  1500,  1006,     0,  1266,  1266,  1500,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1266,     0,     0,     0,     0,     0,     0,     0,  1266,  1266,
    1266,     0,     0,   577,     0,     0,     0,     0,     0,  1686,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1687,
    1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,  1266,
       0,  2712,     0,     0,     0,     0,     0,     0,     0,   577,
       0,     0,     0,     0,     0,     0,  1867,  1510,     0,  1510,
    1499,     0,     0,     0,     0,  1671,     0,     0,     0,     0,
       0,     0,     0,     0,  1510,     0,  1510,     0,     0,  1672,
       0,     0,     0,  2232,     0,     0,     0,  1674,   699,     0,
       0,     0,  1675,     0,     0,     0,  1003,     0,  1500,     0,
    1003,     0,  1510,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1003,
       0,     0,  1510,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   577,  3272,     0,     0,   577,  3276,   355,
    1510,     0,  2233,     0,     0,     0,     0,     0,     0,     0,
    1671,     0,     0,     0,     0,  1003,     0,     0,     0,     0,
       0,  1003,     0,     0,  1672,     0,     0,     0,     0,     0,
       0,     0,  1674,     0,     0,  1510,     0,  1675,     0,     0,
       0,     0,     0,     0,     0,     0,  1510,  1676,     0,     0,
       0,  1677,     0,     0,     0,     0,     0,     0,     0,     0,
    1510,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1678,  1679,     0,     0,  1006,     0,     0,     0,  1006,     0,
       0,     0,  1006,  1680,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1499,  1499,     0,
       0,     0,     0,     0,  1006,     0,     0,     0,     0,     0,
       0,  1261,     0,     0,  1681,     0,   871,  1682,     0,   871,
       0,     0,     0,  2562,     0,     0,     0,     0,  2563,     0,
    1683,  1266,  1684,     0,     0,  1500,  1500,  1266,     0,     0,
    1510,     0,  1676,     0,     0,     0,  1677,     0,     0,  1266,
       0,     0,     0,     0,     0,  1266,     0,     0,     0,  1266,
       0,     0,     0,  1510,  1266,  1678,  1679,  1266,  1266,  1266,
    1266,  1266,  1266,  1266,  1266,  1266,  1266,     0,  1680,     0,
       0,  1266,  1266,     0,     0,     0,  1499,     0,  1685,     0,
    1510,  1499,     0,     0,     0,  1266,     0,     0,     0,     0,
       0,     0,  1266,     0,     0,  1266,  1499,  1266,     0,  1681,
       0,     0,  1682,  1510,  1266,  1266,  1266,     0,     0,     0,
    1266,     0,     0,  1266,  1500,  1683,     0,  1684,     0,  1500,
       0,     0,     0,  2234,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1500,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1686,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1687,  1688,  1689,  1266,  1690,  1691,
    1692,  1693,  1694,  1695,     0,  1261,   699,  1499,     0,     0,
    1003,     0,     0,  1685,     0,     0,  1003,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1508,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1500,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1510,     0,     0,  1003,     0,
       0,     0,     0,     0,     0,     0,     0,  1508, -1793,     0,
       0,     0,     0,     0,     0,   592,     0,     0,     0,  1686,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1687,
    1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1793,
       0,  1266,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1793,  1510,     0,     0,     0, -1793,     0,  1671,  1261,
       0, -1793,     0,     0, -1793,     0, -1793,     0,     0,     0,
       0,     0,  1672,     0,     0,     0,     0,     0,     0,     0,
    1674,   834,     0,     0,     0,  1675,  1261,     0,     0, -1793,
       0,     0,     0,  1006,     0,     0,     0,     0,  1006,     0,
       0,   592,  1006,   834,     0,     0,     0, -1793,     0,     0,
    1261,  1261,     0,  1261,     0,     0,     0,     0,     0,     0,
    1266,     0,  1671,     0,     0,     0,     0,     0,     0,     0,
       0,  1261,  1266,     0,     0,     0,  1672,     0,     0,  1673,
       0,     0,     0,     0,  1674,     0,     0,     0, -1793,  1675,
       0,     0,     0,     0,     0,     0, -1793,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1266,  1266,     0,     0,     0,  1510,     0,
       0,     0,     0,     0,  1266,  1266,  1499,  1499,  1266,  1499,
    1676,     0,     0,     0,  1677,     0,     0,  1261,     0,     0,
    1261,  1261,     0,     0,  1499,     0,  1499,     0,     0,     0,
       0,     0,     0,  1678,  1679,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1500,  1500,  1680,  1500,   849,     0,
       0,     0,  1499,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1500,     0,  1500,     0,     0,     0,     0, -1793,
       0,     0,     0,     0,  1676,     0,     0,  1681,  1677,     0,
    1682,  1266,  1499,     0,     0,     0,     0, -1793,  1508,     0,
    1500,   699,     0,  1683,     0,   871,     0,  1678,  1679,     0,
    1499,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1680,     0,     0,     0,  1865,     0,     0,  1006, -1793,     0,
    1500, -1793, -1793, -1793,     0,     0,     0,  1508,     0,   871,
    1266,     0,     0,     0,  1006,  1499,     0,     0,  1500,  1510,
       0,  1681,     0,     0,  1682,     0,  1499,  1266,     0,     0,
       0,  1685,     0,   871,     0,     0,  1266,  1683,  1266,  1684,
    1499,     0,     0,     0,     0,  1510,  1266,  1266,     0,  1508,
    1266,     0,     0,  1500,     0,     0,     0,  1266,  1266,     0,
     699,     0,     0,     0,  1500,     0,     0,  1266,     0,     0,
       0,     0,     0,     0,     0,     0,  1508,     0,  1500,     0,
       0,     0,     0,     0,     0,  1266,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1685,     0,  1686,     0,  1006,
       0,  1508,     0,     0,     0,     0,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,     0,     0,
    1499,     0,     0,     0,     0,     0,     0,  1266,     0,     0,
       0,  1003,     0,  1508,     0,     0,     0,     0,  1508,     0,
       0,     0,     0,  1499,     0,     0,     0,     0,     0,  1266,
       0,     0,     0,     0,     0,     0,     0,     0,  1500,     0,
       0,  1686,     0,     0,     0,     0,     0,     0,  1003,     0,
    1499,  1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,
    1695,  1500,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1671,     0,  1499,     0,     0,     0,     0,  1261,  1261,
       0,     0,  1006,     0,     0,  1672,  1261,     0,  1500,  1261,
    1261,     0,     0,  1674,     0,  1266,     0,     0,  1675,     0,
       0,  1261,  1261,     0,     0,     0,     0,     0,     0,  1261,
       0,  1500,     0,  1261,  1261,  1261,  1261,     0,     0,     0,
       0,     0,     0,  1261,  1261,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1508,  1261,
     699,     0,     0,  1261,     0,  1510,     0,  1261,     0,     0,
       0,  1261,     0,     0,  1261,  1261,  1261,  1261,  1261,  1261,
    1261,  1261,  1261,     0,  1261,     0,  1006,     0,  1261,     0,
       0,     0,  1261,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1499,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1006,
       0,     0,  1510,  1676,     0,     0, -1795,  1677,     0,  1502,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1500,     0,     0,  1678,  1679,   742,     0,
       0,  1671,     0,     0,     0,     0,     0,     0,     0,  1680,
       0,     0,     0,  1502,     0,  1672,     0, -1795,  2521,     0,
       0,   592,  1499,  1674,     0,     0,     0,     0,  1675, -1795,
       0,     0,     0,     0, -1795,     0,     0,   742,     0, -1795,
    1681,     0, -1795,  1682, -1795,   742,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1683,     0,  1684,     0,
    1500,     0,   699,     0,     0,     0,     0, -1795,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1261,     0,     0,
     742,   742,     0,     0,     0, -1795,     0,     0,     0,   834,
       0,   834,     0,   834,     0,  1865,  1508,     0,     0,   834,
     834,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1685,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1795,   592,     0,     0,
       0,     0,     0,  1676, -1795,     0,     0,  1677,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1499,     0,
       0,     0,   592,     0,     0,     0,  1678,  1679,     0,  2523,
       0,     0,     0,   592,   592,     0,     0,     0,     0,  1680,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1686,     0,     0,  1261,  1508,     0,  1500,     0,     0,  1508,
    1687,  1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,
    1681,     0,  1261,  1682,  1508,     0,   849,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1683,     0,  1684,  1337,
       0,     0,     0,     0,  1503,     0,     0, -1795,     0,     0,
       0,     0,     0,     0,     0,     0,   592,   592,     0,     0,
       0,     0,     0,     0,     0, -1795,     0,     0,     0,     0,
       0,     0,     0,  1337,     0,     0,     0,     0,  1503,     0,
       0,     0,     0,  1003,     0,     0,     0,     0,     0,     0,
       0,     0,  1261,     0,  1685,  1508, -1795,     0,     0, -1795,
   -1795, -1795,     0,     0,  1502,     0,     0,     0,     0,  1499,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1261,     0,
    1502,     0,     0,     0,     0,  1499,     0,     0,     0,     0,
       0,     0,     0,  1502,     0,     0,     0,  1500,     0,     0,
       0,     0,  1261,     0,     0,     0,     0,     0,     0,     0,
    1686,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1687,  1688,  1689,  1500,  1690,  1691,  1692,  1693,  1694,  1695,
       0,     0,     0,     0,  1261,  1502,     0,  1261,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1261,
    1261,  1261,  1261,     0,     0,     0,   752,     0,  1261,     0,
       0,     0,  1502,     0,     0,   592,     0,   753,  1261,  1261,
       0,  1261,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1261,     0,  1261,   754,  1502,     0,  1261,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   755,     0,  -456,     0,     0,     0,     0,
       0,     0,  1003,     0,  1261,  1261,     0,     0,     0,  1502,
       0,   756,     0,     0,  1502,     0,     0,   757,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1261,   758,
       0,     0,     0,     0,     0,     0,  1261,  1261,  1261,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -575,     0,
     759,   592,     0,     0,   760,     0,     0,  1261,     0,     0,
       0,     0,   592,     0,     0,     0,     0,  -561,     0,     0,
       0,     0,     0,     0,  1865,  1508,     0,  1508,     0,  1503,
       0,     0,     0,     0,     0,  1499,     0,     0,     0,  -387,
       0,     0,  1508,     0,  1508,     0,     0,     0,     0,     0,
     761,     0,     0,     0,     0,  1503,     0,   592,     0,     0,
    1337,     0,  1337,  1337,     0,     0,     0,     0,  1503,     0,
    1508,     0,     0,  1500,  1502,     0,     0,     0,     0,   999,
       0,     0,     0,   999,     0,   742,     0,     0,     0,     0,
     742,   742,  1499,   762,     0,   763,     0,     0,     0,     0,
    1508,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1503,   742,   999,  -387,     0,     0,   592,   699,  1508,     0,
       0,     0,     0,     0,     0,     0,     0,   834,  1671,     0,
    1500,     0,   764,     0,     0,     0,  -575,  1503,   765,     0,
       0,     0,  1672,     0,     0,     0,     0,   742,   999,     0,
    1674,     0,     0,  1508,   999,  1675,     0,     0,     0,     0,
       0,     0,  1503,     0,  1508,     0,     0,     0,     0,   766,
     767,     0,   768,     0,     0,     0,     0,     0,  1508,     0,
       0,   769,     0,     0,     0,   770,   771,     0,     0,     0,
     772,     0,  1003,     0,  1503,   773,  1003,     0,     0,  1503,
    1003,     0,     0,     0,   742,     0,     0,     0,     0,     0,
     742,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     742,     0,  1003,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1337,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,  1261,     0,     0,  1508,     0,
    1676,  1502,  1502,   742,  1677,     0,     0,  1261,   742,     0,
       0,     0,     0,  1261,     0,     0,     0,  1261,     0,   742,
       0,  1508,  1261,  1678,  1679,  1261,  1261,  1261,  1261,  1261,
    1261,  1261,  1261,  1261,  1261,     0,  1680,     0,     0,  1261,
    1261,     0,     0,     0,     0,     0,   592,     0,  1508,     0,
       0,     0,     0,  1261,     0,     0,     0,     0,     0,  1503,
    1261,     0,     0,  1261,     0,  1261,     0,  1681,     0,   703,
    1682,  1508,  1261,  1261,  1261,     0,     0,     0,  1261,   705,
       0,  1261,     0,  1683,     0,  1684,     0,     0,     0,     0,
    1502,     0,     0,     0,  2540,  1502,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1502,     0,     0,     0,   739,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   782,  1261,     0,   786,     0,     0,
       0,   782,     0,     0,     0,   830,     0,   834,   834,   834,
       0,  1685,     0,     0,   592,   834,     0,  1671,     0,   834,
     834,     0,   742,   999,     0,     0,   834,   852,     0,   999,
       0,  1672,     0,     0,  2571,   834,     0,   834,     0,  1674,
       0,     0,   782,     0,  1675,     0,     0,     0,     0,     0,
     834,  1502,   834,  1508,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   742,   742,   742,     0,     0,
       0,   999,     0,     0,     0,     0,     0,  1686,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1671,  1261,
       0,     0,     0,   592,     0,   742,  1503,  1503,     0,     0,
    1508,     0,  1672,     0,     0,     0,     0,     0,     0,     0,
    1674,     0,     0,   742,     0,  1675,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1504,     0,  1676,
       0,     0,     0,  1677,     0,     0,     0,     0,     0,     0,
       0,  1003,     0,     0,     0,     0,  1003,     0,     0,     0,
    1003,     0,  1678,  1679,     0,     0,     0,     0,     0,     0,
    1337,  1504,     0,     0,     0,  1680,   592,     0,  1261,     0,
       0,     0,     0,     0,     0,     0,  1337,     0,     0,     0,
    1261,     0,     0,     0,     0,  1503,     0,     0,     0,     0,
    1503,   957,     0,     0,     0,     0,  1681,     0,     0,  1682,
       0,     0,     0,     0,     0,  1503,  2576,     0,     0,     0,
       0,     0,  1683,     0,  1684,     0,     0,     0,     0,     0,
    1676,  1261,  1261,     0,  1677,     0,  1508,     0,     0,     0,
       0,     0,  1261,  1261,     0,     0,  1261,     0,     0,     0,
       0,     0,     0,  1678,  1679,     0,     0,   742,     0,     0,
       0,     0,     0,     0,     0,     0,  1680,     0,     0,     0,
       0,     0,     0,   834,     0,     0,     0,     0,     0,     0,
    1685,  1337,     0,     0,  1337,  1337,  1503,     0,     0,     0,
    1502,  1502,     0,  1502,     0,     0,     0,  1681,     0,     0,
    1682,     0,     0,     0,     0,     0,     0,     0,  1502,     0,
    1502,     0,     0,  1683,     0,  1684,     0,     0,     0,  1261,
       0,     0,     0,     0,     0,     0,   592,     0,     0,     0,
     592,     0,     0,     0,   592,     0,  1502,     0,     0,     0,
       0,     0,   834,     0,     0,     0,  1686,   834,     0,     0,
       0,     0,     0,     0,     0,  1003,  1687,  1688,  1689,     0,
    1690,  1691,  1692,  1693,  1694,  1695,  1502,     0,  1261,     0,
       0,  1685,  1003,     0,     0,     0,     0,  1508,     0,     0,
       0,     0,     0,     0,  1502,  1261,     0,     0,     0,     0,
       0,   592,     0,     0,  1261,     0,  1261,     0,     0,     0,
       0,     0,   742,  1508,  1261,  1261,     0,     0,  1261,     0,
       0,     0,     0,     0,     0,  1261,  1261,     0,     0,  1502,
       0,     0,     0,     0,     0,  1261,     0,     0,     0,     0,
    1502,     0,     0,   965,   966,     0,     0,  1686,     0,     0,
       0,     0,  1504,  1261,  1502,     0,     0,  1687,  1688,  1689,
       0,  1690,  1691,  1692,  1693,  1694,  1695,  1003,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   834,  1504,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1504,     0,     0,     0,  1261,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2034,     0,     0,  1261,     0,     0,
       0,     0,   742,   742,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1504,  1502,     0,     0,     0,     0,     0,
       0,     0,     0,   869,     0,  1503,  1503,     0,  1503,     0,
     869,   999,   869,     0,   742,     0,     0,  1502,     0,     0,
    1504,     0,     0,  1503,     0,  1503,   742,     0,     0,     0,
    1003,     0,     0,  1017,     0,     0,  1034,     0,     0,  1038,
    1039,     0,     0,  1261,  1502,  1504,     0,     0,     0,     0,
       0,  1503,     0,     0,     0,     0,     0,     0,     0,     0,
    1075,   834,     0,  1337,     0,     0,     0,  1502,     0,     0,
       0,     0,     0,  1091,     0,     0,  1092,  1504,     0,     0,
       0,  1503,  1504,     0,     0,     0,     0,   957,   782,     0,
       0,     0,     0,  1508,     0,     0,  1109,     0,     0,  1503,
       0,     0,     0,     0,     0,     0,     0,  1118,     0,     0,
       0,  1119,  1120,     0,  1003,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     742,     0,     0,     0,  1503,  1138,  1139,     0,     0,     0,
       0,     0,   957,     0,     0,  1503,     0,  1003,     0,     0,
    1508,     0,   834,     0,     0,     0,     0,     0,     0,  1503,
       0,     0,  1507,  1154,     0,  1155,     0,  1337,     0,     0,
       0,     0,     0,  1337,  1337,     0,     0,     0,     0,  1502,
       0,     0,   742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   957,     0,     0,  1507,     0,     0,     0,
       0,     0,  1504,     0,     0,     0,     0,   592,   592,     0,
       0,     0,     0,     0,     0,     0,   592,     0,     0,     0,
       0,     0,     0,     0,  1337,     0,     0,     0,     0,   834,
       0,   834,     0,     0,     0,     0,     0,     0,     0,  1503,
       0,     0,  2751,   592,     0,     0,  1502,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1503,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   592,   592,     0,     0,     0,     0,     0,  1503,
       4,     0,     0,     0,     0,  1373,     0,     0,  1375,     0,
       0,  1377,     0,     0,     5,     0,     0,     0,     0,     0,
       0,     0,  1503,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     7,     8,     0,     0,     0,     0,
       9,     0,    10,    11,     0,     0,     0,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1467,   834,  1502,     0,  1468,     0,     0,     0,  1470,     0,
       0,   834,     0,     0,  1511,     0,     0,     0,     0,  1504,
    1504,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    36,     0,     0,     0,     0,     0,     0,     0,  1538,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   742,
       0,     0,     0,     0,  1503,   592,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   742,     0,  1569,     0,     0,     0,     0,   742,
       0,     0,     0,     0,     0,     0,  2034,     0,  1598,     0,
       0,     0,     0,     0,     0,     0,     0,  1507,     0,     0,
       0,     0,     0,    37,     0,     0,     0,     0,  1504,     0,
       0,     0,     0,  1504,     0,     0,     0,     0,     0,     0,
       0,  1503,    38,  1863,     0,     0,     0,     0,  1504,     0,
       0,     0,     0,     0,     0,     0,  1507,     0,     0,     0,
      39,     0,     0,  1502,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1001,     0,     0,     0,  1001,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1502,
       0,    40,     0,     0,    41,     0,     0,     0,  1507,     0,
       0,     0,     0,     0,     0,     0,  1001,     0,     0,     0,
       0,     0,   592,   592,     0,    42,     0,     0,     0,  1504,
       0,     0,     0,     0,     0,  1507,   834,     0,     0,     0,
       0,   834,   834,   834,   834,   834,     0,     0,     0,   834,
       0,     0,  1001,     0,     0,     0,     0,     0,  1001,     0,
    1507,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1503,     0,     0,
       0,     0,     0,    43,     0,     0,     0,     0,     0,   742,
       0,     0,  1507,     0,     0,  2034,     0,  1507,     0,   592,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,  1816,     0,     0,    46,     0,     0,     0,  1258,     0,
       0,     0,     0,   869,     0,    47,   869,     0,    48,    49,
       0,    50,     0,    51,     0,     0,     0,    52,     0,    53,
      54,     0,     0,     0,    55,    56,    57,    58,    59,     0,
       0,    60,    61,    62,    63,     0,    64,    65,    66,     0,
      67,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1507,  1503,  1502,
       0,     0,     0,     0,     0,     0,   592,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   834,
       0,     0,     0,     0,  1503,     0,     0,     0,     0,     0,
       0,     0,   834,     0,     0,     0,     0,   592,     0,   592,
     592,     0,     0,     0,   592,     0,  1671,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1502,     0,  1504,  1504,
    1672,  1504,     0,     0,     0,     0,     0,     0,  1674,  2001,
       0,     0,     0,  1675,     0,     0,  1504,     0,  1504,     0,
       0,     0,   742,     0,     0,     0,     0,     0,   742,     0,
       0,     0,  1258,     0,     0,     0,  2040,  1001,     0,     0,
       0,     0,   592,  1001,  1504,     0,     0,     0,     0,  2049,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,     0,     0,     0,  2034,     0,     0,     0,  2034,
       0,     0,     0,  2034,  1504,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1001,     0,     0,     0,     0,
       0,     0,  1504,     0,  1506,   999,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   742,  1676,     0,
       0,     0,  1677,     0,  1863,  1863,     0,  1504,     0,     0,
       0,     0,   592,     0,     0,     0,     0,     0,  1504,     0,
       0,  1678,  1679,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1504,     0,  1680,     0,  1258,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   592,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1258,  1503,  1681,     0,     0,  1682,     0,
    1671,     0,     0,  2212,     0,     0,     0,     0,     0,     0,
       0,  1683,     0,  1684,  1672,     0,     0,  1258,  1258,     0,
    1258,     0,  1674,  1507,     0,     0,     0,  1675,  1507,     0,
       0,   742,   742,     0,     0,     0,     0,     0,  1258,     0,
       0,     0,  1504,  1507,     0,     0,     0,     0,     0,     0,
       0,  1503,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1504,     0,     0,     0,  1685,
       0,     0,   592,     0,     0,     0,   592,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2853,  1504,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,     0,     0,  1258,  1258,   957,
       0,     0,     0,     0,  1507,  1504,     0,   834,   834,     0,
    2264,     0,     0,     0,     0,     0,     0,     0,  2271,     0,
       0,     0,  1676,     0,  2275,  1686,  1677,     0,     0,  2279,
       0,     0,     0,     0,     0,  1687,  1688,  1689,     0,  1690,
    1691,  1692,  1693,  1694,  1695,  1678,  1679,     0,     0,     0,
       0,     0,     0,     0,     0,   742,     0,     0,  1680,     0,
       0,  2299,  2300,     0,  2302,  1506,     0,     0,     0,     0,
       0,     0,   869,     0,     0,     0,     0,     0,   742,     0,
       0,     0,     0,     0,     0,     0,   742,     0,     0,  1681,
       0,  1862,  1682,  2320,  2321,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1506,  1683,   869,  1684,  2335,     0,
    2339,  2340,     0,  2344,  2345,  2346,  2347,  1504,     0,     0,
    2353,     0,     0,  2356,  2034,     0,     0,     0,     0,  2034,
     869,     0,     0,  2034,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1506,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1685,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1504,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1506,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   742,   742,   742,   742,     0,     0,     0,  1001,  1686,
    1506,     0,     0,     0,     0,  1506,     0,     0,   957,  1687,
    1688,  1689,     0,  1690,  1691,  1692,  1693,  1694,  1695,     0,
       0,     0,     0,  1863,  1863,     0,  1863,     0,     0,     0,
       0,     0,     0,     0,     0,  1001,     0,     0,     0,     0,
       0,  1507,     0,  1507,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1258,  1258,     0,     0,  1507,
       0,     0,     0,  1258,     0,     0,  1258,  1258,     0,     0,
    1504,     0,     0,     0,     0,     0,     0,     0,  1258,  1258,
       0,     0,     0,     0,     0,     0,  1258,     0,   999,  1507,
    1258,  1258,  1258,  1258,     0,     0,     0,     0,     0,     0,
    1258,  1258,     0,     0,     0,  2034,     0,  1863,     0,     0,
       0,     0,     0,     0,     0,  1506,  1258,     0,     0,     0,
    1258,     0,     0,     0,  1258,     0,     0,     0,  1258,     0,
       0,  1258,  1258,  1258,  1258,  1258,  1258,  1258,  1258,  1258,
       0,  1258,  1507,     0,     0,  1258,     0,     0,     0,  1258,
       0,     0,     0,  1507,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1863,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     999,     0,   742,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     742,  1504,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   742,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1504,     0,     0,
       0,  2686,  2687,     0,     0,     0,     0,  1507,     0,     0,
       0,     0,     0,     0,     0,   742,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1507,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,     0,     0,     0,     0,     0,
       0,     0,     0,   999,     0,     0,     0,  1507,     0,     0,
       0,     0,  1862,  1506,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1507,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2755,  2757,
    2759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   999,     0,     0,
       0,     0,     0,  2795,     0,     0,     0,     0,     0,     0,
    1258,  1506,     0,     0,     0,   782,  1506,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1258,
     999,  1506,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1507,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1504,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1001,     0,     0,     0,     0,     0,     0,     0,     0,  1258,
       0,     0,  1506,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,  1507,
       0,     0,     0,     0,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,  1504,  1258,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     7,     8,     0,
       0,     0,     0,     0,     0,    10,    11,     0,     0,  1258,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,  1258,     0,     0,  1258,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1258,  1258,  1258,  1258,
       0,     0,     0,     0,     0,  1258,     0,     0,     0,     0,
       0,     0,     0,     0,    36,  1258,  1258,     0,  1258,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1258,     0,  1258,     0,     0,  1507,  1258,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1001,
       0,  1258,  1258,     0,     0,     0,     0,  2952,  2953,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1258,    37,     0,     0,     0,
       0,     0,     0,  1258,  1258,  1258,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2983,     0,
       0,     0,     0,    39,  1258,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1004,     0,     0,     0,  1004,     0,
       0,  1862,  1506,     0,  1506,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,  1506,
       0,  1506,     0,     0,     0,     0,     0,  1004,     0,     0,
       0,     0,     0,     0,     0,     0,  1507,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1507,  1004,     0,     0,     0,     0,     0,  1004,
       0,     0,     0,     0,     0,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1506,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,  1506,     0,     0,     0,    45,     0,     0,     0,     0,
       0,  3093,  3094,     0,     0,  1506,     0,    46,     0,  1262,
       0,  3100,     0,     0,     0,     0,     0,     0,    47,  1001,
       0,    48,    49,  1001,    50,     0,     0,  1001,     0,     0,
      52,     0,    53,    54,     0,     0,     0,    55,    56,    57,
      58,    59,     0,     0,    60,    61,   972,     0,     0,  1001,
     973,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1258,     0,     0,     0,
    2795,     0,  1258,     0,     0,  1506,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,     0,     0,     0,     0,     0,
    1258,     0,     0,     0,  1258,     0,     0,     0,  1506,  1258,
       0,     0,  1258,  1258,  1258,  1258,  1258,  1258,  1258,  1258,
    1258,  1258,     0,     0,     0,     0,  1258,  1258,     0,     0,
       0,     0,  1507,     0,     0,  1506,     0,     0,     0,     0,
    1258,     0,     0,     0,     0,     0,     0,  1258,     0,     0,
    1258,     0,  1258,     0,     0,     0,     0,     0,  1506,  1258,
    1258,  1258,     0,     0,     0,  1258,     0,     0,  1258,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,  1004,     0,
       0,     0,     0,     0,  1004,     0,     0,     0,     0,  1507,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1509,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1004,     0,     0,     0,
       0,     0,     0,     0,     0,  1509,     0,     0,  1240,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,     0,     0,  3254,     0,     0,     0,     0,  3256,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1262,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1262,     0,  1258,  3294,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1262,  1262,
       0,  1262,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1262,
       0,     0,     0,     0,     0,     0,     0,     0,  1001,     0,
       0,     0,     0,  1001,     0,     0,     0,  1001,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1455,     0,     0,  1258,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1258,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1262,     0,     0,  1262,  1262,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1258,  1258,
       0,     0,     0,  1506,     0,     0,     0,     0,     0,  1258,
    1258,     0,     0,  1258,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1509,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1617,     0,     0,     0,
       0,     0,  1866,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1509,  1258,     0,     0,     0,
       0,     0,     0,  1641,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1660,  1661,     0,
    1663,     0,  1001,     0,     0,     0,     0,  1509,     0,     0,
       0,     0,     0,     0,     0,  1258,     0,     0,  1699,  1001,
       0,     0,     0,     0,  1506,     0,     0,     0,     0,     0,
       0,     0,  1258,     0,  1509,     0,     0,     0,     0,     0,
       0,  1258,     0,  1258,     0,     0,     0,     0,     0,     0,
    1506,  1258,  1258,     0,     0,  1258,     0,     0,     0,  1509,
       0,     0,  1258,  1258,     0,     0,     0,     0,     0,     0,
       0,     0,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1761,     0,     0,  1768,  1770,  1004,
    1258,  1509,     0,     0,     0,     0,  1509,     0,     0,     0,
       0,     0,     0,     0,  1001,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1004,     0,     0,     0,
       0,     0,  1258,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1258,     0,  1262,  1262,     0,     0,
       0,     0,     0,     0,  1262,     0,     0,  1262,  1262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1262,
    1262,     0,     0,     0,     0,     0,     0,  1262,     0,     0,
       0,  1262,  1262,  1262,  1262,     0,     0,     0,     0,     0,
       0,  1262,  1262,     0,     0,     0,     0,  1001,     0,     0,
       0,     0,     0,     0,     0,     0,  1509,  1262,     0,     0,
    1258,  1262,     0,     0,     0,  1262,     0,     0,     0,  1262,
       0,     0,  1262,  1262,  1262,  1262,  1262,  1262,  1262,  1262,
    1262,     0,  1262,     0,     0,     0,  1262,     0,     0,     0,
    1262,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1001,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1001,     0,     0,  1506,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1262,     0,     0,     0,     0,
       0,     0,     0,  2098,     0,     0,     0,  2100,     0,     0,
       0,     0,     0,  1866,  1509,     0,     0,     0,     0,    78,
       0,     0,     0,     0,     0,    82,  2122,     0,     0,     0,
    2125,     0,    88,  2134,    89,     0,     0,    92,     0,     0,
    2141,  2146,     0,     0,     0,     0,     0,     0,   102,     0,
       0,     0,     0,     0,     0,     0,  2157,     0,     0,     0,
    2163,     0,     0,     0,  2174,     0,   115,   116,  2181,     0,
       0,  2183,  2184,  2185,  2186,  2187,  2188,  2189,  2190,  2191,
       0,  2192,     0,     0,     0,  1240,     0,     0,     0,     0,
       0,     0,     0,   124,     0,     0,     0,     0,     0,     0,
       0,  1262,  1509,   125,   126,   127,     0,  1509,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   915,     0,
    1262,     0,  1509,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   136,     0,   137,   138,
       0,     0,     0,   140,   141,     0,     0,     0,     0,     0,
       0,   143,   144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   146,     0,   147,     0,     0,
     150,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,  1004,     0,     0,     0,   152,     0,     0,     0,     0,
    1262,   153,     0,  1509,     0,     0,   154,     0,   156,  1697,
       0,     0,   158,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
       0,     0,     0,     0,  2277,     0,  1262,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1262,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   177,   178,     0,     0,     0,     0,   179,     0,
       0,     0,     0,     0,     0,     0,   180,     0,     0,     0,
       0,     0,  1262,     0,     0,  1262,     0,     0,     0,     0,
       0,     0,     0,   185,     0,     0,     0,  1262,  1262,  1262,
    1262,     0,     0,     0,     0,     0,  1262,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1262,  1262,     0,  1262,
       0,     0,   195,     0,     0,     0,     0,     0,     0,     0,
    2361,  1262,     0,  1262,   197,     0,   198,  1262,     0,     0,
     199,     0,     0,     0,   200,     0,     0,   202,     0,  2382,
       0,   204,     0,     0,     0,     0,   205,     0,     0,     0,
    1004,   206,  1262,  1262,   208,     0,     0,     0,     0,     0,
     211,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1262,     0,     0,     0,
       0,     0,     0,     0,  1262,  1262,  1262,     0,   217,     0,
     218,     0,     0,     0,     0,     0,   220,     0,   221,     0,
       0,   222,     0,     0,  1697,     0,     0,     0,     0,  2470,
       0,     0,     0,     0,     0,  1262,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1866,  1509,     0,  1509,     0,     0,     0,     0,
       0,     0,     0,     0,   227,  2494,     0,     0,     0,     0,
    1509,     0,  1509,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2517,
       0,     0,     0,     0,     0,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,  2146,     0,  2146,  2146,
       0,     0,     0,     0,     0,  2579,  1509,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2598,     0,  2600,     0,     0,     0,  2603,     0,     0,     0,
       0,  1509,     0,     0,     0,     0,  1697,     0,     0,     0,
       0,     0,  1509,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1509,     0,     0,     0,
    1697,     0,     0,     0,     0,     0,  2130,     0,     0,     0,
    1004,     0,     0,     0,  1004,  1761,     0,     0,  1004,  1697,
    1697,     0,  1697,  1770,  1770,  1768,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1004,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2673,     0,     0,     0,  1697,     0,
       0,     0,     0,     0,     0,     0,     0,  1262,     0,     0,
       0,     0,     0,  1262,     0,     0,  1509,     0,     0,     0,
       0,     0,     0,     0,     0,  1262,     0,     0,     0,     0,
       0,  1262,     0,     0,     0,  1262,     0,     0,     0,  1509,
    1262,     0,     0,  1262,  1262,  1262,  1262,  1262,  1262,  1262,
    1262,  1262,  1262,     0,     0,     0,     0,  1262,  1262,     0,
    1697,     0,     0,     0,     0,     0,  1509,  1697,     0,  1697,
       0,  1262,     0,     0,     0,     0,     0,     0,  1262,     0,
       0,  1262,     0,  1262,     0,     0,     0,     0,     0,  1509,
    1262,  1262,  1262,     0,     0,     0,  1262,     0,     0,  1262,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1509,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2850,     0,     0,     0,
       0,     0,  2854,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2859,     0,     0,  1262,     0,     0,
    2860,     0,     0,     0,  2862,     0,     0,     0,  1509,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2879,  2880,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2893,     0,  1004,
    2896,     0,  2898,     0,  1004,     0,     0,     0,  1004,  2902,
       0,     0,     0,     0,     0,  2907,     0,     0,  2910,     0,
       0,     0,     0,     0,     0,     0,  1262,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1262,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1697,  1262,
    1262,     0,     0,     0,  1509,     0,     0,  1697,     0,  1697,
    1262,  1262,     0,     0,  1262,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1697,     0,     0,  1697,     0,  2130,  2558,     0,  2130,
       0,     0,     0,  1697,     0,     0,     0,     0,     0,     0,
    1697,     0,     0,     0,     0,  1697,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1697,     0,     0,     0,
    2130,  2130,  1697,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1697,     0,     0,     0,  1262,     0,     0,
    1697,     0,  1697,  1697,  1697,  1697,  1697,  1697,  1697,  1697,
    1697,  1697,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1004,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1262,     0,     0,     0,
    1004,     0,     0,     0,     0,  1509,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,  1262,     0,  1262,     0,     0,     0,     0,     0,
       0,  1509,  1262,  1262,     0,  2494,  1262,     0,     0,     0,
       0,     0,     0,  1262,  1262,     0,  1697,  3050,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1262,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1004,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3069,
    3070,     0,     0,  3072,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1262,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1697,     0,     0,     0,     0,  1262,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1697,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3124,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1004,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1262,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3158,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1697,
       0,     0,  2494,     0,     0,     0,     0,     0,     0,     0,
       0,  1509,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1697,     0,  3176,     0,     0,     0,     0,
       0,     0,  1004,  3178,     0,     0,     0,     0,     0,     0,
       0,     0,  3182,     0,     0,     0,  1697,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3187,     0,     0,     0,     0,  1004,     0,     0,  1509,     0,
       0,     0,  2558,     0,  2130,     0,     0,  2130,  2130,  2130,
    2130,  2130,  2130,  2130,  2130,  2130,  2130,     0,  2558,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,  3221,     0,     0,     0,     0,     0,  1697,     0,
       0,     0,     0,  2558,  2558,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     6,  2130,  2130,  1697,     0,  1697,
       0,     0,  1697,     0,     0,     7,     8,     0,     0,     0,
       0,     0,     0,    10,    11,     0,     0,     0,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3182,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1697,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    36,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    37,     0,     0,     0,     0,     0,
       0,  2130,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    38,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    39,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    40,     0,     0,    41,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42,     0,     0,  1697,
       0,     0,     0,  1697,     0,     0,     0,     0,  1697,  1697,
       0,  1697,     0,     0,  2558,     0,     0,     0,  2558,  2558,
    2558,  2558,  2558,  2558,  2558,  2558,  2558,  2558,  1697,  1697,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1697,  2130,  2130,  1697,     0,  1697,     0,     0,
       0,  1697,  2558,  2558,    43,     0,  1697,     0,     0,  1697,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1697,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      44,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,    48,
      49,     0,    50,  2558,     0,     0,     0,     0,    52,     0,
      53,    54,     0,     0,     0,    55,    56,    57,    58,    59,
       0,     0,    60,    61,   972,  1357,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1697,
       0,     0,     0,     0,     0,     0,  2130,     0,  2130,     0,
       0,  2558,  2558,     0,     0,     0,  2130,  2130,  1697,  1697,
       0,  1697,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1697,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1697,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2558,  2130,
    2558,     0,     0,  2558,  2558,  1697,     0,  1697,     0,     0,
       0,  1697,     0,     0,     0,     0,  1697,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   611,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
    1697,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,  2558,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,   618,   386,   387,   619,   620,   621,
     622,   623,   624,   625,   388,   389,   626,   390,   129,   391,
     392,   393,   131,   132,   133,   134,     0,   627,   394,   395,
       0,   396,   628,   629,   397,   630,   135,   399,   631,   400,
     401,   402,   403,   139,   632,   633,   404,   405,   406,   407,
     634,   408,   409,   142,   410,   635,   411,   412,   413,   145,
     414,   636,   637,   638,   639,   640,   415,   416,   417,   418,
     419,   148,   149,   420,   641,   421,   642,   422,     0,   423,
     424,   425,   643,   426,   644,   645,   427,   428,   429,   430,
     646,   431,   432,   433,   647,   434,   648,   435,   436,   437,
     155,   438,     0,   157,   649,   439,   440,   159,   650,   441,
     651,   442,   160,   652,   161,   443,     0,   444,   653,   445,
     164,   654,   446,   655,   447,   448,   449,   165,   450,   451,
     452,   656,   453,   454,   455,   456,   457,   657,   166,   167,
     658,   458,   459,   460,   659,   169,   660,   170,   661,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,   662,
     174,   175,   467,   176,   663,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,   182,   183,   664,   482,   483,   484,   485,   486,
     487,   488,   184,   489,   665,   490,   491,   186,   492,   666,
     187,   188,   493,   494,   667,   668,   495,   669,   670,   671,
     496,   497,   672,   673,   189,   190,   191,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,   674,   504,   505,
     506,   507,   508,   509,   196,   510,   675,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,   676,
     530,   531,   532,   677,   533,   207,   534,   535,   209,   536,
     210,   678,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,   679,   546,   547,   680,   548,   549,   550,   551,
     681,   213,   214,   682,   553,   683,   554,   215,   555,   216,
     684,   556,   557,   558,   559,   560,   685,   686,   561,   562,
     563,   564,   687,   688,   565,   566,     0,   567,   223,   568,
     224,   569,     0,   689,   690,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,     0,     0,     0,    79,
      80,    81,     0,    83,    84,     0,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,   691,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110,     0,   111,
     112,   113,   114,     0,     0,     0,     0,     0,   117,   118,
       0,     0,     0,     0,   119,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,   121,     0,   122,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,     0,     0,   131,   132,   133,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     135,     0,     0,     0,     0,     0,     0,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,   165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,   171,   172,     0,   173,     0,     0,
       0,     0,     0,     0,   174,   175,     0,   176,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,   183,     0,     0,
       0,     0,     0,     0,     0,     0,   184,     0,     0,     0,
       0,   186,     0,     0,   187,   188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   189,   190,
     191,   192,     0,     0,     0,     0,   193,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   207,
       0,     0,   209,     0,   210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   213,   214,     0,     0,     0,
       0,   215,     0,   216,     0,     0,     0,     0,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,     0,     0,     0,
       0,     0,     0,    79,    80,    81,   225,    83,    84,   226,
      85,    86,    87,     0,     0,     0,    90,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,     0,
       0,     0,   103,   104,   105,   106,  2245,   107,     0,   108,
     109,   110,     0,   111,   112,   113,   114,     0,     0,     0,
       0,     0,   117,   118,     0,     0,     0,     0,   119,     0,
       0,     0,     0,     0,     0,     0,     0,   120,     0,   121,
       0,   122,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   129,     0,     0,     0,
     131,   132,   133,   134,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   135,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   142,     0,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   148,
     149,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   155,     0,
       0,   157,     0,     0,     0,   159,     0,     0,     0,     0,
     160,     0,   161,     0,     0,     0,     0,     0,   164,     0,
       0,     0,     0,     0,     0,   165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   166,   167,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,   171,   172,
       0,   173,     0,     0,     0,     0,     0,     0,   174,   175,
       0,   176,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,   183,     0,     0,     0,     0,     0,     0,     0,     0,
     184,     0,     0,     0,     0,   186,     0,     0,   187,   188,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,   192,     0,     0,     0,     0,
     193,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   207,     0,     0,   209,     0,   210,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   213,
     214,     0,     0,     0,     0,   215,     0,   216,     0,     0,
       0,     0,     0,     0,   219,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   223,     0,   224,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     225,     0,     0,   226,     0,    78,     0,     0,    79,    80,
      81,    82,    83,    84,     0,    85,    86,    87,    88,     0,
      89,    90,    91,    92,    93,    94,    95,    96,    97,    98,
    2247,    99,   100,   101,   102,     0,     0,   103,   104,   105,
     106,     0,   107,     0,   108,   109,   110,     0,   111,   112,
     113,   114,   115,   116,     0,     0,     0,   117,   118,     0,
       0,     0,     0,   119,     0,     0,     0,     0,     0,     0,
       0,     0,   120,     0,   121,     0,   122,   123,     0,   124,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   125,
     126,   127,     0,     0,     0,     0,     0,     0,     0,     0,
     128,   129,     0,     0,   130,   131,   132,   133,   134,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   135,
       0,     0,   136,     0,   137,   138,   139,     0,     0,   140,
     141,     0,     0,     0,     0,     0,   142,   143,   144,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,   146,     0,   147,   148,   149,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,   153,     0,     0,
       0,     0,   154,   155,   156,     0,   157,     0,   158,     0,
     159,     0,     0,     0,     0,   160,     0,   161,     0,   162,
       0,   163,     0,   164,     0,     0,     0,     0,     0,     0,
     165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   166,   167,     0,     0,   168,     0,     0,   169,     0,
     170,     0,     0,   171,   172,     0,   173,     0,     0,     0,
       0,     0,     0,   174,   175,     0,   176,     0,   177,   178,
       0,     0,     0,     0,   179,     0,     0,     0,     0,     0,
       0,     0,   180,     0,   181,   182,   183,     0,     0,     0,
       0,     0,     0,     0,     0,   184,     0,     0,     0,   185,
     186,     0,     0,   187,   188,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   189,   190,   191,
     192,     0,     0,     0,     0,   193,   194,     0,   195,     0,
       0,     0,     0,     0,     0,     0,     0,   196,     0,     0,
     197,     0,   198,     0,     0,     0,   199,     0,     0,     0,
     200,   201,     0,   202,   203,     0,     0,   204,     0,     0,
       0,     0,   205,     0,     0,     0,     0,   206,   207,     0,
     208,   209,     0,   210,     0,     0,   211,     0,     0,     0,
       0,     0,     0,   212,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   213,   214,     0,     0,     0,     0,
     215,     0,   216,     0,   217,     0,   218,     0,     0,   219,
       0,     0,   220,     0,   221,     0,     0,   222,     0,     0,
       0,   223,     0,   224,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   225,     0,     0,   226,     0,
       0,     0,     0,     0,   611,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
     227,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,     0,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,  2207,   386,   387,     0,     0,     0,
       0,  1168,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1169,   133,  1170,  1171,     0,   394,   395,
       0,   396,  1172,  1173,   397,  1174,  1175,   399,     0,   400,
     401,   402,   403,  1176,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1177,   410,     0,   411,   412,   413,   145,
     414,  1178,  1179,  1180,  1181,  1182,   415,   416,   417,   418,
     419,  1183,  1184,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,  2208,     0,   427,  1185,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1186,   438,     0,  1187,  1188,   439,   440,  1189,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1190,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1191,  1192,     0,  1193,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1194,   175,   467,   176,     0,   468,   469,   470,  1195,  1196,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1197,   182,  1198,   740,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1199,   490,   491,   186,   492,  1200,
    1201,  1202,   493,   494,     0,     0,   495,   741,     0,     0,
    1203,   497,     0,     0,   189,   190,   191,  1204,   498,   499,
     500,     0,  1205,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1206,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1207,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1208,   533,   207,   534,   535,   209,   536,
    1209,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1210,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1211,  1212,     0,   553,     0,   554,  1213,   555,  1214,
    1215,   556,   557,   558,   559,   560,     0,  1216,   561,   562,
     563,   564,  1217,     0,   565,   566,     0,   567,  1218,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1219,   226,   576,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
    2209,     0,     0,     0,     0,     0,     0,  1226,  2210,   611,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   612,    99,   100,   101,   368,   613,     0,   103,
     104,   105,   106,   614,   615,     0,   108,   109,   110,     0,
     111,   616,   617,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,  1168,     0,     0,   388,
     389,     0,   390,   129,   391,   392,   393,   131,  1169,   133,
    1170,  1171,     0,   394,   395,     0,   396,  1172,  1173,   397,
    1174,  1175,   399,     0,   400,   401,   402,   403,  1176,     0,
       0,   404,   405,   406,   407,     0,   408,   409,  1177,   410,
       0,   411,   412,   413,   145,   414,  1178,  1179,  1180,  1181,
    1182,   415,   416,   417,   418,   419,  1183,  1184,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,  1185,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,  1186,   438,     0,  1187,  1188,
     439,   440,  1189,     0,   441,     0,   442,   160,     0,   161,
     443,     0,   444,     0,   445,  1190,     0,   446,     0,   447,
     448,   449,   165,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,   166,   167,     0,   458,   459,   460,  1191,
    1192,     0,  1193,     0,     0,   171,   172,   461,   173,   462,
     463,   464,   465,   466,     0,  1194,   175,   467,   176,     0,
     468,   469,   470,  1195,  1196,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,  1197,   182,  1198,   740,
     482,   483,   484,   485,   486,   487,   488,   184,   489,  1199,
     490,   491,   186,   492,  1200,  1201,  1202,   493,   494,     0,
       0,   495,   741,     0,     0,  1203,   497,     0,     0,   189,
     190,   191,  1204,   498,   499,   500,     0,  1205,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,  1206,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   201,   522,   523,  1207,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,  1208,   533,
     207,   534,   535,   209,   536,  1209,     0,   537,   538,   539,
     540,   541,   542,   543,   544,  1210,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,  1211,  1212,     0,   553,
       0,   554,  1213,   555,  1214,  1215,   556,   557,   558,   559,
     560,     0,  1216,   561,   562,   563,   564,  1217,     0,   565,
     566,     0,   567,  1218,   568,   224,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,    49,  1219,
     226,   576,     0,     0,  1220,  1221,    52,  1222,    53,     0,
       0,     0,     0,  1223,  1224,     0,     0,     0,     0,     0,
       0,     0,  1226,  2132,   611,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,     0,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1476,   133,  1477,  1171,     0,   394,   395,
       0,   396,     0,     0,   397,  1478,  1479,   399,     0,   400,
     401,   402,   403,     0,     0,     0,   404,   405,   406,   407,
       0,   408,   409,     0,   410,     0,   411,   412,   413,   145,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,  1480,  1481,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1185,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
       0,   438,     0,     0,     0,   439,   440,  1482,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
       0,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,  1852,   453,   454,   455,   456,   457,     0,   166,  1853,
       0,   458,   459,   460,  1191,  1483,     0,  1484,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
       0,   175,   467,   176,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1485,   182,  1486,     0,   482,   483,   484,   485,   486,
     487,   488,     0,   489,     0,   490,   491,   186,   492,     0,
       0,  1487,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,  1854,   190,   191,     0,   498,   499,
     500,     0,     0,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1488,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,     0,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,  1489,   534,   535,   209,   536,
    1490,     0,   537,   538,   539,   540,   541,   542,   543,   544,
       0,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1491,  1492,     0,   553,     0,   554,     0,   555,     0,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,  1493,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,  1855,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,  3224,   565,   566,     0,   567,   223,
     568,     0,   569,     4,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     6,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1239,     7,     8,     0,
   -1239,     0,     0,     0,     0,    10,    11,     0,     0,     0,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    37,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    38,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    39,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    40,     0,     0,    41,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,    48,    49,     0,    50,     0,     0,     0,     0,     0,
      52,     0,    53,    54,     0,     0,     0,    55,    56,    57,
      58,    59,     0,     0,    60,    61,   972,  1809,   611,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   612,    99,   100,   101,   368,   613,     0,   103,   104,
     105,   106,   614,   615,     0,   108,   109,   110,     0,   111,
     616,   617,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,  1168,     0,     0,   388,   389,
       0,   390,   129,   391,   392,   393,   131,  1169,   133,  1170,
    1171,  2142,   394,   395,     0,   396,  1172,  1173,   397,  1174,
    1175,   399,     0,   400,   401,   402,   403,  1176,     0,     0,
     404,   405,   406,   407,     0,   408,   409,  1177,   410,     0,
     411,   412,   413,   145,   414,  1178,  1179,  1180,  1181,  1182,
     415,   416,   417,   418,   419,  1183,  1184,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,  1185,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,  1186,   438,     0,  1187,  1188,   439,
     440,  1189,     0,   441,     0,   442,   160,  2143,   161,   443,
       0,   444,     0,   445,  1190,     0,   446,     0,   447,   448,
     449,   165,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,   166,   167,     0,   458,   459,   460,  1191,  1192,
       0,  1193,     0,     0,   171,   172,   461,   173,   462,   463,
     464,   465,   466,  2144,  1194,   175,   467,   176,     0,   468,
     469,   470,  1195,  1196,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,  1197,   182,  1198,   740,   482,
     483,   484,   485,   486,   487,   488,   184,   489,  1199,   490,
     491,   186,   492,  1200,  1201,  1202,   493,   494,     0,     0,
     495,   741,     0,     0,  1203,   497,     0,     0,   189,   190,
     191,  1204,   498,   499,   500,     0,  1205,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,  1206,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   201,   522,   523,  1207,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,  1208,   533,   207,
     534,   535,   209,   536,  1209,     0,   537,   538,   539,   540,
     541,   542,   543,   544,  1210,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,  1211,  1212,     0,   553,  2145,
     554,  1213,   555,  1214,  1215,   556,   557,   558,   559,   560,
       0,  1216,   561,   562,   563,   564,  1217,     0,   565,   566,
       0,   567,  1218,   568,   224,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,  1219,   226,
     576,     0,     0,  1220,  1221,    52,  1222,    53,     0,     0,
       0,     0,  1223,  1224,   611,    79,    80,    81,   365,    83,
      84,  1226,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,     0,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1168,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1169,   133,  1170,  1171,     0,   394,   395,
       0,   396,  1172,  1173,   397,  1174,  1175,   399,     0,   400,
     401,   402,   403,  1176,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1177,   410,     0,   411,   412,   413,   145,
     414,  1178,  1179,  1180,  1181,  1182,   415,   416,   417,   418,
     419,  1183,  1184,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1185,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1186,   438,     0,  1187,  1188,   439,   440,  1189,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1190,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1191,  1192,     0,  1193,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1194,   175,   467,   176,     0,   468,   469,   470,  1195,  1196,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1197,   182,  1198,   740,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1199,   490,   491,   186,   492,  1200,
    1201,  1202,   493,   494,     0,     0,   495,   741,     0,     0,
    1203,   497,     0,     0,   189,   190,   191,  1204,   498,   499,
     500,     0,  1205,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1206,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1207,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1208,   533,   207,   534,   535,   209,   536,
    1209,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1210,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1211,  1212,     0,   553,     0,   554,  1213,   555,  1214,
    1215,   556,   557,   558,   559,   560,     0,  1216,   561,   562,
     563,   564,  1217,     0,   565,   566,     0,   567,  1218,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1219,   226,   576,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
    1225,     0,     0,     0,     0,     0,     0,  1226,   611,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   612,    99,   100,   101,   368,   613,     0,   103,   104,
     105,   106,   614,   615,     0,   108,   109,   110,     0,   111,
     616,   617,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,  1168,     0,     0,   388,   389,
       0,   390,   129,   391,   392,   393,   131,  1169,   133,  1170,
    1171,     0,   394,   395,     0,   396,  1172,  1173,   397,  1174,
    1175,   399,     0,   400,   401,   402,   403,  1176,     0,     0,
     404,   405,   406,   407,     0,   408,   409,  1177,   410,     0,
     411,   412,   413,   145,   414,  1178,  1179,  1180,  1181,  1182,
     415,   416,   417,   418,   419,  1183,  1184,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,  1185,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,  1186,   438,     0,  1187,  1188,   439,
     440,  1189,     0,   441,     0,   442,   160,     0,   161,   443,
       0,   444,     0,   445,  1190,     0,   446,     0,   447,   448,
     449,   165,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,   166,   167,     0,   458,   459,   460,  1191,  1192,
       0,  1193,     0,     0,   171,   172,   461,   173,   462,   463,
     464,   465,   466,     0,  1194,   175,   467,   176,     0,   468,
     469,   470,  1195,  1196,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,  1197,   182,  1198,   740,   482,
     483,   484,   485,   486,   487,   488,   184,   489,  1199,   490,
     491,   186,   492,  1200,  1201,  1202,   493,   494,     0,     0,
     495,   741,     0,     0,  1203,   497,     0,     0,   189,   190,
     191,  1204,   498,   499,   500,     0,  1205,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,  1206,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   201,   522,   523,  1207,   524,   525,   526,   527,
     528,   529,     0,   205,   530,   531,   532,  1208,   533,   207,
     534,   535,   209,   536,  1209,     0,   537,   538,   539,   540,
     541,   542,   543,   544,  1210,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,  1211,  1212,     0,   553,     0,
     554,  1213,   555,  1214,  1215,   556,   557,   558,   559,   560,
       0,  1216,   561,   562,   563,   564,  1217,     0,   565,   566,
       0,   567,  1218,   568,   224,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,  1219,   226,
     576,     0,     0,  1220,  1221,    52,  1222,    53,     0,     0,
       0,     0,  1223,  1224,   611,    79,    80,    81,   365,    83,
      84,  1226,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,     0,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,  1766,   386,   387,     0,     0,     0,
       0,  1168,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1169,   133,  1170,  1171,     0,   394,   395,
       0,   396,  1172,  1173,   397,  1174,  1175,   399,     0,   400,
     401,   402,   403,  1176,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1177,   410,     0,   411,   412,   413,   145,
     414,  1178,  1179,  1180,  1181,  1182,   415,   416,   417,   418,
     419,  1183,  1184,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1185,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1186,   438,     0,  1187,  1188,   439,   440,  1189,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1190,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1191,  1192,     0,  1193,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1194,   175,   467,   176,     0,   468,   469,   470,  1195,  1196,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1197,   182,  1198,   740,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1199,   490,   491,   186,   492,  1200,
    1201,  1202,   493,   494,     0,     0,   495,   741,     0,     0,
    1203,   497,     0,     0,   189,   190,   191,  1204,   498,   499,
     500,     0,  1205,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1206,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1207,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1208,   533,   207,   534,   535,   209,   536,
    1209,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1210,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1211,  1212,     0,   553,     0,   554,  1213,   555,  1214,
    1215,   556,   557,   558,   559,   560,     0,  1216,   561,   562,
     563,   564,  1217,     0,   565,   566,     0,   567,  1218,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1219,   226,   576,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
     611,    79,    80,    81,   365,    83,    84,  1226,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   368,   613,     0,
     103,   104,   105,   106,   614,   615,     0,   108,   109,   110,
       0,   111,   616,   617,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,  1168,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,   131,  1169,
     133,  1170,  1171,     0,   394,   395,     0,   396,  1172,  1173,
     397,  1174,  1175,   399,     0,   400,   401,   402,   403,  1176,
       0,     0,   404,   405,   406,   407,     0,   408,   409,  1177,
     410,     0,   411,   412,   413,   145,   414,  1178,  1179,  1180,
    1181,  1182,   415,   416,   417,   418,   419,  1183,  1184,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1185,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,  1186,   438,     0,  1187,
    1188,   439,   440,  1189,     0,   441,     0,   442,   160,     0,
     161,   443,     0,   444,     0,   445,  1190,     0,   446,     0,
     447,   448,   449,   165,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,   166,   167,     0,   458,   459,   460,
    1191,  1192,     0,  1193,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,     0,  1194,   175,   467,   176,
       0,   468,   469,   470,  1195,  1196,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1197,   182,  1198,
     740,   482,   483,   484,   485,   486,   487,   488,   184,   489,
    1199,   490,   491,   186,   492,  1200,  1201,  1202,   493,   494,
       0,     0,   495,   741,     0,     0,  1203,   497,     0,     0,
     189,   190,   191,  1204,   498,   499,   500,     0,  1205,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1206,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,  1207,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,  1208,
     533,   207,   534,   535,   209,   536,  1209,     0,   537,   538,
     539,   540,   541,   542,   543,   544,  1210,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1211,  1212,     0,
     553,     0,   554,  1213,   555,  1214,  1215,   556,   557,   558,
     559,   560,     0,  1216,   561,   562,   563,   564,  1217,     0,
     565,   566,     0,   567,  1218,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
    1219,   226,   576,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,  1223,  1224,     0,     0,     0,     0,
       0,  1612,     0,  1226,   611,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,     0,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1168,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,   131,  1169,   133,  1170,  1171,     0,   394,   395,
       0,   396,  1172,  1173,   397,  1174,  1175,   399,     0,   400,
     401,   402,   403,  1176,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1177,   410,     0,   411,   412,   413,   145,
     414,  1178,  1179,  1180,  1181,  1182,   415,   416,   417,   418,
     419,  1183,  1184,   420,  2493,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1185,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
    1186,   438,     0,  1187,  1188,   439,   440,  1189,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1190,     0,   446,     0,   447,   448,   449,   165,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1191,  1192,     0,  1193,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1194,   175,   467,   176,     0,   468,   469,   470,  1195,  1196,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1197,   182,  1198,   740,   482,   483,   484,   485,   486,
     487,   488,   184,   489,  1199,   490,   491,   186,   492,  1200,
    1201,  1202,   493,   494,     0,     0,   495,   741,     0,     0,
    1203,   497,     0,     0,   189,   190,   191,  1204,   498,   499,
     500,     0,  1205,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1206,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1207,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1208,   533,   207,   534,   535,   209,   536,
    1209,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1210,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1211,  1212,     0,   553,     0,   554,  1213,   555,  1214,
    1215,   556,   557,   558,   559,   560,     0,  1216,   561,   562,
     563,   564,  1217,     0,   565,   566,     0,   567,  1218,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1219,   226,   576,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
     611,    79,    80,    81,   365,    83,    84,  1226,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   368,   613,     0,
     103,   104,   105,   106,   614,   615,     0,   108,   109,   110,
       0,   111,   616,   617,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,  1168,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,   131,  1169,
     133,  1170,  1171,     0,   394,   395,     0,   396,  1172,  1173,
     397,  1174,  1175,   399,     0,   400,   401,   402,   403,  1176,
       0,     0,   404,   405,   406,   407,     0,   408,   409,  1177,
     410,     0,   411,   412,   413,   145,   414,  1178,  1179,  1180,
    1181,  1182,   415,   416,   417,   418,   419,  1183,  1184,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1185,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,  1186,   438,     0,  1187,
    1188,   439,   440,  1189,     0,   441,     0,   442,   160,  2143,
     161,   443,     0,   444,     0,   445,  1190,     0,   446,     0,
     447,   448,   449,   165,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,   166,   167,     0,   458,   459,   460,
    1191,  1192,     0,  1193,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,     0,  1194,   175,   467,   176,
       0,   468,   469,   470,  1195,  1196,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1197,   182,  1198,
     740,   482,   483,   484,   485,   486,   487,   488,   184,   489,
    1199,   490,   491,   186,   492,  1200,  1201,  1202,   493,   494,
       0,     0,   495,   741,     0,     0,  1203,   497,     0,     0,
     189,   190,   191,  1204,   498,   499,   500,     0,  1205,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1206,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,  1207,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,  1208,
     533,   207,   534,   535,   209,   536,  1209,     0,   537,   538,
     539,   540,   541,   542,   543,   544,  1210,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1211,  1212,     0,
     553,     0,   554,  1213,   555,  1214,  1215,   556,   557,   558,
     559,   560,     0,  1216,   561,   562,   563,   564,  1217,     0,
     565,   566,     0,   567,  1218,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
    1219,   226,   576,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,  1223,  1224,   611,    79,    80,    81,
     365,    83,    84,  1226,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,   612,
      99,   100,   101,   368,   613,     0,   103,   104,   105,   106,
     614,   615,     0,   108,   109,   110,     0,   111,   616,   617,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,  1168,     0,     0,   388,   389,     0,   390,
     129,   391,   392,   393,   131,  1169,   133,  1170,  1171,     0,
     394,   395,     0,   396,  1172,  1173,   397,  1174,  1175,   399,
       0,   400,   401,   402,   403,  1176,     0,     0,   404,   405,
     406,   407,     0,   408,   409,  1177,   410,     0,   411,   412,
     413,   145,   414,  1178,  1179,  1180,  1181,  1182,   415,   416,
     417,   418,   419,  1183,  1184,   420,  2927,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,  1185,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,  1186,   438,     0,  1187,  1188,   439,   440,  1189,
       0,   441,     0,   442,   160,     0,   161,   443,     0,   444,
       0,   445,  1190,     0,   446,     0,   447,   448,   449,   165,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
     166,   167,     0,   458,   459,   460,  1191,  1192,     0,  1193,
       0,     0,   171,   172,   461,   173,   462,   463,   464,   465,
     466,     0,  1194,   175,   467,   176,     0,   468,   469,   470,
    1195,  1196,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,  1197,   182,  1198,   740,   482,   483,   484,
     485,   486,   487,   488,   184,   489,  1199,   490,   491,   186,
     492,  1200,  1201,  1202,   493,   494,     0,     0,   495,   741,
       0,     0,  1203,   497,     0,     0,   189,   190,   191,  1204,
     498,   499,   500,     0,  1205,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,  1206,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
     201,   522,   523,  1207,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,  1208,   533,   207,   534,   535,
     209,   536,  1209,     0,   537,   538,   539,   540,   541,   542,
     543,   544,  1210,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,  1211,  1212,     0,   553,     0,   554,  1213,
     555,  1214,  1215,   556,   557,   558,   559,   560,     0,  1216,
     561,   562,   563,   564,  1217,     0,   565,   566,     0,   567,
    1218,   568,   224,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,  1219,   226,   576,     0,
       0,  1220,  1221,    52,  1222,    53,     0,     0,     0,     0,
    1223,  1224,   611,    79,    80,    81,   365,    83,    84,  1226,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,   612,    99,   100,   101,   368,
     613,     0,   103,   104,   105,   106,   614,   615,     0,   108,
     109,   110,     0,   111,   616,   617,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,  1168,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,  1169,   133,  1170,  1171,     0,   394,   395,     0,   396,
    1172,  1173,   397,  1174,  1175,   399,     0,   400,   401,   402,
     403,  1176,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1177,   410,     0,   411,   412,   413,   145,   414,  1178,
    1179,  1180,  1181,  1182,   415,   416,   417,   418,   419,  1183,
    1184,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,  1185,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,  1186,   438,
       0,  1187,  1188,   439,   440,  1189,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1190,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,  1191,  1192,     0,  1193,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1194,   175,
     467,   176,     0,   468,   469,   470,  1195,  1196,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,  1197,
     182,  1198,   740,   482,   483,   484,   485,   486,   487,   488,
     184,   489,  1199,   490,   491,   186,   492,  1200,  1201,  1202,
     493,   494,     0,     0,   495,   741,     0,     0,  1203,   497,
       0,     0,   189,   190,   191,  1204,   498,   499,   500,     0,
    1205,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,  1206,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,  1207,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1208,   533,   207,   534,   535,   209,   536,  1209,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1210,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,  1211,
    1212,     0,   553,     0,   554,  1213,   555,  1214,  1215,   556,
     557,   558,   559,   560,     0,  1216,   561,   562,   563,   564,
    1217,     0,   565,   566,     0,   567,  1218,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,  1219,   226,   576,     0,     0,  1220,  1221,    52,
    1222,    53,     0,     0,     0,     0,  1223,  1224,   611,    79,
      80,    81,   365,    83,    84,  1226,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,   612,    99,   100,   101,   368,   613,     0,   103,   104,
     105,   106,   614,   615,     0,   108,   109,   110,     0,   111,
     616,   617,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,  1168,     0,     0,   388,   389,
       0,   390,   129,   391,   392,   393,   131,  1169,   133,  1170,
    1171,     0,   394,   395,     0,   396,  1172,  1173,   397,  1174,
    1175,   399,     0,   400,   401,   402,   403,  1176,     0,     0,
     404,   405,   406,   407,     0,   408,   409,  1177,   410,     0,
     411,   412,   413,   145,   414,  1178,  1179,  1180,  1181,  1182,
     415,   416,   417,   418,   419,  1183,  1184,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,  1185,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,  1186,   438,     0,  1187,  1188,   439,
     440,  1189,     0,   441,     0,   442,   160,     0,   161,   443,
       0,   444,     0,   445,  1190,     0,   446,     0,   447,   448,
     449,   165,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,   166,   167,     0,   458,   459,   460,  1191,  1192,
       0,  1193,     0,     0,   171,   172,   461,   173,   462,   463,
     464,   465,   466,     0,  1194,   175,   467,   176,     0,   468,
     469,   470,  1195,  1196,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,  1197,   182,  1198,   740,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,   186,   492,  1200,  1201,  1202,   493,   494,     0,     0,
     495,   741,     0,     0,  1203,   497,     0,     0,   189,   190,
     191,  1204,   498,   499,   500,     0,  1205,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,  1206,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,   201,   522,   523,  1207,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,  1208,   533,   207,
     534,   535,   209,   536,  1209,     0,   537,   538,   539,   540,
     541,   542,   543,   544,  1210,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,  1211,  1212,     0,   553,     0,
     554,  1213,   555,  1214,  1215,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,  1217,     0,   565,   566,
       0,   567,  1218,   568,   224,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,  1219,   226,
     576,     0,     0,  1220,  1221,    52,  1222,    53,     0,     0,
       0,     0,     0,  2127,   611,    79,    80,    81,   365,    83,
      84,  1226,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,   612,    99,   100,
     101,   368,   613,     0,   103,   104,   105,   106,   614,   615,
       0,   108,   109,   110,     0,   111,   616,   617,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,  1168,     0,     0,   388,   389,     0,   390,   129,   391,
     392,   393,     0,  1169,   133,  1170,  1171,     0,   394,   395,
       0,   396,  1172,  1173,   397,  1174,  1175,   399,     0,   400,
     401,   402,   403,  1176,     0,     0,   404,   405,   406,   407,
       0,   408,   409,  1177,   410,     0,   411,   412,   413,   145,
     414,  1178,  1179,  1180,  1181,  1182,   415,   416,   417,   418,
     419,  1183,  1184,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,  1185,   429,   430,
       0,   431,   432,   433,     0,     0,     0,   435,   436,   437,
    1186,   438,     0,  1187,  1188,   439,   440,  1189,     0,   441,
       0,   442,   160,     0,   161,   443,     0,   444,     0,   445,
    1190,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,   166,   167,
       0,   458,   459,   460,  1191,  1192,     0,  1193,     0,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,     0,
    1194,   175,   467,     0,     0,   468,   469,   470,  1195,  1196,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,  1197,   182,  1198,   740,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,   186,   492,  1200,
    1201,  1202,   493,   494,     0,     0,   495,   741,     0,     0,
    1203,   497,     0,     0,   189,   190,   191,  1204,   498,   499,
     500,     0,  1205,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,  1206,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,  1207,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,  1208,   533,   207,   534,   535,     0,   536,
    1209,     0,   537,   538,   539,   540,   541,   542,   543,   544,
    1210,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,  1211,  1212,     0,   553,     0,   554,  1213,   555,  1214,
    1215,   556,   557,   558,   559,   560,     0,  1216,   561,   562,
     563,   564,  1217,     0,   565,   566,     0,   567,  1218,   568,
     224,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,  1219,   226,   576,     0,     0,  1220,
    1221,    52,  1222,    53,     0,     0,     0,     0,  1223,  1224,
     611,    79,    80,    81,   365,    83,    84,  1226,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,   612,    99,   100,   101,   368,   613,     0,
     103,   104,   105,   106,   614,   615,     0,   108,   109,   110,
       0,   111,   616,   617,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,  1168,     0,     0,
     388,   389,     0,   390,   129,   391,   392,   393,     0,  1169,
     133,  1170,  1171,     0,   394,   395,     0,   396,  1172,  1173,
     397,  1174,  1175,   399,     0,   400,   401,   402,   403,  1176,
       0,     0,   404,   405,   406,   407,     0,   408,   409,  1177,
     410,     0,   411,   412,   413,   145,   414,  1178,  1179,  1180,
    1181,  1182,   415,   416,   417,   418,   419,  1183,  1184,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,  1185,   429,   430,     0,   431,   432,   433,
       0,     0,     0,   435,   436,   437,  1186,   438,     0,  1187,
    1188,   439,   440,  1189,     0,   441,     0,   442,   160,     0,
     161,   443,     0,   444,     0,   445,  1190,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,   166,   167,     0,   458,   459,   460,
    1191,  1192,     0,  1193,     0,     0,   171,   172,   461,   173,
     462,   463,   464,   465,   466,     0,  1194,   175,   467,     0,
       0,   468,   469,   470,  1195,  1196,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,  1197,   182,  1198,
     740,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,   186,   492,  1200,  1201,  1202,   493,   494,
       0,     0,   495,   741,     0,     0,     0,   497,     0,     0,
     189,   190,   191,  1204,   498,   499,   500,     0,  1205,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
    1206,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,   201,   522,   523,  1207,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,  1208,
     533,   207,   534,   535,     0,   536,  1209,     0,   537,   538,
     539,   540,   541,   542,   543,   544,  1210,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,  1211,  1212,     0,
     553,     0,   554,  1213,   555,  1214,  1215,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,  1217,     0,
     565,   566,     0,   567,  1218,   568,   224,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
       0,   226,   576,     0,     0,  1220,  1221,    52,  1222,    53,
       0,     0,     0,     0,     0,  2127,     0,    79,    80,    81,
     365,    83,    84,  1226,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,  2452,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,  -829,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
    -829,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,  -829,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,  -829,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,  -829,   495,     0,
       0,     0,   496,   497,     0,  -829,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,  -829,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     4,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     5,   226,     0,     0,
       0,     0,     0,     0,     0,     6,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     7,     8,     0,     0,
    1303,     0,     0,     0,    10,    11,     0,     0,     0,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    36,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    37,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    38,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    39,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    40,     0,     0,    41,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    43,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    46,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
      48,    49,     0,    50,     0,     0,     0,     0,     0,    52,
       0,    53,    54,     0,     0,     0,    55,    56,    57,    58,
      59,     0,     0,    60,    61,   972,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,   129,
     391,   392,   393,   131,   132,   133,   134,     0,     0,   394,
     395,     0,   396,     0,  1173,   397,   398,   135,   399,     0,
     400,   401,   402,   403,  1176,     0,     0,   404,   405,   406,
     407,     0,   408,   409,  1177,   410,     0,   411,   412,   413,
     145,   414,  1178,  1179,  1180,  1181,  1182,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,  1187,     0,   439,   440,   159,     0,
     441,     0,   442,   160,     0,   161,   443,     0,   444,     0,
     445,  1190,     0,   446,     0,   447,   448,   449,   165,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,   166,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,   171,   172,   461,   173,   462,   463,   464,   465,   466,
       0,  1194,   175,   467,   176,     0,   468,   469,   470,  1195,
    1196,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,   182,   183,   740,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,   186,   492,
       0,  1201,   188,   493,   494,     0,     0,   495,   741,     0,
     908,   496,   497,     0,     0,   189,   190,   191,  1204,   498,
     499,   500,     0,  1205,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   201,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
     205,   530,   531,   532,  1208,   533,   207,   534,   535,   209,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,  1210,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,  1213,   555,
    1214,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,  1217,     0,   565,   566,     0,   567,   223,
     568,   224,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,     0,     0,     0,
       0,     0,     0,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,  2026,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,   129,   391,   392,   393,
     131,   132,   133,   134,     0,     0,   394,   395,     0,   396,
       0,  1173,   397,   398,   135,   399,     0,   400,   401,   402,
     403,  1176,     0,     0,   404,   405,   406,   407,     0,   408,
     409,  1177,   410,     0,   411,   412,   413,   145,   414,  1178,
    1179,  1180,  1181,  1182,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,  1187,     0,   439,   440,   159,     0,   441,     0,   442,
     160,     0,   161,   443,     0,   444,     0,   445,  1190,     0,
     446,     0,   447,   448,   449,   165,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,   166,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,   171,   172,
     461,   173,   462,   463,   464,   465,   466,     0,  1194,   175,
     467,   176,     0,   468,   469,   470,  1195,  1196,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
     182,   183,   740,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,   186,   492,     0,  1201,   188,
     493,   494,     0,     0,   495,   741,     0,   908,   496,   497,
       0,     0,   189,   190,   191,  1204,   498,   499,   500,     0,
    1205,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,   201,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,  1208,   533,   207,   534,   535,   209,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,  1210,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,  1213,   555,  1214,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
    1217,     0,   565,   566,     0,   567,   223,   568,   224,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,     0,     0,     0,     0,     0,     0,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,  2026,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,   129,   391,   392,   393,   131,   132,   133,
     134,     0,     0,   394,   395,     0,   396,     0,  1173,   397,
     398,   135,   399,     0,   400,   401,   402,   403,  1176,     0,
       0,   404,   405,   406,   407,     0,   408,   409,  1177,   410,
       0,   411,   412,   413,   145,   414,  1178,  1179,  1180,  1181,
    1182,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,  1187,     0,
     439,   440,   159,     0,   441,     0,   442,   160,     0,   161,
     443,     0,   444,     0,   445,  1190,     0,   446,     0,   447,
     448,   449,   165,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,   166,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,   171,   172,   461,   173,   462,
     463,   464,   465,   466,     0,  1194,   175,   467,   176,     0,
     468,   469,   470,  1195,  1196,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,   182,   183,   740,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,   186,   492,     0,  1201,   188,   493,   494,     0,
       0,   495,   741,     0,     0,   496,   497,     0,     0,   189,
     190,   191,  1204,   498,   499,   500,     0,  1205,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   201,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,  1208,   533,
     207,   534,   535,   209,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,  1210,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,  1213,   555,  1214,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,  1217,     0,   565,
     566,     0,   567,   223,   568,   224,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,     0,     0,     0,     0,     0,     0,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,  3148,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,     0,   226,   576,     0,
       0,     0,     0,    52,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2387,  2388,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,    49,     0,
     226,   576,     0,     0,     0,     0,    52,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,  2388,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,   740,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,   741,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,     0,     0,
       0,     0,     0,     0,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,  1297,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,   205,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,   576,     0,     0,     0,     0,
       0,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,   227,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,   205,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,     0,     0,     0,     0,     0,     0,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,   227,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,     0,
       0,     0,     0,     0,     0,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
    1748,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,     0,     0,     0,     0,
       0,   611,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,  2824,    93,    94,
      95,    96,    97,    98,   612,    99,   100,   101,   368,   613,
       0,   103,   104,   105,   106,   614,   615,     0,   108,   109,
     110,     0,   111,   616,   617,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
    1476,     0,  1477,  1171,     0,   394,   395,     0,   396,     0,
       0,   397,  1478,  1479,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1480,  1481,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1185,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1482,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,     0,     0,   458,   459,
     460,  1191,  1483,     0,  1484,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,     0,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1485,     0,
    1486,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,     0,   492,     0,     0,  1487,   493,
     494,     0,     0,   495,     0,     0,     0,  2726,   497,     0,
       0,     0,     0,     0,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1488,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1489,   534,   535,     0,   536,  1490,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1491,  1492,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1493,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,  1019,   226,   576,     0,     0,     0,     0,    52,     0,
      53,  1020,  1021,  1022,     0,  1023,  2727,  1025,  1026,  1027,
    1028,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,  1018,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
    1019,   226,     0,     0,     0,     0,     0,     0,     0,     0,
    1020,  1021,  1022,     0,  1023,  1024,  1025,  1026,  1027,  1028,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,  1019,
     226,     0,     0,     0,     0,     0,     0,     0,     0,  1020,
    1021,  1022,     0,  1023,  1024,  1025,  1026,  1027,  1028,   611,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   612,    99,   100,   101,   368,   613,     0,   103,
     104,   105,   106,   614,   615,     0,   108,   109,   110,     0,
     111,   616,   617,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,   618,
     386,   387,   619,   620,   621,   622,   623,   624,   625,   388,
     389,   626,   390,   129,   391,   392,   393,   131,   132,   133,
     134,     0,   627,   394,   395,     0,   396,   628,   629,   397,
     630,   135,   399,   631,   400,   401,   402,   403,   139,   632,
     633,   404,   405,   406,   407,   634,   408,   409,   142,   410,
     635,   411,   412,   413,   145,   414,   636,   637,   638,   639,
     640,   415,   416,   417,   418,   419,   148,   149,   420,   641,
     421,   642,   422,     0,   423,   424,   425,   643,   426,   644,
     645,   427,   428,   429,   430,   646,   431,   432,   433,   647,
     434,   648,   435,   436,   437,   155,   438,     0,   157,   649,
     439,   440,   159,   650,   441,   651,   442,   160,   652,   161,
     443,     0,   444,   653,   445,   164,   654,   446,   655,   447,
     448,   449,   165,   450,   451,   452,   656,   453,   454,   455,
     456,   457,   657,   166,   167,   658,   458,   459,   460,   659,
     169,   660,   170,   661,     0,   171,   172,   461,   173,   462,
     463,   464,   465,   466,   662,   174,   175,   467,   176,   663,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,   182,   183,   664,
     482,   483,   484,   485,   486,   487,   488,   184,   489,   665,
     490,   491,   186,   492,   666,   187,   188,   493,   494,   667,
     668,   495,   669,   670,   671,   496,   497,   672,   673,   189,
     190,   191,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,   674,   504,   505,   506,   507,   508,   509,   196,
     510,   675,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   201,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,   676,   530,   531,   532,   677,   533,
     207,   534,   535,   209,   536,   210,   678,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,   679,   546,   547,
     680,   548,   549,   550,   551,   681,   213,   214,   682,   553,
     683,   554,   215,   555,   216,   684,   556,   557,   558,   559,
     560,   685,   686,   561,   562,   563,   564,   687,   688,   565,
     566,     0,   567,   223,   568,   224,   569,     0,   689,   690,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,   611,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,  1456,    91,     0,    93,    94,
      95,    96,    97,    98,   612,    99,   100,   101,   368,   613,
       0,   103,   104,   105,   106,   614,   615,     0,   108,   109,
     110,     0,   111,   616,   617,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
    1476,     0,  1477,  1171,     0,   394,   395,     0,   396,     0,
       0,   397,  1478,  1479,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1480,  1481,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1185,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1482,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,     0,     0,   458,   459,
     460,  1191,  1483,     0,  1484,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,     0,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1485,     0,
    1486,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,     0,   492,     0,     0,  1487,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,     0,     0,     0,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1488,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1489,   534,   535,     0,   536,  1490,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1491,  1492,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1493,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,     0,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,  1819,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,   740,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,   741,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,     0,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,   906,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,  1733,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,  1734,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,  1735,     0,   495,     0,  1736,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,  1737,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,    49,     0,   226,   576,     0,     0,
       0,     0,    52,     0,    53,     0,     0,     0,     0,     0,
    1332,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
    1734,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
    1735,     0,   495,     0,  1736,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,  1737,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
       0,   226,   576,     0,     0,     0,     0,    52,     0,    53,
       0,     0,     0,     0,     0,  1332,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   816,   380,
     381,   382,   383,   384,   385,   817,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     818,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   819,   159,     0,
     441,     0,   820,     0,   821,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,   822,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   823,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   824,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   825,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   826,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   576,     0,     0,
       0,     0,    52,     0,    79,    80,    81,   365,    83,    84,
     827,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   816,   380,   381,   382,
     383,   384,   385,   817,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   818,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   819,   159,     0,   441,     0,
     820,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   823,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   824,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   825,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   826,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,   576,     0,     0,     0,     0,
      52,     0,    79,    80,    81,   365,    83,    84,   827,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,   600,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
    1270,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
      49,     0,   226,   576,     0,    79,    80,    81,   365,    83,
      84,  1271,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,     0,   226,   576,     0,     0,  1220,
    1221,    52,     0,    53,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,     0,   885,  1351,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,   886,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   864,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   887,     0,   888,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     889,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   890,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   891,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   892,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   893,   214,     0,   553,     0,   894,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,     0,    83,    84,     0,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110, -1352,   111,
     112,   113,   114,     0,     0,     0,     0,     0,   117,   118,
       0,     0,     0,     0,   119,     0,     0,     0,     0,     0,
       0,     0,     0,   120,     0,   121,     0,   122,   123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,     0,     0,   131,   132,   133,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     135,     0,     0,     0,     0,     0,     0,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,   165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,   171,   172,     0,   173,     0,     0,
       0,     0,     0,     0,   174,   175,     0,   176,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,   183,     0,     0,
       0,     0,     0,     0,     0,     0,   184,     0,     0,     0,
       0,   186,     0,     0,   187,   188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   189,   190,
     191,   192,     0,     0,     0,     0,   193,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   207,
       0,     0,   209,     0,   210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   213,   214,     0,     0,     0,
       0,   215,     0,   216,     0,     0,     0,     0,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   223,     0,   224,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   225,     0,     0,   226,
       0,   356,    79,    80,    81,     0,    83,    84,     0,    85,
      86,    87,     0,     0,     0,    90,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,     0,     0,
       0,   103,   104,   105,   106,     0,   107,     0,   108,   109,
     110, -1353,   111,   112,   113,   114,     0,     0,     0,     0,
       0,   117,   118,     0,     0,     0,     0,   119,     0,     0,
       0,     0,     0,     0,     0,     0,   120,     0,   121,     0,
     122,   123,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,     0,     0,   131,
     132,   133,   134,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   135,     0,     0,     0,     0,     0,     0,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     142,     0,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   148,   149,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,     0,     0,
     157,     0,     0,     0,   159,     0,     0,     0,     0,   160,
       0,   161,     0,     0,     0,     0,     0,   164,     0,     0,
       0,     0,     0,     0,   165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   166,   167,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,   171,   172,     0,
     173,     0,     0,     0,     0,     0,     0,   174,   175,     0,
     176,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   181,   182,
     183,     0,     0,     0,     0,     0,     0,     0,     0,   184,
       0,     0,     0,     0,   186,     0,     0,   187,   188,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   189,   190,   191,   192,     0,     0,     0,     0,   193,
     194,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   201,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   207,     0,     0,   209,     0,   210,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   212,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   213,   214,
       0,     0,     0,     0,   215,     0,   216,     0,     0,     0,
       0,     0,     0,   219,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   223,     0,   224,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   225,
       0,     0,   226,     0,   951,   611,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   612,    99,
     100,   101,   368,   613,     0,   103,   104,   105,   106,   614,
     615,     0,   108,   109,   110,     0,   111,   616,   617,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,   618,   386,   387,   619,   620,
     621,   622,   623,   624,   625,   388,   389,   626,   390,   129,
     391,   392,   393,   131,   132,   133,   134,     0,   627,   394,
     395,     0,   396,   628,   629,   397,   630,   135,   399,   631,
     400,   401,   402,   403,   139,   632,   633,   404,   405,   406,
     407,   634,   408,   409,   142,   410,   635,   411,   412,   413,
     145,   414,   636,   637,   638,   639,   640,   415,   416,   417,
     418,   419,   148,   149,   420,   641,   421,   642,   422,     0,
     423,   424,   425,   643,   426,   644,   645,   427,   428,   429,
     430,   646,   431,   432,   433,   647,   434,   648,   435,   436,
     437,   155,   438,     0,   157,   649,   439,   440,   159,   650,
     441,   651,   442,   160,   652,   161,   443,     0,   444,   653,
     445,   164,   654,   446,   655,   447,   448,   449,   165,   450,
     451,   452,   656,   453,   454,   455,   456,   457,   657,   166,
     167,   658,   458,   459,   460,   659,   169,   660,   170,   661,
       0,   171,   172,   461,   173,   462,   463,   464,   465,   466,
     662,   174,   175,   467,   176,   663,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,   182,   183,   664,   482,   483,   484,   485,
     486,   487,   488,   184,   489,   665,   490,   491,   186,   492,
     666,   187,   188,   493,   494,   667,   668,   495,   669,   670,
     671,   496,   497,   672,   673,   189,   190,   191,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,   674,   504,
     505,   506,   507,   508,   509,   196,   510,   675,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   201,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
     676,   530,   531,   532,   677,   533,   207,   534,   535,   209,
     536,   210,   678,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,   679,   546,   547,   680,   548,   549,   550,
     551,   681,   213,   214,   682,   553,   683,   554,   215,   555,
     216,   684,   556,   557,   558,   559,   560,   685,   686,   561,
     562,   563,   564,   687,   688,   565,   566,     0,   567,   223,
     568,   224,   569,     0,   689,   690,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   611,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     612,    99,   100,   101,   368,   613,     0,   103,   104,   105,
     106,   614,   615,     0,   108,   109,   110,     0,   111,   616,
     617,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,   129,   391,   392,   393,   131,  1476,   133,  1477,  1171,
       0,   394,   395,     0,   396,     0,     0,   397,  1478,  1479,
     399,     0,   400,   401,   402,   403,     0,     0,     0,   404,
     405,   406,   407,     0,   408,   409,     0,   410,     0,   411,
     412,   413,   145,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,  1480,  1481,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
    1185,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,     0,   438,     0,     0,     0,   439,   440,
    1482,     0,   441,     0,   442,   160,     0,   161,   443,     0,
     444,     0,   445,     0,     0,   446,     0,   447,   448,   449,
     165,   450,   451,   452,  1852,   453,   454,   455,   456,   457,
       0,   166,  1853,     0,   458,   459,   460,  1191,  1483,     0,
    1484,     0,     0,   171,   172,   461,   173,   462,   463,   464,
     465,   466,     0,     0,   175,   467,   176,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,  1485,   182,  1486,     0,   482,   483,
     484,   485,   486,   487,   488,     0,   489,     0,   490,   491,
     186,   492,     0,     0,  1487,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,  1854,   190,   191,
       0,   498,   499,   500,     0,     0,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,  1488,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,   201,   522,   523,     0,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,  1489,   534,
     535,   209,   536,  1490,     0,   537,   538,   539,   540,   541,
     542,   543,   544,     0,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,  1491,  1492,     0,   553,     0,   554,
       0,   555,     0,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,  1493,   568,   224,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,   611,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   612,    99,   100,   101,   368,   613,     0,   103,
     104,   105,   106,   614,   615,     0,   108,   109,   110,     0,
     111,   616,   617,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,   129,   391,   392,   393,   131,  1476,   133,
    1477,  1171,     0,   394,   395,     0,   396,     0,     0,   397,
    1478,  1479,   399,     0,   400,   401,   402,   403,     0,     0,
       0,   404,   405,   406,   407,     0,   408,   409,     0,   410,
       0,   411,   412,   413,   145,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,  1480,  1481,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,  1185,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,     0,   438,     0,     0,     0,
     439,   440,  1482,     0,   441,     0,   442,   160,     0,   161,
     443,     0,   444,     0,   445,     0,     0,   446,     0,   447,
     448,   449,   165,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,   166,     0,     0,   458,   459,   460,  1191,
    1483,     0,  1484,     0,     0,   171,   172,   461,   173,   462,
     463,   464,   465,   466,     0,     0,   175,   467,   176,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,  1485,   182,  1486,     0,
     482,   483,   484,   485,   486,   487,   488,     0,   489,     0,
     490,   491,   186,   492,     0,     0,  1487,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,     0,
     190,   191,     0,   498,   499,   500,     0,     0,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,  1488,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,   201,   522,   523,     0,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
    1489,   534,   535,   209,   536,  1490,     0,   537,   538,   539,
     540,   541,   542,   543,   544,     0,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,  1491,  1492,     0,   553,
       0,   554,     0,   555,     0,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,  1493,   568,   224,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,   598,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
     599,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
     600,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
       0,   226,   576,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,  1363,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,  2197,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,  2198,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,   740,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,   741,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,  2199,   548,  2200,   550,  2201,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,   576,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,   552,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,    49,     0,   226,   576,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,   960,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,    49,     0,   226,   576,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,   600,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,    49,     0,   226,
     576,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
    1724,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,    49,
       0,   226,   576,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,    49,     0,   226,   576,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,   780,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   781,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,   576,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     812,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,   576,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     854,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
     576,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,   576,   611,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   612,    99,   100,   101,
     368,   613,     0,   103,   104,   105,   106,   614,   615,     0,
     108,   109,   110,     0,   111,   616,   617,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,  1476,     0,  1477,  1171,     0,   394,   395,     0,
     396,     0,     0,   397,  1478,  1479,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1480,  1481,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1185,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1482,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
    1852,   453,   454,   455,   456,   457,     0,     0,  1853,     0,
     458,   459,   460,  1191,  1483,     0,  1484,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,     0,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1485,     0,  1486,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,     0,   492,     0,     0,
    1487,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,  1854,     0,     0,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1488,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,  1489,   534,   535,     0,   536,  1490,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1491,  1492,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1493,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,   611,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,   612,    99,
     100,   101,   368,   613,     0,   103,   104,   105,   106,   614,
     615,     0,   108,   109,   110,     0,   111,   616,   617,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,  1476,     0,  1477,  1171,     0,   394,
     395,     0,   396,     0,     0,   397,  1478,  1479,   399,     0,
     400,   401,   402,   403,     0,     0,     0,   404,   405,   406,
     407,     0,   408,   409,     0,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,  1480,  1481,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,  1185,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,     0,   438,     0,     0,     0,   439,   440,  1482,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,     0,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
       0,     0,   458,   459,   460,  1191,  1483,     0,  1484,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,     0,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,  1485,     0,  1486,     0,   482,   483,   484,   485,
     486,   487,   488,  1879,   489,     0,   490,   491,     0,   492,
       0,     0,  1487,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,     0,     0,     0,     0,   498,
     499,   500,     0,     0,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,  1488,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,     0,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,  1489,   534,   535,     0,
     536,  1490,     0,   537,   538,   539,   540,   541,   542,   543,
     544,     0,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,  1491,  1492,     0,   553,     0,   554,     0,   555,
       0,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,  1493,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,   611,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
     612,    99,   100,   101,   368,   613,     0,   103,   104,   105,
     106,   614,   615,     0,   108,   109,   110,     0,   111,   616,
     617,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,  1476,     0,  1477,  1171,
       0,   394,   395,     0,   396,     0,     0,   397,  1478,  1479,
     399,     0,   400,   401,   402,   403,     0,     0,     0,   404,
     405,   406,   407,     0,   408,   409,     0,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,  1480,  1481,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
    1185,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,     0,   438,     0,     0,     0,   439,   440,
    1482,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,     0,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,     0,     0,   458,   459,   460,  1191,  1483,     0,
    1484,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,     0,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,  1485,     0,  1486,     0,   482,   483,
     484,   485,   486,   487,   488,  2692,   489,     0,   490,   491,
       0,   492,     0,     0,  1487,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,     0,     0,     0,
       0,   498,   499,   500,     0,     0,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,  1488,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,     0,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,  1489,   534,
     535,     0,   536,  1490,     0,   537,   538,   539,   540,   541,
     542,   543,   544,     0,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,  1491,  1492,     0,   553,     0,   554,
       0,   555,     0,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,  1493,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,   611,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,   612,    99,   100,   101,   368,   613,     0,   103,
     104,   105,   106,   614,   615,     0,   108,   109,   110,     0,
     111,   616,   617,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,  1476,     0,
    1477,  1171,     0,   394,   395,     0,   396,     0,     0,   397,
    1478,  1479,   399,     0,   400,   401,   402,   403,     0,     0,
       0,   404,   405,   406,   407,     0,   408,   409,     0,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,  1480,  1481,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,  1185,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,     0,   438,     0,     0,     0,
     439,   440,  1482,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,     0,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,     0,     0,   458,   459,   460,  1191,
    1483,     0,  1484,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,     0,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,  1485,     0,  1486,     0,
     482,   483,   484,   485,   486,   487,   488,     0,   489,     0,
     490,   491,     0,   492,  1846,     0,  1487,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,     0,
       0,     0,     0,   498,   499,   500,     0,     0,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,  1488,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,     0,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
    1489,   534,   535,     0,   536,  1490,     0,   537,   538,   539,
     540,   541,   542,   543,   544,     0,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,  1491,  1492,     0,   553,
       0,   554,     0,   555,     0,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,  1493,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,   611,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,   612,    99,   100,   101,   368,   613,
       0,   103,   104,   105,   106,   614,   615,     0,   108,   109,
     110,     0,   111,   616,   617,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
    1476,     0,  1477,  1171,     0,   394,   395,     0,   396,     0,
       0,   397,  1478,  1479,   399,     0,   400,   401,   402,   403,
       0,     0,     0,   404,   405,   406,   407,     0,   408,   409,
       0,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,  1480,  1481,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,  1185,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,     0,   438,     0,
       0,     0,   439,   440,  1482,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,     0,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,     0,     0,   458,   459,
     460,  1191,  1483,     0,  1484,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,     0,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,  1485,     0,
    1486,     0,   482,   483,   484,   485,   486,   487,   488,     0,
     489,     0,   490,   491,     0,   492,     0,     0,  1487,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,     0,     0,     0,     0,   498,   499,   500,     0,     0,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,  1488,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,     0,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,  1489,   534,   535,     0,   536,  1490,     0,   537,
     538,   539,   540,   541,   542,   543,   544,     0,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,  1491,  1492,
       0,   553,     0,   554,     0,   555,     0,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,  1493,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,   611,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,   612,    99,   100,   101,
     368,   613,     0,   103,   104,   105,   106,   614,   615,     0,
     108,   109,   110,     0,   111,   616,   617,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,  1476,     0,  1477,  1171,     0,   394,   395,     0,
     396,     0,     0,   397,  1478,  1479,   399,     0,   400,   401,
     402,   403,     0,     0,     0,   404,   405,   406,   407,     0,
     408,   409,     0,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
    1480,  1481,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,  1185,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,     0,
     438,     0,     0,     0,   439,   440,  1482,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,     0,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,     0,     0,
     458,   459,   460,  1191,  1483,     0,  1484,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,     0,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
    1485,     0,  1486,     0,   482,   483,   484,   485,   486,   487,
     488,     0,   489,     0,   490,   491,     0,   492,     0,     0,
    1487,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,     0,     0,     0,     0,   498,   499,   500,
       0,     0,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,  1488,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
       0,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,     0,   534,   535,     0,   536,  1490,
       0,   537,   538,   539,   540,   541,   542,   543,   544,     0,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
    1491,  1492,     0,   553,     0,   554,     0,   555,     0,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,  1493,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   378,   379,   380,   381,
     382,   383,   384,   385,   618,   386,   387,   619,   620,   621,
     622,   623,   624,   625,   388,   389,   626,   390,   129,   391,
     392,   393,   131,   132,   133,   134,     0,   627,   394,   395,
       0,   396,   628,   629,   397,     0,   135,   399,   631,   400,
     401,   402,   403,   139,   632,   633,   404,   405,   406,   407,
     634,   408,   409,   142,   410,   635,   411,   412,   413,   145,
     414,   636,   637,   638,   639,   640,   415,   416,   417,     0,
     419,   148,   149,   420,   641,   421,   642,   422,     0,   423,
     424,   425,   643,   426,   644,   645,   427,   428,   429,   430,
     646,   431,   432,   433,   647,   434,   648,   435,   436,   437,
     155,   438,     0,   157,   649,   439,   440,   159,   650,   441,
     651,   442,   160,   652,   161,   443,     0,   444,   653,   445,
     164,   654,   446,   655,   447,   448,     0,   165,   450,   451,
     452,   656,   453,   454,   455,   456,   457,   657,   166,   167,
       0,   458,   459,   460,     0,   169,   660,   170,   661,     0,
     171,   172,   461,   173,   462,   463,   464,   465,   466,   662,
     174,   175,   467,   176,   663,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,     0,   477,   478,     0,   480,
     481,   181,   182,   183,   664,   482,   483,   484,   485,   486,
     487,   488,   184,   489,   665,   490,   491,   186,   492,   666,
     187,   188,   493,   494,   667,   668,   495,   669,   670,   671,
     496,   497,   672,   673,   189,   190,   191,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,   674,   504,   505,
     506,   507,   508,   509,   196,   510,   675,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,   201,   522,
     523,   203,   524,   525,   526,   527,   528,     0,     0,   676,
     530,   531,   532,   677,   533,   207,   534,   535,   209,   536,
     210,   678,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,   679,   546,   547,   680,   548,   549,   550,   551,
     681,   213,   214,     0,   553,   683,   554,   215,   555,   216,
     684,   556,   557,   558,   559,   560,     0,   686,   561,   562,
     563,   564,   687,   688,   565,   566,     0,   567,   223,   568,
     224,   569,     0,   689,   690,   570,   571,   572,   573,     0,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,   129,
     391,   392,   393,   131,   132,   133,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
     145,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,   160,     0,   161,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,   165,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,   166,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,   171,   172,   461,   173,   462,   463,   464,   465,   466,
       0,   174,   175,   467,   176,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,   182,   183,   740,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,   186,   492,
       0,   187,   188,   493,   494,     0,     0,   495,   741,     0,
       0,   496,   497,     0,     0,   189,   190,   191,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,   201,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,   209,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,   224,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
    1830,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,  1831,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,  1832,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,  2418,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,  1833,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,  1834,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,   836,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,   837,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,   876,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,   838,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,   839,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,   836,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,   837,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
     838,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,   839,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,   126,   127,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,   740,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,   741,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
     740,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,   741,     0,   908,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,  1580,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,  1581,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,  1582,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,   740,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,   741,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,  1583,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,  1584,  1585,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,   837,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,   838,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,   839,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,   740,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,   741,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,   821,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,   822,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,     0,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,  2337,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,  2338,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,  2342,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   539,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,  2343,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,  1273,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   526,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,     0,   386,
     387,     0,     0,     0,     0,     0,  2452,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   398,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,   407,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   532,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   213,   214,     0,   553,     0,
     554,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,     0,
     386,   387,     0,     0,     0,     0,     0,  2466,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     398,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,   407,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   532,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   213,   214,     0,   553,
       0,   554,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,     0,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   398,   135,   399,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,   407,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,  2487,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   522,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,   532,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   213,   214,     0,
     553,     0,   554,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,    79,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,  2754,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,  2756,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,   526,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   398,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,   407,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,  2758,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   481,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   522,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,   532,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     213,   214,     0,   553,     0,   554,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,   365,    83,
      84,     0,    85,    86,    87,   366,     0,   367,     0,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,   368,     0,     0,   103,   104,   105,   106,     0,     0,
       0,   108,   109,   110,     0,   111,     0,     0,   114,   369,
     370,     0,     0,     0,   371,   372,     0,     0,     0,     0,
     373,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,   375,     0,   376,   377,     0,   378,   379,   380,   381,
     382,   383,   384,   385,     0,   386,   387,     0,     0,     0,
       0,     0,     0,     0,   388,   389,     0,   390,     0,   391,
     392,   393,     0,   132,     0,   134,     0,     0,   394,   395,
       0,   396,     0,     0,   397,   398,   135,   399,     0,   400,
     401,   402,   403,   139,     0,     0,   404,   405,   406,   407,
       0,   408,   409,   142,   410,     0,   411,   412,   413,     0,
     414,     0,     0,     0,     0,     0,   415,   416,   417,   418,
     419,   148,   149,   420,     0,   421,     0,   422,     0,   423,
     424,   425,     0,   426,     0,     0,   427,   428,   429,   430,
       0,   431,   432,   433,     0,   434,     0,   435,   436,   437,
     155,   438,     0,   157,     0,   439,   440,   159,     0,   441,
       0,   442,     0,     0,     0,   443,     0,   444,     0,   445,
     164,     0,   446,     0,   447,   448,   449,     0,   450,   451,
     452,     0,   453,   454,   455,   456,   457,     0,     0,   167,
       0,   458,   459,   460,     0,   169,     0,   170,     0,     0,
       0,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     174,     0,   467,     0,     0,   468,   469,   470,     0,     0,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   181,     0,   183,     0,   482,   483,   484,   485,   486,
     487,   488,   184,   489,     0,   490,   491,     0,   492,     0,
     187,   188,   493,   494,     0,     0,   495,     0,     0,     0,
     496,   497,     0,     0,   189,     0,     0,   192,   498,   499,
     500,     0,   193,   194,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,   196,   510,     0,   511,   512,   513,
     514,   515,   516,   517,   518,   519,   520,   521,     0,   522,
     523,   203,   524,   525,   526,   527,   528,   529,     0,     0,
     530,   531,   532,     0,   533,   207,   534,   535,     0,   536,
     210,     0,   537,   538,   539,   540,   541,   542,   543,   544,
     212,   545,     0,   546,   547,     0,   548,   549,   550,   551,
       0,   213,   214,     0,   553,     0,   554,   215,   555,   216,
       0,   556,   557,   558,   559,   560,     0,     0,   561,   562,
     563,   564,     0,  3224,   565,   566,     0,   567,   223,   568,
       0,   569,     0,     0,     0,   570,   571,   572,   573,   574,
     575,     0,   225,     0,     0,   226,    79,    80,    81,   365,
      83,    84,     0,    85,    86,    87,   366,     0,   367,     0,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,   368,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
     369,   370,     0,     0,     0,   371,   372,     0,     0,     0,
       0,   373,     0,     0,     0,     0,     0,     0,     0,     0,
     374,     0,   375,     0,   376,   377,     0,   378,   379,   380,
     381,   382,   383,   384,   385,     0,   386,   387,     0,     0,
       0,     0,     0,     0,     0,   388,   389,     0,   390,     0,
     391,   392,   393,     0,   132,     0,   134,     0,     0,   394,
     395,     0,   396,     0,     0,   397,   398,   135,   399,     0,
     400,   401,   402,   403,   139,     0,     0,   404,   405,   406,
     407,     0,   408,   409,   142,   410,     0,   411,   412,   413,
       0,   414,     0,     0,     0,     0,     0,   415,   416,   417,
     418,   419,   148,   149,   420,     0,   421,     0,   422,     0,
     423,   424,   425,     0,   426,     0,     0,   427,   428,   429,
     430,     0,   431,   432,   433,     0,   434,     0,   435,   436,
     437,   155,   438,     0,   157,     0,   439,   440,   159,     0,
     441,     0,   442,     0,     0,     0,   443,     0,   444,     0,
     445,   164,     0,   446,     0,   447,   448,   449,     0,   450,
     451,   452,     0,   453,   454,   455,   456,   457,     0,     0,
     167,     0,   458,   459,   460,     0,   169,     0,   170,     0,
       0,     0,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   174,     0,   467,     0,     0,   468,   469,   470,     0,
       0,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   181,     0,   183,     0,   482,   483,   484,   485,
     486,   487,   488,   184,   489,     0,   490,   491,     0,   492,
       0,   187,   188,   493,   494,     0,     0,   495,     0,     0,
       0,   496,   497,     0,     0,   189,     0,     0,   192,   498,
     499,   500,     0,   193,   194,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,   196,   510,     0,   511,   512,
     513,   514,   515,   516,   517,   518,   519,   520,   521,     0,
     522,   523,   203,   524,   525,   526,   527,   528,   529,     0,
       0,   530,   531,   532,     0,   533,   207,   534,   535,     0,
     536,   210,     0,   537,   538,   539,   540,   541,   542,   543,
     544,   212,   545,     0,   546,   547,     0,   548,   549,   550,
     551,     0,   213,   214,     0,   553,     0,   554,   215,   555,
     216,     0,   556,   557,   558,   559,   560,     0,     0,   561,
     562,   563,   564,     0,     0,   565,   566,     0,   567,   223,
     568,     0,   569,     0,     0,     0,   570,   571,   572,   573,
     574,   575,     0,   225,     0,     0,   226,    79,    80,    81,
     365,    83,    84,     0,    85,    86,    87,   366,     0,   367,
       0,    91,     0,    93,    94,    95,    96,    97,    98,     0,
      99,   100,   101,   368,     0,     0,   103,   104,   105,   106,
       0,     0,     0,   108,   109,   110,     0,   111,     0,     0,
     114,   369,   370,     0,     0,     0,   371,   372,     0,     0,
       0,     0,   373,     0,     0,     0,     0,     0,     0,     0,
       0,   374,     0,   375,     0,   376,   377,     0,   378,   379,
     380,   381,   382,   383,   384,   385,     0,   386,   387,     0,
       0,     0,     0,     0,     0,     0,   388,   389,     0,   390,
       0,   391,   392,   393,     0,   132,     0,   134,     0,     0,
     394,   395,     0,   396,     0,     0,   397,   398,   135,   399,
       0,   400,   401,   402,   403,   139,     0,     0,   404,   405,
     406,   407,     0,   408,   409,   142,   410,     0,   411,   412,
     413,     0,   414,     0,     0,     0,     0,     0,   415,   416,
     417,   418,   419,   148,   149,   420,     0,   421,     0,   422,
       0,   423,   424,   425,     0,   426,     0,     0,   427,   428,
     429,   430,     0,   431,   432,   433,     0,   434,     0,   435,
     436,   437,   155,   438,     0,   157,     0,   439,   440,   159,
       0,   441,     0,   442,     0,     0,     0,   443,     0,   444,
       0,   445,   164,     0,   446,     0,   447,   448,   449,     0,
     450,   451,   452,     0,   453,   454,   455,   456,   457,     0,
       0,   167,     0,   458,   459,   460,     0,   169,     0,   170,
       0,     0,     0,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   174,     0,   467,     0,     0,   468,   469,   470,
       0,     0,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   181,     0,   183,     0,   482,   483,   484,
     485,   486,   487,   488,   184,   489,     0,   490,   491,     0,
     492,     0,   187,   188,   493,   494,     0,     0,   495,     0,
       0,     0,   496,   497,     0,     0,   189,     0,     0,   192,
     498,   499,   500,     0,   193,   194,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,   196,   510,     0,   511,
     512,   513,   514,   515,   516,   517,   518,   519,   520,   521,
       0,   522,   523,   203,   524,   525,   526,   527,   528,   529,
       0,     0,   530,   531,   532,     0,   533,   207,   534,   535,
       0,   536,   210,     0,   537,   538,   785,   540,   541,   542,
     543,   544,   212,   545,     0,   546,   547,     0,   548,   549,
     550,   551,     0,   213,   214,     0,   553,     0,   554,   215,
     555,   216,     0,   556,   557,   558,   559,   560,     0,     0,
     561,   562,   563,   564,     0,     0,   565,   566,     0,   567,
     223,   568,     0,   569,     0,     0,     0,   570,   571,   572,
     573,   574,   575,     0,   225,     0,     0,   226,    79,    80,
      81,   365,    83,    84,     0,    85,    86,    87,   366,     0,
     367,     0,    91,     0,    93,    94,    95,    96,    97,    98,
       0,    99,   100,   101,   368,     0,     0,   103,   104,   105,
     106,     0,     0,     0,   108,   109,   110,     0,   111,     0,
       0,   114,   369,   370,     0,     0,     0,   371,   372,     0,
       0,     0,     0,   373,     0,     0,     0,     0,     0,     0,
       0,     0,   374,     0,   375,     0,   376,   377,     0,   378,
     379,   380,   381,   382,   383,   384,   385,     0,   386,   387,
       0,     0,     0,     0,     0,     0,     0,   388,   389,     0,
     390,     0,   391,   392,   393,     0,   132,     0,   134,     0,
       0,   394,   395,     0,   396,     0,     0,   397,   398,   135,
     399,     0,   400,   401,   402,   403,   139,     0,     0,   404,
     405,   406,   407,     0,   408,   409,   142,   410,     0,   411,
     412,   413,     0,   414,     0,     0,     0,     0,     0,   415,
     416,   417,   418,   419,   148,   149,   420,     0,   421,     0,
     422,     0,   423,   424,   425,     0,   426,     0,     0,   427,
     428,   429,   430,     0,   431,   432,   433,     0,   434,     0,
     435,   436,   437,   155,   438,     0,   157,     0,   439,   440,
     159,     0,   441,     0,   442,     0,     0,     0,   443,     0,
     444,     0,   445,   164,     0,   446,     0,   447,   448,   449,
       0,   450,   451,   452,     0,   453,   454,   455,   456,   457,
       0,     0,   167,     0,   458,   459,   460,     0,   169,     0,
     170,     0,     0,     0,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   174,     0,   467,     0,     0,   468,   469,
     470,     0,     0,   471,   472,   473,   474,   475,   476,   477,
     478,   479,   480,   481,   181,     0,   183,     0,   482,   483,
     484,   485,   486,   487,   488,   184,   489,     0,   490,   491,
       0,   492,     0,   187,   188,   493,   494,     0,     0,   495,
       0,     0,     0,   496,   497,     0,     0,   189,     0,     0,
     192,   498,   499,   500,     0,   193,   194,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,   196,   510,     0,
     511,   512,   513,   514,   515,   516,   517,   518,   519,   520,
     521,     0,   522,   523,   203,   524,   525,   861,   527,   528,
     529,     0,     0,   530,   531,   532,     0,   533,   207,   534,
     535,     0,   536,   210,     0,   537,   538,   539,   540,   541,
     542,   543,   544,   212,   545,     0,   546,   547,     0,   548,
     549,   550,   551,     0,   213,   214,     0,   553,     0,   554,
     215,   555,   216,     0,   556,   557,   558,   559,   560,     0,
       0,   561,   562,   563,   564,     0,     0,   565,   566,     0,
     567,   223,   568,     0,   569,     0,     0,     0,   570,   571,
     572,   573,   574,   575,     0,   225,     0,     0,   226,    79,
      80,    81,   365,    83,    84,     0,    85,    86,    87,   366,
       0,   367,     0,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,   368,     0,     0,   103,   104,
     105,   106,     0,     0,     0,   108,   109,   110,     0,   111,
       0,     0,   114,   369,   370,     0,     0,     0,   371,   372,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,     0,   374,     0,   375,     0,   376,   377,     0,
     378,   379,   380,   381,   382,   383,   384,   385,   863,   386,
     387,     0,     0,     0,     0,     0,     0,     0,   388,   389,
       0,   390,     0,   391,   392,   393,     0,   132,     0,   134,
       0,     0,   394,   395,     0,   396,     0,     0,   397,   864,
     135,   399,     0,   400,   401,   402,   403,   139,     0,     0,
     404,   405,   406,     0,     0,   408,   409,   142,   410,     0,
     411,   412,   413,     0,   414,     0,     0,     0,     0,     0,
     415,   416,   417,   418,   419,   148,   149,   420,     0,   421,
       0,   422,     0,   423,   424,   425,     0,   426,     0,     0,
     427,   428,   429,   430,     0,   431,   432,   433,     0,   434,
       0,   435,   436,   437,   155,   438,     0,   157,     0,   439,
     440,   159,     0,   441,     0,   442,     0,     0,     0,   443,
       0,   444,     0,   445,   164,     0,   446,     0,   447,   448,
     449,     0,   450,   451,   452,     0,   453,   454,   455,   456,
     457,     0,     0,   167,     0,   458,   459,   460,     0,   169,
       0,   170,     0,     0,     0,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   174,     0,   467,     0,     0,   468,
     469,   470,     0,     0,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   181,     0,   183,     0,   482,
     483,   484,   485,   486,   487,   488,   184,   489,     0,   490,
     491,     0,   492,     0,   187,   188,   493,   494,     0,     0,
     495,     0,     0,     0,   496,   497,     0,     0,   189,     0,
       0,   192,   498,   499,   500,     0,   193,   194,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,   196,   510,
       0,   511,   512,   513,   514,   515,   516,   517,   518,   519,
     520,   521,     0,   522,   523,   203,   524,   525,   526,   527,
     528,   529,     0,     0,   530,   531,   865,     0,   533,   207,
     534,   535,     0,   536,   210,     0,   537,   538,   539,   540,
     541,   542,   543,   544,   212,   545,     0,   546,   547,     0,
     548,   549,   550,   551,     0,   866,   214,     0,   553,     0,
     867,   215,   555,   216,     0,   556,   557,   558,   559,   560,
       0,     0,   561,   562,   563,   564,     0,     0,   565,   566,
       0,   567,   223,   568,     0,   569,     0,     0,     0,   570,
     571,   572,   573,   574,   575,     0,   225,     0,     0,   226,
      79,    80,    81,   365,    83,    84,     0,    85,    86,    87,
     366,     0,   367,     0,    91,     0,    93,    94,    95,    96,
      97,    98,     0,    99,   100,   101,   368,     0,     0,   103,
     104,   105,   106,     0,     0,     0,   108,   109,   110,     0,
     111,     0,     0,   114,   369,   370,     0,     0,     0,   371,
     372,     0,     0,     0,     0,   373,     0,     0,     0,     0,
       0,     0,     0,     0,   374,     0,   375,     0,   376,   377,
       0,   378,   379,   380,   381,   382,   383,   384,   385,   897,
     386,   387,     0,     0,     0,     0,     0,     0,     0,   388,
     389,     0,   390,     0,   391,   392,   393,     0,   132,     0,
     134,     0,     0,   394,   395,     0,   396,     0,     0,   397,
     864,   135,   399,     0,   400,   401,   402,   403,   139,     0,
       0,   404,   405,   406,     0,     0,   408,   409,   142,   410,
       0,   411,   412,   413,     0,   414,     0,     0,     0,     0,
       0,   415,   416,   417,   418,   419,   148,   149,   420,     0,
     421,     0,   422,     0,   423,   424,   425,     0,   426,     0,
       0,   427,   428,   429,   430,     0,   431,   432,   433,     0,
     434,     0,   435,   436,   437,   155,   438,     0,   157,     0,
     439,   440,   159,     0,   441,     0,   442,     0,     0,     0,
     443,     0,   444,     0,   445,   164,     0,   446,     0,   447,
     448,   449,     0,   450,   451,   452,     0,   453,   454,   455,
     456,   457,     0,     0,   167,     0,   458,   459,   460,     0,
     169,     0,   170,     0,     0,     0,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   174,     0,   467,     0,     0,
     468,   469,   470,     0,     0,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   181,     0,   183,     0,
     482,   483,   484,   485,   486,   487,   488,   184,   489,     0,
     490,   491,     0,   492,     0,   187,   188,   493,   494,     0,
       0,   495,     0,     0,     0,   496,   497,     0,     0,   189,
       0,     0,   192,   498,   499,   500,     0,   193,   194,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,   196,
     510,     0,   511,   512,   513,   514,   515,   516,   517,   518,
     519,   520,   521,     0,   522,   523,   203,   524,   525,   526,
     527,   528,   529,     0,     0,   530,   531,   898,     0,   533,
     207,   534,   535,     0,   536,   210,     0,   537,   538,   539,
     540,   541,   542,   543,   544,   212,   545,     0,   546,   547,
       0,   548,   549,   550,   551,     0,   899,   214,     0,   553,
       0,   900,   215,   555,   216,     0,   556,   557,   558,   559,
     560,     0,     0,   561,   562,   563,   564,     0,     0,   565,
     566,     0,   567,   223,   568,     0,   569,     0,     0,     0,
     570,   571,   572,   573,   574,   575,     0,   225,     0,     0,
     226,    79,    80,    81,   365,    83,    84,     0,    85,    86,
      87,   366,     0,   367,     0,    91,     0,    93,    94,    95,
      96,    97,    98,     0,    99,   100,   101,   368,     0,     0,
     103,   104,   105,   106,     0,     0,     0,   108,   109,   110,
       0,   111,     0,     0,   114,   369,   370,     0,     0,     0,
     371,   372,     0,     0,     0,     0,   373,     0,     0,     0,
       0,     0,     0,     0,     0,   374,     0,   375,     0,   376,
     377,     0,   378,   379,   380,   381,   382,   383,   384,   385,
       0,   386,   387,     0,     0,     0,     0,     0,     0,     0,
     388,   389,     0,   390,  1284,   391,   392,   393,     0,   132,
       0,   134,     0,     0,   394,   395,     0,   396,     0,     0,
     397,   864,   135,  1285,     0,   400,   401,   402,   403,   139,
       0,     0,   404,   405,   406,     0,     0,   408,   409,   142,
     410,     0,   411,   412,   413,     0,   414,     0,     0,     0,
       0,     0,   415,   416,   417,   418,   419,   148,   149,   420,
       0,   421,     0,   422,     0,   423,   424,   425,     0,   426,
       0,     0,   427,   428,   429,   430,     0,   431,   432,   433,
       0,   434,     0,   435,   436,   437,   155,   438,     0,   157,
       0,   439,   440,   159,     0,   441,     0,   442,     0,     0,
       0,   443,     0,   444,     0,   445,   164,     0,   446,     0,
     447,   448,   449,     0,   450,   451,   452,     0,   453,   454,
     455,   456,   457,     0,     0,   167,     0,   458,   459,   460,
       0,   169,     0,   170,     0,     0,     0,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   174,     0,   467,     0,
       0,   468,   469,   470,     0,     0,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   890,   181,     0,   183,
       0,   482,   483,   484,   485,   486,   487,   488,   184,   489,
       0,   490,   491,     0,   492,     0,   187,   188,   493,   494,
       0,     0,   495,     0,     0,     0,   496,   497,     0,     0,
     189,     0,     0,   192,   498,   499,   500,     0,   193,   194,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
     196,   510,     0,   511,   512,   513,   514,   515,   516,   517,
     518,   519,   520,   521,     0,   891,   523,   203,   524,   525,
     526,   527,   528,   529,     0,     0,   530,   531,  1276,     0,
     533,   207,   534,   535,     0,   536,   210,     0,   537,   538,
     539,   540,   541,   542,   543,   544,   212,   545,     0,   546,
     547,     0,   548,   549,   550,   551,     0,   893,   214,     0,
     553,     0,   894,   215,   555,   216,     0,   556,   557,   558,
     559,   560,     0,     0,   561,   562,   563,   564,     0,     0,
     565,   566,     0,   567,   223,   568,     0,   569,     0,     0,
       0,   570,   571,   572,   573,   574,   575,     0,   225,     0,
       0,   226,  1376,    80,    81,   365,    83,    84,     0,    85,
      86,    87,   366,     0,   367,     0,    91,     0,    93,    94,
      95,    96,    97,    98,     0,    99,   100,   101,   368,     0,
       0,   103,   104,   105,   106,     0,     0,     0,   108,   109,
     110,     0,   111,     0,     0,   114,   369,   370,     0,     0,
       0,   371,   372,     0,     0,     0,     0,   373,     0,     0,
       0,     0,     0,     0,     0,     0,   374,     0,   375,     0,
     376,   377,     0,   378,   379,   380,   381,   382,   383,   384,
     385,     0,   386,   387,     0,     0,     0,     0,     0,     0,
       0,   388,   389,     0,   390,     0,   391,   392,   393,     0,
     132,     0,   134,     0,     0,   394,   395,     0,   396,     0,
       0,   397,   398,   135,   399,     0,   400,   401,   402,   403,
     139,     0,     0,   404,   405,   406,   407,     0,   408,   409,
     142,   410,     0,   411,   412,   413,     0,   414,     0,     0,
       0,     0,     0,   415,   416,   417,   418,   419,   148,   149,
     420,     0,   421,     0,   422,     0,   423,   424,   425,     0,
     426,     0,     0,   427,   428,   429,   430,     0,   431,   432,
     433,     0,   434,     0,   435,   436,   437,   155,   438,     0,
     157,     0,   439,   440,   159,     0,   441,     0,   442,     0,
       0,     0,   443,     0,   444,     0,   445,   164,     0,   446,
       0,   447,   448,   449,     0,   450,   451,   452,     0,   453,
     454,   455,   456,   457,     0,     0,   167,     0,   458,   459,
     460,     0,   169,     0,   170,     0,     0,     0,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   174,     0,   467,
       0,     0,   468,   469,   470,     0,     0,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   181,     0,
     183,     0,   482,   483,   484,   485,   486,   487,   488,   184,
     489,     0,   490,   491,     0,   492,     0,   187,   188,   493,
     494,     0,     0,   495,     0,     0,     0,   496,   497,     0,
       0,   189,     0,     0,   192,   498,   499,   500,     0,   193,
     194,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,   196,   510,     0,   511,   512,   513,   514,   515,   516,
     517,   518,   519,   520,   521,     0,   522,   523,   203,   524,
     525,   526,   527,   528,   529,     0,     0,   530,   531,   532,
       0,   533,   207,   534,   535,     0,   536,   210,     0,   537,
     538,   539,   540,   541,   542,   543,   544,   212,   545,     0,
     546,   547,     0,   548,   549,   550,   551,     0,   213,   214,
       0,   553,     0,   554,   215,   555,   216,     0,   556,   557,
     558,   559,   560,     0,     0,   561,   562,   563,   564,     0,
       0,   565,   566,     0,   567,   223,   568,     0,   569,     0,
       0,     0,   570,   571,   572,   573,   574,   575,     0,   225,
       0,     0,   226,    79,    80,    81,   365,    83,    84,     0,
      85,    86,    87,   366,     0,   367,     0,    91,     0,    93,
      94,    95,    96,    97,    98,     0,    99,   100,   101,   368,
       0,     0,   103,   104,   105,   106,     0,     0,     0,   108,
     109,   110,     0,   111,     0,     0,   114,   369,   370,     0,
       0,     0,   371,   372,     0,     0,     0,     0,   373,     0,
       0,     0,     0,     0,     0,     0,     0,   374,     0,   375,
       0,   376,   377,     0,   378,   379,   380,   381,   382,   383,
     384,   385,     0,   386,   387,     0,     0,     0,     0,     0,
       0,     0,   388,   389,     0,   390,     0,   391,   392,   393,
       0,   132,     0,   134,     0,     0,   394,   395,     0,   396,
       0,     0,   397,   398,   135,   399,     0,   400,   401,   402,
     403,   139,     0,     0,   404,   405,   406,   407,     0,   408,
     409,   142,   410,     0,   411,   412,   413,     0,   414,     0,
       0,     0,     0,     0,   415,   416,   417,   418,   419,   148,
     149,   420,     0,   421,     0,   422,     0,   423,   424,   425,
       0,   426,     0,     0,   427,   428,   429,   430,     0,   431,
     432,   433,     0,   434,     0,   435,   436,   437,   155,   438,
       0,   157,     0,   439,   440,   159,     0,   441,     0,   442,
       0,     0,     0,   443,     0,   444,     0,   445,   164,     0,
     446,     0,   447,   448,   449,     0,   450,   451,   452,     0,
     453,   454,   455,   456,   457,     0,     0,   167,     0,   458,
     459,   460,     0,   169,     0,   170,     0,     0,     0,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   174,     0,
     467,     0,     0,   468,   469,   470,     0,     0,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   181,
       0,   183,     0,   482,   483,   484,   485,   486,   487,   488,
     184,   489,     0,   490,   491,     0,   492,     0,   187,   188,
     493,   494,     0,     0,   495,     0,     0,     0,   496,   497,
       0,     0,   189,     0,     0,   192,   498,   499,   500,     0,
     193,   194,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,   196,   510,     0,   511,   512,   513,   514,   515,
     516,   517,   518,   519,   520,   521,     0,   522,   523,   203,
     524,   525,  1609,   527,   528,   529,     0,     0,   530,   531,
     532,     0,   533,   207,   534,   535,     0,   536,   210,     0,
     537,   538,   539,   540,   541,   542,   543,   544,   212,   545,
       0,   546,   547,     0,   548,   549,   550,   551,     0,   213,
     214,     0,   553,     0,   554,   215,   555,   216,     0,   556,
     557,   558,   559,   560,     0,     0,   561,   562,   563,   564,
       0,     0,   565,   566,     0,   567,   223,   568,     0,   569,
       0,     0,     0,   570,   571,   572,   573,   574,   575,     0,
     225,     0,     0,   226,    79,    80,    81,   365,    83,    84,
       0,    85,    86,    87,   366,     0,   367,     0,    91,     0,
      93,    94,    95,    96,    97,    98,     0,    99,   100,   101,
     368,     0,     0,   103,   104,   105,   106,     0,     0,     0,
     108,   109,   110,     0,   111,     0,     0,   114,   369,   370,
       0,     0,     0,   371,   372,     0,     0,     0,     0,   373,
       0,     0,     0,     0,     0,     0,     0,     0,   374,     0,
     375,     0,   376,   377,     0,   378,   379,   380,   381,   382,
     383,   384,   385,     0,   386,   387,     0,     0,     0,     0,
       0,     0,     0,   388,   389,     0,   390,     0,   391,   392,
     393,     0,   132,     0,   134,     0,     0,   394,   395,     0,
     396,     0,     0,   397,   864,   135,   399,     0,   400,   401,
     402,   403,   139,     0,     0,   404,   405,   406,     0,     0,
     408,   409,   142,   410,     0,   411,   412,   413,     0,   414,
       0,     0,     0,     0,     0,   415,   416,   417,   418,   419,
     148,   149,   420,     0,   421,     0,   422,     0,   423,   424,
     425,     0,   426,     0,     0,   427,   428,   429,   430,     0,
     431,   432,   433,     0,   434,     0,   435,   436,   437,   155,
     438,     0,   157,     0,   439,   440,   159,     0,   441,     0,
     442,     0,     0,     0,   443,     0,   444,     0,   445,   164,
       0,   446,     0,   447,   448,   449,     0,   450,   451,   452,
       0,   453,   454,   455,   456,   457,     0,     0,   167,     0,
     458,   459,   460,     0,   169,     0,   170,     0,     0,     0,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   174,
       0,   467,     0,     0,   468,   469,   470,     0,     0,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,   890,
     181,     0,   183,     0,   482,   483,   484,   485,   486,   487,
     488,   184,   489,     0,   490,   491,     0,   492,     0,   187,
     188,   493,   494,     0,     0,   495,     0,     0,     0,   496,
     497,     0,     0,   189,     0,     0,   192,   498,   499,   500,
       0,   193,   194,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,   196,   510,     0,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,     0,   891,   523,
     203,   524,   525,   526,   527,   528,   529,     0,     0,   530,
     531,  1276,     0,   533,   207,   534,   535,     0,   536,   210,
       0,   537,   538,   539,   540,   541,   542,   543,   544,   212,
     545,     0,   546,   547,     0,   548,   549,   550,   551,     0,
     893,   214,     0,   553,     0,   894,   215,   555,   216,     0,
     556,   557,   558,   559,   560,     0,     0,   561,   562,   563,
     564,     0,     0,   565,   566,     0,   567,   223,   568,     0,
     569,     0,     0,     0,   570,   571,   572,   573,   574,   575,
       0,   225,     0,     0,   226,    79,    80,    81,     0,    83,
      84,     0,    85,    86,    87,     0,     0,     0,    90,    91,
       0,    93,    94,    95,    96,    97,    98,     0,    99,   100,
     101,     0,     0,     0,   103,   104,   105,   106,     0,   107,
       0,   108,   109,   110,     0,   111,   112,   113,   114,     0,
       0,     0,     0,     0,   117,   118,     0,     0,     0,     0,
     119,     0,     0,     0,     0,     0,     0,     0,     0,   120,
       0,   121,     0,   122,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
       0,     0,   131,   132,   133,   134,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     0,     0,
       0,     0,     0,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   142,     0,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   148,   149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     155,     0,     0,   157,     0,     0,     0,   159,     0,     0,
       0,     0,   160,     0,   161,     0,     0,     0,     0,     0,
     164,     0,     0,     0,     0,     0,     0,   165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   166,   167,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
     171,   172,     0,   173,     0,     0,     0,     0,     0,     0,
     174,   175,     0,   176,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,   183,     0,     0,     0,     0,     0,     0,
       0,     0,   184,     0,     0,     0,     0,   186,     0,     0,
     187,   188,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   189,   190,   191,   192,     0,     0,
       0,     0,   193,   194,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   201,     0,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   207,     0,     0,   209,     0,
     210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   213,   214,     0,     0,     0,     0,   215,     0,   216,
       0,     0,     0,     0,     0,     0,   219,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   223,     0,
     224,     0,     0,     0,     0,     0,     0,     0,     0,    79,
      80,    81,   225,    83,    84,   226,    85,    86,    87,     0,
       0,     0,    90,    91,     0,    93,    94,    95,    96,    97,
      98,     0,    99,   100,   101,     0,     0,     0,   103,   104,
     105,   106,     0,   107,     0,   108,   109,   110,     0,   111,
     112,   113,   114,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   129,     0,     0,     0,   131,   132,   133,   134,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     135,     0,     0,     0,     0,     0,     0,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   142,     0,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   148,   149,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   155,     0,     0,   157,     0,     0,
       0,   159,     0,     0,     0,     0,   160,     0,   161,     0,
       0,     0,     0,     0,   164,     0,     0,     0,     0,     0,
       0,   165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   166,   167,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,   171,   172,     0,   173,     0,     0,
       0,     0,     0,     0,   174,   175,     0,   176,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,   183,     0,     0,
       0,     0,     0,     0,     0,     0,   184,     0,     0,     0,
       0,   186,     0,     0,   187,   188,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   189,   190,
     191,   192,     0,     0,     0,     0,   193,   194,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,     0,   203,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   207,
       0,     0,   209,     0,   210,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   213,   214,     0,     0,     0,
       0,   215,     0,   216,     0,     0,     0,     0,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   223,     0,   224,     0,    79,    80,    81,     0,
      83,    84,     0,    85,    86,    87,   225,     0,     0,   226,
      91,     0,    93,    94,    95,    96,    97,    98,     0,    99,
     100,   101,     0,     0,     0,   103,   104,   105,   106,     0,
       0,     0,   108,   109,   110,     0,   111,     0,     0,   114,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   129,
       0,     0,     0,   131,   132,   133,   134,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   135,     0,     0,
       0,     0,     0,     0,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   142,     0,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   148,   149,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,     0,     0,   157,     0,     0,     0,   159,     0,
       0,     0,     0,   160,     0,   161,     0,     0,     0,     0,
       0,   164,     0,     0,     0,     0,     0,     0,   165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   166,
     167,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,   171,   172,     0,   173,     0,     0,     0,     0,     0,
       0,   174,   175,     0,   176,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   181,   182,   183,     0,     0,     0,     0,     0,
       0,     0,     0,   184,     0,     0,     0,     0,   186,     0,
       0,   187,   188,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,   191,   192,     0,
       0,     0,     0,   193,   194,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   201,
       0,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   207,     0,     0,   209,
       0,   210,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   212,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   213,   214,     0,     0,     0,     0,   215,     0,
     216,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   223,
       0,   224,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   225,     0,     0,   226
};

static const short yycheck[] =
{
       2,   154,   719,    90,   727,   227,   723,    74,    77,   850,
      90,   147,    82,    74,   720,  1421,   722,   144,   154,   217,
    1551,     2,   742,  1086,   711,   112,    74,  1505,   734,  1033,
    1093,  1112,   112,    74,    90,   752,   980,  1041,  1581,   762,
    1046,  1212,   195,   200,  1163,   721,   722,  1362,   894,   221,
    1507,   816,   758,   818,  1548,   820,   112,  1544,   780,   195,
    1554,   826,   903,   128,    90,   771,  1714,  1284,  2274,  1521,
    1407,   788,  1612,  2041,   797,    74,    74,   794,  1082,   999,
     756,   146,    74,   946,  1088,  2206,   112,  2026,   980,  2407,
    1094,  2085,   199,  2031,  2032,  1521,  1521,  2413,  1521,   206,
    1521,   208,  1521,  2442,   810,  2226,  1384,   889,   178,  1779,
     892,  1858,  1859,   835,  1751,   815,   792,  1546,  1980,  1981,
    1982,  1983,    24,  1128,   955,  1128,  1957,  1174,  1175,  1013,
      49,    74,   219,    90,    77,  1138,  1139,    76,    41,   219,
      25,   980,   887,    76,  1814,   975,    93,    90,  1818,   112,
      92,  1198,    92,   117,  2564,   112,   158,   963,   964,    98,
     227,   228,   136,   219,   886,    93,    81,   228,   136,   112,
     713,   160,    79,   129,    85,  1184,   155,   112,   180,   691,
      91,   200,   162,    77,     8,   194,  1226,   212,   119,    13,
      14,    15,  1670,   219,   194,   126,   126,   119,   169,   229,
     131,    25,    26,    27,   154,    29,    30,    31,   229,    85,
     194,    35,    36,    37,    85,    91,   233,    92,    97,    28,
      91,   157,   229,    76,    41,   199,    28,    97,   364,   228,
     228,   199,   112,   155,   223,   284,   228,    39,  3152,  1645,
     123,   202,   199,   229,  1247,    98,  2824,   229,  2826,   206,
      81,   208,   157,   324,   169,   117,   155,   148,   286,   345,
     191,   374,   219,   316,   136,    76,   795,   340,   256,   321,
     799,   178,   324,   321,   345,    85,   219,   332,   807,   999,
     321,    86,  1288,   160,    11,   406,    28,   276,   277,   358,
     275,   314,    99,   345,   138,    76,  1966,   314,    42,   322,
      44,   158,   433,   155,   160,   417,     0,   171,   245,   440,
     422,   118,  1018,   361,   116,   229,  1533,    98,   430,   342,
     361,  1492,    49,    33,   445,   398,   155,   199,   313,  1249,
     119,  1051,   445,   177,   112,   406,  1053,   392,   169,  1062,
      92,   185,  1059,  1287,   280,   431,   223,    76,  3262,   286,
     338,   340,   209,   275,   406,   165,   724,  3123,   280,   888,
     728,  2388,  1049,   326,   255,   438,   257,   735,    76,   330,
     275,   117,    74,   827,   345,    77,   220,   308,   321,  1085,
     155,   280,  1463,    92,  1101,   438,   308,    82,    90,   438,
     374,   326,   760,  1099,    89,   317,   764,    92,  2366,   229,
      85,    85,   191,   392,   287,   773,  1863,   102,   394,  1115,
     112,   441,   394,   384,   394,   358,   225,   445,   361,   224,
     445,  1952,    76,   225,   445,   332,   445,   377,   445,   385,
     345,  1478,  1479,   128,   441,   414,   445,  2074,   417,  1486,
     347,   352,   137,   138,   374,   445,   326,  1453,    76,   438,
     231,   146,   147,  2863,   997,   150,  1537,   388,   408,   154,
    3038,   973,   441,   158,   358,   439,   388,   441,   163,  2675,
    2676,   439,  1481,   441,   438,    92,   352,    76,   406,   407,
     304,   352,   445,   225,   363,   180,  1317,   552,   340,   267,
     321,   438,   394,   363,   436,   434,   436,   199,   417,    98,
     195,   434,   231,   198,   206,   200,   208,  1346,  1339,   204,
     445,   221,   284,  2150,   417,   392,  2455,   219,  1947,   308,
    2459,  1858,  1406,   231,  2463,  1270,  1271,   441,  1358,  1249,
     432,   275,   417,  2364,  2365,  2397,   392,  1343,   400,  2026,
     404,  2288,  2373,  2290,   229,   229,   398,  1825,   326,  2043,
    2044,  2221,   414,   725,  3320,   417,  1561,  1560,   730,   731,
     384,   436,    74,   155,   439,   440,  1569,   345,  2216,   154,
     445,  1611,  1612,    76,  2541,   160,   438,   231,   431,   432,
     433,   434,  1622,  1623,   178,   414,   438,  2224,   417,   155,
     195,  1638,  1639,  2087,  1634,  1635,   178,   414,  2565,   388,
     417,  1464,  1302,   231,  1392,   422,  1388,   424,  1648,  1649,
     299,   441,   160,   430,   155,   787,    17,  1146,   406,   321,
     431,   432,   433,   434,   711,   149,  3222,   377,   781,   290,
     103,   711,   231,   232,  2381,  1164,   289,   291,   223,   414,
    1422,  1429,   417,   163,   780,   781,    17,   422,   429,   430,
     431,   432,   433,   434,   340,   711,   358,   445,   408,   361,
    1380,  3257,   196,   291,  1446,  1705,   438,   715,   414,   364,
      74,   417,  2990,    77,   715,   223,   812,   105,   748,   278,
     200,  3020,  2998,   275,   436,   711,    90,   439,   440,   691,
     150,   215,   438,   445,  2441,   300,   196,  1384,  1421,   835,
     429,   430,   431,   432,   433,   434,   280,   160,   112,   275,
     691,  2738,  2739,  2740,  2741,  2742,   228,  2387,  2205,   147,
    2940,   429,   430,   431,   432,   433,   434,   436,   231,   277,
     439,   440,   417,   417,   275,   208,   445,   422,   422,   212,
     160,  2219,   112,  1584,   165,   430,   430,   207,   409,   169,
     886,   440,   438,   347,   711,   340,   441,   441,   140,  1465,
     332,   415,   105,  1469,   356,   347,   828,   359,   711,  2989,
     223,   244,   715,   229,  2180,   429,   430,   431,   432,   433,
     434,  2275,   889,   355,   854,   892,  1473,   415,   291,   851,
     233,   291,   340,   366,   222,   336,   256,   425,   426,   427,
     334,   429,   430,   431,   432,   433,   434,   392,   159,   879,
    2672,   439,   207,   195,   816,   219,   818,   904,   820,   436,
     890,   891,   439,   440,   826,   827,   119,   747,   445,  2797,
     429,   430,   431,   432,   433,   434,   189,   219,   131,   267,
     414,   365,   366,   417,   392,   157,  2340,  2341,   307,   219,
     231,  1557,   234,   438,   275,   775,   194,   552,   150,   359,
     242,   256,   158,   284,  1581,   374,   336,   131,   299,  1813,
     256,   314,  2810,   259,   159,  2814,   349,  3097,   338,   230,
    2819,   263,   377,   299,  2823,   305,   730,   340,  2719,  2720,
     438,   155,   245,   963,   964,   437,   150,   195,   191,   189,
    1354,   596,   597,   445,   105,   321,   218,   751,   289,   337,
    1914,  1915,   415,   209,   345,   207,   425,   321,   377,   124,
    3238,  1813,  1645,   426,   427,   314,   429,   430,   431,   432,
     433,   434,   889,   286,  1797,   892,   141,   407,   299,   392,
     131,   150,  2485,   338,   946,   230,   147,   329,   153,   408,
    2287,   121,   338,   207,   358,   245,  2408,   361,   347,   441,
     321,   904,  1049,   275,   256,   946,   299,   259,  2455,  1049,
     972,   973,  2459,   975,   299,  2515,  2463,  2471,   980,  2473,
    2474,  2062,  2408,  2408,  1704,  2408,  1673,  2408,   321,  2408,
     158,   972,   973,  1049,   975,   401,   286,   202,   207,   980,
     844,   179,   256,   392,  1226,   259,   850,   198,   441,   711,
     177,   275,   307,   715,  2508,   308,   860,  1153,   341,   341,
     345,   222,   185,  1049,   215,   720,   721,   722,   442,   724,
     412,   726,   727,   728,   729,   213,  3242,   732,   733,   734,
     735,   209,    45,   366,   366,  1908,   338,   256,  1911,  1912,
     259,  1580,  1122,  1582,  1583,  3049,  1585,   248,   753,   903,
     227,   756,  1129,   758,   908,   760,   267,  3273,  1129,   764,
     765,   766,   441,  2743,   769,   919,   771,   299,   773,   402,
     402,  1148,   377,   437,   338,   780,   781,  1148,  3289,   299,
    1812,   445,  1049,   417,   789,   388,  3035,   792,    76,   321,
     795,  1168,   293,  2143,   799,   800,  1049,  3228,   415,   804,
     805,   321,   807,   408,  2034,   810,   446,   280,   410,  1186,
      98,   284,   130,  2954,  2164,  2956,  2957,   294,  3329,   338,
    1129,  1129,    56,   828,   829,   345,   337,  1129,  1825,   374,
     835,   442,  3263,   417,   406,   407,   438,   111,   422,  1216,
      74,  1827,  1520,   299,  3355,   194,   410,   155,  1228,  1226,
     436,   856,  3130,   858,   440,   173,   861,  2207,  2208,  1239,
    1624,  1625,  1626,   212,   394,   321,   438,   368,  1632,   370,
     357,   358,  1636,  1637,   438,    76,   121,   889,   379,  1643,
     892,   886,   887,   888,    88,    89,   891,   388,  1652,   345,
    1654,   410,   904,   414,    83,   440,   417,    98,  1052,   444,
     425,   439,   103,  1667,  1284,  1669,   225,   445,   381,   183,
     387,   436,   101,  2440,  1753,   440,   389,   438,   126,    81,
     228,   416,   417,   131,  1321,    87,   198,   414,   199,   198,
     417,  1308,  1309,   251,  1311,   415,   210,   208,  1954,  1955,
     248,  1095,  1096,  1097,   285,   425,   426,   427,   289,   429,
     430,   431,   432,   433,   434,  1321,  2744,    38,   963,   964,
    1442,   123,   967,  1343,  2922,    20,  1341,   439,  3109,   195,
     438,  1388,  1447,   445,   136,  1287,   248,  1289,  1290,   248,
     441,   299,  1379,   988,   445,  1321,   991,  1384,   441,   994,
     299,  1145,   445,   219,  1384,   289,  1287,   711,  1289,  1290,
     379,   715,   164,   414,  2034,  1422,   417,   169,   234,  1163,
     172,   212,   321,  1018,  1372,   311,   242,  2814,  1384,  2051,
    1332,  1372,  2819,   368,  2828,   370,  2823,   438,  2795,  1446,
     231,   232,    81,  1872,   289,  2660,   345,  1049,    87,   441,
    1515,  1332,  1354,   445,  1519,  1884,  1358,   133,  1384,   367,
    1362,   369,   326,   327,  1529,    93,   116,   117,  1063,  1898,
    1592,  2217,  1067,  1902,   323,   339,  1071,  1358,  1321,  1322,
    1323,  1362,  1077,   111,   123,   215,  1473,   278,  2507,   353,
    1085,   406,   407,  1473,   237,   439,   360,   136,  2569,  2570,
     291,   445,   406,   407,  1099,  1100,   368,  1102,   370,   368,
     368,   370,   370,   329,  2892,   413,   414,  1473,   416,   417,
    1115,   400,   439,   438,   422,   164,   424,  1384,   445,  1372,
     169,  1388,   430,   172,   229,   414,  1379,  2381,   417,   403,
     165,  1384,  1137,   402,   439,   413,  1900,  1473,   416,  1606,
     445,  1146,  1147,  1297,  1822,   183,  1151,  2180,  1826,   438,
     185,  2324,  1464,  1533,   438,  1422,  1161,  2330,  2331,  1164,
     436,  1166,   441,   111,   440,  1843,   445,  1544,  1009,   445,
     415,   110,   210,  1464,   414,  1308,  1309,   417,  1311,  1446,
     425,   426,   427,   345,   429,   430,   431,   432,   433,   434,
     904,   439,  1033,  1871,   310,  1873,   439,   445,   438,   237,
    1041,  2234,   445,   194,   414,  1969,  1473,   417,   411,   148,
    1974,   406,   407,  2929,   415,  1592,   289,   439,     5,   414,
    1473,  3018,   417,   445,    99,   299,  2576,  1905,   429,   430,
     431,   432,   433,   434,  2309,   183,   177,   233,  3035,   414,
     275,    28,   417,   438,   443,   280,   445,   321,   189,   284,
     324,  1631,    39,   414,  1932,   121,   417,  1935,   414,  1937,
     440,   417,   210,   438,  1576,  1270,  1271,  3120,  2254,   292,
     414,   345,   321,   417,   439,   214,  1673,   438,   414,  1284,
     445,   417,   438,  1673,  1289,  1290,   227,   406,   407,   327,
    2142,   289,  2144,  2145,  1299,   414,   345,    76,   417,  3087,
    1677,   339,   438,   374,   245,  1308,  1309,  1673,  1311,  1321,
    1322,  1323,  1624,  1625,  1626,   353,   255,   289,   257,   438,
    1632,   411,   360,  2639,  1636,  1637,    99,    76,   267,   116,
    2094,  1643,   406,   411,   417,  1049,  1341,  1673,  1343,   422,
    1652,   424,  1654,   406,   407,   286,   381,   430,  2381,   414,
    1730,   233,   417,   294,   389,  1667,   414,  1669,   414,   417,
    1372,   417,   406,   407,  3168,   403,  1812,  1379,    76,  1374,
    1076,  1430,  1384,   438,   345,  1434,  1388,  1436,   431,   327,
     438,   168,    90,  2380,   414,   193,   325,   417,  1746,  2067,
     414,   339,   439,   417,   439,  1746,    76,  2236,  1552,  1553,
     445,  1780,  1714,  1782,  1110,   353,  1673,  2085,   438,  2723,
    1422,   414,   360,   439,   417,   354,  1421,    85,   439,   422,
    1673,   424,   414,  1803,   445,   417,  3223,   430,  1825,   441,
    1584,  2804,   109,   414,  1446,  1825,   417,   431,   225,  2469,
     442,   422,  1596,   424,  3191,  3192,   387,   442,  3195,   430,
    3197,   439,   231,    93,  2218,   403,   439,   445,  2485,  1825,
    1465,  1473,   445,   212,  1469,   225,   429,   430,   431,   432,
     433,   111,  2311,  2312,   439,     7,   439,   439,    10,   374,
     445,   439,   231,   445,   374,  1797,   439,   445,   374,  1825,
      22,    23,   445,  1746,  2026,    93,   374,   422,   439,   424,
     374,  1813,  3343,  1815,   439,  1817,  1797,  2523,   406,   407,
     445,    43,   291,   111,    46,  1520,   175,  1522,   436,   439,
     438,    93,  1813,   231,  1815,   445,  1817,  1780,  1533,  1782,
     429,   430,   431,   432,   433,   439,  1155,  1156,   437,   439,
     109,   445,   291,   183,  1549,   445,  1700,   439,   439,   415,
     439,   231,  1557,   445,   445,  1992,   445,  1562,  1825,   425,
     426,   427,   394,   429,   430,   431,   432,   433,   434,   436,
     210,   438,  1825,   440,   446,  1580,   439,  1582,  1583,   225,
    1585,  1961,   445,   291,   439,   183,   231,  1592,  1900,   439,
     445,   443,  3308,   445,   374,   445,  1908,   237,  1752,  1911,
    1912,  1606,  2237,  2238,  1609,  2051,   440,  1321,  1322,  1323,
     439,   291,   210,   439,   438,  2293,   445,  1908,   438,   445,
    1911,  1912,  2386,   439,  2388,   439,   368,   439,   370,   445,
     299,   445,  2164,   445,   166,   439,   415,   291,  2018,   237,
    1645,   445,   431,   432,   433,   438,   425,   426,   427,  2026,
     429,   430,   431,   432,   433,   434,  1647,  1969,  1372,   321,
     439,  1673,  1974,   439,   438,  1379,   415,   439,   439,   445,
    1384,  2239,  2240,   445,   445,  1381,   425,   426,   427,   438,
     429,   430,   431,   432,   433,   434,   368,   327,   370,   439,
     438,   441,  2200,  2201,   439,  2460,   441,  2462,   921,   339,
     923,  1706,   965,   966,   438,   440,  1076,   415,   345,   289,
     441,   438,   243,   353,  1420,   283,   237,   425,   426,   427,
     360,   429,   430,   431,   432,   433,   434,   406,  3078,   327,
     119,   438,   406,    93,  1746,   415,   406,    99,    99,   299,
    1110,   339,   237,  1748,   394,   425,   426,   427,  1753,   429,
     430,   431,   432,   433,   434,   353,  1462,   438,   445,  1473,
     438,   415,   360,   403,  2528,   289,   406,   289,  1780,   190,
    1782,   425,   426,   427,  2538,   429,   430,   431,   432,   433,
     434,   243,  2094,   189,   140,   438,   438,  2164,   304,   438,
     438,   438,    93,   243,   438,   438,   438,   438,  1803,   438,
    2177,  1806,   438,   438,   438,   403,   438,  1812,  1514,  2487,
     438,   438,   438,  1825,   438,   438,   438,  1822,  1823,  2196,
     438,  1826,  1827,   231,   445,   438,  1831,   431,  2205,   225,
     189,  2509,  1837,   338,   259,  1989,   445,  1842,  1843,   195,
    1546,   154,   150,   393,    41,  1551,   440,    17,   445,   438,
     438,   438,   289,   339,   374,   374,   440,   374,  2012,   374,
     374,   280,   374,   219,   393,  2019,  1871,  1872,  1873,  1874,
    1875,   374,  1877,  1878,   374,   367,   374,   374,   234,  1884,
     445,   394,   336,   374,   126,   289,   242,   375,   445,   379,
     379,   374,   374,  1898,   374,   336,  2929,  1902,   374,   207,
    1905,  1906,  1907,   438,  2216,   438,  2218,   263,  2220,   289,
     231,   287,   438,   400,  1919,  1920,  1921,  1287,  1923,  1924,
    1925,  1926,  1927,  1928,  1929,    93,    83,  1932,  1933,  2220,
    1935,  1936,  1937,   289,  3325,   155,   438,   438,   402,   438,
     251,   189,   438,   289,   438,    93,   337,   405,   256,  1954,
    1955,   259,    93,    17,   394,   425,   119,   374,   194,  1673,
     445,   445,   398,   438,  1969,  1671,   438,   279,   131,  2733,
     404,   372,   372,   329,  2738,  2739,  2740,  2741,  2742,    76,
     445,   345,  2746,  2380,   372,  2448,   438,   438,  1993,  3140,
    2380,   374,   155,   194,   157,   425,   445,  2309,   377,   445,
     439,   227,  2448,  2008,   290,   284,   245,   445,  2013,   436,
    2015,  1381,  2324,   439,  2380,    38,   432,   439,  2330,  2331,
    2400,   130,  2027,   438,   235,   235,  2031,  2032,   438,   280,
     338,   280,  1746,  2324,   280,   289,  2041,  1407,   394,  2330,
    2331,   374,   295,   374,  2380,  2199,  2051,   336,   445,   439,
    1420,    76,   445,   245,   301,   218,   412,   414,  2435,  2439,
    2440,   301,  2067,   391,  2435,    90,  1780,   109,  1782,  2381,
     366,  2448,  2604,   314,  2386,    93,  2388,  2448,  2455,   231,
    2085,   231,  2459,   321,   394,   231,  2463,  2399,   425,   436,
    2381,   374,  1462,  3120,   374,   425,   245,    82,  2606,  2607,
    2608,  2609,   410,   189,    89,   413,   414,   289,   416,   417,
     293,  1825,   275,  2380,    93,    76,   203,   280,   206,  1489,
    2497,   206,   189,   445,   439,   439,  2497,  2380,    11,   445,
      82,  3147,   200,   258,   289,   109,  2127,    98,   445,  2130,
     439,    76,   103,   128,  1514,   308,   439,  2152,   439,   194,
     445,   439,   439,   411,   317,    90,   411,   439,   439,  2837,
     194,   146,   147,    98,   439,   439,   439,   439,   103,   154,
    2161,  2162,  2936,   158,   439,  2180,  1546,   439,    76,   439,
     439,  1551,   411,   374,   441,  2949,   438,    34,   438,  3028,
     425,   245,    90,   178,   439,   180,   439,   221,   280,  3038,
      98,   445,  2582,   299,   441,   103,   231,   439,  3224,   439,
     195,   438,   374,   438,   407,  2220,  2528,   439,   374,   231,
    2225,   439,   231,   436,   439,   388,  2538,  2604,   259,   289,
     439,  2236,   323,   384,   438,   287,   439,   445,   287,   374,
     394,  1947,   289,   439,   438,   234,  1952,   208,   296,  2254,
     234,   212,   438,   425,   439,  2933,   445,  2127,  2412,   292,
    2130,  1967,   178,   178,  2418,  2943,   291,  2945,   439,  2274,
     231,   232,   436,   208,   175,  3308,   194,   212,    76,   189,
    3307,   439,   117,   244,   415,   202,   439,   425,  2293,  2294,
    2295,  2161,  2162,   425,   439,   438,   231,   232,   445,   105,
     439,  1671,   439,   374,   438,   374,  2311,  2312,   336,   244,
     208,   384,   221,  3340,   212,   374,   374,   278,   374,   231,
    3159,   439,   162,   231,   231,   437,    93,   438,   394,   235,
     291,   189,  2038,   231,   232,   141,   293,   217,    93,    93,
     275,   445,   397,   278,   438,   438,   244,   234,  2660,   438,
     199,   194,   194,  2507,   438,   161,   291,   284,   293,   439,
     439,  2366,   439,   439,   438,   109,   204,   439,  2380,  2660,
     176,  3049,   394,   438,   231,   280,   280,   275,   157,   364,
     278,   218,   196,  2388,   190,   196,   437,   194,   349,    76,
     415,   215,   394,   291,   170,   293,  2401,  2402,  2403,   205,
     425,   426,   427,    90,   429,   430,   431,   432,   433,   434,
     180,   156,   439,  2790,   349,  2727,  2796,   156,   438,  2790,
     236,  2733,   194,   374,   438,   189,  2738,  2739,  2740,  2741,
    2742,  2436,   292,   438,  2746,  2440,  2727,  2814,   439,   317,
      93,   280,  2819,  2448,  2449,   254,  2823,  2452,   367,   312,
      96,   349,   439,   287,   415,   287,   289,  2611,  2612,   189,
     289,  2466,    93,   128,   425,   426,   427,   367,   429,   430,
     431,   432,   433,   434,   280,   280,   170,   289,   438,   289,
     415,   287,  2487,   166,   332,   160,   445,   445,  1858,  1859,
     425,   426,   427,  2498,   429,   430,   431,   432,   433,   434,
     392,   180,   437,   333,  2509,   333,    80,   313,   312,   438,
     228,   446,  1991,   439,   316,  1290,  2220,   415,  2523,  1931,
    3284,  3285,  2334,  1876,  2782,  1919,  2785,   425,   426,   427,
    2703,   429,   430,   431,   432,   433,   434,  2271,  2983,  3270,
    3298,  2792,  3253,  2923,   231,  3252,     2,   445,  3137,  3279,
    3213,  2787,  1530,  3013,  2545,  1977,  3355,  2548,  2549,  2550,
    2551,  2552,  2553,  2554,  2555,  2556,  2557,   552,  3329,  2967,
    3310,  2966,  2380,  1516,  3356,   180,  1147,  1947,  2069,  3223,
    2287,  2961,  1952,  2837,  1859,  1858,  2802,  3020,  3199,  1984,
    3319,  2745,  3354,   902,  1752,   156,  2831,  1967,  2498,  2305,
    2049,  2307,  1129,  2231,   291,  2596,  2597,  1316,  1765,  1315,
    2922,  2241,  1749,  2205,  2768,  2461,  2026,  2994,  3036,  2780,
    1489,  2581,  2776,  2994,  2936,   610,    82,  2333,  2177,  2381,
    2899,  2922,  2096,    89,  2175,  1701,  3236,  2949,  2926,  3019,
    2225,  3048,  2841,  1100,   970,  1356,  1806,  1323,  1803,    74,
     322,   695,  1778,   998,  1813,  2215,  2057,  2363,  3035,  2058,
    1153,   966,  2832,  1268,  2833,  2921,  2380,  2643,  2038,   357,
    2675,  2676,   128,  1575,  1817,  2545,  2052,     2,  2548,  2549,
    2550,  2551,  2552,  2553,  2554,  2555,  2556,  2557,  1321,    -1,
     146,    -1,    -1,    -1,   972,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2710,  2711,    -1,    -1,    -1,
    2416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2427,   178,    -1,    -1,    -1,  2596,  2597,   415,    -1,
      -1,    -1,    -1,  2738,  2739,  2740,  2741,  2742,   425,   426,
     427,    -1,   429,   430,   431,   432,   433,   434,    -1,    -1,
      -1,    -1,    -1,    -1,    76,    -1,  2761,  2911,  2912,  2913,
    2914,    -1,    -1,   748,    -1,  3145,    -1,    -1,    90,    -1,
    3082,  2762,    -1,    -1,    -1,  2780,    98,  2782,    -1,    -1,
    2785,   103,  2787,    -1,    -1,    -1,    -1,  2792,  3165,    -1,
      -1,  3082,  2797,    -1,  3165,   780,   781,    -1,    -1,  3331,
      -1,    -1,    -1,    -1,    -1,  2810,    -1,  2812,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2521,    -1,    -1,    -1,  2824,
      -1,  2826,    -1,    -1,    -1,    -1,    -1,   812,    -1,    -1,
      -1,   816,  2837,   818,    -1,   820,    -1,    -1,  2544,    -1,
      -1,   826,   827,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     835,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3239,
      -1,    -1,    -1,  3243,    -1,  2571,    -1,    -1,    -1,   854,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,  2594,    -1,
     212,    -1,  2762,    -1,   879,    -1,    -1,    -1,    -1,    -1,
      -1,   886,   887,  2894,  2895,   890,   891,    -1,    -1,   231,
     232,    -1,    -1,    -1,    -1,  1076,    -1,  2287,  2288,    76,
    2290,  2926,   244,    -1,  2929,    -1,  2931,    -1,  2933,  2934,
    2935,    -1,    -1,    -1,    -1,  2305,    -1,  2307,  2943,  2944,
    2945,    98,  3319,    -1,    -1,  2950,   103,    -1,    -1,  1110,
      -1,    -1,    -1,   275,  3331,    -1,   278,    -1,    76,    -1,
      -1,   946,    -1,  2333,    -1,    -1,    -1,    -1,  3122,   291,
      -1,   293,  3284,  3285,    -1,    -1,    -1,  3354,   963,   964,
      98,    -1,    -1,    -1,    -1,   103,  3140,    -1,    -1,    -1,
      76,    -1,    -1,  2363,    -1,    -1,    -1,    -1,    -1,    -1,
    2706,  3155,    -1,    -1,    90,    -1,    -1,    -1,  3013,    -1,
      -1,  2381,    -1,  3018,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3028,  2894,  2895,    -1,   349,    -1,    -1,
      -1,  3185,    -1,  3038,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3049,    -1,  2416,    -1,    -1,    -1,
      -1,   208,    -1,    -1,    -1,   212,    -1,  2427,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3057,  2773,  3059,    -1,
      -1,  2441,    -1,    -1,   231,   232,  3067,  3068,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,
     208,    -1,    -1,   415,   212,    -1,   552,    -1,    -1,    -1,
      -1,    -1,    -1,   425,   426,   427,    -1,   429,   430,   431,
     432,   433,   434,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,   278,    -1,   445,    -1,  3130,   244,  3132,    -1,    -1,
      -1,    -1,    -1,    -1,   291,    -1,    -1,  1122,    -1,    -1,
      -1,    -1,  3147,    -1,    -1,   231,  3151,  3152,    -1,    -1,
      -1,  2521,    -1,    -1,  3159,  1140,  1076,   275,  1143,    -1,
     278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1153,    -1,
      -1,    -1,    -1,   291,  2544,    -1,    -1,    -1,    -1,  3170,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3057,    -1,  3059,
    1110,    -1,   349,  2899,    -1,    -1,    -1,  3067,  3068,    -1,
      -1,  2571,  3207,    -1,    -1,   291,    -1,  3212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3223,  3224,
    1381,    -1,    -1,    -1,  2594,    -1,    -1,    -1,    -1,    -1,
      -1,   349,    -1,    -1,    -1,   691,    -1,  3242,    -1,    -1,
      -1,    -1,    -1,  1228,    -1,    -1,  1407,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1239,  3260,    -1,  3262,   415,  1420,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3273,   426,
     427,    -1,   429,   430,   431,   432,   433,   434,    -1,    -1,
    1265,    -1,    -1,    -1,  3289,  1270,  1271,    -1,    -1,    -1,
      -1,    -1,   748,    -1,    -1,    -1,    -1,   415,    -1,  1284,
    3170,  1462,  1287,  3308,  1289,  1290,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,    84,    -1,
      -1,    -1,    -1,    -1,  3329,    -1,    -1,    -1,  1489,   415,
      -1,    -1,    -1,    -1,  3040,    -1,  2706,    76,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
    3355,    90,    -1,  1514,    -1,    -1,  1341,    -1,  1343,    98,
    3066,    -1,    -1,    -1,   103,    -1,    -1,   133,    -1,  1354,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   149,    -1,  1546,    -1,    -1,    -1,    -1,
    1551,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   854,    -1,
      -1,   167,    -1,  2773,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   879,    -1,    -1,    -1,    -1,    -1,    -1,
     196,   887,    -1,    -1,   890,   891,   202,    -1,    -1,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   215,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1381,    -1,    98,    -1,    -1,    -1,    -1,   103,   208,
      -1,   237,    -1,   212,    -1,    -1,    -1,    -1,    -1,  1464,
      -1,    -1,    -1,    74,    -1,    -1,    77,  1407,    -1,    -1,
      -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    89,    90,
    1420,    -1,    -1,    -1,    -1,   244,    -1,   963,   964,    -1,
    1671,    -1,    -1,    -1,    -1,    -1,   972,   973,    -1,   975,
      -1,   112,    -1,    -1,   980,   291,    -1,    -1,    -1,  2899,
      -1,    -1,    -1,    -1,    -1,    -1,   275,   128,    -1,   278,
      -1,   176,  1462,    -1,    -1,    -1,    -1,    -1,  1533,    -1,
      -1,    -1,   291,    -1,   293,   146,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   330,    -1,    -1,    -1,    -1,  1489,
     336,    -1,    -1,   208,    -1,   341,    -1,   212,    -1,    -1,
    3286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1575,  1576,    -1,    -1,  1514,    -1,   231,   232,    -1,    -1,
     366,   367,    -1,    -1,    -1,    -1,    -1,    -1,   199,   244,
     349,    -1,    -1,   379,    -1,   206,    -1,   208,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1546,   393,   219,    -1,
      -1,  1551,    -1,    -1,    -1,    -1,    -1,  3343,    -1,  1624,
    1625,  1626,    -1,   278,    -1,    -1,  1631,  1632,    -1,    -1,
      -1,  1636,  1637,    -1,    -1,    -1,   291,    -1,  1643,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1122,  1652,    -1,  1654,
    3040,    -1,    -1,    -1,    -1,    -1,   415,    -1,    -1,    -1,
      -1,    -1,  1667,    -1,  1669,    -1,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,  3066,  1858,  1859,    -1,
     439,    84,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   349,  1700,    -1,    -1,    -1,    90,
      -1,  1706,    -1,    -1,    -1,    -1,    -1,    98,    -1,  1714,
     321,   114,   103,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   126,    -1,  1730,    -1,    -1,    -1,    90,
     133,  1671,    -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,
      -1,    -1,   103,    -1,    -1,    -1,   149,   358,    -1,    -1,
     361,    -1,  1228,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     415,    -1,    -1,  1239,   167,    -1,  1947,    -1,    -1,    -1,
      -1,  1952,    -1,    -1,   429,   430,   431,   432,   433,   434,
      -1,    -1,    -1,    -1,    -1,    -1,  1967,    -1,    -1,    -1,
      -1,    -1,  1797,   196,  1270,  1271,    -1,    -1,  1803,    -1,
      -1,    -1,    -1,    -1,    76,    -1,    -1,  1812,  1284,    -1,
      -1,  1287,   215,  1289,  1290,    76,    -1,   208,    -1,    -1,
      -1,   212,    -1,    -1,    -1,    -1,    98,    -1,    -1,    90,
      -1,   103,    -1,    -1,    -1,   238,    -1,    98,    -1,    -1,
     231,   232,   103,    -1,    -1,    -1,    -1,   208,    -1,    -1,
      -1,   212,    -1,   244,    -1,    -1,    -1,  2038,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1341,    -1,  1343,    -1,    -1,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1358,   244,   275,    -1,  1362,   278,   291,    -1,
      -1,    -1,    -1,    -1,    -1,  1900,  3286,    -1,    -1,    -1,
     291,    -1,   293,  1908,   176,    -1,  1911,  1912,   311,    -1,
      -1,    -1,    -1,    -1,   275,    -1,    -1,   278,  1858,  1859,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     291,   334,   293,   336,    -1,    -1,   208,    -1,   341,    -1,
     212,   552,    -1,    -1,    -1,    -1,    -1,   208,  1953,    -1,
      -1,   212,  1957,  3343,    -1,    -1,  1961,    -1,   349,   231,
     232,    -1,    -1,   366,  1969,    -1,    -1,    -1,    -1,  1974,
     231,   232,   244,    -1,    -1,    -1,   379,    -1,    -1,    -1,
      -1,   384,    -1,   244,    -1,    -1,    -1,    -1,   349,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   402,
      -1,    -1,    -1,    -1,    -1,    -1,   278,  1947,    -1,    -1,
      -1,    -1,  1952,  2018,   275,    -1,    -1,   278,    -1,   291,
      -1,    -1,    -1,    -1,   415,    -1,    -1,  1967,    -1,    -1,
     291,    -1,   293,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,    -1,    -1,  2051,  2052,   439,    -1,
    2055,    -1,  2057,    -1,   415,    -1,    -1,  1533,    -1,    -1,
      -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,    -1,    -1,    -1,   349,   439,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   349,  2094,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2038,    -1,
     711,    76,    -1,    -1,   715,    -1,  2287,  2288,   719,  2290,
      -1,    -1,   723,    -1,    -1,    90,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    98,  2305,    -1,  2307,    -1,   103,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   752,    -1,   415,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2333,    -1,   415,  1631,    -1,   429,   430,   431,
     432,   433,   434,    -1,   425,   426,   427,    -1,   429,   430,
     431,   432,   433,   434,   785,    -1,    -1,   788,   439,    84,
      -1,    -1,  2363,   794,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2381,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,   114,
      -1,  2216,    -1,  2218,    -1,  2220,    90,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   133,   103,
      -1,    -1,    -1,   208,    -1,  2416,    -1,   212,    -1,    -1,
      -1,    -1,    -1,    -1,   149,    -1,  2427,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1730,    -1,   231,   232,    -1,    -1,
    2441,    -1,   167,    -1,    -1,    -1,    -1,    -1,    -1,   244,
      -1,    -1,    -1,   884,    -1,    -1,   887,    -1,   889,    -1,
      -1,   892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   196,    -1,   904,    -1,    -1,    -1,   202,    -1,    -1,
     275,    -1,    -1,   278,  2309,    -1,    -1,    -1,    -1,    -1,
     215,    -1,    -1,    -1,    -1,    -1,   291,    -1,   293,  2324,
      -1,    -1,    -1,    -1,    -1,  2330,  2331,  1803,    -1,    -1,
      -1,    -1,    -1,    -1,   208,    -1,    -1,  1813,   212,  1815,
    2521,  1817,    -1,    -1,    -1,    -1,    -1,  2287,  2288,    -1,
    2290,    -1,    -1,    -1,    -1,    -1,    -1,   231,   232,  2364,
    2365,    -1,    -1,  2544,    -1,  2305,    -1,  2307,  2373,    -1,
     244,    -1,    -1,    -1,   349,    -1,  2381,    -1,    -1,    -1,
      -1,  2386,    -1,  2388,    -1,    -1,   291,    -1,    -1,    -1,
    2571,    -1,    -1,  2333,  2399,  2400,    -1,    -1,    -1,    -1,
      -1,   275,    -1,    -1,   278,    -1,   311,    -1,    -1,    -1,
      -1,    -1,    -1,  2594,    -1,    -1,    -1,   291,    -1,   293,
      -1,  1897,    -1,  2363,    -1,   330,    -1,    -1,    -1,   334,
      -1,   336,    -1,    -1,  2439,  2440,   341,  1048,  1049,    -1,
     415,  2381,  1053,  2448,    -1,    -1,    -1,    -1,  1059,    -1,
     425,   426,   427,    -1,   429,   430,   431,   432,   433,   434,
      -1,   366,   367,    -1,   439,  1076,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,   349,  2416,  1953,    -1,   384,
      -1,  1957,    -1,    -1,    -1,  1961,    -1,  2427,   393,    -1,
    1101,    -1,    -1,  1969,    -1,    -1,    -1,   402,    -1,  1110,
      -1,  2441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2528,    -1,  2706,  2002,    -1,    -1,    -1,
      -1,    -1,    -1,  2538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   415,  2018,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,  1172,    -1,    -1,    -1,   439,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2582,    -1,    -1,
      -1,  2521,    -1,    -1,    -1,    -1,    -1,    -1,  1199,    -1,
      -1,    -1,  2773,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2544,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1223,  1224,    -1,  1226,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,
      -1,  2571,    -1,  1244,    -1,    -1,    -1,    -1,    -1,    -1,
      90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    98,    -1,
      -1,    -1,    -1,   103,  2594,    -1,    -1,    -1,    -1,  1270,
    1271,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1287,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1310,
      76,    -1,  1313,  1314,    -1,    -1,    -1,    -1,    -1,    -1,
    1321,  1322,  1323,    -1,  2719,  2720,    -1,    -1,  2899,    -1,
      -1,    -1,    98,    -1,    -1,    -1,    -1,   103,  2733,    -1,
    1341,    -1,    -1,  2738,  2739,  2740,  2741,  2742,    -1,    -1,
      -1,  2746,    -1,    -1,  2220,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   208,    -1,
      -1,  1372,   212,    -1,    -1,    -1,  2706,    -1,  1379,    -1,
    1381,    -1,    -1,  1384,    -1,    -1,    -1,  1388,    -1,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,  2796,    -1,    -1,   244,    -1,  1407,    -1,    -1,    -1,
     176,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1420,
      -1,  1422,    98,    -1,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   275,    -1,  2832,   278,    -1,
      -1,    -1,   208,  2773,  2310,  1446,   212,    -1,    -1,    -1,
    2316,   291,  2318,   293,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1462,    -1,    -1,    -1,   231,   232,    -1,    -1,  3040,
      -1,    -1,  1473,    -1,    -1,    -1,    -1,    -1,   244,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1489,    -1,
      -1,    -1,    -1,    -1,    -1,  3066,    -1,    -1,  2364,  2365,
     176,    -1,    -1,    -1,    -1,    -1,    -1,  2373,    -1,   349,
      -1,    -1,   278,  1514,    -1,  2381,    -1,    -1,    -1,    -1,
      -1,    -1,  2388,    -1,    -1,   291,    -1,  2922,  2923,    -1,
      -1,    -1,   208,  2399,  2400,    -1,   212,    -1,    -1,    -1,
      -1,  2936,    -1,  1544,    -1,  1546,    -1,    -1,    -1,    -1,
    1551,    -1,    -1,    -1,  2949,   231,   232,    -1,    -1,  2954,
      -1,  2956,  2957,    -1,    -1,    -1,  2961,    -1,   244,  2899,
      -1,    -1,    -1,  2439,  2440,   415,    -1,    -1,    -1,    -1,
    1581,    -1,    -1,   349,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,    -1,    -1,    -1,    -1,   439,
      -1,    -1,   278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1611,  1612,    -1,    -1,    -1,   291,    -1,    -1,  1619,    -1,
      -1,  1622,  1623,    -1,  3019,    -1,    -1,    -1,    -1,    -1,
    1631,    -1,    76,  1634,  1635,    -1,    -1,    -1,    -1,    -1,
      -1,  1642,    -1,    -1,    -1,  1646,  1647,  1648,  1649,   415,
      -1,    -1,    -1,    -1,    98,  1656,  1657,    -1,    -1,   103,
      -1,    -1,    -1,   429,   430,   431,   432,   433,   434,    -1,
    1671,  1672,  1673,   349,    -1,  1676,    -1,    -1,    -1,  1680,
      -1,    -1,    -1,  1684,    -1,    -1,  1687,  1688,  1689,  1690,
    1691,  1692,  1693,  1694,  1695,  1076,  1697,    90,    -1,    -1,
    1701,    -1,    -1,    -1,  1705,    -1,    -1,    -1,    -1,    -1,
    3040,    -1,    -1,    -1,  3109,  3286,  2582,    -1,    -1,   112,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1110,
      -1,    -1,   176,  1076,    -1,    -1,  3066,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,  1746,    -1,    -1,    76,    82,
    3145,    -1,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,    90,    -1,   208,    -1,    -1,  1110,   212,    -1,
      98,    -1,  3343,    -1,    -1,   103,    -1,    -1,    -1,  1780,
      -1,  1782,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,
      -1,    -1,    -1,    -1,  2660,    -1,    -1,   130,    -1,    -1,
     244,    -1,    -1,    -1,   137,   138,   199,    -1,    -1,    -1,
      -1,    -1,    -1,   206,    -1,   208,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1825,    -1,   219,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   278,    -1,    -1,    -1,    -1,  1840,
      -1,   174,    -1,    76,  3239,    -1,    -1,   291,  3243,    -1,
      -1,    -1,    -1,  2719,  2720,    -1,    -1,  1858,  1859,    -1,
      -1,    -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,    -1,
     103,    -1,  2738,  2739,  2740,  2741,  2742,    -1,    -1,   212,
     208,    -1,    -1,   216,   212,    -1,    -1,    -1,    -1,  3284,
    3285,    -1,    -1,    -1,  3289,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,   349,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,
     253,    -1,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
    2796,    -1,    98,    -1,  3329,   268,   269,   103,   271,   272,
      -1,   274,    -1,   176,    -1,  1946,  1947,   275,    -1,    -1,
     278,  1952,    -1,    -1,    -1,    -1,  3286,    -1,    -1,    -1,
    3355,    -1,    -1,   291,  1965,   293,  1967,    -1,   301,    -1,
      -1,   415,    -1,    -1,    -1,   208,    -1,    -1,    -1,   212,
      -1,    -1,    -1,    -1,    -1,   429,   430,   431,   432,   433,
     434,    -1,    -1,    -1,    -1,    -1,    -1,   330,   231,   232,
    1381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   244,    -1,  3343,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   349,    -1,    -1,    -1,  2026,  1407,    -1,    -1,   362,
      -1,   364,    -1,    -1,  2035,    -1,    -1,  2038,  1381,  1420,
      -1,    -1,   208,    -1,    -1,   278,   212,    -1,    -1,    -1,
      -1,    -1,    -1,   386,    -1,    -1,  2922,  2923,   291,    -1,
     393,    -1,    -1,   396,  1407,   231,   232,    -1,    -1,    -1,
    2071,    -1,    -1,    -1,    -1,    -1,    -1,  1420,   244,    -1,
      -1,  1462,    -1,    -1,    -1,    -1,    -1,   415,  2954,    -1,
    2956,  2957,    -1,    -1,  2095,  2961,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,  1489,   275,
      -1,   439,   278,    -1,    -1,    -1,   349,    -1,    -1,  1462,
      -1,    -1,    -1,    -1,    -1,   291,  2127,   293,    -1,  2130,
      -1,    -1,    -1,  1514,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2142,  2143,  2144,  2145,    -1,  1489,    -1,    -1,    -1,
    2151,    -1,    -1,  3019,    -1,    -1,    -1,    -1,    -1,    -1,
    2161,  2162,    -1,  2164,    -1,  1546,    -1,    -1,    -1,    -1,
    1551,  1514,    -1,    -1,    -1,  2176,    -1,  2178,    -1,    -1,
      -1,  2182,   415,   349,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   429,   430,   431,   432,
     433,   434,    -1,  1546,  2205,    -1,  2207,  2208,  1551,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2231,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2239,  2240,
    2241,    -1,    -1,  3109,    -1,    -1,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,  2270,
      -1,   437,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3145,
      -1,    -1,    -1,    -1,    -1,    -1,  2287,  2288,    -1,  2290,
    1671,    -1,    -1,    -1,    -1,    76,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2305,    -1,  2307,    -1,    -1,    90,
      -1,    -1,    -1,    94,    -1,    -1,    -1,    98,   711,    -1,
      -1,    -1,   103,    -1,    -1,    -1,   719,    -1,  1671,    -1,
     723,    -1,  2333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   752,
      -1,    -1,  2363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3239,  3240,    -1,    -1,  3243,  3244,  2380,
    2381,    -1,   163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      76,    -1,    -1,    -1,    -1,   788,    -1,    -1,    -1,    -1,
      -1,   794,    -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    98,    -1,    -1,  2416,    -1,   103,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2427,   208,    -1,    -1,
      -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2441,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     231,   232,    -1,    -1,  2455,    -1,    -1,    -1,  2459,    -1,
      -1,    -1,  2463,   244,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1858,  1859,    -1,
      -1,    -1,    -1,    -1,  2485,    -1,    -1,    -1,    -1,    -1,
      -1,   884,    -1,    -1,   275,    -1,   889,   278,    -1,   892,
      -1,    -1,    -1,   189,    -1,    -1,    -1,    -1,   194,    -1,
     291,  2512,   293,    -1,    -1,  1858,  1859,  2518,    -1,    -1,
    2521,    -1,   208,    -1,    -1,    -1,   212,    -1,    -1,  2530,
      -1,    -1,    -1,    -1,    -1,  2536,    -1,    -1,    -1,  2540,
      -1,    -1,    -1,  2544,  2545,   231,   232,  2548,  2549,  2550,
    2551,  2552,  2553,  2554,  2555,  2556,  2557,    -1,   244,    -1,
      -1,  2562,  2563,    -1,    -1,    -1,  1947,    -1,   349,    -1,
    2571,  1952,    -1,    -1,    -1,  2576,    -1,    -1,    -1,    -1,
      -1,    -1,  2583,    -1,    -1,  2586,  1967,  2588,    -1,   275,
      -1,    -1,   278,  2594,  2595,  2596,  2597,    -1,    -1,    -1,
    2601,    -1,    -1,  2604,  1947,   291,    -1,   293,    -1,  1952,
      -1,    -1,    -1,   394,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1967,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   415,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   425,   426,   427,  2648,   429,   430,
     431,   432,   433,   434,    -1,  1048,  1049,  2038,    -1,    -1,
    1053,    -1,    -1,   349,    -1,    -1,  1059,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1076,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2038,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2706,    -1,    -1,  1101,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1110,   136,    -1,
      -1,    -1,    -1,    -1,    -1,    82,    -1,    -1,    -1,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   177,
      -1,  2762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   189,  2773,    -1,    -1,    -1,   194,    -1,    76,  1172,
      -1,   199,    -1,    -1,   202,    -1,   204,    -1,    -1,    -1,
      -1,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,   158,    -1,    -1,    -1,   103,  1199,    -1,    -1,   227,
      -1,    -1,    -1,  2814,    -1,    -1,    -1,    -1,  2819,    -1,
      -1,   178,  2823,   180,    -1,    -1,    -1,   245,    -1,    -1,
    1223,  1224,    -1,  1226,    -1,    -1,    -1,    -1,    -1,    -1,
    2841,    -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1244,  2853,    -1,    -1,    -1,    90,    -1,    -1,    93,
      -1,    -1,    -1,    -1,    98,    -1,    -1,    -1,   286,   103,
      -1,    -1,    -1,    -1,    -1,    -1,   294,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2894,  2895,    -1,    -1,    -1,  2899,    -1,
      -1,    -1,    -1,    -1,  2905,  2906,  2287,  2288,  2909,  2290,
     208,    -1,    -1,    -1,   212,    -1,    -1,  1310,    -1,    -1,
    1313,  1314,    -1,    -1,  2305,    -1,  2307,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2287,  2288,   244,  2290,   366,    -1,
      -1,    -1,  2333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2305,    -1,  2307,    -1,    -1,    -1,    -1,   387,
      -1,    -1,    -1,    -1,   208,    -1,    -1,   275,   212,    -1,
     278,  2982,  2363,    -1,    -1,    -1,    -1,   405,  1381,    -1,
    2333,  1384,    -1,   291,    -1,  1388,    -1,   231,   232,    -1,
    2381,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     244,    -1,    -1,    -1,  1407,    -1,    -1,  3018,   436,    -1,
    2363,   439,   440,   441,    -1,    -1,    -1,  1420,    -1,  1422,
    3031,    -1,    -1,    -1,  3035,  2416,    -1,    -1,  2381,  3040,
      -1,   275,    -1,    -1,   278,    -1,  2427,  3048,    -1,    -1,
      -1,   349,    -1,  1446,    -1,    -1,  3057,   291,  3059,   293,
    2441,    -1,    -1,    -1,    -1,  3066,  3067,  3068,    -1,  1462,
    3071,    -1,    -1,  2416,    -1,    -1,    -1,  3078,  3079,    -1,
    1473,    -1,    -1,    -1,  2427,    -1,    -1,  3088,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1489,    -1,  2441,    -1,
      -1,    -1,    -1,    -1,    -1,  3106,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   349,    -1,   415,    -1,  3120,
      -1,  1514,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,    -1,    -1,
    2521,    -1,    -1,    -1,    -1,    -1,    -1,  3148,    -1,    -1,
      -1,  1544,    -1,  1546,    -1,    -1,    -1,    -1,  1551,    -1,
      -1,    -1,    -1,  2544,    -1,    -1,    -1,    -1,    -1,  3170,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2521,    -1,
      -1,   415,    -1,    -1,    -1,    -1,    -1,    -1,  1581,    -1,
    2571,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,  2544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    76,    -1,  2594,    -1,    -1,    -1,    -1,  1611,  1612,
      -1,    -1,  3223,    -1,    -1,    90,  1619,    -1,  2571,  1622,
    1623,    -1,    -1,    98,    -1,  3236,    -1,    -1,   103,    -1,
      -1,  1634,  1635,    -1,    -1,    -1,    -1,    -1,    -1,  1642,
      -1,  2594,    -1,  1646,  1647,  1648,  1649,    -1,    -1,    -1,
      -1,    -1,    -1,  1656,  1657,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1671,  1672,
    1673,    -1,    -1,  1676,    -1,  3286,    -1,  1680,    -1,    -1,
      -1,  1684,    -1,    -1,  1687,  1688,  1689,  1690,  1691,  1692,
    1693,  1694,  1695,    -1,  1697,    -1,  3307,    -1,  1701,    -1,
      -1,    -1,  1705,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2706,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3340,
      -1,    -1,  3343,   208,    -1,    -1,   136,   212,    -1,  1076,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2706,    -1,    -1,   231,   232,   138,    -1,
      -1,    76,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   244,
      -1,    -1,    -1,  1110,    -1,    90,    -1,   177,    93,    -1,
      -1,   748,  2773,    98,    -1,    -1,    -1,    -1,   103,   189,
      -1,    -1,    -1,    -1,   194,    -1,    -1,   177,    -1,   199,
     275,    -1,   202,   278,   204,   185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   291,    -1,   293,    -1,
    2773,    -1,  1825,    -1,    -1,    -1,    -1,   227,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1840,    -1,    -1,
     220,   221,    -1,    -1,    -1,   245,    -1,    -1,    -1,   816,
      -1,   818,    -1,   820,    -1,  1858,  1859,    -1,    -1,   826,
     827,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   286,   854,    -1,    -1,
      -1,    -1,    -1,   208,   294,    -1,    -1,   212,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2899,    -1,
      -1,    -1,   879,    -1,    -1,    -1,   231,   232,    -1,   394,
      -1,    -1,    -1,   890,   891,    -1,    -1,    -1,    -1,   244,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     415,    -1,    -1,  1946,  1947,    -1,  2899,    -1,    -1,  1952,
     425,   426,   427,    -1,   429,   430,   431,   432,   433,   434,
     275,    -1,  1965,   278,  1967,    -1,   366,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   291,    -1,   293,   946,
      -1,    -1,    -1,    -1,  1076,    -1,    -1,   387,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   963,   964,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   405,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   980,    -1,    -1,    -1,    -1,  1110,    -1,
      -1,    -1,    -1,  2026,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2035,    -1,   349,  2038,   436,    -1,    -1,   439,
     440,   441,    -1,    -1,  1381,    -1,    -1,    -1,    -1,  3040,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2071,    -1,
    1407,    -1,    -1,    -1,    -1,  3066,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1420,    -1,    -1,    -1,  3040,    -1,    -1,
      -1,    -1,  2095,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     415,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     425,   426,   427,  3066,   429,   430,   431,   432,   433,   434,
      -1,    -1,    -1,    -1,  2127,  1462,    -1,  2130,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2142,
    2143,  2144,  2145,    -1,    -1,    -1,    84,    -1,  2151,    -1,
      -1,    -1,  1489,    -1,    -1,  1122,    -1,    95,  2161,  2162,
      -1,  2164,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2176,    -1,  2178,   114,  1514,    -1,  2182,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   131,    -1,   133,    -1,    -1,    -1,    -1,
      -1,    -1,  2205,    -1,  2207,  2208,    -1,    -1,    -1,  1546,
      -1,   149,    -1,    -1,  1551,    -1,    -1,   155,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2231,   167,
      -1,    -1,    -1,    -1,    -1,    -1,  2239,  2240,  2241,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   196,    -1,
     198,  1228,    -1,    -1,   202,    -1,    -1,  2270,    -1,    -1,
      -1,    -1,  1239,    -1,    -1,    -1,    -1,   215,    -1,    -1,
      -1,    -1,    -1,    -1,  2287,  2288,    -1,  2290,    -1,  1381,
      -1,    -1,    -1,    -1,    -1,  3286,    -1,    -1,    -1,   237,
      -1,    -1,  2305,    -1,  2307,    -1,    -1,    -1,    -1,    -1,
     248,    -1,    -1,    -1,    -1,  1407,    -1,  1284,    -1,    -1,
    1287,    -1,  1289,  1290,    -1,    -1,    -1,    -1,  1420,    -1,
    2333,    -1,    -1,  3286,  1671,    -1,    -1,    -1,    -1,   719,
      -1,    -1,    -1,   723,    -1,   725,    -1,    -1,    -1,    -1,
     730,   731,  3343,   291,    -1,   293,    -1,    -1,    -1,    -1,
    2363,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1462,   751,   752,   311,    -1,    -1,  1343,  2380,  2381,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1354,    76,    -1,
    3343,    -1,   330,    -1,    -1,    -1,   334,  1489,   336,    -1,
      -1,    -1,    90,    -1,    -1,    -1,    -1,   787,   788,    -1,
      98,    -1,    -1,  2416,   794,   103,    -1,    -1,    -1,    -1,
      -1,    -1,  1514,    -1,  2427,    -1,    -1,    -1,    -1,   367,
     368,    -1,   370,    -1,    -1,    -1,    -1,    -1,  2441,    -1,
      -1,   379,    -1,    -1,    -1,   383,   384,    -1,    -1,    -1,
     388,    -1,  2455,    -1,  1546,   393,  2459,    -1,    -1,  1551,
    2463,    -1,    -1,    -1,   844,    -1,    -1,    -1,    -1,    -1,
     850,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     860,    -1,  2485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1464,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2512,
      -1,    -1,    -1,    -1,    -1,  2518,    -1,    -1,  2521,    -1,
     208,  1858,  1859,   903,   212,    -1,    -1,  2530,   908,    -1,
      -1,    -1,    -1,  2536,    -1,    -1,    -1,  2540,    -1,   919,
      -1,  2544,  2545,   231,   232,  2548,  2549,  2550,  2551,  2552,
    2553,  2554,  2555,  2556,  2557,    -1,   244,    -1,    -1,  2562,
    2563,    -1,    -1,    -1,    -1,    -1,  1533,    -1,  2571,    -1,
      -1,    -1,    -1,  2576,    -1,    -1,    -1,    -1,    -1,  1671,
    2583,    -1,    -1,  2586,    -1,  2588,    -1,   275,    -1,    92,
     278,  2594,  2595,  2596,  2597,    -1,    -1,    -1,  2601,   102,
      -1,  2604,    -1,   291,    -1,   293,    -1,    -1,    -1,    -1,
    1947,    -1,    -1,    -1,   302,  1952,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1967,    -1,    -1,    -1,   137,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   147,  2648,    -1,   150,    -1,    -1,
      -1,   154,    -1,    -1,    -1,   158,    -1,  1624,  1625,  1626,
      -1,   349,    -1,    -1,  1631,  1632,    -1,    76,    -1,  1636,
    1637,    -1,  1052,  1053,    -1,    -1,  1643,   180,    -1,  1059,
      -1,    90,    -1,    -1,    93,  1652,    -1,  1654,    -1,    98,
      -1,    -1,   195,    -1,   103,    -1,    -1,    -1,    -1,    -1,
    1667,  2038,  1669,  2706,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1095,  1096,  1097,    -1,    -1,
      -1,  1101,    -1,    -1,    -1,    -1,    -1,   415,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    76,  2762,
      -1,    -1,    -1,  1730,    -1,  1145,  1858,  1859,    -1,    -1,
    2773,    -1,    90,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    -1,    -1,  1163,    -1,   103,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1076,    -1,   208,
      -1,    -1,    -1,   212,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2814,    -1,    -1,    -1,    -1,  2819,    -1,    -1,    -1,
    2823,    -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,
    1797,  1110,    -1,    -1,    -1,   244,  1803,    -1,  2841,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1813,    -1,    -1,    -1,
    2853,    -1,    -1,    -1,    -1,  1947,    -1,    -1,    -1,    -1,
    1952,   364,    -1,    -1,    -1,    -1,   275,    -1,    -1,   278,
      -1,    -1,    -1,    -1,    -1,  1967,   194,    -1,    -1,    -1,
      -1,    -1,   291,    -1,   293,    -1,    -1,    -1,    -1,    -1,
     208,  2894,  2895,    -1,   212,    -1,  2899,    -1,    -1,    -1,
      -1,    -1,  2905,  2906,    -1,    -1,  2909,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,    -1,    -1,  1297,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   244,    -1,    -1,    -1,
      -1,    -1,    -1,  1900,    -1,    -1,    -1,    -1,    -1,    -1,
     349,  1908,    -1,    -1,  1911,  1912,  2038,    -1,    -1,    -1,
    2287,  2288,    -1,  2290,    -1,    -1,    -1,   275,    -1,    -1,
     278,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2305,    -1,
    2307,    -1,    -1,   291,    -1,   293,    -1,    -1,    -1,  2982,
      -1,    -1,    -1,    -1,    -1,    -1,  1953,    -1,    -1,    -1,
    1957,    -1,    -1,    -1,  1961,    -1,  2333,    -1,    -1,    -1,
      -1,    -1,  1969,    -1,    -1,    -1,   415,  1974,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3018,   425,   426,   427,    -1,
     429,   430,   431,   432,   433,   434,  2363,    -1,  3031,    -1,
      -1,   349,  3035,    -1,    -1,    -1,    -1,  3040,    -1,    -1,
      -1,    -1,    -1,    -1,  2381,  3048,    -1,    -1,    -1,    -1,
      -1,  2018,    -1,    -1,  3057,    -1,  3059,    -1,    -1,    -1,
      -1,    -1,  1442,  3066,  3067,  3068,    -1,    -1,  3071,    -1,
      -1,    -1,    -1,    -1,    -1,  3078,  3079,    -1,    -1,  2416,
      -1,    -1,    -1,    -1,    -1,  3088,    -1,    -1,    -1,    -1,
    2427,    -1,    -1,   596,   597,    -1,    -1,   415,    -1,    -1,
      -1,    -1,  1381,  3106,  2441,    -1,    -1,   425,   426,   427,
      -1,   429,   430,   431,   432,   433,   434,  3120,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2094,  1407,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1420,    -1,    -1,    -1,  3148,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1544,    -1,    -1,  3170,    -1,    -1,
      -1,    -1,  1552,  1553,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1462,  2521,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   199,    -1,  2287,  2288,    -1,  2290,    -1,
     206,  1581,   208,    -1,  1584,    -1,    -1,  2544,    -1,    -1,
    1489,    -1,    -1,  2305,    -1,  2307,  1596,    -1,    -1,    -1,
    3223,    -1,    -1,   726,    -1,    -1,   729,    -1,    -1,   732,
     733,    -1,    -1,  3236,  2571,  1514,    -1,    -1,    -1,    -1,
      -1,  2333,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     753,  2218,    -1,  2220,    -1,    -1,    -1,  2594,    -1,    -1,
      -1,    -1,    -1,   766,    -1,    -1,   769,  1546,    -1,    -1,
      -1,  2363,  1551,    -1,    -1,    -1,    -1,   780,   781,    -1,
      -1,    -1,    -1,  3286,    -1,    -1,   789,    -1,    -1,  2381,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   800,    -1,    -1,
      -1,   804,   805,    -1,  3307,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1700,    -1,    -1,    -1,  2416,   828,   829,    -1,    -1,    -1,
      -1,    -1,   835,    -1,    -1,  2427,    -1,  3340,    -1,    -1,
    3343,    -1,  2309,    -1,    -1,    -1,    -1,    -1,    -1,  2441,
      -1,    -1,  1076,   856,    -1,   858,    -1,  2324,    -1,    -1,
      -1,    -1,    -1,  2330,  2331,    -1,    -1,    -1,    -1,  2706,
      -1,    -1,  1752,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   886,    -1,    -1,  1110,    -1,    -1,    -1,
      -1,    -1,  1671,    -1,    -1,    -1,    -1,  2364,  2365,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2373,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2381,    -1,    -1,    -1,    -1,  2386,
      -1,  2388,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2521,
      -1,    -1,  2399,  2400,    -1,    -1,  2773,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2439,  2440,    -1,    -1,    -1,    -1,    -1,  2571,
       5,    -1,    -1,    -1,    -1,   988,    -1,    -1,   991,    -1,
      -1,   994,    -1,    -1,    19,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2594,    28,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    39,    40,    -1,    -1,    -1,    -1,
      45,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1063,  2528,  2899,    -1,  1067,    -1,    -1,    -1,  1071,    -1,
      -1,  2538,    -1,    -1,  1077,    -1,    -1,    -1,    -1,  1858,
    1859,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1102,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1989,
      -1,    -1,    -1,    -1,  2706,  2582,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2012,    -1,  1137,    -1,    -1,    -1,    -1,  2019,
      -1,    -1,    -1,    -1,    -1,    -1,  2026,    -1,  1151,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1381,    -1,    -1,
      -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,  1947,    -1,
      -1,    -1,    -1,  1952,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2773,   207,  1407,    -1,    -1,    -1,    -1,  1967,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1420,    -1,    -1,    -1,
     225,    -1,    -1,  3040,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   719,    -1,    -1,    -1,   723,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3066,
      -1,   256,    -1,    -1,   259,    -1,    -1,    -1,  1462,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,    -1,
      -1,    -1,  2719,  2720,    -1,   280,    -1,    -1,    -1,  2038,
      -1,    -1,    -1,    -1,    -1,  1489,  2733,    -1,    -1,    -1,
      -1,  2738,  2739,  2740,  2741,  2742,    -1,    -1,    -1,  2746,
      -1,    -1,   788,    -1,    -1,    -1,    -1,    -1,   794,    -1,
    1514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2899,    -1,    -1,
      -1,    -1,    -1,   338,    -1,    -1,    -1,    -1,    -1,  2199,
      -1,    -1,  1546,    -1,    -1,  2205,    -1,  1551,    -1,  2796,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   374,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1374,    -1,    -1,   399,    -1,    -1,    -1,   884,    -1,
      -1,    -1,    -1,   889,    -1,   410,   892,    -1,   413,   414,
      -1,   416,    -1,   418,    -1,    -1,    -1,   422,    -1,   424,
     425,    -1,    -1,    -1,   429,   430,   431,   432,   433,    -1,
      -1,   436,   437,   438,   439,    -1,   441,   442,   443,    -1,
     445,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1671,  3040,  3286,
      -1,    -1,    -1,    -1,    -1,    -1,  2923,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2936,
      -1,    -1,    -1,    -1,  3066,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2949,    -1,    -1,    -1,    -1,  2954,    -1,  2956,
    2957,    -1,    -1,    -1,  2961,    -1,    76,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3343,    -1,  2287,  2288,
      90,  2290,    -1,    -1,    -1,    -1,    -1,    -1,    98,  1522,
      -1,    -1,    -1,   103,    -1,    -1,  2305,    -1,  2307,    -1,
      -1,    -1,  2412,    -1,    -1,    -1,    -1,    -1,  2418,    -1,
      -1,    -1,  1048,    -1,    -1,    -1,  1549,  1053,    -1,    -1,
      -1,    -1,  3019,  1059,  2333,    -1,    -1,    -1,    -1,  1562,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1076,    -1,    -1,    -1,    -1,  2455,    -1,    -1,    -1,  2459,
      -1,    -1,    -1,  2463,  2363,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1101,    -1,    -1,    -1,    -1,
      -1,    -1,  2381,    -1,  1110,  2485,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2507,   208,    -1,
      -1,    -1,   212,    -1,  1858,  1859,    -1,  2416,    -1,    -1,
      -1,    -1,  3109,    -1,    -1,    -1,    -1,    -1,  2427,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2441,    -1,   244,    -1,  1172,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3145,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1199,  3286,   275,    -1,    -1,   278,    -1,
      76,    -1,    -1,  1706,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   291,    -1,   293,    90,    -1,    -1,  1223,  1224,    -1,
    1226,    -1,    98,  1947,    -1,    -1,    -1,   103,  1952,    -1,
      -1,  2611,  2612,    -1,    -1,    -1,    -1,    -1,  1244,    -1,
      -1,    -1,  2521,  1967,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3343,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2544,    -1,    -1,    -1,   349,
      -1,    -1,  3239,    -1,    -1,    -1,  3243,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   371,  2571,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1310,    -1,    -1,  1313,  1314,  1812,
      -1,    -1,    -1,    -1,  2038,  2594,    -1,  3284,  3285,    -1,
    1823,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1831,    -1,
      -1,    -1,   208,    -1,  1837,   415,   212,    -1,    -1,  1842,
      -1,    -1,    -1,    -1,    -1,   425,   426,   427,    -1,   429,
     430,   431,   432,   433,   434,   231,   232,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2745,    -1,    -1,   244,    -1,
      -1,  1874,  1875,    -1,  1877,  1381,    -1,    -1,    -1,    -1,
      -1,    -1,  1388,    -1,    -1,    -1,    -1,    -1,  2768,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2776,    -1,    -1,   275,
      -1,  1407,   278,  1906,  1907,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1420,   291,  1422,   293,  1921,    -1,
    1923,  1924,    -1,  1926,  1927,  1928,  1929,  2706,    -1,    -1,
    1933,    -1,    -1,  1936,  2814,    -1,    -1,    -1,    -1,  2819,
    1446,    -1,    -1,  2823,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1462,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   349,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1489,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2773,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1514,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2911,  2912,  2913,  2914,    -1,    -1,    -1,  1544,   415,
    1546,    -1,    -1,    -1,    -1,  1551,    -1,    -1,  2051,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,    -1,
      -1,    -1,    -1,  2287,  2288,    -1,  2290,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1581,    -1,    -1,    -1,    -1,
      -1,  2305,    -1,  2307,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1611,  1612,    -1,    -1,  2333,
      -1,    -1,    -1,  1619,    -1,    -1,  1622,  1623,    -1,    -1,
    2899,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1634,  1635,
      -1,    -1,    -1,    -1,    -1,    -1,  1642,    -1,  3018,  2363,
    1646,  1647,  1648,  1649,    -1,    -1,    -1,    -1,    -1,    -1,
    1656,  1657,    -1,    -1,    -1,  3035,    -1,  2381,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1671,  1672,    -1,    -1,    -1,
    1676,    -1,    -1,    -1,  1680,    -1,    -1,    -1,  1684,    -1,
      -1,  1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,
      -1,  1697,  2416,    -1,    -1,  1701,    -1,    -1,    -1,  1705,
      -1,    -1,    -1,  2427,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2441,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3120,    -1,  3122,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3140,  3040,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3155,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3066,    -1,    -1,
      -1,  2294,  2295,    -1,    -1,    -1,    -1,  2521,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2544,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1840,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3223,    -1,    -1,    -1,  2571,    -1,    -1,
      -1,    -1,  1858,  1859,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2594,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2401,  2402,
    2403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3307,    -1,    -1,
      -1,    -1,    -1,  2436,    -1,    -1,    -1,    -1,    -1,    -1,
    1946,  1947,    -1,    -1,    -1,  2448,  1952,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1965,
    3340,  1967,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3286,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2026,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2035,
      -1,    -1,  2038,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,    -1,  2773,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,    -1,    -1,
      -1,    -1,    -1,    -1,  3343,  2071,    28,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    -1,
      -1,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,  2095,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2127,    -1,    -1,  2130,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2142,  2143,  2144,  2145,
      -1,    -1,    -1,    -1,    -1,  2151,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,  2161,  2162,    -1,  2164,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2176,    -1,  2178,    -1,    -1,  2899,  2182,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2205,
      -1,  2207,  2208,    -1,    -1,    -1,    -1,  2710,  2711,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2231,   188,    -1,    -1,    -1,
      -1,    -1,    -1,  2239,  2240,  2241,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2761,    -1,
      -1,    -1,    -1,   225,  2270,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   719,    -1,    -1,    -1,   723,    -1,
      -1,  2287,  2288,    -1,  2290,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,   259,    -1,  2305,
      -1,  2307,    -1,    -1,    -1,    -1,    -1,   752,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3040,    -1,   280,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2333,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3066,   788,    -1,    -1,    -1,    -1,    -1,   794,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2363,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2381,   338,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2416,    -1,   374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2427,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,
      -1,  2934,  2935,    -1,    -1,  2441,    -1,   399,    -1,   884,
      -1,  2944,    -1,    -1,    -1,    -1,    -1,    -1,   410,  2455,
      -1,   413,   414,  2459,   416,    -1,    -1,  2463,    -1,    -1,
     422,    -1,   424,   425,    -1,    -1,    -1,   429,   430,   431,
     432,   433,    -1,    -1,   436,   437,   438,    -1,    -1,  2485,
     442,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,
    3013,    -1,  2518,    -1,    -1,  2521,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2530,    -1,    -1,    -1,    -1,    -1,
    2536,    -1,    -1,    -1,  2540,    -1,    -1,    -1,  2544,  2545,
      -1,    -1,  2548,  2549,  2550,  2551,  2552,  2553,  2554,  2555,
    2556,  2557,    -1,    -1,    -1,    -1,  2562,  2563,    -1,    -1,
      -1,    -1,  3286,    -1,    -1,  2571,    -1,    -1,    -1,    -1,
    2576,    -1,    -1,    -1,    -1,    -1,    -1,  2583,    -1,    -1,
    2586,    -1,  2588,    -1,    -1,    -1,    -1,    -1,  2594,  2595,
    2596,  2597,    -1,    -1,    -1,  2601,    -1,    -1,  2604,    -1,
      -1,    -1,    -1,  1048,    -1,    -1,    -1,    -1,  1053,    -1,
      -1,    -1,    -1,    -1,  1059,    -1,    -1,    -1,    -1,  3343,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1076,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2648,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1101,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1110,    -1,    -1,   884,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2706,    -1,    -1,    -1,  3207,    -1,    -1,    -1,    -1,  3212,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1172,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1199,    -1,  2762,  3260,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2773,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1223,  1224,
      -1,  1226,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1244,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2814,    -1,
      -1,    -1,    -1,  2819,    -1,    -1,    -1,  2823,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1048,    -1,    -1,  2841,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2853,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1310,    -1,    -1,  1313,  1314,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2894,  2895,
      -1,    -1,    -1,  2899,    -1,    -1,    -1,    -1,    -1,  2905,
    2906,    -1,    -1,  2909,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1172,    -1,    -1,    -1,
      -1,    -1,  1407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1420,  2982,    -1,    -1,    -1,
      -1,    -1,    -1,  1199,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1223,  1224,    -1,
    1226,    -1,  3018,    -1,    -1,    -1,    -1,  1462,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3031,    -1,    -1,  1244,  3035,
      -1,    -1,    -1,    -1,  3040,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3048,    -1,  1489,    -1,    -1,    -1,    -1,    -1,
      -1,  3057,    -1,  3059,    -1,    -1,    -1,    -1,    -1,    -1,
    3066,  3067,  3068,    -1,    -1,  3071,    -1,    -1,    -1,  1514,
      -1,    -1,  3078,  3079,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3088,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1310,    -1,    -1,  1313,  1314,  1544,
    3106,  1546,    -1,    -1,    -1,    -1,  1551,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1581,    -1,    -1,    -1,
      -1,    -1,  3148,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3170,    -1,  1611,  1612,    -1,    -1,
      -1,    -1,    -1,    -1,  1619,    -1,    -1,  1622,  1623,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1634,
    1635,    -1,    -1,    -1,    -1,    -1,    -1,  1642,    -1,    -1,
      -1,  1646,  1647,  1648,  1649,    -1,    -1,    -1,    -1,    -1,
      -1,  1656,  1657,    -1,    -1,    -1,    -1,  3223,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1671,  1672,    -1,    -1,
    3236,  1676,    -1,    -1,    -1,  1680,    -1,    -1,    -1,  1684,
      -1,    -1,  1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,
    1695,    -1,  1697,    -1,    -1,    -1,  1701,    -1,    -1,    -1,
    1705,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3340,    -1,    -1,  3343,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1840,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1619,    -1,    -1,    -1,  1623,    -1,    -1,
      -1,    -1,    -1,  1858,  1859,    -1,    -1,    -1,    -1,     3,
      -1,    -1,    -1,    -1,    -1,     9,  1642,    -1,    -1,    -1,
    1646,    -1,    16,  1649,    18,    -1,    -1,    21,    -1,    -1,
    1656,  1657,    -1,    -1,    -1,    -1,    -1,    -1,    32,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1672,    -1,    -1,    -1,
    1676,    -1,    -1,    -1,  1680,    -1,    50,    51,  1684,    -1,
      -1,  1687,  1688,  1689,  1690,  1691,  1692,  1693,  1694,  1695,
      -1,  1697,    -1,    -1,    -1,  1701,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    77,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1946,  1947,    87,    88,    89,    -1,  1952,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   102,    -1,
    1965,    -1,  1967,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,   122,   123,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,    -1,
      -1,   135,   136,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   149,    -1,   151,    -1,    -1,
     154,    -1,    -1,    -1,    -1,    -1,   160,    -1,    -1,    -1,
      -1,  2026,    -1,    -1,    -1,   169,    -1,    -1,    -1,    -1,
    2035,   175,    -1,  2038,    -1,    -1,   180,    -1,   182,  1240,
      -1,    -1,   186,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   197,    -1,   199,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1840,    -1,  2071,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   223,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2095,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   246,   247,    -1,    -1,    -1,    -1,   252,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   260,    -1,    -1,    -1,
      -1,    -1,  2127,    -1,    -1,  2130,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   277,    -1,    -1,    -1,  2142,  2143,  2144,
    2145,    -1,    -1,    -1,    -1,    -1,  2151,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2161,  2162,    -1,  2164,
      -1,    -1,   306,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1946,  2176,    -1,  2178,   318,    -1,   320,  2182,    -1,    -1,
     324,    -1,    -1,    -1,   328,    -1,    -1,   331,    -1,  1965,
      -1,   335,    -1,    -1,    -1,    -1,   340,    -1,    -1,    -1,
    2205,   345,  2207,  2208,   348,    -1,    -1,    -1,    -1,    -1,
     354,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2239,  2240,  2241,    -1,   382,    -1,
     384,    -1,    -1,    -1,    -1,    -1,   390,    -1,   392,    -1,
      -1,   395,    -1,    -1,  1455,    -1,    -1,    -1,    -1,  2035,
      -1,    -1,    -1,    -1,    -1,  2270,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2287,  2288,    -1,  2290,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   438,  2071,    -1,    -1,    -1,    -1,
    2305,    -1,  2307,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2095,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2333,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2363,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2142,    -1,  2144,  2145,
      -1,    -1,    -1,    -1,    -1,  2151,  2381,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2176,    -1,  2178,    -1,    -1,    -1,  2182,    -1,    -1,    -1,
      -1,  2416,    -1,    -1,    -1,    -1,  1617,    -1,    -1,    -1,
      -1,    -1,  2427,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2441,    -1,    -1,    -1,
    1641,    -1,    -1,    -1,    -1,    -1,  1647,    -1,    -1,    -1,
    2455,    -1,    -1,    -1,  2459,  2231,    -1,    -1,  2463,  1660,
    1661,    -1,  1663,  2239,  2240,  2241,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2485,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2270,    -1,    -1,    -1,  1699,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,
      -1,    -1,    -1,  2518,    -1,    -1,  2521,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2530,    -1,    -1,    -1,    -1,
      -1,  2536,    -1,    -1,    -1,  2540,    -1,    -1,    -1,  2544,
    2545,    -1,    -1,  2548,  2549,  2550,  2551,  2552,  2553,  2554,
    2555,  2556,  2557,    -1,    -1,    -1,    -1,  2562,  2563,    -1,
    1761,    -1,    -1,    -1,    -1,    -1,  2571,  1768,    -1,  1770,
      -1,  2576,    -1,    -1,    -1,    -1,    -1,    -1,  2583,    -1,
      -1,  2586,    -1,  2588,    -1,    -1,    -1,    -1,    -1,  2594,
    2595,  2596,  2597,    -1,    -1,    -1,  2601,    -1,    -1,  2604,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2648,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2706,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2512,    -1,    -1,    -1,
      -1,    -1,  2518,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2530,    -1,    -1,  2762,    -1,    -1,
    2536,    -1,    -1,    -1,  2540,    -1,    -1,    -1,  2773,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2562,  2563,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2583,    -1,  2814,
    2586,    -1,  2588,    -1,  2819,    -1,    -1,    -1,  2823,  2595,
      -1,    -1,    -1,    -1,    -1,  2601,    -1,    -1,  2604,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2841,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2853,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2648,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2089,  2894,
    2895,    -1,    -1,    -1,  2899,    -1,    -1,  2098,    -1,  2100,
    2905,  2906,    -1,    -1,  2909,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2122,    -1,    -1,  2125,    -1,  2127,  2128,    -1,  2130,
      -1,    -1,    -1,  2134,    -1,    -1,    -1,    -1,    -1,    -1,
    2141,    -1,    -1,    -1,    -1,  2146,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2157,    -1,    -1,    -1,
    2161,  2162,  2163,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2174,    -1,    -1,    -1,  2982,    -1,    -1,
    2181,    -1,  2183,  2184,  2185,  2186,  2187,  2188,  2189,  2190,
    2191,  2192,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3018,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3031,    -1,    -1,    -1,
    3035,    -1,    -1,    -1,    -1,  3040,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3057,    -1,  3059,    -1,    -1,    -1,    -1,    -1,
      -1,  3066,  3067,  3068,    -1,  2841,  3071,    -1,    -1,    -1,
      -1,    -1,    -1,  3078,  3079,    -1,  2277,  2853,    -1,    -1,
      -1,    -1,    -1,  3088,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2905,
    2906,    -1,    -1,  2909,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3148,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2361,    -1,    -1,    -1,    -1,  3170,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2982,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3223,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3031,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2470,
      -1,    -1,  3048,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3286,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2494,    -1,  3071,    -1,    -1,    -1,    -1,
      -1,    -1,  3307,  3079,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3088,    -1,    -1,    -1,  2517,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3106,    -1,    -1,    -1,    -1,  3340,    -1,    -1,  3343,    -1,
      -1,    -1,  2543,    -1,  2545,    -1,    -1,  2548,  2549,  2550,
    2551,  2552,  2553,  2554,  2555,  2556,  2557,    -1,  2559,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     5,  3148,    -1,    -1,    -1,    -1,    -1,  2579,    -1,
      -1,    -1,    -1,  2584,  2585,    19,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    28,  2596,  2597,  2598,    -1,  2600,
      -1,    -1,  2603,    -1,    -1,    39,    40,    -1,    -1,    -1,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,    63,
      64,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2673,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,
      -1,  2762,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   256,    -1,    -1,   259,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   280,    -1,    -1,  2850,
      -1,    -1,    -1,  2854,    -1,    -1,    -1,    -1,  2859,  2860,
      -1,  2862,    -1,    -1,  2865,    -1,    -1,    -1,  2869,  2870,
    2871,  2872,  2873,  2874,  2875,  2876,  2877,  2878,  2879,  2880,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2893,  2894,  2895,  2896,    -1,  2898,    -1,    -1,
      -1,  2902,  2903,  2904,   338,    -1,  2907,    -1,    -1,  2910,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2928,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,    -1,   413,
     414,    -1,   416,  2984,    -1,    -1,    -1,    -1,   422,    -1,
     424,   425,    -1,    -1,    -1,   429,   430,   431,   432,   433,
      -1,    -1,   436,   437,   438,   439,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3050,
      -1,    -1,    -1,    -1,    -1,    -1,  3057,    -1,  3059,    -1,
      -1,  3062,  3063,    -1,    -1,    -1,  3067,  3068,  3069,  3070,
      -1,  3072,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3124,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3158,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3169,  3170,
    3171,    -1,    -1,  3174,  3175,  3176,    -1,  3178,    -1,    -1,
      -1,  3182,    -1,    -1,    -1,    -1,  3187,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
    3221,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,  3234,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,    -1,   198,   199,   200,
     201,   202,   203,   204,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
     221,   222,   223,   224,   225,   226,   227,   228,   229,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,   387,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,     6,
       7,     8,    -1,    10,    11,    -1,    13,    14,    15,    -1,
      -1,    -1,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,   442,    29,    30,    31,    -1,    -1,    -1,    35,    36,
      37,    38,    -1,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    -1,    -1,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     117,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,
      -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   152,   153,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,   184,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,   193,    -1,   195,    -1,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,    -1,    -1,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   219,   220,    -1,    -1,    -1,    -1,    -1,   226,
      -1,   228,    -1,    -1,   231,   232,    -1,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   262,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,
      -1,   278,    -1,    -1,   281,   282,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,    -1,    -1,    -1,    -1,   303,   304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   315,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   329,    -1,    -1,   332,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,
      -1,    -1,   349,    -1,   351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   372,   373,    -1,    -1,    -1,
      -1,   378,    -1,   380,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,   413,    10,    11,   416,
      13,    14,    15,    -1,    -1,    -1,    19,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    -1,
      -1,    -1,    35,    36,    37,    38,   443,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    -1,    -1,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,
     103,   104,   105,   106,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,
      -1,   124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   134,    -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,
     153,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,
      -1,   184,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,
     193,    -1,   195,    -1,    -1,    -1,    -1,    -1,   201,    -1,
      -1,    -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   219,   220,    -1,    -1,
      -1,    -1,    -1,   226,    -1,   228,    -1,    -1,   231,   232,
      -1,   234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,
      -1,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,
     263,   264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     273,    -1,    -1,    -1,    -1,   278,    -1,    -1,   281,   282,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   295,   296,   297,   298,    -1,    -1,    -1,    -1,
     303,   304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,   332,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   346,    -1,    -1,   349,    -1,   351,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,
     373,    -1,    -1,    -1,    -1,   378,    -1,   380,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,   401,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     413,    -1,    -1,   416,    -1,     3,    -1,    -1,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
     443,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,
      88,    89,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      98,    99,    -1,    -1,   102,   103,   104,   105,   106,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,
      -1,    -1,   120,    -1,   122,   123,   124,    -1,    -1,   127,
     128,    -1,    -1,    -1,    -1,    -1,   134,   135,   136,    -1,
      -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   149,    -1,   151,   152,   153,   154,    -1,    -1,    -1,
      -1,    -1,   160,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   169,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
      -1,    -1,   180,   181,   182,    -1,   184,    -1,   186,    -1,
     188,    -1,    -1,    -1,    -1,   193,    -1,   195,    -1,   197,
      -1,   199,    -1,   201,    -1,    -1,    -1,    -1,    -1,    -1,
     208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   219,   220,    -1,    -1,   223,    -1,    -1,   226,    -1,
     228,    -1,    -1,   231,   232,    -1,   234,    -1,    -1,    -1,
      -1,    -1,    -1,   241,   242,    -1,   244,    -1,   246,   247,
      -1,    -1,    -1,    -1,   252,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   260,    -1,   262,   263,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,   277,
     278,    -1,    -1,   281,   282,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,   296,   297,
     298,    -1,    -1,    -1,    -1,   303,   304,    -1,   306,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   315,    -1,    -1,
     318,    -1,   320,    -1,    -1,    -1,   324,    -1,    -1,    -1,
     328,   329,    -1,   331,   332,    -1,    -1,   335,    -1,    -1,
      -1,    -1,   340,    -1,    -1,    -1,    -1,   345,   346,    -1,
     348,   349,    -1,   351,    -1,    -1,   354,    -1,    -1,    -1,
      -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   372,   373,    -1,    -1,    -1,    -1,
     378,    -1,   380,    -1,   382,    -1,   384,    -1,    -1,   387,
      -1,    -1,   390,    -1,   392,    -1,    -1,   395,    -1,    -1,
      -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,   416,    -1,
      -1,    -1,    -1,    -1,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
     438,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,   165,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
     431,    -1,    -1,    -1,    -1,    -1,    -1,   438,   439,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,   185,
     186,   187,   188,    -1,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,   208,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,   219,   220,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,   231,   232,   233,   234,   235,
     236,   237,   238,   239,    -1,   241,   242,   243,   244,    -1,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,    -1,
      -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,   297,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,    -1,   388,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,   415,
     416,   417,    -1,    -1,   420,   421,   422,   423,   424,    -1,
      -1,    -1,    -1,   429,   430,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   438,   439,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,    -1,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,    -1,   135,    -1,   137,   138,   139,   140,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
      -1,   182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
      -1,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
      -1,   242,   243,   244,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,    -1,   274,    -1,   276,   277,   278,   279,    -1,
      -1,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,    -1,   299,   300,
     301,    -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,    -1,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
      -1,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,   439,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,   394,   395,   396,    -1,   398,   399,
     400,    -1,   402,     5,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,    19,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   436,    39,    40,    -1,
     440,    -1,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   256,    -1,    -1,   259,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   280,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,
      -1,   413,   414,    -1,   416,    -1,    -1,    -1,    -1,    -1,
     422,    -1,   424,   425,    -1,    -1,    -1,   429,   430,   431,
     432,   433,    -1,    -1,   436,   437,   438,   439,     5,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,   185,   186,
     187,   188,    -1,   190,    -1,   192,   193,   194,   195,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,   208,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,   220,    -1,   222,   223,   224,   225,   226,
      -1,   228,    -1,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   241,   242,   243,   244,    -1,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,   376,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,   416,
     417,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
      -1,    -1,   429,   430,     5,     6,     7,     8,     9,    10,
      11,   438,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
     431,    -1,    -1,    -1,    -1,    -1,    -1,   438,     5,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,   185,   186,
     187,   188,    -1,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,   208,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,   220,    -1,   222,   223,   224,   225,   226,
      -1,   228,    -1,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,    -1,   241,   242,   243,   244,    -1,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,   340,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
      -1,   388,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,   416,
     417,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
      -1,    -1,   429,   430,     5,     6,     7,     8,     9,    10,
      11,   438,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,    -1,    -1,    -1,    -1,
      -1,   436,    -1,   438,     5,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,   155,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,   208,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,   244,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,   194,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,   208,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,   244,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,   388,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
     415,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,   429,   430,     5,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    -1,    35,    36,    37,    38,
      39,    40,    -1,    42,    43,    44,    -1,    46,    47,    48,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    92,    -1,    -1,    95,    96,    -1,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
     109,   110,    -1,   112,   113,   114,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,   140,   141,   142,   143,   144,   145,   146,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,   185,   186,   187,   188,
      -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,   208,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
     219,   220,    -1,   222,   223,   224,   225,   226,    -1,   228,
      -1,    -1,   231,   232,   233,   234,   235,   236,   237,   238,
     239,    -1,   241,   242,   243,   244,    -1,   246,   247,   248,
     249,   250,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,   263,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,   275,   276,   277,   278,
     279,   280,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
     329,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,   381,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,   401,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,   415,   416,   417,    -1,
      -1,   420,   421,   422,   423,   424,    -1,    -1,    -1,    -1,
     429,   430,     5,     6,     7,     8,     9,    10,    11,   438,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    -1,    35,    36,    37,    38,    39,    40,    -1,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    92,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,   109,   110,    -1,   112,
     113,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,   185,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,   225,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,   275,   276,   277,   278,   279,   280,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,   381,   382,
     383,   384,   385,   386,    -1,   388,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,   415,   416,   417,    -1,    -1,   420,   421,   422,
     423,   424,    -1,    -1,    -1,    -1,   429,   430,     5,     6,
       7,     8,     9,    10,    11,   438,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    -1,    35,    36,
      37,    38,    39,    40,    -1,    42,    43,    44,    -1,    46,
      47,    48,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    92,    -1,    -1,    95,    96,
      -1,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,    -1,   109,   110,    -1,   112,   113,   114,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,   140,   141,   142,   143,   144,   145,   146,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,   185,   186,
     187,   188,    -1,   190,    -1,   192,   193,    -1,   195,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,   208,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,   219,   220,    -1,   222,   223,   224,   225,   226,
      -1,   228,    -1,    -1,   231,   232,   233,   234,   235,   236,
     237,   238,   239,    -1,   241,   242,   243,   244,    -1,   246,
     247,   248,   249,   250,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,   263,   264,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,   278,   279,   280,   281,   282,   283,   284,    -1,    -1,
     287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,   329,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,   381,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,   393,    -1,   395,   396,
      -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,   415,   416,
     417,    -1,    -1,   420,   421,   422,   423,   424,    -1,    -1,
      -1,    -1,    -1,   430,     5,     6,     7,     8,     9,    10,
      11,   438,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    -1,    35,    36,    37,    38,    39,    40,
      -1,    42,    43,    44,    -1,    46,    47,    48,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    92,    -1,    -1,    95,    96,    -1,    98,    99,   100,
     101,   102,    -1,   104,   105,   106,   107,    -1,   109,   110,
      -1,   112,   113,   114,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,    -1,    -1,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,    -1,   190,
      -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,   219,   220,
      -1,   222,   223,   224,   225,   226,    -1,   228,    -1,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,    -1,
     241,   242,   243,    -1,    -1,   246,   247,   248,   249,   250,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,   278,   279,   280,
     281,   282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,
     291,   292,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,    -1,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,   415,   416,   417,    -1,    -1,   420,
     421,   422,   423,   424,    -1,    -1,    -1,    -1,   429,   430,
       5,     6,     7,     8,     9,    10,    11,   438,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    -1,
      35,    36,    37,    38,    39,    40,    -1,    42,    43,    44,
      -1,    46,    47,    48,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    92,    -1,    -1,
      95,    96,    -1,    98,    99,   100,   101,   102,    -1,   104,
     105,   106,   107,    -1,   109,   110,    -1,   112,   113,   114,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,    -1,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,   193,    -1,
     195,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,   219,   220,    -1,   222,   223,   224,
     225,   226,    -1,   228,    -1,    -1,   231,   232,   233,   234,
     235,   236,   237,   238,   239,    -1,   241,   242,   243,    -1,
      -1,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,   278,   279,   280,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,    -1,    -1,   292,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,   393,    -1,
     395,   396,    -1,   398,   399,   400,   401,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
      -1,   416,   417,    -1,    -1,   420,   421,   422,   423,   424,
      -1,    -1,    -1,    -1,    -1,   430,    -1,     6,     7,     8,
       9,    10,    11,   438,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    93,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,   177,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
     189,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,   227,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,   245,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,   286,   287,    -1,
      -1,    -1,   291,   292,    -1,   294,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,   387,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,     5,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    19,   416,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    39,    40,    -1,    -1,
     439,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    54,    55,    56,    57,    58,    59,    60,    61,    62,
      63,    64,    65,    66,    67,    68,    69,    70,    71,    72,
      73,    74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   116,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   207,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   225,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   256,    -1,    -1,   259,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   280,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   374,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   399,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   410,    -1,    -1,
     413,   414,    -1,   416,    -1,    -1,    -1,    -1,    -1,   422,
      -1,   424,   425,    -1,    -1,    -1,   429,   430,   431,   432,
     433,    -1,    -1,   436,   437,   438,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,   114,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,   208,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,   219,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,   231,   232,   233,   234,   235,   236,   237,   238,   239,
      -1,   241,   242,   243,   244,    -1,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,   278,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,   288,    -1,
     290,   291,   292,    -1,    -1,   295,   296,   297,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,   398,   399,
     400,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,
      -1,    -1,    -1,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,   438,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    99,   100,   101,   102,
     103,   104,   105,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,   114,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,   140,   141,   142,
     143,   144,   145,   146,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
     193,    -1,   195,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,   208,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,   219,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,   231,   232,
     233,   234,   235,   236,   237,   238,   239,    -1,   241,   242,
     243,   244,    -1,   246,   247,   248,   249,   250,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
     263,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,   278,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,   290,   291,   292,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,   329,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
     393,    -1,   395,   396,    -1,   398,   399,   400,   401,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,   438,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,   114,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,   208,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,   219,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,   231,   232,   233,   234,   235,
     236,   237,   238,   239,    -1,   241,   242,   243,   244,    -1,
     246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,   278,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
     296,   297,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,   393,    -1,   395,
     396,    -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   438,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,    -1,   416,   417,    -1,
      -1,    -1,    -1,   422,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   437,   438,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,   414,    -1,
     416,   417,    -1,    -1,    -1,    -1,   422,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,   438,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,   265,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,   288,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,    -1,
      -1,    -1,    -1,    -1,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,   438,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,   340,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,   417,    -1,    -1,    -1,    -1,
      -1,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,   438,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,   340,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,    -1,    -1,    -1,    -1,    -1,    -1,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,   438,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,    -1,
      -1,    -1,    -1,    -1,    -1,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
     438,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,    -1,    -1,    -1,    -1,
      -1,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,   438,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,   107,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
      -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
      -1,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,    -1,   182,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,    -1,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,    -1,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,    -1,   276,   277,    -1,   279,    -1,    -1,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,    -1,    -1,    -1,    -1,   299,   300,   301,    -1,    -1,
      -1,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,   415,   416,   417,    -1,    -1,    -1,    -1,   422,    -1,
     424,   425,   426,   427,    -1,   429,   430,   431,   432,   433,
     434,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
     415,   416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     425,   426,   427,    -1,   429,   430,   431,   432,   433,   434,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,   415,
     416,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,
     426,   427,    -1,   429,   430,   431,   432,   433,   434,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,    90,    91,    92,    93,    94,    95,
      96,    97,    98,    99,   100,   101,   102,   103,   104,   105,
     106,    -1,   108,   109,   110,    -1,   112,   113,   114,   115,
     116,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   139,   140,   141,   142,   143,   144,   145,
     146,   147,   148,   149,   150,   151,   152,   153,   154,   155,
     156,   157,   158,    -1,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,   177,   178,   179,   180,   181,   182,    -1,   184,   185,
     186,   187,   188,   189,   190,   191,   192,   193,   194,   195,
     196,    -1,   198,   199,   200,   201,   202,   203,   204,   205,
     206,   207,   208,   209,   210,   211,   212,   213,   214,   215,
     216,   217,   218,   219,   220,   221,   222,   223,   224,   225,
     226,   227,   228,   229,    -1,   231,   232,   233,   234,   235,
     236,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,   275,
     276,   277,   278,   279,   280,   281,   282,   283,   284,   285,
     286,   287,   288,   289,   290,   291,   292,   293,   294,   295,
     296,   297,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,   317,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,   340,   341,   342,   343,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,   363,   364,   365,
     366,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,   380,   381,   382,   383,   384,   385,
     386,   387,   388,   389,   390,   391,   392,   393,   394,   395,
     396,    -1,   398,   399,   400,   401,   402,    -1,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,   431,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,   107,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
      -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
      -1,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,    -1,   182,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,    -1,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,    -1,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,    -1,   276,   277,    -1,   279,    -1,    -1,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,    -1,    -1,    -1,    -1,   299,   300,   301,    -1,    -1,
      -1,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,    -1,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,   431,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,    -1,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,   431,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,   185,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,   285,    -1,   287,    -1,   289,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,   414,    -1,   416,   417,    -1,    -1,
      -1,    -1,   422,    -1,   424,    -1,    -1,    -1,    -1,    -1,
     430,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
     185,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
     285,    -1,   287,    -1,   289,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
      -1,   416,   417,    -1,    -1,    -1,    -1,   422,    -1,   424,
      -1,    -1,    -1,    -1,    -1,   430,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,   194,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,   212,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,   417,    -1,    -1,
      -1,    -1,   422,    -1,     6,     7,     8,     9,    10,    11,
     430,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,   417,    -1,    -1,    -1,    -1,
     422,    -1,     6,     7,     8,     9,    10,    11,   430,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
     374,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
     414,    -1,   416,   417,    -1,     6,     7,     8,     9,    10,
      11,   425,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,    -1,   416,   417,    -1,    -1,   420,
     421,   422,    -1,   424,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,    -1,     4,   419,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    17,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,    -1,    10,    11,    -1,    13,    14,    15,    -1,
      -1,    -1,    19,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    -1,    -1,    -1,    35,    36,
      37,    38,    -1,    40,    -1,    42,    43,    44,    45,    46,
      47,    48,    49,    -1,    -1,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    99,    -1,    -1,    -1,   103,   104,   105,   106,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     117,    -1,    -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   134,    -1,    -1,
      -1,    -1,    -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   152,   153,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   181,    -1,    -1,   184,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,   193,    -1,   195,    -1,
      -1,    -1,    -1,    -1,   201,    -1,    -1,    -1,    -1,    -1,
      -1,   208,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   219,   220,    -1,    -1,    -1,    -1,    -1,   226,
      -1,   228,    -1,    -1,   231,   232,    -1,   234,    -1,    -1,
      -1,    -1,    -1,    -1,   241,   242,    -1,   244,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   262,   263,   264,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   273,    -1,    -1,    -1,
      -1,   278,    -1,    -1,   281,   282,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,    -1,    -1,    -1,    -1,   303,   304,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   315,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   329,    -1,    -1,   332,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   346,
      -1,    -1,   349,    -1,   351,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   361,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   372,   373,    -1,    -1,    -1,
      -1,   378,    -1,   380,    -1,    -1,    -1,    -1,    -1,    -1,
     387,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   399,    -1,   401,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   413,    -1,    -1,   416,
      -1,   418,     6,     7,     8,    -1,    10,    11,    -1,    13,
      14,    15,    -1,    -1,    -1,    19,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    -1,    -1,
      -1,    35,    36,    37,    38,    -1,    40,    -1,    42,    43,
      44,    45,    46,    47,    48,    49,    -1,    -1,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    99,    -1,    -1,    -1,   103,
     104,   105,   106,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   117,    -1,    -1,    -1,    -1,    -1,    -1,
     124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     134,    -1,    -1,    -1,    -1,    -1,   140,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   152,   153,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   181,    -1,    -1,
     184,    -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,   193,
      -1,   195,    -1,    -1,    -1,    -1,    -1,   201,    -1,    -1,
      -1,    -1,    -1,    -1,   208,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   219,   220,    -1,    -1,    -1,
      -1,    -1,   226,    -1,   228,    -1,    -1,   231,   232,    -1,
     234,    -1,    -1,    -1,    -1,    -1,    -1,   241,   242,    -1,
     244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   262,   263,
     264,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   273,
      -1,    -1,    -1,    -1,   278,    -1,    -1,   281,   282,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   295,   296,   297,   298,    -1,    -1,    -1,    -1,   303,
     304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   329,    -1,    -1,   332,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   346,    -1,    -1,   349,    -1,   351,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   361,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   372,   373,
      -1,    -1,    -1,    -1,   378,    -1,   380,    -1,    -1,    -1,
      -1,    -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   399,    -1,   401,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   413,
      -1,    -1,   416,    -1,   418,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
      90,    91,    92,    93,    94,    95,    96,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,   108,   109,
     110,    -1,   112,   113,   114,   115,   116,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   139,
     140,   141,   142,   143,   144,   145,   146,   147,   148,   149,
     150,   151,   152,   153,   154,   155,   156,   157,   158,    -1,
     160,   161,   162,   163,   164,   165,   166,   167,   168,   169,
     170,   171,   172,   173,   174,   175,   176,   177,   178,   179,
     180,   181,   182,    -1,   184,   185,   186,   187,   188,   189,
     190,   191,   192,   193,   194,   195,   196,    -1,   198,   199,
     200,   201,   202,   203,   204,   205,   206,   207,   208,   209,
     210,   211,   212,   213,   214,   215,   216,   217,   218,   219,
     220,   221,   222,   223,   224,   225,   226,   227,   228,   229,
      -1,   231,   232,   233,   234,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,   275,   276,   277,   278,   279,
     280,   281,   282,   283,   284,   285,   286,   287,   288,   289,
     290,   291,   292,   293,   294,   295,   296,   297,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
     340,   341,   342,   343,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,   363,   364,   365,   366,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
     380,   381,   382,   383,   384,   385,   386,   387,   388,   389,
     390,   391,   392,   393,   394,   395,   396,    -1,   398,   399,
     400,   401,   402,    -1,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,    -1,   135,    -1,   137,
     138,   139,   140,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,
     188,    -1,   190,    -1,   192,   193,    -1,   195,   196,    -1,
     198,    -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,
     208,   209,   210,   211,   212,   213,   214,   215,   216,   217,
      -1,   219,   220,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,   231,   232,   233,   234,   235,   236,   237,
     238,   239,    -1,    -1,   242,   243,   244,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,   263,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,    -1,   274,    -1,   276,   277,
     278,   279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,   296,   297,
      -1,   299,   300,   301,    -1,    -1,    -1,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,   329,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,   349,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
      -1,   379,    -1,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,   401,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    99,   100,   101,   102,   103,   104,   105,
     106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,    -1,   135,
      -1,   137,   138,   139,   140,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,    -1,   182,    -1,    -1,    -1,
     186,   187,   188,    -1,   190,    -1,   192,   193,    -1,   195,
     196,    -1,   198,    -1,   200,    -1,    -1,   203,    -1,   205,
     206,   207,   208,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,   219,    -1,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,   231,   232,   233,   234,   235,
     236,   237,   238,   239,    -1,    -1,   242,   243,   244,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,   263,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,    -1,
     276,   277,   278,   279,    -1,    -1,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,    -1,
     296,   297,    -1,   299,   300,   301,    -1,    -1,    -1,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,   329,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,   349,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,    -1,   379,    -1,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,   401,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
      -1,   416,   417,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    41,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,   265,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,   417,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,   374,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,   414,    -1,   416,   417,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,   155,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,   414,    -1,   416,   417,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,   155,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,   414,    -1,   416,
     417,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,   414,
      -1,   416,   417,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,   414,    -1,   416,   417,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    17,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,    -1,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,   417,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,   417,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
     417,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,   417,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
     212,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,    -1,   276,   277,    -1,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     5,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    -1,    35,    36,    37,    38,    39,
      40,    -1,    42,    43,    44,    -1,    46,    47,    48,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,   107,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,    -1,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,    -1,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,    -1,   182,    -1,    -1,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,    -1,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
      -1,    -1,   222,   223,   224,   225,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,    -1,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,    -1,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,    -1,    -1,    -1,    -1,   299,
     300,   301,    -1,    -1,    -1,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,    -1,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,    -1,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,    -1,   379,
      -1,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     5,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    -1,    35,    36,    37,
      38,    39,    40,    -1,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    -1,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,   107,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,    -1,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,    -1,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,    -1,   182,    -1,    -1,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,    -1,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,    -1,    -1,   222,   223,   224,   225,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,    -1,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,    -1,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,    -1,    -1,    -1,
      -1,   299,   300,   301,    -1,    -1,    -1,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,    -1,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,    -1,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
      -1,   379,    -1,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     5,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    -1,    35,
      36,    37,    38,    39,    40,    -1,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,   107,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,    -1,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,    -1,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,    -1,   182,    -1,    -1,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,    -1,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,    -1,    -1,   222,   223,   224,   225,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,    -1,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,    -1,   274,    -1,
     276,   277,    -1,   279,   280,    -1,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,    -1,
      -1,    -1,    -1,   299,   300,   301,    -1,    -1,    -1,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,    -1,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,    -1,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,    -1,   379,    -1,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     5,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      -1,    35,    36,    37,    38,    39,    40,    -1,    42,    43,
      44,    -1,    46,    47,    48,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,   107,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
      -1,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
      -1,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,    -1,   182,    -1,
      -1,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,    -1,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,    -1,    -1,   222,   223,
     224,   225,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,    -1,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,    -1,
     274,    -1,   276,   277,    -1,   279,    -1,    -1,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,    -1,    -1,    -1,    -1,   299,   300,   301,    -1,    -1,
      -1,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,    -1,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,    -1,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,    -1,   379,    -1,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     5,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    -1,    35,    36,    37,    38,    39,    40,    -1,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,   107,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,    -1,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,    -1,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,    -1,
     182,    -1,    -1,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,    -1,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,    -1,    -1,
     222,   223,   224,   225,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,    -1,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,    -1,   274,    -1,   276,   277,    -1,   279,    -1,    -1,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,    -1,    -1,    -1,    -1,   299,   300,   301,
      -1,    -1,    -1,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
      -1,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,    -1,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,    -1,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,    -1,   379,    -1,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    90,
      91,    92,    93,    94,    95,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,    -1,   108,   109,   110,
      -1,   112,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   139,   140,
     141,   142,   143,   144,   145,   146,   147,   148,   149,    -1,
     151,   152,   153,   154,   155,   156,   157,   158,    -1,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,    -1,   184,   185,   186,   187,   188,   189,   190,
     191,   192,   193,   194,   195,   196,    -1,   198,   199,   200,
     201,   202,   203,   204,   205,   206,    -1,   208,   209,   210,
     211,   212,   213,   214,   215,   216,   217,   218,   219,   220,
      -1,   222,   223,   224,    -1,   226,   227,   228,   229,    -1,
     231,   232,   233,   234,   235,   236,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,    -1,   257,   258,    -1,   260,
     261,   262,   263,   264,   265,   266,   267,   268,   269,   270,
     271,   272,   273,   274,   275,   276,   277,   278,   279,   280,
     281,   282,   283,   284,   285,   286,   287,   288,   289,   290,
     291,   292,   293,   294,   295,   296,   297,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,   329,   330,
     331,   332,   333,   334,   335,   336,   337,    -1,    -1,   340,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,   363,   364,   365,   366,   367,   368,   369,   370,
     371,   372,   373,    -1,   375,   376,   377,   378,   379,   380,
     381,   382,   383,   384,   385,   386,    -1,   388,   389,   390,
     391,   392,   393,   394,   395,   396,    -1,   398,   399,   400,
     401,   402,    -1,   404,   405,   406,   407,   408,   409,    -1,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    -1,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    99,
     100,   101,   102,   103,   104,   105,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
     140,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,   193,    -1,   195,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,   208,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,   219,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,   231,   232,   233,   234,   235,   236,   237,   238,   239,
      -1,   241,   242,   243,   244,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,   263,   264,   265,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,   278,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,   288,    -1,
      -1,   291,   292,    -1,    -1,   295,   296,   297,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,   329,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,   349,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,    -1,    -1,   395,   396,    -1,   398,   399,
     400,   401,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    -1,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
     119,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,   131,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,   191,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,   244,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,   388,
     389,   390,   391,   392,    -1,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,   136,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,   199,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,   317,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,   340,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,   136,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,   340,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    88,    89,    -1,    -1,    -1,    -1,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,   265,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,   288,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,   288,    -1,   290,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,    -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,   265,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,   288,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,   366,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,   136,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,    -1,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,   340,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,    -1,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,   265,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,   288,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,
     101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,
      -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,   120,
     121,   122,   123,   124,    -1,    -1,   127,   128,   129,   130,
      -1,   132,   133,   134,   135,    -1,   137,   138,   139,    -1,
     141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,
     151,   152,   153,   154,    -1,   156,    -1,   158,    -1,   160,
     161,   162,    -1,   164,    -1,    -1,   167,   168,   169,   170,
      -1,   172,   173,   174,    -1,   176,    -1,   178,   179,   180,
     181,   182,    -1,   184,    -1,   186,   187,   188,    -1,   190,
      -1,   192,    -1,   194,    -1,   196,    -1,   198,    -1,   200,
     201,    -1,   203,    -1,   205,   206,   207,    -1,   209,   210,
     211,   212,   213,   214,   215,   216,   217,    -1,    -1,   220,
      -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,
      -1,    -1,   233,    -1,   235,   236,   237,   238,   239,    -1,
     241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,
     251,   252,   253,   254,   255,   256,   257,   258,   259,   260,
     261,   262,    -1,   264,    -1,   266,   267,   268,   269,   270,
     271,   272,   273,   274,    -1,   276,   277,    -1,   279,    -1,
     281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,
     291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,
     301,    -1,   303,   304,   305,   306,   307,    -1,   309,   310,
     311,   312,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,   322,   323,   324,   325,   326,   327,   328,    -1,   330,
     331,   332,   333,   334,   335,   336,   337,   338,    -1,    -1,
     341,   342,   343,    -1,   345,   346,   347,   348,    -1,   350,
     351,    -1,   353,   354,   355,   356,   357,   358,   359,   360,
     361,   362,    -1,   364,   365,    -1,   367,   368,   369,   370,
      -1,   372,   373,    -1,   375,    -1,   377,   378,   379,   380,
      -1,   382,   383,   384,   385,   386,    -1,    -1,   389,   390,
     391,   392,    -1,    -1,   395,   396,    -1,   398,   399,   400,
      -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,   410,
     411,    -1,   413,    -1,    -1,   416,     6,     7,     8,     9,
      10,    11,    -1,    13,    14,    15,    16,    -1,    18,    -1,
      20,    -1,    22,    23,    24,    25,    26,    27,    -1,    29,
      30,    31,    32,    -1,    -1,    35,    36,    37,    38,    -1,
      -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,
      50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,
      -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      70,    -1,    72,    -1,    74,    75,    -1,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,    -1,
     100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,   109,
     110,    -1,   112,    -1,    -1,   115,   116,   117,   118,    -1,
     120,   121,   122,   123,   124,    -1,    -1,   127,   128,   129,
     130,    -1,   132,   133,   134,   135,    -1,   137,   138,   139,
      -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,   149,
     150,   151,   152,   153,   154,    -1,   156,    -1,   158,    -1,
     160,   161,   162,    -1,   164,    -1,    -1,   167,   168,   169,
     170,    -1,   172,   173,   174,    -1,   176,    -1,   178,   179,
     180,   181,   182,    -1,   184,    -1,   186,   187,   188,    -1,
     190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,    -1,
     200,   201,    -1,   203,    -1,   205,   206,   207,    -1,   209,
     210,   211,    -1,   213,   214,   215,   216,   217,    -1,    -1,
     220,    -1,   222,   223,   224,    -1,   226,    -1,   228,    -1,
      -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,   239,
      -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,    -1,
      -1,   251,   252,   253,   254,   255,   256,   257,   258,   259,
     260,   261,   262,    -1,   264,    -1,   266,   267,   268,   269,
     270,   271,   272,   273,   274,    -1,   276,   277,    -1,   279,
      -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,    -1,
      -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,   299,
     300,   301,    -1,   303,   304,   305,   306,   307,    -1,   309,
     310,   311,   312,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,   322,   323,   324,   325,   326,   327,   328,    -1,
     330,   331,   332,   333,   334,   335,   336,   337,   338,    -1,
      -1,   341,   342,   343,    -1,   345,   346,   347,   348,    -1,
     350,   351,    -1,   353,   354,   355,   356,   357,   358,   359,
     360,   361,   362,    -1,   364,   365,    -1,   367,   368,   369,
     370,    -1,   372,   373,    -1,   375,    -1,   377,   378,   379,
     380,    -1,   382,   383,   384,   385,   386,    -1,    -1,   389,
     390,   391,   392,   393,    -1,   395,   396,    -1,   398,   399,
     400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,   409,
     410,   411,    -1,   413,    -1,    -1,   416,     6,     7,     8,
       9,    10,    11,    -1,    13,    14,    15,    16,    -1,    18,
      -1,    20,    -1,    22,    23,    24,    25,    26,    27,    -1,
      29,    30,    31,    32,    -1,    -1,    35,    36,    37,    38,
      -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,    -1,
      49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,    -1,
      -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,    98,
      -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,    -1,
     109,   110,    -1,   112,    -1,    -1,   115,   116,   117,   118,
      -1,   120,   121,   122,   123,   124,    -1,    -1,   127,   128,
     129,   130,    -1,   132,   133,   134,   135,    -1,   137,   138,
     139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,   148,
     149,   150,   151,   152,   153,   154,    -1,   156,    -1,   158,
      -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,   168,
     169,   170,    -1,   172,   173,   174,    -1,   176,    -1,   178,
     179,   180,   181,   182,    -1,   184,    -1,   186,   187,   188,
      -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,   198,
      -1,   200,   201,    -1,   203,    -1,   205,   206,   207,    -1,
     209,   210,   211,    -1,   213,   214,   215,   216,   217,    -1,
      -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,   228,
      -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,   248,
      -1,    -1,   251,   252,   253,   254,   255,   256,   257,   258,
     259,   260,   261,   262,    -1,   264,    -1,   266,   267,   268,
     269,   270,   271,   272,   273,   274,    -1,   276,   277,    -1,
     279,    -1,   281,   282,   283,   284,    -1,    -1,   287,    -1,
      -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,   298,
     299,   300,   301,    -1,   303,   304,   305,   306,   307,    -1,
     309,   310,   311,   312,   313,   314,   315,   316,    -1,   318,
     319,   320,   321,   322,   323,   324,   325,   326,   327,   328,
      -1,   330,   331,   332,   333,   334,   335,   336,   337,   338,
      -1,    -1,   341,   342,   343,    -1,   345,   346,   347,   348,
      -1,   350,   351,    -1,   353,   354,   355,   356,   357,   358,
     359,   360,   361,   362,    -1,   364,   365,    -1,   367,   368,
     369,   370,    -1,   372,   373,    -1,   375,    -1,   377,   378,
     379,   380,    -1,   382,   383,   384,   385,   386,    -1,    -1,
     389,   390,   391,   392,   393,    -1,   395,   396,    -1,   398,
     399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,   408,
     409,   410,   411,    -1,   413,    -1,    -1,   416,     6,     7,
       8,     9,    10,    11,    -1,    13,    14,    15,    16,    -1,
      18,    -1,    20,    -1,    22,    23,    24,    25,    26,    27,
      -1,    29,    30,    31,    32,    -1,    -1,    35,    36,    37,
      38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,    -1,
      -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,    -1,
      -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    95,    96,    -1,
      98,    -1,   100,   101,   102,    -1,   104,    -1,   106,    -1,
      -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,   117,
     118,    -1,   120,   121,   122,   123,   124,    -1,    -1,   127,
     128,   129,   130,    -1,   132,   133,   134,   135,    -1,   137,
     138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,   147,
     148,   149,   150,   151,   152,   153,   154,    -1,   156,    -1,
     158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,   167,
     168,   169,   170,    -1,   172,   173,   174,    -1,   176,    -1,
     178,   179,   180,   181,   182,    -1,   184,    -1,   186,   187,
     188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,    -1,
     198,    -1,   200,   201,    -1,   203,    -1,   205,   206,   207,
      -1,   209,   210,   211,    -1,   213,   214,   215,   216,   217,
      -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,    -1,
     228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,   237,
     238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,   247,
     248,    -1,    -1,   251,   252,   253,   254,   255,   256,   257,
     258,   259,   260,   261,   262,    -1,   264,    -1,   266,   267,
     268,   269,   270,   271,   272,   273,   274,    -1,   276,   277,
      -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,   287,
      -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,    -1,
     298,   299,   300,   301,    -1,   303,   304,   305,   306,   307,
      -1,   309,   310,   311,   312,   313,   314,   315,   316,    -1,
     318,   319,   320,   321,   322,   323,   324,   325,   326,   327,
     328,    -1,   330,   331,   332,   333,   334,   335,   336,   337,
     338,    -1,    -1,   341,   342,   343,    -1,   345,   346,   347,
     348,    -1,   350,   351,    -1,   353,   354,   355,   356,   357,
     358,   359,   360,   361,   362,    -1,   364,   365,    -1,   367,
     368,   369,   370,    -1,   372,   373,    -1,   375,    -1,   377,
     378,   379,   380,    -1,   382,   383,   384,   385,   386,    -1,
      -1,   389,   390,   391,   392,    -1,    -1,   395,   396,    -1,
     398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,   407,
     408,   409,   410,   411,    -1,   413,    -1,    -1,   416,     6,
       7,     8,     9,    10,    11,    -1,    13,    14,    15,    16,
      -1,    18,    -1,    20,    -1,    22,    23,    24,    25,    26,
      27,    -1,    29,    30,    31,    32,    -1,    -1,    35,    36,
      37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,    46,
      -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,    56,
      -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,    -1,
      77,    78,    79,    80,    81,    82,    83,    84,    -1,    86,
      87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,    96,
      -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,   106,
      -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,   116,
     117,   118,    -1,   120,   121,   122,   123,   124,    -1,    -1,
     127,   128,   129,   130,    -1,   132,   133,   134,   135,    -1,
     137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,    -1,
     147,   148,   149,   150,   151,   152,   153,   154,    -1,   156,
      -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,    -1,
     167,   168,   169,   170,    -1,   172,   173,   174,    -1,   176,
      -1,   178,   179,   180,   181,   182,    -1,   184,    -1,   186,
     187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,   196,
      -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,   206,
     207,    -1,   209,   210,   211,    -1,   213,   214,   215,   216,
     217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,   226,
      -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,   236,
     237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,   246,
     247,   248,    -1,    -1,   251,   252,   253,   254,   255,   256,
     257,   258,   259,   260,   261,   262,    -1,   264,    -1,   266,
     267,   268,   269,   270,   271,   272,   273,   274,    -1,   276,
     277,    -1,   279,    -1,   281,   282,   283,   284,    -1,    -1,
     287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,    -1,
      -1,   298,   299,   300,   301,    -1,   303,   304,   305,   306,
     307,    -1,   309,   310,   311,   312,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,   322,   323,   324,   325,   326,
     327,   328,    -1,   330,   331,   332,   333,   334,   335,   336,
     337,   338,    -1,    -1,   341,   342,   343,    -1,   345,   346,
     347,   348,    -1,   350,   351,    -1,   353,   354,   355,   356,
     357,   358,   359,   360,   361,   362,    -1,   364,   365,    -1,
     367,   368,   369,   370,    -1,   372,   373,    -1,   375,    -1,
     377,   378,   379,   380,    -1,   382,   383,   384,   385,   386,
      -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,   396,
      -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,   406,
     407,   408,   409,   410,   411,    -1,   413,    -1,    -1,   416,
       6,     7,     8,     9,    10,    11,    -1,    13,    14,    15,
      16,    -1,    18,    -1,    20,    -1,    22,    23,    24,    25,
      26,    27,    -1,    29,    30,    31,    32,    -1,    -1,    35,
      36,    37,    38,    -1,    -1,    -1,    42,    43,    44,    -1,
      46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,    55,
      56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,    75,
      -1,    77,    78,    79,    80,    81,    82,    83,    84,    -1,
      86,    87,    -1,    -1,    -1,    -1,    -1,    93,    -1,    95,
      96,    -1,    98,    -1,   100,   101,   102,    -1,   104,    -1,
     106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,   115,
     116,   117,   118,    -1,   120,   121,   122,   123,   124,    -1,
      -1,   127,   128,   129,   130,    -1,   132,   133,   134,   135,
      -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,    -1,
      -1,   147,   148,   149,   150,   151,   152,   153,   154,    -1,
     156,    -1,   158,    -1,   160,   161,   162,    -1,   164,    -1,
      -1,   167,   168,   169,   170,    -1,   172,   173,   174,    -1,
     176,    -1,   178,   179,   180,   181,   182,    -1,   184,    -1,
     186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,    -1,
     196,    -1,   198,    -1,   200,   201,    -1,   203,    -1,   205,
     206,   207,    -1,   209,   210,   211,    -1,   213,   214,   215,
     216,   217,    -1,    -1,   220,    -1,   222,   223,   224,    -1,
     226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,   243,    -1,    -1,
     246,   247,   248,    -1,    -1,   251,   252,   253,   254,   255,
     256,   257,   258,   259,   260,   261,   262,    -1,   264,    -1,
     266,   267,   268,   269,   270,   271,   272,   273,   274,    -1,
     276,   277,    -1,   279,    -1,   281,   282,   283,   284,    -1,
      -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,   295,
      -1,    -1,   298,   299,   300,   301,    -1,   303,   304,   305,
     306,   307,    -1,   309,   310,   311,   312,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,   322,   323,   324,   325,
     326,   327,   328,    -1,   330,   331,   332,   333,   334,   335,
     336,   337,   338,    -1,    -1,   341,   342,   343,    -1,   345,
     346,   347,   348,    -1,   350,   351,    -1,   353,   354,   355,
     356,   357,   358,   359,   360,   361,   362,    -1,   364,   365,
      -1,   367,   368,   369,   370,    -1,   372,   373,    -1,   375,
      -1,   377,   378,   379,   380,    -1,   382,   383,   384,   385,
     386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,   395,
     396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,    -1,
     406,   407,   408,   409,   410,   411,    -1,   413,    -1,    -1,
     416,     6,     7,     8,     9,    10,    11,    -1,    13,    14,
      15,    16,    -1,    18,    -1,    20,    -1,    22,    23,    24,
      25,    26,    27,    -1,    29,    30,    31,    32,    -1,    -1,
      35,    36,    37,    38,    -1,    -1,    -1,    42,    43,    44,
      -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,    -1,
      55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,    74,
      75,    -1,    77,    78,    79,    80,    81,    82,    83,    84,
      -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    96,    -1,    98,    -1,   100,   101,   102,    -1,   104,
      -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,    -1,
     115,   116,   117,   118,    -1,   120,   121,   122,   123,   124,
      -1,    -1,   127,   128,   129,   130,    -1,   132,   133,   134,
     135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,    -1,
      -1,    -1,   147,   148,   149,   150,   151,   152,   153,   154,
      -1,   156,    -1,   158,    -1,   160,   161,   162,    -1,   164,
      -1,    -1,   167,   168,   169,   170,    -1,   172,   173,   174,
      -1,   176,    -1,   178,   179,   180,   181,   182,    -1,   184,
      -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,    -1,
      -1,   196,    -1,   198,    -1,   200,   201,   202,   203,    -1,
     205,   206,   207,    -1,   209,   210,   211,    -1,   213,   214,
     215,   216,   217,    -1,    -1,   220,    -1,   222,   223,   224,
      -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,    -1,
     235,   236,   237,   238,   239,    -1,   241,    -1,   243,    -1,
      -1,   246,   247,   248,    -1,    -1,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,    -1,   264,
      -1,   266,   267,   268,   269,   270,   271,   272,   273,   274,
      -1,   276,   277,    -1,   279,    -1,   281,   282,   283,   284,
      -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,    -1,
     295,    -1,    -1,   298,   299,   300,   301,    -1,   303,   304,
     305,   306,   307,    -1,   309,   310,   311,   312,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,    -1,   330,   331,   332,   333,   334,
     335,   336,   337,   338,    -1,    -1,   341,   342,   343,    -1,
     345,   346,   347,   348,    -1,   350,   351,    -1,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,    -1,   364,
     365,    -1,   367,   368,   369,   370,    -1,   372,   373,    -1,
     375,    -1,   377,   378,   379,   380,    -1,   382,   383,   384,
     385,   386,    -1,    -1,   389,   390,   391,   392,    -1,    -1,
     395,   396,    -1,   398,   399,   400,    -1,   402,    -1,    -1,
      -1,   406,   407,   408,   409,   410,   411,    -1,   413,    -1,
      -1,   416,     6,     7,     8,     9,    10,    11,    -1,    13,
      14,    15,    16,    -1,    18,    -1,    20,    -1,    22,    23,
      24,    25,    26,    27,    -1,    29,    30,    31,    32,    -1,
      -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,    43,
      44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,    -1,
      -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,    -1,
      74,    75,    -1,    77,    78,    79,    80,    81,    82,    83,
      84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    95,    96,    -1,    98,    -1,   100,   101,   102,    -1,
     104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,    -1,
      -1,   115,   116,   117,   118,    -1,   120,   121,   122,   123,
     124,    -1,    -1,   127,   128,   129,   130,    -1,   132,   133,
     134,   135,    -1,   137,   138,   139,    -1,   141,    -1,    -1,
      -1,    -1,    -1,   147,   148,   149,   150,   151,   152,   153,
     154,   155,   156,    -1,   158,    -1,   160,   161,   162,    -1,
     164,    -1,    -1,   167,   168,   169,   170,    -1,   172,   173,
     174,    -1,   176,    -1,   178,   179,   180,   181,   182,    -1,
     184,    -1,   186,   187,   188,    -1,   190,    -1,   192,    -1,
      -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,   203,
      -1,   205,   206,   207,    -1,   209,   210,   211,    -1,   213,
     214,   215,   216,   217,    -1,    -1,   220,    -1,   222,   223,
     224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,   233,
      -1,   235,   236,   237,   238,   239,    -1,   241,    -1,   243,
      -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,   253,
     254,   255,   256,   257,   258,   259,   260,   261,   262,    -1,
     264,    -1,   266,   267,   268,   269,   270,   271,   272,   273,
     274,    -1,   276,   277,    -1,   279,    -1,   281,   282,   283,
     284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,    -1,
      -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,   303,
     304,   305,   306,   307,    -1,   309,   310,   311,   312,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,   322,   323,
     324,   325,   326,   327,   328,    -1,   330,   331,   332,   333,
     334,   335,   336,   337,   338,    -1,    -1,   341,   342,   343,
      -1,   345,   346,   347,   348,    -1,   350,   351,    -1,   353,
     354,   355,   356,   357,   358,   359,   360,   361,   362,    -1,
     364,   365,    -1,   367,   368,   369,   370,    -1,   372,   373,
      -1,   375,    -1,   377,   378,   379,   380,    -1,   382,   383,
     384,   385,   386,    -1,    -1,   389,   390,   391,   392,    -1,
      -1,   395,   396,    -1,   398,   399,   400,    -1,   402,    -1,
      -1,    -1,   406,   407,   408,   409,   410,   411,    -1,   413,
      -1,    -1,   416,     6,     7,     8,     9,    10,    11,    -1,
      13,    14,    15,    16,    -1,    18,    -1,    20,    -1,    22,
      23,    24,    25,    26,    27,    -1,    29,    30,    31,    32,
      -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,    42,
      43,    44,    -1,    46,    -1,    -1,    49,    50,    51,    -1,
      -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,    72,
      -1,    74,    75,    -1,    77,    78,    79,    80,    81,    82,
      83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,   102,
      -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,   112,
      -1,    -1,   115,   116,   117,   118,    -1,   120,   121,   122,
     123,   124,    -1,    -1,   127,   128,   129,   130,    -1,   132,
     133,   134,   135,    -1,   137,   138,   139,    -1,   141,    -1,
      -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,   152,
     153,   154,   155,   156,    -1,   158,    -1,   160,   161,   162,
      -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,   172,
     173,   174,    -1,   176,    -1,   178,   179,   180,   181,   182,
      -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,   192,
      -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,    -1,
     203,    -1,   205,   206,   207,    -1,   209,   210,   211,    -1,
     213,   214,   215,   216,   217,    -1,    -1,   220,    -1,   222,
     223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,    -1,
     233,    -1,   235,   236,   237,   238,   239,    -1,   241,    -1,
     243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,   252,
     253,   254,   255,   256,   257,   258,   259,   260,   261,   262,
      -1,   264,    -1,   266,   267,   268,   269,   270,   271,   272,
     273,   274,    -1,   276,   277,    -1,   279,    -1,   281,   282,
     283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,   292,
      -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,    -1,
     303,   304,   305,   306,   307,    -1,   309,   310,   311,   312,
     313,   314,   315,   316,    -1,   318,   319,   320,   321,   322,
     323,   324,   325,   326,   327,   328,    -1,   330,   331,   332,
     333,   334,   335,   336,   337,   338,    -1,    -1,   341,   342,
     343,    -1,   345,   346,   347,   348,    -1,   350,   351,    -1,
     353,   354,   355,   356,   357,   358,   359,   360,   361,   362,
      -1,   364,   365,    -1,   367,   368,   369,   370,    -1,   372,
     373,    -1,   375,    -1,   377,   378,   379,   380,    -1,   382,
     383,   384,   385,   386,    -1,    -1,   389,   390,   391,   392,
      -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,   402,
      -1,    -1,    -1,   406,   407,   408,   409,   410,   411,    -1,
     413,    -1,    -1,   416,     6,     7,     8,     9,    10,    11,
      -1,    13,    14,    15,    16,    -1,    18,    -1,    20,    -1,
      22,    23,    24,    25,    26,    27,    -1,    29,    30,    31,
      32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,    -1,
      42,    43,    44,    -1,    46,    -1,    -1,    49,    50,    51,
      -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,    61,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,    -1,
      72,    -1,    74,    75,    -1,    77,    78,    79,    80,    81,
      82,    83,    84,    -1,    86,    87,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    95,    96,    -1,    98,    -1,   100,   101,
     102,    -1,   104,    -1,   106,    -1,    -1,   109,   110,    -1,
     112,    -1,    -1,   115,   116,   117,   118,    -1,   120,   121,
     122,   123,   124,    -1,    -1,   127,   128,   129,   130,    -1,
     132,   133,   134,   135,    -1,   137,   138,   139,    -1,   141,
      -1,    -1,    -1,    -1,    -1,   147,   148,   149,   150,   151,
     152,   153,   154,   155,   156,    -1,   158,    -1,   160,   161,
     162,    -1,   164,    -1,    -1,   167,   168,   169,   170,    -1,
     172,   173,   174,    -1,   176,    -1,   178,   179,   180,   181,
     182,    -1,   184,    -1,   186,   187,   188,    -1,   190,    -1,
     192,    -1,    -1,    -1,   196,    -1,   198,    -1,   200,   201,
      -1,   203,    -1,   205,   206,   207,    -1,   209,   210,   211,
      -1,   213,   214,   215,   216,   217,    -1,    -1,   220,    -1,
     222,   223,   224,    -1,   226,    -1,   228,    -1,    -1,    -1,
      -1,   233,    -1,   235,   236,   237,   238,   239,    -1,   241,
      -1,   243,    -1,    -1,   246,   247,   248,    -1,    -1,   251,
     252,   253,   254,   255,   256,   257,   258,   259,   260,   261,
     262,    -1,   264,    -1,   266,   267,   268,   269,   270,   271,
     272,   273,   274,    -1,   276,   277,    -1,   279,    -1,   281,
     282,   283,   284,    -1,    -1,   287,    -1,    -1,    -1,   291,
     292,    -1,    -1,   295,    -1,    -1,   298,   299,   300,   301,
      -1,   303,   304,   305,   306,   307,    -1,   309,   310,   311,
     312,   313,   314,   315,   316,    -1,   318,   319,   320,   321,
     322,   323,   324,   325,   326,   327,   328,    -1,   330,   331,
     332,   333,   334,   335,   336,   337,   338,    -1,    -1,   341,
     342,   343,    -1,   345,   346,   347,   348,    -1,   350,   351,
      -1,   353,   354,   355,   356,   357,   358,   359,   360,   361,
     362,    -1,   364,   365,    -1,   367,   368,   369,   370,    -1,
     372,   373,    -1,   375,    -1,   377,   378,   379,   380,    -1,
     382,   383,   384,   385,   386,    -1,    -1,   389,   390,   391,
     392,    -1,    -1,   395,   396,    -1,   398,   399,   400,    -1,
     402,    -1,    -1,    -1,   406,   407,   408,   409,   410,   411,
      -1,   413,    -1,    -1,   416,     6,     7,     8,     9,    10,
      11,    -1,    13,    14,    15,    16,    -1,    18,    -1,    20,
      -1,    22,    23,    24,    25,    26,    27,    -1,    29,    30,
      31,    32,    -1,    -1,    35,    36,    37,    38,    -1,    -1,
      -1,    42,    43,    44,    -1,    46,    -1,    -1,    49,    50,
      51,    -1,    -1,    -1,    55,    56,    -1,    -1,    -1,    -1,
      61,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    70,
      -1,    72,    -1,    74,    75,    -1,    77,    78,    79,    80,
      81,    