.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DECLARE" "l" "2002-03-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
DECLARE \- define a cursor
.SH SYNOPSIS
.sp
.nf
DECLARE \fIcursorname\fR [ BINARY ] [ INSENSITIVE ] [ SCROLL ]
    CURSOR FOR \fIquery\fR
    [ FOR { READ ONLY | UPDATE [ OF \fIcolumn\fR [, ...] ] ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIcursorname\fB\fR
The name of the cursor to be used in subsequent FETCH operations.
.TP
\fBBINARY\fR
Causes the cursor to fetch data in binary
rather than in text format.
.TP
\fBINSENSITIVE\fR
SQL92 keyword indicating that data retrieved
from the cursor should be unaffected by updates from other processes or cursors.
Since cursor operations occur within transactions
in PostgreSQL this is always the case.
This keyword has no effect.
.TP
\fBSCROLL\fR
SQL92 keyword indicating that data may be retrieved
in multiple rows per FETCH operation. Since this is allowed at all times
by PostgreSQL this keyword has no effect.
.TP
\fB\fIquery\fB\fR
An SQL query which will provide the rows to be governed by the
cursor.
Refer to the SELECT statement for further information about
valid arguments.
.TP
\fBREAD ONLY\fR
SQL92 keyword indicating that the cursor will be used
in a read only mode. Since this is the only cursor access mode
available in PostgreSQL this keyword has no effect.
.TP
\fBUPDATE\fR
SQL92 keyword indicating that the cursor will be used
to update tables. Since cursor updates are not currently
supported in PostgreSQL this keyword
provokes an informational error message.
.TP
\fB\fIcolumn\fB\fR
Column(s) to be updated.
Since cursor updates are not currently
supported in PostgreSQL the UPDATE clause
provokes an informational error message.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBSELECT\fR
The message returned if the SELECT is run successfully.
.TP
\fBNOTICE: Closing pre-existing portal "\fIcursorname\fB"\fR
This message is reported if the same cursor name was already declared
in the current transaction block. The previous definition is
discarded.
.TP
\fBERROR: DECLARE CURSOR may only be used in begin/end transaction blocks\fR
This error occurs if the cursor is not declared within a transaction block.
.PP
.SH "DESCRIPTION"
.PP
\fBDECLARE\fR allows a user to create cursors, which
can be used to retrieve
a small number of rows at a time out of a larger query. Cursors can
return data either in text or in binary format using
FETCH [\fBfetch\fR(l)].
.PP
Normal cursors return data in text format, either ASCII or another
encoding scheme depending on how the PostgreSQL
backend was built. Since
data is stored natively in binary format, the system must
do a conversion to produce the text format. In addition,
text formats are often larger in size than the corresponding binary format.
Once the information comes back in text form, the client
application may need to convert it to a binary format to
manipulate it.
BINARY cursors give you back the data in the native binary
representation.
.PP
As an example, if a query returns a value of one from an integer column,
you would get a string of 1 with a default cursor
whereas with a binary cursor you would get
a 4-byte value equal to control-A (^A).
.PP
BINARY cursors should be used carefully. User applications such
as \fBpsql\fR are not aware of binary cursors
and expect data to come back in a text format.
.PP
String representation is architecture-neutral whereas binary
representation can differ between different machine architectures.
\fBPostgreSQL does not resolve
byte ordering or representation issues for binary cursors\fR.
Therefore, if your client machine and server machine use different
representations (e.g., ``big-endian'' versus ``little-endian''),
you will probably not want your data returned in
binary format.
However, binary cursors may be a
little more efficient since there is less conversion overhead in
the server to client data transfer.
.sp
.RS
.B "Tip:"
If you intend to display the data in
ASCII, getting it back in ASCII will save you some
effort on the client side.
.RE
.sp
.SS "NOTES"
.PP
Cursors are only available in transactions. Use to
BEGIN [\fBbegin\fR(l)],
COMMIT [\fBcommit\fR(l)]
and
ROLLBACK [\fBrollback\fR(l)]
to define a transaction block.
.PP
In SQL92 cursors are only available in
embedded SQL (ESQL) applications. 
The PostgreSQL backend
does not implement an explicit \fBOPEN cursor\fR
statement; a cursor is considered to be open when it is declared.
However, \fBecpg\fR, the
embedded SQL preprocessor for PostgreSQL,
supports the SQL92 cursor conventions, including those
involving DECLARE and OPEN statements.
.SH "USAGE"
.PP
To declare a cursor:
.sp
.nf
DECLARE liahona CURSOR
    FOR SELECT * FROM films;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 allows cursors only in embedded SQL
and in modules. PostgreSQL permits cursors to be used
interactively.
SQL92 allows embedded or modular cursors to
update database information.
All PostgreSQL cursors are read only.
The BINARY keyword is a PostgreSQL extension.
