.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_TYPE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
DROP TYPE \- Removes a user-defined type from the system catalogs
.SH SYNOPSIS
.sp
.nf
DROP TYPE \fItypename\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItypename\fB\fR
The name of an existing type.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the command is successful.
.TP
\fBERROR: RemoveType: type '\fItypename\fB' does not exist\fR
This message occurs if the specified type is not found.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP TYPE\fR will remove a user type from the
system catalogs.
.PP
Only the owner of a type can remove it.
.SS "NOTES"
.PP
DROP TYPE statement is a Postgres
language extension.
.PP
Refer to \fBCREATE TYPE\fR for
inforamation on how to create types.
.PP
It is the user's responsibility to remove any operators,
functions, aggregates, access methods, subtypes, and classes
that use a deleted type.
.PP
If a built-in type is removed, the behavior of the backend
is unpredictable.
.SH "USAGE"
.PP
To remove the box type:
.sp
.nf
DROP TYPE box;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL3"
.PP
\fBDROP TYPE\fR is a SQL3 statement.
