.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_INDEX" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
DROP INDEX \- Removes an index from a database
.SH SYNOPSIS
.sp
.nf
DROP INDEX \fIindex_name\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIindex_name\fB\fR
The name of the index to remove.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
The message returned if the index is successfully dropped.
.TP
\fBERROR: index "\fIindex_name\fB" nonexistent\fR
This message occurs if \fIindex_name\fR
is not an index in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP INDEX\fR drops an existing index from the database
system. To execute this command you must be the owner of
the index.
.SS "NOTES"
.PP
\fBDROP INDEX\fR is a Postgres
language extension.
.PP
Refer to 
\fBcreate_index\fR(l)
for information on how to create indexes.
.SH "USAGE"
.PP
This command will remove the title_idx index:
.sp
.nf
    DROP INDEX title_idx;
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
SQL92 defines commands by which to access
a generic relational database.
Indexes are an implementation-dependent feature and hence
there are no index-specific commands or definitions in the
SQL92 language.
