.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "DROP_AGGREGATE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
DROP AGGREGATE \- Removes the definition of an aggregate function
.SH SYNOPSIS
.sp
.nf
DROP AGGREGATE \fIname\fR \fItype\fR
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an existing aggregate function.
.TP
\fB\fItype\fB\fR
The type of an existing aggregate function.
(Refer to the \fIPostgreSQL User's Guide\fR for
further information about data types).
[Comment: This should become a cross-reference rather than a
hard-coded chapter number]
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP\fR
Message returned if the command is successful.
.TP
\fBWARN RemoveAggregate: aggregate '\fIagg\fB' for '\fItype\fB' does not exist\fR
This message occurs if the aggregate function specified does not
exist in the database.
.PP
.SH "DESCRIPTION"
.PP
\fBDROP AGGREGATE\fR will remove all references to an existing
aggregate definition. To execute this command the current
user must be the owner of the aggregate.
.SS "NOTES"
.PP
Use
\fBcreate_aggregate\fR(l)
to create aggregate functions.
.SH "USAGE"
.PP
To remove the myavg aggregate for type
int4:
.sp
.nf
DROP AGGREGATE myavg int4;
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBDROP AGGREGATE\fR statement
in SQL92; the statement is a
Postgres
language extension.
