.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_TABLE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE TABLE \- Creates a new table
.SH SYNOPSIS
.sp
.nf
CREATE [ TEMPORARY | TEMP ] TABLE \fItable\fR (
    \fIcolumn\fR \fItype\fR
    [ NULL | NOT NULL ] [ UNIQUE ] [ DEFAULT \fIvalue\fR ]
    [\fIcolumn_constraint_clause\fR | PRIMARY KEY } [ ... ] ]
    [, ... ]
    [, PRIMARY KEY ( \fIcolumn\fR [, ...] ) ]
    [, CHECK ( \fIcondition\fR ) ]
    [, \fItable_constraint_clause\fR ]
    ) [ INHERITS ( \fIinherited_table\fR [, ...] ) ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBTEMPORARY\fR
The table is created only for this session, and is
automatically dropped on session exit.
Existing permanent tables with the same name are not visible
while the temporary table exists.
.TP
\fB\fItable\fB\fR
The name of a new class or table to be created.
.TP
\fB\fIcolumn\fB\fR
The name of a column.
.TP
\fB\fItype\fB\fR
The type of the column. This may include array specifiers.
Refer to the \fIPostgreSQL User's Guide\fR for
further information about data types and arrays.
.TP
\fBDEFAULT \fIvalue\fB\fR
A default value for a column.
See the DEFAULT clause for more information.
.TP
\fB\fIcolumn_constraint_clause\fB\fR
The optional column constraint clauses specify a list of
integrity constraints or tests which new or updated entries must
satisfy for an insert or update operation to succeed. Each
constraint must evaluate to a boolean expression. Although
SQL92 requires the \fIcolumn_constraint_clause\fR to
refer to that column only, Postgres
allows multiple columns to be referenced within a single column
constraint. See the column constraint clause for more
information.
.TP
\fB\fItable_constraint_clause\fB\fR
The optional table CONSTRAINT clause specifies a
list of integrity constraints which new or updated entries must
satisfy for an insert or update operation to succeed. Each
constraint must evaluate to a boolean expression. Multiple
columns may be referenced within a single constraint. Only one
PRIMARY KEY clause may be specified for a table;
PRIMARY KEY \fIcolumn\fR (a table
constraint) and PRIMARY KEY (a column constraint)
are mutually exclusive.. See the table constraint clause for
more information.
.TP
\fBINHERITS \fIinherited_table\fB\fR
The optional INHERITS clause specifies a collection of table
names from which this table automatically inherits all fields.
If any inherited field name appears more than once, 
Postgres
reports an error.
Postgres automatically allows the created
table to inherit functions on tables above it in the inheritance
hierarchy.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if table is successfully created.
.TP
\fBERROR\fR
Message returned if table creation failed.
This is usually accompanied by some descriptive text, such as:
ERROR: Relation '\fItable\fR' already exists
which occurs at runtime, if the table specified already exists
in the database.
.TP
\fBERROR: DEFAULT: type mismatched\fR
If data type of default value doesn't match the
column definition's data type.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE\fR will enter a new class or table
into the current data base. The table will be "owned" by the user issuing the
command.
.PP
Each \fItype\fR
may be a simple type, a complex type (set) or an array type.
Each attribute may be specified to be non-null and
each may have a default value, specified by the
\fBcreate_table\fR(l).
.PP
.sp
.RS
.B "Note:"
As of Postgres version 6.0, consistent array dimensions within an
attribute are not enforced. This will likely change in a future
release.
.RE
.sp
.PP
The optional INHERITS
clause specifies a collection of class names from which this class
automatically inherits all fields. If any inherited field name
appears more than once, Postgres reports an error. Postgres automatically
allows the created class to inherit functions on classes above it in
the inheritance hierarchy. Inheritance of functions is done according
to the conventions of the Common Lisp Object System (CLOS).
.PP
Each new table or class \fItable\fR
is automatically created as a type. Therefore, one or more instances
from the class are automatically a type and can be used in 
\fBalter_table\fR(l)
or other \fBCREATE TABLE\fR statements.
.PP
The new table is created as a heap with no initial data.
A table can have no more than 1600 columns (realistically,
this is limited by the fact that tuple sizes must
be less than 8192 bytes), but this limit may be configured
lower at some sites. A table cannot have the same name as
a system catalog table.
.SH "DEFAULT CLAUSE"
.PP
.sp
.nf
DEFAULT \fIvalue\fR
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIvalue\fB\fR
The possible values for the default value expression are:
.RS
.TP 0.2i
\(bu
a literal value
.TP 0.2i
\(bu
a user function
.TP 0.2i
\(bu
a niladic function
.RE
.PP
.PP
.SS "OUTPUTS"
.PP
None.
.SS "DESCRIPTION"
.PP
The DEFAULT clause assigns a default data value to a column
(via a column definition in the CREATE TABLE statement). 
The data type of a default value must match the column definition's
data type.
.PP
An INSERT operation that includes a column without a specified
default value will assign the NULL value to the column
if no explicit data value is provided for it.
Default \fIliteral\fR means
that the default is the specified constant value.
Default \fIniladic-function\fR
or \fIuser-function\fR means
that the default
is the value of the specified function at the time of the INSERT.
.PP
There are two types of niladic functions:
.TP
\fBniladic USER\fR
.RS
.TP
\fBCURRENT_USER / USER\fR
See CURRENT_USER function
.TP
\fBSESSION_USER\fR
See CURRENT_USER function
.TP
\fBSYSTEM_USER\fR
Not implemented
.RE
.PP
.TP
\fBniladic datetime\fR
.RS
.TP
\fBCURRENT_DATE\fR
See CURRENT_DATE function
.TP
\fBCURRENT_TIME\fR
See CURRENT_TIME function
.TP
\fBCURRENT_TIMESTAMP\fR
See CURRENT_TIMESTAMP function
.RE
.PP
.SS "USAGE"
.PP
To assign a constant value as the default for the
columns did and number,
and a string literal to the column did:
.sp
.nf
CREATE TABLE video_sales (
    did      VARCHAR(40) DEFAULT 'luso films',
    number   INTEGER DEFAULT 0,
    total    CASH DEFAULT '$0.0'
);
    
.sp
.fi
.PP
To assign an existing sequence
as the default for the column did,
and a literal to the column name:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3)  DEFAULT NEXTVAL('serial'),
    name     VARCHAR(40) DEFAULT 'luso films'
);
    
.sp
.fi
.SH "COLUMN CONSTRAINT CLAUSE"
.PP
.sp
.nf
[ CONSTRAINT \fIname\fR ] { [
    NULL | NOT NULL ] | UNIQUE | PRIMARY KEY | CHECK \fIconstraint\fR | REFERENCES 
     \fIreftable\fR
     (\fIrefcolumn\fR)
     [ MATCH \fImatchtype\fR ]
     [ ON DELETE \fIaction\fR ] 
     [ ON UPDATE \fIaction\fR ]
     [ [ NOT ] DEFERRABLE ] 
     [ INITIALLY \fIchecktime\fR ] }
    [, ...]
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
An arbitrary name given to the integrity constraint. 
If \fIname\fR is not specified,
it is generated from the table and column names,
which should ensure uniqueness for
\fIname\fR.
.TP
\fBNULL\fR
The column is allowed to contain NULL values. This is the default.
.TP
\fBNOT NULL\fR
The column is not allowed to contain NULL values.
This is equivalent to the column constraint
CHECK (\fIcolumn\fR NOT NULL).
.TP
\fBUNIQUE\fR
The column must have unique values. In Postgres
this is enforced by an implicit creation of a unique index on the table.
.TP
\fBPRIMARY KEY\fR
This column is a primary key, which implies that uniqueness is
enforced by the system and that other tables may rely on this
column as a unique identifier for rows. See PRIMARY KEY for more
information.
.TP
\fB\fIconstraint\fB\fR
The definition of the constraint.
.PP
.SS "DESCRIPTION"
.PP
The optional constraint clauses specify constraints or tests which
new or updated entries must satisfy for an insert or update
operation to succeed. Each constraint must evaluate to a boolean
expression. Multiple attributes may be referenced within a single
constraint. The use of PRIMARY KEY as a table constraint is mutually
incompatible with PRIMARY KEY as a column constraint.
.PP
A constraint is a named rule: an SQL object which helps define
valid sets of values by putting limits on the results of INSERT,
UPDATE or DELETE operations performed on a Base Table. 
.PP
There are two ways to define integrity constraints:
table constraints, covered later, and column constraints, covered here.
.PP
A column constraint is an integrity constraint defined as part of a
column definition, and logically becomes a table constraint as soon
as it is created. The column constraints available are:

PRIMARY KEY

REFERENCES

UNIQUE

CHECK

NOT NULL
.SS "NOT NULL CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] NOT NULL 
   
.sp
.fi
.PP
The NOT NULL constraint specifies a rule that a column may
contain only non-null values. 
This is a column constraint only, and not allowed
as a table constraint.
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: ExecAppend: Fail to add null value in not null attribute "\fIcolumn\fB".\fR
This error occurs at runtime if one tries to insert a null value
into a column which has a NOT NULL constraint.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
.SS "USAGE"
.PP
Define two NOT NULL column constraints on the table
\fBdistributors\fR,
one of which being a named constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3) CONSTRAINT no_null NOT NULL,
    name     VARCHAR(40) NOT NULL
);
     
.sp
.fi
.SS "UNIQUE CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] UNIQUE
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary label given to a constraint.
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: Cannot insert a duplicate key into a unique index.\fR
This error occurs at runtime if one tries to insert a
duplicate value into a column.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The UNIQUE constraint specifies a rule that a group of one or
more distinct columns of a table may contain only unique values.
.PP
The column definitions of the specified columns do not have to
include a NOT NULL constraint to be included in a UNIQUE
constraint. Having more than one null value in a column without a
NOT NULL constraint, does not violate a UNIQUE constraint. (This
deviates from the SQL92 definition, but is a
more sensible convention. See the section on compatibility for more
details.).
.PP
Each UNIQUE column constraint must name a column that is
different from the set of columns named by any other UNIQUE or
PRIMARY KEY constraint defined for the table.
.sp
.RS
.B "Note:"
Postgres automatically creates a unique
index for each UNIQUE constraint, to assure
data integrity. See CREATE INDEX for more information.
.RE
.sp
.SS "USAGE"
.PP
Defines a UNIQUE column constraint for the table distributors.
UNIQUE column constraints can only be defined on one column
of the table:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40) UNIQUE
);
  
.sp
.fi
which is equivalent to the following specified as a table constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40),
    UNIQUE(name)
);
     
.sp
.fi
.SS "THE CHECK CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] CHECK
    ( \fIcondition\fR [, ...] ) 
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
An arbitrary name given to a constraint.
.TP
\fB\fIcondition\fB\fR
Any valid conditional expression evaluating to a boolean result.
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: ExecAppend: rejected due to CHECK constraint "\fItable_column\fB".\fR
This error occurs at runtime if one tries to insert an illegal
value into a column subject to a CHECK constraint.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The CHECK constraint specifies a restriction on allowed values
within a column. The CHECK constraint is also allowed as a table
constraint.
.PP
The SQL92 CHECK column constraints can only be defined on, and
refer to, one column of the table.
Postgres does not have this restriction.
.SS "PRIMARY KEY CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] PRIMARY KEY 
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary name for the constraint.
.PP
.SS "OUTPUTS"
.TP
\fBERROR: Cannot insert a duplicate key into a unique index.\fR
This occurs at run-time if one tries to insert a duplicate value into
a column subject to a PRIMARY KEY constraint.
.SS "DESCRIPTION"
.PP
The PRIMARY KEY column constraint specifies that a column of a
table may contain only unique (non-duplicate), non-NULL values. The
definition of the specified column does not have to include an
explicit NOT NULL constraint to be included in a PRIMARY KEY
constraint.
.PP
Only one PRIMARY KEY can be specified for a table.
.SS "NOTES"
.PP
Postgres automatically creates
a unique index to assure
data integrity. (See CREATE INDEX statement)
.PP
The PRIMARY KEY constraint should name a set of columns that is
different from other sets of columns named by any UNIQUE constraint
defined for the same table, since it will result in duplication
of equivalent indexes and unproductive additional runtime overhead.
However, Postgres does not specifically
disallow this.
.SS "REFERENCES CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR ) ] 
    [ MATCH \fImatchtype\fR ]
    [ ON DELETE \fIaction\fR ] 
    [ ON UPDATE \fIaction\fR ]
    [ [ NOT ] DEFERRABLE ] 
    [ INITIALLY \fIchecktime\fR ]
   
.sp
.fi
.PP
The REFERENCES constraint specifies a rule that a column
value is checked against the values of another column.
REFERENCES can also be specified as part of
a FOREIGN KEY table constraint.
.SS "INPUTS"
.PP
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary name for the constraint.
.TP
\fB\fIreftable\fB\fR
The table that contains the data to check against.
.TP
\fB\fIrefcolumn\fB\fR
The column in \fIreftable\fR
to check the data against. If this is not specified, the PRIMARY KEY of the
\fIreftable\fR is used.
.TP
\fBMATCH \fImatchtype\fB\fR
There are three match types: MATCH FULL, MATCH PARTIAL, and a
default match type if none is specified. MATCH FULL will not
allow one column of a multi-column foreign key to be NULL
unless all foreign key columns are NULL. The default MATCH type
allows a some foreign key columns to be NULL while other parts
of the foreign key are not NULL. MATCH PARTIAL is currently not
supported.
.TP
\fBON DELETE \fIaction\fB\fR
The action to do when a referenced row in the referenced table is being
deleted. There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Same as NO ACTION.
.TP
\fBCASCADE\fR
Delete any rows referencing the deleted row.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fBON UPDATE \fIaction\fB\fR
The action to do when a referenced column in the referenced
table is being updated to a new value. If the row is updated,
but the referenced column is not changed, no action is done.
There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Same as NO ACTION.
.TP
\fBCASCADE\fR
Update the value of the referencing column to the new value of the
referenced column.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fB[ NOT ] DEFERRABLE\fR
This controls whether the constraint can be deferred to the end
of the transaction. If DEFERRABLE, SET CONSTRAINTS ALL DEFERRED
will cause the foreign key to be checked only at the end of the
transaction. NOT DEFERRABLE is the default.
.TP
\fBINITIALLY \fIchecktime\fB\fR
\fIchecktime\fR has two possible values 
which specify the default time to check the constraint.
.RS
.TP
\fBDEFERRED\fR
Check constraint only at the end of the transaction.
.TP
\fBIMMEDIATE\fR
Check constraint after each statement. This is the default.
.RE
.PP
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: \fIname\fB referential integrity violation - key referenced from\fR
This error occurs at runtime if one tries to insert a value
into a column which does not have a matching column in the
referenced table.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The REFERENCES column constraint specifies that a
column of a table must only contain values which match against
values in a referenced column of a referenced table.
.PP
A value added to this column are matched against the values of the
referenced table and referenced column using the given match type.
In addition, when the referenced column data is changed, actions
are run upon this column's matching data.
.SS "NOTES"
.PP
Currently Postgres only supports MATCH
FULL and a default match type. In addition, the referenced
columns are supposed to be the columns of a UNIQUE constraint in
the referenced table, however Postgres
does not enforce this.
.SH "TABLE CONSTRAINT CLAUSE"
.PP
.sp
.nf
[ CONSTRAINT name ] { PRIMARY KEY |  UNIQUE } ( \fIcolumn\fR [, ...] )
[ CONSTRAINT name ] CHECK ( \fIconstraint\fR )
[ CONSTRAINT name ] FOREIGN KEY ( \fIcolumn\fR [, ...] ) 
                     REFERENCES \fIreftable\fR
                      (\fIrefcolumn\fR [, ...] )
                      [ MATCH \fImatchtype\fR ] 
                      [ ON DELETE \fIaction\fR ] 
                      [ ON UPDATE \fIaction\fR ]
                      [ [ NOT ] DEFERRABLE ] 
                      [ INITIALLY \fIchecktime\fR ]
   
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary name given to an integrity constraint.
.TP
\fB\fIcolumn\fB [, ...]\fR
The column name(s) for which to define a unique index
and, for PRIMARY KEY, a NOT NULL constraint.
.TP
\fBCHECK ( \fIconstraint\fB )\fR
A boolean expression to be evaluated as the constraint.
.PP
.SS "OUTPUTS"
.PP
The possible outputs for the table constraint clause are the same
as for the corresponding portions of the column constraint clause.
.SS "DESCRIPTION"
.PP
A table constraint is an integrity constraint defined on one or
more columns of a base table. The four variations of "Table
Constraint" are:

UNIQUE

CHECK

PRIMARY KEY

FOREIGN KEY
.SS "UNIQUE CONSTRAINT"
.PP
.sp
.nf
[ CONSTRAINT \fIname\fR ] UNIQUE ( \fIcolumn\fR [, ...] )
    
.sp
.fi
.SS "INPUTS"
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary name given to a constraint.
.TP
\fB\fIcolumn\fB\fR
A name of a column in a table.
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: Cannot insert a duplicate key into a unique index\fR
This error occurs at runtime if one tries to insert a
duplicate value into a column.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The UNIQUE constraint specifies a rule that a group of one or more
distinct columns of a table may contain only unique values. The
behavior of the UNIQUE table constraint is the same as that for
column constraints, with the additional capability to span multiple
columns.
.PP
See the section on the UNIQUE column constraint for more details.
.SS "USAGE"
.PP
Define a UNIQUE table constraint for the table distributors:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(03),
    name     VARCHAR(40),
    UNIQUE(name)
);
     
.sp
.fi
.SS "PRIMARY KEY CONSTRAINT"
.PP
.sp
.nf
[ CONSTRAINT \fIname\fR ] PRIMARY KEY ( \fIcolumn\fR [, ...] ) 
    
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary name for the constraint.
.TP
\fB\fIcolumn\fB [, ...]\fR
The names of one or more columns in the table.
.PP
.SS "OUTPUTS"
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: Cannot insert a duplicate key into a unique index.\fR
This occurs at run-time if one tries to insert a duplicate
value into a column subject to a PRIMARY KEY constraint.
.RE
.PP
.SS "DESCRIPTION"
.PP
The PRIMARY KEY constraint specifies a rule that a group of one
or more distinct columns of a table may contain only unique,
(non duplicate), non-null values. The column definitions of
the specified columns do not have to include a NOT NULL
constraint to be included in a PRIMARY KEY constraint.
.PP
The PRIMARY KEY table constraint is similar to that for column constraints,
with the additional capability of encompassing multiple columns.
.PP
Refer to the section on the PRIMARY KEY column constraint for more
information.
.SS "REFERENCES CONSTRAINT"
.sp
.nf
[ CONSTRAINT \fIname\fR ] FOREIGN KEY ( \fIcolumn\fR [, ...] )
    REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR [, ...] ) ] 
    [ MATCH \fImatchtype\fR ]
    [ ON DELETE \fIaction\fR ] 
    [ ON UPDATE \fIaction\fR ]
    [ [ NOT ] DEFERRABLE ]
    [ INITIALLY \fIchecktime\fR ]
   
.sp
.fi
.PP
The REFERENCES constraint specifies a rule that a column value is
checked against the values of another column. REFERENCES can also be
specified as part of a FOREIGN KEY table constraint.
.SS "INPUTS"
.PP
.TP
\fBCONSTRAINT \fIname\fB\fR
An arbitrary name for the constraint.
.TP
\fB\fIcolumn\fB [, ...]\fR
The names of one or more columns in the table.
.TP
\fB\fIreftable\fB\fR
The table that contains the data to check against.
.TP
\fB\fIreferenced column\fB [, ...]\fR
One or more column in the \fIreftable\fR
to check the data against. If this is not specified, the PRIMARY KEY of the
\fIreftable\fR is used.
.TP
\fBMATCH \fImatchtype\fB\fR
There are three match types: MATCH FULL, MATCH PARTIAL, and a
default match type if none is specified. MATCH FULL will not
allow one column of a multi-column foreign key to be NULL
unless all foreign key columns are NULL. The default MATCH type
allows a some foreign key columns to be NULL while other parts
of the foreign key are not NULL. MATCH PARTIAL is currently not
supported.
.TP
\fBON DELETE \fIaction\fB\fR
The action to do when a referenced row in the referenced table is being
deleted. There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Same as NO ACTION.
.TP
\fBCASCADE\fR
Delete any rows referencing the deleted row.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fBON UPDATE \fIaction\fB\fR
The action to do when a referenced column in the referenced
table is being updated to a new value. If the row is updated,
but the referenced column is not changed, no action is done.
There are the following actions.
.RS
.TP
\fBNO ACTION\fR
Produce error if foreign key violated. This is the default.
.TP
\fBRESTRICT\fR
Disallow update of row being referenced.
.TP
\fBCASCADE\fR
Update the value of the referencing column to the new value
of the referenced column.
.TP
\fBSET NULL\fR
Set the referencing column values to NULL.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP
.TP
\fB[ NOT ] DEFERRABLE\fR
This controls whether the constraint can be deferred to the end
of the transaction. If DEFERRABLE, SET CONSTRAINTS ALL DEFERRED
will cause the foreign key to be checked only at the end of the
transaction. NOT DEFERRABLE is the default.
.TP
\fBINITIALLY \fIchecktime\fB\fR
\fIchecktime\fR has two
possible values which specify the default time to check the
constraint.
.RS
.TP
\fBIMMEDIATE\fR
Check constraint after each statement. This is the default.
.TP
\fBDEFERRED\fR
Check constraint only at the end of the transaction.
.RE
.PP
.PP
.SS "OUTPUTS"
.PP
.TP
\fB\fIstatus\fB\fR
.RS
.TP
\fBERROR: \fIname\fB referential integrity violation - key referenced from\fR
This error occurs at runtime if one tries to insert a value
into a column which does not have a matching column in the
referenced table.
.RE
.PP
.PP
.SS "DESCRIPTION"
.PP
The FOREIGN KEY constraint specifies a rule that a group of one
or more distinct columns of a table are related to a group
of distinct columns in the referenced table.
.PP
The FOREIGN KEY table constraint is similar to that for column
constraints, with the additional capability of encompassing
multiple columns.
.PP
Refer to the section on the FOREIGN KEY column constraint for more
information.
.SH "USAGE"
.PP
Create table films and table distributors:
.sp
.nf
CREATE TABLE films (
     code      CHARACTER(5) CONSTRAINT firstkey PRIMARY KEY,
     title     CHARACTER VARYING(40) NOT NULL,
     did       DECIMAL(3) NOT NULL,
     date_prod DATE,
     kind      CHAR(10),
     len       INTERVAL HOUR TO MINUTE
);
   
.sp
.fi
.sp
.nf
CREATE TABLE distributors (
     did      DECIMAL(03) PRIMARY KEY DEFAULT NEXTVAL('serial'),
     name     VARCHAR(40) NOT NULL CHECK (name <> '')
);
   
.sp
.fi
.PP
Create a table with a 2-dimensional array:
.sp
.nf
   CREATE TABLE array (
          vector INT[][]
          );
   
.sp
.fi
.PP
Define a UNIQUE table constraint for the table films.
UNIQUE table constraints can be defined on one or more
columns of the table:
.sp
.nf
CREATE TABLE films (
    code      CHAR(5),
    title     VARCHAR(40),
    did       DECIMAL(03),
    date_prod DATE,
    kind      CHAR(10),
    len       INTERVAL HOUR TO MINUTE,
    CONSTRAINT production UNIQUE(date_prod)
);
   
.sp
.fi
.PP
Define a CHECK column constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3) CHECK (did > 100),
    name     VARCHAR(40)
);
   
.sp
.fi
.PP
Define a CHECK table constraint:
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(3),
    name     VARCHAR(40)
    CONSTRAINT con1 CHECK (did > 100 AND name > '')
);
   
.sp
.fi
.PP
Define a PRIMARY KEY table constraint for the table films.
PRIMARY KEY table constraints can be defined on one or more
columns of the table:
.sp
.nf
CREATE TABLE films (
    code      CHAR(05),
    title     VARCHAR(40),
    did       DECIMAL(03),
    date_prod DATE,
    kind      CHAR(10),
    len       INTERVAL HOUR TO MINUTE,
    CONSTRAINT code_title PRIMARY KEY(code,title)
);
   
.sp
.fi
.PP
Defines a PRIMARY KEY column constraint for table distributors.
PRIMARY KEY column constraints can only be defined on one column
of the table (the following two examples are equivalent):
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(03),
    name     CHAR VARYING(40),
    PRIMARY KEY(did)
); 
   
.sp
.fi
.sp
.nf
CREATE TABLE distributors (
    did      DECIMAL(03) PRIMARY KEY,
    name     VARCHAR(40)
);
   
.sp
.fi
.SS "NOTES"
.PP
CREATE TABLE/INHERITS is a Postgres
language extension.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
In addition to the locally-visible temporary table, SQL92 also defines a
CREATE GLOBAL TEMPORARY TABLE statement, and optionally an 
ON COMMIT clause:
.sp
.nf
CREATE GLOBAL TEMPORARY TABLE \fItable\fR ( \fIcolumn\fR \fItype\fR [
    DEFAULT \fIvalue\fR ] [ CONSTRAINT \fIcolumn_constraint\fR ] [, ...] )
    [ CONSTRAINT \fItable_constraint\fR ] [ ON COMMIT { DELETE | PRESERVE } ROWS ] 
   
.sp
.fi
.PP
For temporary tables, the CREATE GLOBAL TEMPORARY TABLE statement
names a new table visible to other clients and defines the table's columns and
constraints. 
.PP
The optional ON COMMIT clause of CREATE TEMPORARY TABLE specifies
whether or not the temporary table should be emptied of rows
whenever COMMIT is executed. If the ON COMMIT clause is omitted, the
default option, ON COMMIT DELETE ROWS, is assumed.
.PP
To create a temporary table:
.sp
.nf
CREATE TEMPORARY TABLE actors (
    id         DECIMAL(03),
    name       VARCHAR(40),
    CONSTRAINT actor_id CHECK (id < 150)
) ON COMMIT DELETE ROWS;
    
.sp
.fi
.SS "UNIQUE CLAUSE"
.PP
SQL92 specifies some additional capabilities for UNIQUE:
.PP
Table Constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] UNIQUE ( \fIcolumn\fR [, ...] )
    [ { INITIALLY DEFERRED | INITIALLY IMMEDIATE } ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Column Constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] UNIQUE
      [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
      [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.SS "NULL CLAUSE"
.PP
The NULL "constraint" (actually a non-constraint) is a
Postgres extension to SQL92 is
included for symmetry with the NOT NULL clause. Since it is the
default for any column, its presence is simply noise.
.sp
.nf
[ CONSTRAINT \fIname\fR ] NULL 
     
.sp
.fi
.SS "NOT NULL CLAUSE"
.PP
SQL92 specifies some additional capabilities for NOT NULL:
.sp
.nf
[ CONSTRAINT \fIname\fR ] NOT NULL 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.SS "CONSTRAINT CLAUSE"
.PP
SQL92 specifies some additional capabilities for constraints,
and also defines assertions and domain constraints.
.sp
.RS
.B "Note:"
Postgres does not yet support 
either domains or assertions.
.RE
.sp
.PP
An assertion is a special type of integrity constraint and share
the same namespace as other constraints. However, an assertion is
not necessarily dependent on one particular base table as
constraints are, so SQL-92 provides the CREATE ASSERTION statement
as an alternate method for defining a constraint:
.sp
.nf
CREATE ASSERTION \fIname\fR CHECK ( \fIcondition\fR )
    
.sp
.fi
.PP
Domain constraints are defined by CREATE DOMAIN or ALTER DOMAIN
statements:
.PP
Domain constraint: 
.sp
.nf
[ CONSTRAINT \fIname\fR ] CHECK \fIconstraint\fR 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Table constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] { PRIMARY KEY ( \fIcolumn\fR, ... ) | FOREIGN KEY \fIconstraint\fR | UNIQUE \fIconstraint\fR | CHECK \fIconstraint\fR }
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Column constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] { NOT NULL | PRIMARY KEY | FOREIGN KEY \fIconstraint\fR | UNIQUE | CHECK \fIconstraint\fR }  
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
A CONSTRAINT definition may contain one deferment attribute
clause and/or one initial constraint mode clause, in any order.
.TP
\fBNOT DEFERRABLE\fR
The constraint must be checked at the end of each statement.
SET CONSTRAINTS ALL DEFERRED will have no effect on this type
of constraint.
.TP
\fBDEFERRABLE\fR
This controls whether the constraint can be deferred to the end
of the transaction. If SET CONSTRAINTS ALL DEFERRED is used or
the constraint is set to INITIALLY DEFERRED, this will cause
the foreign key to be checked only at the end of the
transaction.
.PP
.PP
SET CONSTRAINT changes the foreign key constraint mode only for
the current transaction.
.TP
\fBINITIALLY IMMEDIATE\fR
Check constraint only at the end of the transaction. This
is the default
.TP
\fBINITIALLY DEFERRED\fR
Check constraint after each statement.
.PP
.SS "CHECK CLAUSE"
.PP
SQL92 specifies some additional capabilities for CHECK in either
table or column constraints.
.PP
table constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] CHECK ( VALUE \fIcondition\fR ) 
      [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
      [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
column constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] CHECK ( VALUE \fIcondition\fR ) 
      [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
      [ [ NOT ] DEFERRABLE ]
    
.sp
.fi
.SS "PRIMARY KEY CLAUSE"
.PP
SQL92 specifies some additional capabilities for PRIMARY KEY:
.PP
Table Constraint definition:
.sp
.nf
[ CONSTRAINT \fIname\fR ] PRIMARY KEY ( \fIcolumn\fR [, ...] ) 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
.PP
Column Constraint definition: 
.sp
.nf
[ CONSTRAINT \fIname\fR ] PRIMARY KEY 
    [ {INITIALLY DEFERRED | INITIALLY IMMEDIATE} ]
    [ [ NOT ] DEFERRABLE ]
     
.sp
.fi
