.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_AGGREGATE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE AGGREGATE \- Defines a new aggregate function
.SH SYNOPSIS
.sp
.nf
CREATE AGGREGATE \fIname\fR ( BASETYPE = \fIinput_data_type\fR
    [ , SFUNC1 = \fIsfunc1\fR, STYPE1 = \fIstate1_type\fR ]
    [ , SFUNC2 = \fIsfunc2\fR, STYPE2 = \fIstate2_type\fR ]
    [ , FINALFUNC = \fIffunc\fR ]
    [ , INITCOND1 = \fIinitial_condition1\fR ]
    [ , INITCOND2 = \fIinitial_condition2\fR ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of an aggregate function to create.
.TP
\fB\fIinput_data_type\fB\fR
The input data type on which this aggregate function operates.
.TP
\fB\fIsfunc1\fB\fR
A state transition function
to be called for every non-NULL input data value.
This must be a function of two arguments, the first being of
type \fIstate1_type\fR
and the second of
type \fIinput_data_type\fR.
The function must return a value of
type \fIstate1_type\fR.
This function takes the current state value 1 and the current
input data item, and returns the next state value 1.
.TP
\fB\fIstate1_type\fB\fR
The data type for the first state value of the aggregate.
.TP
\fB\fIsfunc2\fB\fR
A state transition function
to be called for every non-NULL input data value.
This must be a function of one argument of
type \fIstate2_type\fR,
returning a value of the same type.
This function takes the current state value 2 and
returns the next state value 2.
.TP
\fB\fIstate2_type\fB\fR
The data type for the second state value of the aggregate.
.TP
\fB\fIffunc\fB\fR
The final function called to compute the aggregate's result
after all input data has been traversed.
If both state values are used, the final function must
take two arguments of types
\fIstate1_type\fR
and
\fIstate2_type\fR.
If only one state value is used, the final function must
take a single argument of that state value's type.
The output datatype of the aggregate is defined as the return
type of this function.
.TP
\fB\fIinitial_condition1\fB\fR
The initial value for state value 1.
.TP
\fB\fIinitial_condition2\fB\fR
The initial value for state value 2.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the command completes successfully.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE AGGREGATE\fR 
allows a user or programmer to extend Postgres
functionality by defining new aggregate functions. Some aggregate functions
for base types such as \fBmin(int4)\fR
and \fBavg(float8)\fR are already provided in the base
distribution. If one defines new types or needs an aggregate function not
already provided then \fBCREATE AGGREGATE\fR
can be used to provide the desired features.
.PP
An aggregate function is identified by its name and input data type.
Two aggregates can have the same name if they operate on different
input types. To avoid confusion, do not make an ordinary function
of the same name and input data type as an aggregate.
.PP
An aggregate function is made from between one and three ordinary
functions:
two state transition functions, 
\fIsfunc1\fR
and \fIsfunc2\fR,
and a final calculation function,
\fIffunc\fR.
These are used as follows:
.sp
.nf
\fIsfunc1\fR( internal-state1, next-data-item ) ---> next-internal-state1
\fIsfunc2\fR( internal-state2 ) ---> next-internal-state2
\fIffunc\fR(internal-state1, internal-state2) ---> aggregate-value
   
.sp
.fi
.PP
Postgres creates one or two temporary variables
(of data types \fIstype1\fR and/or
\fIstype2\fR) to hold the
current internal states of the aggregate. At each input data item,
the state transition function(s) are invoked to calculate new values
for the internal state values. After all the data has been processed,
the final function is invoked once to calculate the aggregate's output
value.
.PP
\fIffunc\fR must be specified if
both transition functions are specified. If only one transition function
is used, then \fIffunc\fR is
optional. The default behavior when
\fIffunc\fR is not provided is
to return the ending value of the internal state value being used
(and, therefore, the aggregate's output type is the same as that
state value's type).
.PP
An aggregate function may also provide one or two initial conditions,
that is, initial values for the internal state values being used.
These are specified and stored in the database as fields of type
\fBtext\fR, but they must be valid external representations
of constants of the state value datatypes. If
\fIsfunc1\fR is specified 
without an \fIinitcond1\fR value,
then the system does not call
\fIsfunc1\fR 
at the first input item; instead, the internal state value 1 is
initialized with the first input value, and
\fIsfunc1\fR is called beginning 
at the second input item. This is useful for aggregates like MIN and
MAX. Note that an aggregate using this feature will return NULL when
called with no input values. There is no comparable provision for
state value 2; if \fIsfunc2\fR is
specified then an \fIinitcond2\fR is
required.
.SS "NOTES"
.PP
Use \fBDROP AGGREGATE\fR
to drop aggregate functions.
.PP
The parameters of \fBCREATE AGGREGATE\fR can be written
in any order, not just the order illustrated above.
.PP
It is possible to specify aggregate functions
that have varying combinations of state and final functions. 
For example, the \fBcount\fR aggregate requires
\fIsfunc2\fR 
(an incrementing function) but not
\fIsfunc1\fR or 
\fIffunc\fR,
whereas the \fBsum\fR aggregate requires
\fIsfunc1\fR (an addition
function) but not \fIsfunc2\fR or
\fIffunc\fR, and the
\fBavg\fR
aggregate requires 
both state functions as
well as a \fIffunc\fR (a division
function) to produce its 
answer. In any case, at least one state function must be
defined, and any \fIsfunc2\fR must
have a corresponding
\fIinitcond2\fR. 
.SH "USAGE"
.PP
Refer to the chapter on aggregate functions
in the \fIPostgreSQL Programmer's Guide\fR for
complete examples of usage.
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE AGGREGATE\fR 
is a Postgres language extension.
There is no \fBCREATE AGGREGATE\fR in SQL92.
