/* Processed by ecpg (2.10.0) */
/* These four include files are added by the preprocessor */
#include <ecpgtype.h>
#include <ecpglib.h>
#include <ecpgerrno.h>
#include <sqlca.h>
#line 1 "sqlwrite.ec"
#include <arpa/inet.h>
#include <net/ethernet.h>
#include <netdb.h>
#include <netinet/ether.h>
#include <netinet/if_ether.h>
#include <netinet/ip.h>
#include <pthread.h>
#include <sys/time.h>
#include <unistd.h>
#include <pcap.h>
#include <syslog.h>

#include <unistd.h>
#include <stdio.h>
#include <getopt.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <iostream>

#include <list>
#include <map>

using namespace std;


#include "ip.h"
#include "dns.h"
#include "prio.h"


#line 1 "/usr/local/postgres/include/sqlca.h"
#ifndef POSTGRES_SQLCA_H
#define POSTGRES_SQLCA_H

#ifndef DLLIMPORT
#ifdef __CYGWIN__
#define DLLIMPORT __declspec (dllimport)
#else
#define DLLIMPORT
#endif   /* __CYGWIN__ */
#endif   /* DLLIMPORT */

#define SQLERRMC_LEN	70

#ifdef __cplusplus
extern		"C"
{
#endif

struct sqlca
{
	char		sqlcaid[8];
	long		sqlabc;
	long		sqlcode;
	struct
	{
		int			sqlerrml;
		char		sqlerrmc[SQLERRMC_LEN];
	}			sqlerrm;
	char		sqlerrp[8];
	long		sqlerrd[6];
	/* Element 0: empty						*/
	/* 1: OID of processed tuple if applicable			*/
	/* 2: number of rows processed				*/
	/* after an INSERT, UPDATE or				*/
	/* DELETE statement					*/
	/* 3: empty						*/
	/* 4: empty						*/
	/* 5: empty						*/
	char		sqlwarn[8];
	/* Element 0: set to 'W' if at least one other is 'W'	*/
	/* 1: if 'W' at least one character string		*/
	/* value was truncated when it was			*/
	/* stored into a host variable.				*/

	/*
	 * 2: if 'W' a (hopefully) non-fatal notice occured
	 */	/* 3: empty */
	/* 4: empty						*/
	/* 5: empty						*/
	/* 6: empty						*/
	/* 7: empty						*/

	char		sqlext[8];
};

extern DLLIMPORT struct sqlca sqlca;


#ifdef __cplusplus
}
#endif

#endif

#line 31 "sqlwrite.ec"


void	SQLConnect(char *connectionInfo)
{
	/* exec sql begin declare section */
		
	
#line 36 "sqlwrite.ec"
   char * connection   ;
/* exec sql end declare section */
#line 37 "sqlwrite.ec"


	connection = connectionInfo;

	{ ECPGconnect(__LINE__, connection , NULL,NULL , NULL, 0); }
#line 41 "sqlwrite.ec"

	if(sqlca.sqlcode) {
		cerr << "connect Error # " << sqlca.sqlerrm.sqlerrml << " '" << sqlca.sqlerrm.sqlerrmc << "'" << endl;
		exit(0);
	}
}

static void timevalToDate(const struct timeval *in, char *out)
{
   struct tm *ti = localtime(&in->tv_sec);
	sprintf(out, "%04d-%02d-%02d %02d:%02d:%02d.%d", 
			ti->tm_year + 1900, ti->tm_mon + 1, ti->tm_mday,
			ti->tm_hour, ti->tm_min, ti->tm_sec,
			in->tv_usec);
}

bool	SQlSaveRecord(CRecord *cr, string interfaceName)
{
	struct in_addr kk;
	/* exec sql begin declare section */
		
		
		
	 	
		
	 	
		
		
	  
	 		
	
#line 61 "sqlwrite.ec"
   int  f_src_ip_serial   ;
 
#line 62 "sqlwrite.ec"
   int  f_dst_ip_serial   ;
 
#line 63 "sqlwrite.ec"
   int  f_port_src   ;
 
#line 64 "sqlwrite.ec"
   int  f_port_dst   ;
 
#line 65 "sqlwrite.ec"
   int  f_protocol_number   ;
 
#line 66 "sqlwrite.ec"
   int  f_volume   ;
 
#line 67 "sqlwrite.ec"
   int  f_packets   ;
 
#line 68 "sqlwrite.ec"
   char  f_lastUpdate [ 30 ]   ;
 
#line 69 "sqlwrite.ec"
   char  f_firstUpdate [ 30 ]   ;
 
#line 70 "sqlwrite.ec"
  const char * f_interface   ;
/* exec sql end declare section */
#line 71 "sqlwrite.ec"


	f_port_src = cr->port_src_m;
	f_src_ip_serial = cr->srcSerial_m;
	f_port_dst = cr->port_dst_m;
	f_dst_ip_serial = cr->dstSerial_m;
	f_protocol_number = cr->ip_proto_m;
	f_volume = cr->volume_m;
	f_packets = cr->packets_m;
	timevalToDate(&cr->lastUpdate_m, f_lastUpdate);
	timevalToDate(&cr->firstUpdate_m, f_firstUpdate);
	f_interface = interfaceName.c_str();

	{ ECPGtrans(__LINE__, NULL, "begin transaction");}
#line 84 "sqlwrite.ec"

	{ ECPGdo(__LINE__, NULL, "insert into usage ( src_ip_serial  , dst_ip_serial  , port_src  , port_dst  , protocol_number  , first_seen  , last_seen  , packets  , volume  , interface  ) values ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? )", 
	ECPGt_int,&(f_src_ip_serial),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_dst_ip_serial),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_port_src),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_port_dst),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_protocol_number),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_firstUpdate),30L,1L,30*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_lastUpdate),30L,1L,30*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_packets),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_int,&(f_volume),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(f_interface),0L,1L,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EOIT, ECPGt_EORT);}
#line 96 "sqlwrite.ec"

	if (sqlca.sqlcode != 0) {		syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "insert into usage Error %d message '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
		return false;
	}
	{ ECPGtrans(__LINE__, NULL, "commit");}
#line 102 "sqlwrite.ec"

	return true;
}

int	SQLGetDNS(string resolvedName, const struct in_addr& ip)
{
	int		retCode= 0;
	/* exec sql begin declare section */
	 	
		
		

	 	
	 	
	
#line 110 "sqlwrite.ec"
   int  f_serial   ;
 
#line 111 "sqlwrite.ec"
   char  f_hostname [ 512 ]   ;
 
#line 112 "sqlwrite.ec"
   char  f_ip_address [ 16 ]   ;
 
#line 114 "sqlwrite.ec"
  const char * q_hostname   ;
 
#line 115 "sqlwrite.ec"
  const char * q_ip_address   ;
/* exec sql end declare section */
#line 116 "sqlwrite.ec"


	q_hostname = resolvedName.c_str();
	q_ip_address = inet_ntoa(ip);



	for (;;) {
		{ ECPGtrans(__LINE__, NULL, "begin transaction");}
#line 124 "sqlwrite.ec"

		{ ECPGdo(__LINE__, NULL, "select  serial  , hostname  , ip   from dnsentry where hostname  = ? and ip  = ?  ", 
	ECPGt_char,&(q_hostname),0L,1L,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(q_ip_address),0L,1L,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EOIT, 
	ECPGt_int,&(f_serial),1L,1L,sizeof(int), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_hostname),512L,1L,512*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,(f_ip_address),16L,1L,16*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EORT);}
#line 128 "sqlwrite.ec"

		
		if (sqlca.sqlcode == 0) {
			retCode = f_serial;
			break;
		} else if (sqlca.sqlcode != ECPG_NOT_FOUND) {
			syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "select from dnsentry Error %d message '%s'",
					sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
			{ ECPGtrans(__LINE__, NULL, "rollback");}
#line 136 "sqlwrite.ec"

			break;
		} else {
			{ ECPGdo(__LINE__, NULL, "insert into dnsentry ( hostname  , ip  ) values ( ? , ? )", 
	ECPGt_char,&(q_hostname),0L,1L,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, 
	ECPGt_char,&(q_ip_address),0L,1L,1*sizeof(char), 
	ECPGt_NO_INDICATOR, NULL , 0L, 0L, 0L, ECPGt_EOIT, ECPGt_EORT);}
#line 140 "sqlwrite.ec"


			if (sqlca.sqlcode != 0) {
				syslog(LOG_MAKEPRI(LOG_DAEMON, LOG_INFO), "insert into dnsentry Error %d message '%s'",
						sqlca.sqlerrm.sqlerrml, sqlca.sqlerrm.sqlerrmc);
				return 0;
			}
					}
		{ ECPGtrans(__LINE__, NULL, "commit");}
#line 149 "sqlwrite.ec"

	}
	return retCode;
}

