# regress.sh
# rserv regression test script
# (c) 2000 Thomas Lockhart, PostgreSQL Inc.

dir="`dirname $0`/../"

dropdb master
dropdb slave

createdb master || exit 1;
createdb slave || exit 1;

$dir/bin/MasterInit master
$dir/bin/SlaveInit master slave

psql -c "create table t1 (i int, t text, d timestamp default 'now');" master
$dir/bin/MasterAddTable master t1 d

psql -c "create table t1 (i int, t text, d timestamp default 'now');" slave
$dir/bin/SlaveAddTable slave t1 d

psql -c "insert into t1 values (1, 'one');" master
psql -c "insert into t1 values (2, 'two');" master

$dir/bin/Replicate master slave
$dir/bin/MasterSync master `$dir/bin/GetSyncID --noverbose slave`

psql -c "delete from t1 where i=1;" master
psql -c "update t1 set t='two, updated' where i=2;" master
psql -c "insert into t1 values (3, 'three');" master
psql -c "insert into t1 values (4, 'four');" master

$dir/bin/Replicate master slave
$dir/bin/MasterSync master `$dir/bin/GetSyncID --noverbose slave`

psql -c "insert into t1 values (1, 'one-insert2');" master
psql -c "delete from t1 where i=3;" master
psql -c "insert into t1 values (3, 'three-insert2');" master
psql -c "update t1 set t='four, updated' where i=4;" master

$dir/bin/Replicate master slave
$dir/bin/MasterSync master `$dir/bin/GetSyncID --noverbose slave`

if [ -e "$dir/bin/../pgdiff/pgdiff" ] ; then
	cd $dir/bin/../pgdiff/ && ./pgdiff -v master slave
fi

exit
