/* Module:          SQLNativeSql.c
 *
 * Description:     Returns the SQL string as modified by the driver. 
 *
 * Classes:         
 *
 * API functions:   SQLNativeSql
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLNativeSql(
							   SQLHDBC		hDrvDbc,
							   SQLCHAR		*szSqlStrIn,
							   SQLINTEGER	cbSqlStrIn,
							   SQLCHAR		*szSqlStr,
							   SQLINTEGER	cbSqlStrMax,
							   SQLINTEGER	*pcbSqlStr
							   )
{
	static char *func="SQLNativeSql";
	int len = 0;
	char *ptr;
	ConnectionClass *conn = (ConnectionClass *) hDrvDbc;
	SQLRETURN result;

	mylog( "%s: entering...cbSqlStrIn=%d\n", func, cbSqlStrIn);

	ptr = (cbSqlStrIn == 0) ? "" : make_string(szSqlStrIn, cbSqlStrIn, NULL);
	if ( ! ptr)
	{
		conn->errornumber = CONN_NO_MEMORY_ERROR;
		conn->errormsg = "No memory available to store native sql string";
		CC_log_error(func, "", conn);
		return SQL_ERROR;
	}

	result = SQL_SUCCESS;
	len = strlen(ptr);

	if (szSqlStr)
	{
		strncpy_null(szSqlStr, ptr, cbSqlStrMax);

		if (len >= cbSqlStrMax)
		{
			result = SQL_SUCCESS_WITH_INFO;
			conn->errornumber = STMT_TRUNCATED;
			conn->errormsg = "The buffer was too small for the result.";
		}
	}

	if (pcbSqlStr)
	{
		*pcbSqlStr = len;
	}

	free(ptr);

    return result;
}
