/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.NativeStruct;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.internal.Portal;

public class ExecutionPlan
extends NativeStruct {
    static final int INITIAL_CACHE_CAPACITY = 29;
    static final float CACHE_LOAD_FACTOR = 0.75f;
    private static final PlanCache s_planCache;
    private final Object m_key;

    private ExecutionPlan(Object object) {
        this.m_key = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ExecutionPlan executionPlan = s_planCache.put(this.m_key, this);
        if (executionPlan != null) {
            Object object = Backend.THREADLOCK;
            synchronized (object) {
                executionPlan._invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Portal cursorOpen(String string, Object[] objectArray) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._cursorOpen(string, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCursorPlan() throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._isCursorPlan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Object[] objectArray, int n) throws SQLException {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            return this._execute(objectArray, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionPlan prepare(String string, Oid[] oidArray) throws SQLException {
        Object object = oidArray == null ? string : new PlanKey(string, oidArray);
        ExecutionPlan executionPlan = (ExecutionPlan)s_planCache.remove(object);
        if (executionPlan == null) {
            executionPlan = new ExecutionPlan(object);
            Object object2 = Backend.THREADLOCK;
            synchronized (object2) {
                executionPlan._prepare(string, oidArray);
            }
        }
        return executionPlan;
    }

    private native Portal _cursorOpen(String var1, Object[] var2) throws SQLException;

    private native boolean _isCursorPlan() throws SQLException;

    private native int _execute(Object[] var1, int var2) throws SQLException;

    private native void _prepare(String var1, Oid[] var2) throws SQLException;

    private native void _invalidate();

    static {
        int n = Backend.getStatementCacheSize();
        s_planCache = new PlanCache(n < 11 ? 11 : n);
    }

    static final class PlanKey {
        private final int m_hashCode;
        private final String m_stmt;
        private final Oid[] m_argTypes;

        PlanKey(String string, Oid[] oidArray) {
            this.m_stmt = string;
            this.m_hashCode = string.hashCode() + 1;
            this.m_argTypes = oidArray;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PlanKey)) {
                return false;
            }
            PlanKey planKey = (PlanKey)object;
            if (!planKey.m_stmt.equals(this.m_stmt)) {
                return false;
            }
            Oid[] oidArray = this.m_argTypes;
            Oid[] oidArray2 = planKey.m_argTypes;
            int n = oidArray2.length;
            if (oidArray.length != n) {
                return false;
            }
            while (--n >= 0) {
                if (oidArray2[n].equals(oidArray[n])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.m_hashCode;
        }
    }

    static final class PlanCache
    extends LinkedHashMap {
        private final int m_cacheSize;

        public PlanCache(int n) {
            super(29, 0.75f, true);
            this.m_cacheSize = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > this.m_cacheSize) {
                Object object = Backend.THREADLOCK;
                synchronized (object) {
                    ((ExecutionPlan)entry.getValue())._invalidate();
                }
                return true;
            }
            return false;
        }
    }
}

