/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import org.postgresql.pljava.SessionManager;
import org.postgresql.pljava.TriggerData;
import org.postgresql.pljava.TriggerException;

public class Triggers {
    public static void insertUsername(TriggerData triggerData) throws SQLException {
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredAfter()) {
            throw new TriggerException(triggerData, "must be fired before event");
        }
        if (triggerData.isFiredByDelete()) {
            throw new TriggerException(triggerData, "can't process DELETE events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        if (resultSet.getString(stringArray[0]) == null) {
            resultSet.updateString(stringArray[0], SessionManager.current().getUserName());
        }
    }

    public static void leakStatements(TriggerData triggerData) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Trigger ");
        stringBuffer.append(triggerData.getName());
        stringBuffer.append(" declared on table ");
        stringBuffer.append(triggerData.getTableName());
        stringBuffer.append(" was fired ");
        if (triggerData.isFiredAfter()) {
            stringBuffer.append("after");
        } else {
            stringBuffer.append("before");
        }
        stringBuffer.append(' ');
        if (triggerData.isFiredByDelete()) {
            stringBuffer.append("delete");
        } else if (triggerData.isFiredByInsert()) {
            stringBuffer.append("insert");
        } else {
            stringBuffer.append("update");
        }
        if (triggerData.isFiredForEachRow()) {
            stringBuffer.append(" on each row");
        }
        int n = Integer.MIN_VALUE;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT base FROM setReturnExample(?, ?)");
        preparedStatement.setInt(1, 5);
        preparedStatement.setInt(2, 8);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            if (n2 <= n) continue;
            n = n2;
        }
        stringBuffer.append(" reports max = " + n);
        preparedStatement = connection.prepareStatement("INSERT INTO javatest.mdt (idesc) VALUES (?)");
        preparedStatement.setString(1, stringBuffer.toString());
        preparedStatement.executeUpdate();
    }

    public static void afterUsernameUpdate(TriggerData triggerData) throws SQLException {
        Logger logger = Logger.getAnonymousLogger();
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredBefore()) {
            throw new TriggerException(triggerData, "must be fired after event");
        }
        if (!triggerData.isFiredByUpdate()) {
            throw new TriggerException(triggerData, "can't process DELETE or INSERT events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        String string = stringArray[0];
        ResultSet resultSet2 = triggerData.getOld();
        logger.info("Old name is \"" + resultSet2.getString(string) + '\"');
        logger.info("New name is \"" + resultSet.getString(string) + '\"');
    }

    public static void moddatetime(TriggerData triggerData) throws SQLException {
        if (triggerData.isFiredForStatement()) {
            throw new TriggerException(triggerData, "can't process STATEMENT events");
        }
        if (triggerData.isFiredAfter()) {
            throw new TriggerException(triggerData, "must be fired before event");
        }
        if (!triggerData.isFiredByUpdate()) {
            throw new TriggerException(triggerData, "can only process UPDATE events");
        }
        ResultSet resultSet = triggerData.getNew();
        String[] stringArray = triggerData.getArguments();
        if (stringArray.length != 1) {
            throw new TriggerException(triggerData, "one argument was expected");
        }
        resultSet.updateTimestamp(stringArray[0], new Timestamp(System.currentTimeMillis()));
    }
}

