<?php
/* $Id: db_dump.php,v 1.2 2000/07/14 03:53:57 dan Exp $ */

$crlf="\n";
if (empty($asfile)) {
	include("header.inc.php");
	print "<div align=left><pre>\n";
} else {
	include("lib.inc.php");
	header("Content-disposition: filename=$db.sql");
	header("Content-type: application/octetstream");
	header("Pragma: no-cache");
	header("Expires: 0");

	// doing some DOS-CRLF magic...
	$client=getenv("HTTP_USER_AGENT");
	if (ereg('[^(]*\((.*)\)[^)]*',$client,$regs)) {
		$os = $regs[1];
		// this looks better under WinX
		if (eregi("Win",$os)) $crlf="\r\n";
	}
}

function my_handler($sql_insert) {
	global $crlf, $asfile;
	if (empty($asfile)) {
		echo htmlspecialchars("$sql_insert;$crlf");
	} else {
		echo "$sql_insert;$crlf";
	}
}

print "$crlf/* -------------------------------------------------------- $crlf"; 
print "  $cfgProgName $cfgVersion DB Dump$crlf";
print "  http://www.phpwizard.net/phpPgAdmin/$crlf";
print "  $strHost: " . $cfgServer['host'];

if (!empty($cfgServer['port'])) {
	print ":" . $cfgServer['port'];
}
print "$crlf  $strDatabase: $db$crlf";
print "-------------------------------------------------------- */ $crlf";

$get_seq_sql = "
	SELECT relname 
	FROM pg_class 
	WHERE 
		NOT relname ~ 'pg_.*' 
		AND relkind ='S' 
	ORDER BY relname
	";

$seq = @pg_exec($link, $get_seq_sql);
if (!$num_seq = @pg_numrows($seq)) {
	print "/* $strNo $strSequences $strFound */";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strSequences $crlf";
	print "-------------------------------------------------------- */ $crlf";

	while ($i_seq < $num_seq) {
		$sequence = @pg_result($seq, $i_seq, "relname");
		
		$sql_get_props = "SELECT * FROM $cfgQuotes$sequence$cfgQuotes";
		$seq_props = @pg_exec($link, $sql_get_props);
		if (@pg_numrows($seq_props)) {
			$row = @pg_fetch_array($seq_props, 0);
			if ($what != "data") {
				$row[last_value] = 1;
			}
			print "CREATE SEQUENCE $cfgQuotes$sequence$cfgQuotes start $row[last_value] increment $row[increment_by] maxvalue $row[max_value] minvalue $row[min_value] cache $row[cache_value]; $crlf";
		}
		if (($row[last_value] > 1) && ($what == "data")) {
			print "SELECT NEXTVAL('$sequence'); $crlf";
			unset($row[last_value]);
		}
		$i_seq++;
	}
}

$tables = @pg_exec($link, "SELECT tablename FROM pg_tables WHERE tablename !~ 'pg_.*' ORDER BY tablename");

$num_tables = @pg_numrows($tables);
if (!$num_tables) {
	echo $strNoTablesFound;
} else {
	
	for ($i = 0; $i < $num_tables; $i++) {
		$table = pg_result($tables, $i, "tablename");
	
		print "$crlf/* -------------------------------------------------------- $crlf";
		print "  $strTableStructure $cfgQuotes$table$cfgQuotes $crlf";
		print "-------------------------------------------------------- */";

		echo $crlf, get_table_def($link, $table, $crlf), $crlf;
		
		if ($what == "data") {
		
			print "$crlf/* -------------------------------------------------------- $crlf";
			print "  $strDumpingData $cfgQuotes$table$cfgQuotes $crlf";
			print "-------------------------------------------------------- */ $crlf";
		
			get_table_content($link, $table, "my_handler");
		}
	}
}


$sql_get_views = "SELECT * FROM pg_views WHERE viewowner != '$cfgSuperUser'";

$views = @pg_exec($link, $sql_get_views);
if (!$num_views = @pg_numrows($views)) {
	print "$crlf/* $strNo $strViews $strFound */$crlf";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strViews $crlf";
	print "-------------------------------------------------------- */ $crlf";

	for ($i_views = 0; $i_views < $num_views; $i_views++) {
		$view = pg_fetch_array($views, $i_views);
		print "CREATE VIEW $cfgQuotes$view[viewname]$cfgQuotes AS $view[definition] $crlf";
	}
}

$sql_get_funcs = "
	SELECT
		proname
	FROM 
		pg_proc pc, pg_user pu
	WHERE
		proowner = usesysid
		AND usename != '$cfgSuperUser'
";

	
print $crlf;

$funcs = @pg_exec($link, $sql_get_funcs);
if (!$num_funcs = @pg_numrows($funcs)) {
	print "/* $strNo $strFuncs $strFound */$crlf";
} else {
	print "$crlf/* -------------------------------------------------------- $crlf";
	print "  $strFuncs $crlf";
	print "-------------------------------------------------------- */ $crlf";

	for ($i_funcs = 0; $i_funcs < $num_funcs; $i_funcs++) {
		$function = pg_result($funcs, $i_funcs, "proname");

		$sql_func_props = "
			SELECT 
				proname, 
				lanname as language,
				pt.typname as return_type,
				pa.typname as argtype,
				prosrc as source
			FROM 
				pg_proc pc, pg_language pl, pg_type pt, pg_type pa
			WHERE 
				proname = '$function'
				AND pc.prolang = pl.oid
				AND pc.prorettype = pt.oid
		";

		$sql_func_args = "
			SELECT 
				proname, 
				pa.typname as argtype
			FROM 
				pg_proc pc, pg_type pa
			WHERE 
				proname = '$function'
				AND
				(
					pa.oid = pc.proargtypes[0]
					OR pa.oid = pc.proargtypes[1]
					OR pa.oid = pc.proargtypes[2]
					OR pa.oid = pc.proargtypes[3]
					OR pa.oid = pc.proargtypes[4]
					OR pa.oid = pc.proargtypes[5]
					OR pa.oid = pc.proargtypes[6]
					OR pa.oid = pc.proargtypes[7]
				)
		";

		$props = @pg_exec($link, $sql_func_props) or pg_die();
		$row = @pg_fetch_array($props, 0);
		$args = @pg_exec($link, $sql_func_args) or pg_die();
		for ($i_arg = 0; $i_arg < @pg_numrows($args); $i_arg++) {
			$strArgList .= " " . pg_result($args, $i_arg, "argtype") . ",";
		}
		$strArgList = ereg_replace(",$|, $", "", $strArgList);
		
		print "CREATE FUNCTION $function($strArgList) ";
		print "   RETURNS $row[return_type]";
		print "   AS '$row[source]'";
		print "   LANGUAGE '$row[language]'; $crlf $crlf";
	}
}


if(empty($asfile)) {
	print "</pre></div>\n";
	include ("footer.inc.php");
}
?>
