<?php

/**************************************************
Program name:	get_ri_triggers.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of Referential Integrity Info
			
Create Date:	4/22/01 

Modified Date(s):	
**************************************************/

/*
pg_trigger
 tgrelid        | oid        | 
 tgname         | name       | 
 tgfoid         | oid        | 
 tgtype         | smallint   | 
 tgenabled      | boolean    | 
 tgisconstraint | boolean    | 
 tgconstrname   | name       | 
 tgconstrrelid  | oid        | 
 tgdeferrable   | boolean    | 
 tginitdeferred | boolean    | 
 tgnargs        | smallint   | 
 tgattr         | int2vector | 
 tgargs         | bytea      |
pg_proc.proname
pg_class.relnamei

*/

$sql_get_ri_triggers = "SELECT 
pt.*, pp.proname, pc.relname, (Select pc.relname from pg_class pc where pc.oid = pt.tgconstrrelid) AS fk FROM 
	pg_trigger pt, pg_proc pp, pg_class pc 
WHERE 
	pp.oid=pt.tgfoid 
	and pt.tgrelid=pc.oid 
	and relname !~ '^pg_'
	and pt.tgname ~ '^RI_Const' 
ORDER BY pt.oid
";

// Rename SQL string to $sql_get
$sql_get = $sql_get_ri_triggers; 

// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");

// Rename Array
$table_triggers_array = $sql_array;

// Explode tgargs to find 
for ($i = 0; $i < $num_rows; $i++) {

	$temp = $table_triggers_array[$i][tgargs];

	$temp_array = explode('\000',$temp);


	/*
	0-unnamed
	1-fk_table
	2-pk_table 
	3-MatchType (UNSPECIFIED, FULL, PARTIAL)
	4-fk_column (1st)
	5-pk_column (1st)
	6-fk_column (2st)
	7-pk_column (2st)
	..
	..
	*/

	// Create Array of tgargs (maximum 4 field primary key)
	$table_triggers_array[$i][trigger_name] = $temp_array[0];
	$table_triggers_array[$i][i_fk_table] = $temp_array[1];
	$table_triggers_array[$i][i_pk_table] = $temp_array[2];
	$table_triggers_array[$i][i_matchtype] = $temp_array[3];
	$table_triggers_array[$i][i_fk1_column] = $temp_array[4];
	$table_triggers_array[$i][i_pk1_column] = $temp_array[5];
	$table_triggers_array[$i][i_fk2_column] = $temp_array[6];
	$table_triggers_array[$i][i_pk2_column] = $temp_array[7];
	$table_triggers_array[$i][i_fk3_column] = $temp_array[8];
	$table_triggers_array[$i][i_pk3_column] = $temp_array[9];
	$table_triggers_array[$i][i_fk4_column] = $temp_array[10];
	$table_triggers_array[$i][i_pk4_column] = $temp_array[11];

// create if multiple primary/foreign keys, then combine them 

	// Inititialize fk and pk as first column, respectively
	$table_triggers_array[$i][i_fk_column] = $table_triggers_array[$i][i_fk1_column];
	$table_triggers_array[$i][i_pk_column] = $table_triggers_array[$i][i_pk1_column];

	// Build Foreign Key
	if (!empty($table_triggers_array[$i][i_fk2_column])) {
		$table_triggers_array[$i][i_fk_column] .= ", ".$table_triggers_array[$i][i_fk2_column];

		if (!empty($table_triggers_array[$i][i_fk3_column])) {
			$table_triggers_array[$i][i_fk_column] .= ", ".$table_triggers_array[$i][i_fk3_column];

			if (!empty($table_triggers_array[$i][i_fk4_column])) {
				$table_triggers_array[$i][i_fk_column] .= ", ".$table_triggers_array[$i][i_fk4_column];			}
		}
	}

	// Build Primary Key
	if (!empty($table_triggers_array[$i][i_pk2_column])) {
		$table_triggers_array[$i][i_pk_column] .= ", ".$table_triggers_array[$i][i_pk2_column];

		if (!empty($table_triggers_array[$i][i_pk3_column])) {
			$table_triggers_array[$i][i_pk_column] .= ", ".$table_triggers_array[$i][i_pk3_column];

			if (!empty($table_triggers_array[$i][i_fk4_column])) {
				$table_triggers_array[$i][i_pk_column] .= ", ".$table_triggers_array[$i][i_pk4_column];			}
		}
	}


	// Check if there is Cascade Actions for ON UPDATE or ON DELETE
	if ($table_triggers_array[$i][proname] == "RI_FKey_check_ins") {
		// Update
		if ($table_triggers_array[$i+2][proname] == "RI_FKey_noaction_upd") {
			$table_triggers_array[$i][i_cascade] .= "";
		} else {
			$table_triggers_array[$i][i_cascade] .= "UPDATE";
		}

		// Delete
		if ($table_triggers_array[$i+1][proname] == "RI_FKey_noaction_del") {
			$table_triggers_array[$i][i_cascade] .= "";
		} else {
			$table_triggers_array[$i][i_cascade] .= " DELETE";
		}
	}

	// Set to no action if null
	if (empty($table_triggers_array[$i][i_cascade])) { 
		$table_triggers_array[$i][i_cascade] .= "NO ACTION";
	}


	// change matchtype "UNSPECIFIED" to NULL
#	if ($table_triggers_array[$i][i_matchtype] == "UNSPECIFIED") {
#		$table_triggers_array[$i][i_matchtype]="";
#	}

	//Build field in array with Table and Column(s) together  (ex. tbl1(id, id2))
	$table_triggers_array[$i][i_pk] = $table_triggers_array[$i][i_pk_table]."(".$table_triggers_array[$i][i_pk_column].")";
	$table_triggers_array[$i][i_fk] = $table_triggers_array[$i][i_fk_table]."(".$table_triggers_array[$i][i_fk_column].")";


}  //end for loop

?>
