VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "msflxgrd.ocx"
Begin VB.Form frmUsers 
   Caption         =   "Users"
   ClientHeight    =   3330
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5610
   Icon            =   "frmUsers.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   3330
   ScaleWidth      =   5610
   Begin VB.CommandButton cmdModify 
      Caption         =   "&Modify User"
      Height          =   330
      Left            =   3885
      TabIndex        =   4
      ToolTipText     =   "Modify the selected user"
      Top             =   2940
      Width           =   1170
   End
   Begin VB.CommandButton cmdCreate 
      Caption         =   "&Create User"
      Height          =   330
      Left            =   2625
      TabIndex        =   3
      ToolTipText     =   "Create a new user"
      Top             =   2940
      Width           =   1170
   End
   Begin VB.CommandButton cmdDrop 
      Caption         =   "&Drop User"
      Height          =   330
      Left            =   1365
      TabIndex        =   2
      ToolTipText     =   "Delete the selected user"
      Top             =   2940
      Width           =   1170
   End
   Begin VB.CommandButton cmdRefresh 
      Caption         =   "&Refresh"
      Height          =   330
      Left            =   105
      TabIndex        =   1
      ToolTipText     =   "Refresh the list of users"
      Top             =   2940
      Width           =   1170
   End
   Begin MSFlexGridLib.MSFlexGrid grdUsers 
      Height          =   2430
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   5580
      _ExtentX        =   9843
      _ExtentY        =   4286
      _Version        =   393216
      Cols            =   5
      FixedRows       =   0
      FixedCols       =   0
      BackColorBkg    =   -2147483643
      AllowBigSelection=   0   'False
      FocusRect       =   0
      SelectionMode   =   1
      AllowUserResizing=   1
   End
End
Attribute VB_Name = "frmUsers"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' pgAdmin - PostgreSQL db Administration/Management for Win32
' Copyright (C) 1998 - 2000, Dave Page

' This program is free software; you can redistribute it and/or
' modify it under the terms of the GNU General Public License
' as published by the Free Software Foundation; either version 2
' of the License, or (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Option Explicit
Dim rsUsers As New Recordset

Private Sub Form_Unload(Cancel As Integer)
On Error Resume Next
  Set rsUsers = Nothing
End Sub

Private Sub cmdCreate_Click()
On Error GoTo Err_Handler
  If SuperUser <> True Then
    MsgBox "You do not have sufficient authorisation to modify user accounts!", vbExclamation, "Error"
    Exit Sub
  End If
  Load frmAddUser
  frmAddUser.Show
  frmAddUser.WindowState = WinState
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmUsers, cmdCreate_click"
End Sub

Private Sub cmdDrop_Click()
On Error GoTo Err_Handler
  If grdUsers.Text = "" Then Exit Sub
  If SuperUser <> True Then
    MsgBox "You do not have sufficient authorisation to modify user accounts!", vbExclamation, "Error"
    Exit Sub
  End If
  If grdUsers.Text = "" Then
    MsgBox "You must select a user to drop!", vbExclamation, "Error"
    Exit Sub
  Else
    If MsgBox("Are you sure you wish to delete " & grdUsers.Text & "?", vbYesNo + vbQuestion, _
              "Confirm User Delete") = vbYes Then
      StartMsg "Dropping User..."
      fMainForm.txtSQLPane.Text = "DROP USER " & QUOTE & grdUsers.Text & QUOTE
      LogMsg "Executing: DROP USER " & QUOTE & grdUsers.Text & QUOTE
      gConnection.Execute "DROP USER " & QUOTE & grdUsers.Text & QUOTE
      grdUsers.RemoveItem grdUsers.Row
      EndMsg
    End If
  End If
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmUsers, cmdDrop_click"
End Sub

Private Sub cmdModify_Click()
On Error GoTo Err_Handler
  If grdUsers.Text = "" Then Exit Sub
  If SuperUser <> True Then
    MsgBox "You do not have sufficient authorisation to modify user accounts!", vbExclamation, "Error"
    Exit Sub
  End If
  Load frmModifyUser
  frmModifyUser.Show
  frmModifyUser.WindowState = WinState
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmUsers, cmdModify_click"
End Sub

Public Sub cmdRefresh_Click()
On Error GoTo Err_Handler
Dim UserInfo As String
  StartMsg "Retrieving User Information..."
  grdUsers.Clear
  grdUsers.Rows = 0
  grdUsers.ColAlignment(0) = 1
  grdUsers.ColAlignment(1) = 1
  grdUsers.ColAlignment(2) = 1
  grdUsers.ColAlignment(3) = 1
  grdUsers.ColAlignment(4) = 1
  grdUsers.AddItem "Username" & vbTab & "User ID" & vbTab & "Create dbs" & vbTab & "Superuser" & vbTab & "Valid until"
  If rsUsers.State <> adStateClosed Then rsUsers.Close
  LogMsg "Executing: SELECT * FROM pgadmin_users ORDER BY user_name"
  rsUsers.Open "SELECT * FROM pgadmin_users ORDER BY user_name", gConnection, adOpenForwardOnly
  While Not rsUsers.EOF
    UserInfo = rsUsers!user_name & vbTab & rsUsers!user_id & vbTab
    UserInfo = UserInfo & rsUsers!user_create_dbs & vbTab
    UserInfo = UserInfo & rsUsers!user_superuser & vbTab
    UserInfo = UserInfo & Format(rsUsers!user_expires, "Long Date")
    grdUsers.AddItem UserInfo
    rsUsers.MoveNext
  Wend
  If rsUsers.BOF <> True Then rsUsers.MoveFirst
  grdUsers.AddItem "" & vbTab & "" & vbTab & "" & vbTab & "" & vbTab
  grdUsers.FixedRows = 1
  EndMsg
  Exit Sub
Err_Handler:
  EndMsg
  If Err.Number = -2147217887 Then
    MsgBox "Access Denied!", vbExclamation
    Unload Me
    Exit Sub
  End If
  If Err.Number <> 0 Then LogError Err, "frmUsers, cmdRefresh_click"
End Sub

Private Sub Form_Load()
On Error GoTo Err_Handler
  LogMsg "Loading Form: " & Me.Name
  Me.Height = 3735
  Me.Width = 5730
  cmdRefresh_Click
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmUsers, Form_Load"
End Sub

Private Sub Form_Resize()
On Error GoTo Err_Handler
  If Me.WindowState <> 1 Then
    grdUsers.Width = Me.ScaleWidth
    grdUsers.Height = Me.ScaleHeight - cmdRefresh.Height - 50
    cmdRefresh.Top = Me.ScaleHeight - cmdRefresh.Height
    cmdDrop.Top = Me.ScaleHeight - cmdRefresh.Height
    cmdCreate.Top = Me.ScaleHeight - cmdRefresh.Height
    cmdModify.Top = Me.ScaleHeight - cmdRefresh.Height
    If grdUsers.Width > 6120 Then
      grdUsers.ColWidth(0) = (grdUsers.Width / 6) - 20
      grdUsers.ColWidth(1) = (grdUsers.Width / 6) - 20
      grdUsers.ColWidth(2) = (grdUsers.Width / 6) - 20
      grdUsers.ColWidth(3) = (grdUsers.Width / 6) - 20
      grdUsers.ColWidth(4) = 2 * (grdUsers.Width / 6) - 40
    Else
      grdUsers.ColWidth(0) = 1020
      grdUsers.ColWidth(1) = 1020
      grdUsers.ColWidth(2) = 1020
      grdUsers.ColWidth(3) = 1020
      grdUsers.ColWidth(4) = 2040
    End If
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmUsers, Form_Resize"
End Sub

Private Sub grdUsers_DblClick()
On Error GoTo Err_Handler
  If grdUsers.Text <> "" Then cmdModify_Click
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmUsers, grdUsers_DblClick"
End Sub
