package com.postgres.replic.server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

/**
 *  Signal handling remote interface for signaling a running eRServer instance
 *
 * @author    ronz
 */
public class RServSignalHandlerImpl extends UnicastRemoteObject implements RServSignalHandler {

	ReplicationServer replicationServer;

	/**
	 * Constructor for the RServSignalHandlerImpl object
	 *
	 * @param  server               eRServer instance to signal
	 * @exception  RemoteException  Description of the Exception
	 */
	public RServSignalHandlerImpl(ReplicationServer server) throws RemoteException {
		this.replicationServer = server;
	}

	/**
	 *  Receive a signal
	 *
	 * @param  signal               Signal to process
	 * @exception  RemoteException  Description of the Exception
	 * @see com.postgres.replic.server.RServSignalHandler
	 */
	public int signal(int signal) throws RemoteException {
		return replicationServer.receiveSignal(signal);
	}

}

