/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.core.BaseStatement;
import org.postgresql.core.Encoding;
import org.postgresql.core.Field;
import org.postgresql.jdbc1.AbstractJdbc1Connection;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class AbstractJdbc1DatabaseMetaData {
    private static final String keywords = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    protected AbstractJdbc1Connection connection;
    protected Encoding encoding;
    protected static final int iVarcharOid = 1043;
    protected static final int iBoolOid = 16;
    protected static final int iInt2Oid = 21;
    protected static final int iInt4Oid = 23;
    protected static final int VARHDRSZ = 4;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static final Hashtable tableTypeClauses = new Hashtable();
    private static final String[] defaultTableTypes;

    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            String from = this.connection.haveMinimumServerVersion("7.3") ? "pg_catalog.pg_namespace n, pg_catalog.pg_type t1, pg_catalog.pg_type t2 WHERE t1.typnamespace=n.oid AND n.nspname='pg_catalog' AND " : "pg_type t1, pg_type t2 WHERE ";
            String sql = "SELECT t1.typlen/t2.typlen FROM " + from + " t1.typelem=t2.oid AND t1.typname='oidvector'";
            ResultSet rs = this.connection.createStatement().executeQuery(sql);
            if (!rs.next()) {
                throw new PSQLException("postgresql.unexpected", PSQLState.UNEXPECTED_ERROR);
            }
            this.INDEX_MAX_KEYS = rs.getInt(1);
            rs.close();
        }
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String sql = this.connection.haveMinimumServerVersion("7.3") ? "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid AND t.typname='name' AND n.nspname='pg_catalog'" : "SELECT typlen FROM pg_type WHERE typname='name'";
            ResultSet rs = this.connection.createStatement().executeQuery(sql);
            if (!rs.next()) {
                throw new PSQLException("postgresql.unexpected", PSQLState.UNEXPECTED_ERROR);
            }
            this.NAMEDATALEN = rs.getInt("typlen");
            rs.close();
        }
        return this.NAMEDATALEN - 1;
    }

    public AbstractJdbc1DatabaseMetaData(AbstractJdbc1Connection conn) {
        this.connection = conn;
        try {
            this.encoding = conn.getEncoding();
        }
        catch (SQLException sqle) {
            this.encoding = Encoding.defaultEncoding();
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("allProceduresAreCallable");
        }
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("allTablesAreSelectable");
        }
        return true;
    }

    public String getURL() throws SQLException {
        String url = this.connection.getURL();
        if (Driver.logDebug) {
            Driver.debug("getURL " + url);
        }
        return url;
    }

    public String getUserName() throws SQLException {
        String userName = this.connection.getUserName();
        if (Driver.logDebug) {
            Driver.debug("getUserName " + userName);
        }
        return userName;
    }

    public boolean isReadOnly() throws SQLException {
        boolean isReadOnly = this.connection.isReadOnly();
        if (Driver.logDebug) {
            Driver.debug("isReadOnly " + isReadOnly);
        }
        return isReadOnly;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        boolean nullSortedHigh = this.connection.haveMinimumServerVersion("7.2");
        if (Driver.logDebug) {
            Driver.debug("nullsAreSortedHigh " + nullSortedHigh);
        }
        return nullSortedHigh;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("nullsAreSortedLow false");
        }
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("nullsAreSortedAtStart false");
        }
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        boolean nullsAreSortedAtEnd;
        boolean bl = nullsAreSortedAtEnd = !this.connection.haveMinimumServerVersion("7.2");
        if (Driver.logDebug) {
            Driver.debug("nullsAreSortedAtEnd " + nullsAreSortedAtEnd);
        }
        return nullsAreSortedAtEnd;
    }

    public String getDatabaseProductName() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getDatabaseProductName PostgresSQL");
        }
        return "PostgreSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        String versionNumber = this.connection.getDBVersionNumber();
        if (Driver.logDebug) {
            Driver.debug("getDatabaseProductVersion " + versionNumber);
        }
        return versionNumber;
    }

    public String getDriverName() throws SQLException {
        String driverName = "PostgreSQL Native Driver";
        if (Driver.logDebug) {
            Driver.debug("getDriverName" + driverName);
        }
        return driverName;
    }

    public String getDriverVersion() throws SQLException {
        String driverVersion = Driver.getVersion();
        if (Driver.logDebug) {
            Driver.debug("getDriverVersion " + driverVersion);
        }
        return driverVersion;
    }

    public int getDriverMajorVersion() {
        int majorVersion = this.connection.this_driver.getMajorVersion();
        if (Driver.logDebug) {
            Driver.debug("getMajorVersion " + majorVersion);
        }
        return majorVersion;
    }

    public int getDriverMinorVersion() {
        int minorVersion = this.connection.this_driver.getMinorVersion();
        if (Driver.logDebug) {
            Driver.debug("getMinorVersion " + minorVersion);
        }
        return minorVersion;
    }

    public boolean usesLocalFiles() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("usesLocalFiles false");
        }
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("usesLocalFilePerTable false");
        }
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsMixedCaseIdentifiers false");
        }
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("storesUpperCaseIdentifiers false");
        }
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("storesLowerCaseIdentifiers true");
        }
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("storesMixedCaseIdentifiers false");
        }
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsMixedCaseQuotedIdentifiers true");
        }
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("storesUpperCaseQuotedIdentifiers false");
        }
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("storesLowerCaseQuotedIdentifiers false");
        }
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("storesMixedCaseQuotedIdentifiers false");
        }
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getIdentifierQuoteString \"");
        }
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return keywords;
    }

    public String getNumericFunctions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getNumericFunctions");
        }
        return "";
    }

    public String getStringFunctions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getStringFunctions");
        }
        return "";
    }

    public String getSystemFunctions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getSystemFunctions");
        }
        return "";
    }

    public String getTimeDateFunctions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getTimeDateFunctions");
        }
        return "";
    }

    public String getSearchStringEscape() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getSearchStringEscape");
        }
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getExtraNameCharacters");
        }
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsAlterTableWithAddColumn true");
        }
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        boolean dropColumn = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsAlterTableWithDropColumn " + dropColumn);
        }
        return dropColumn;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsColumnAliasing true");
        }
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("nullPlusNonNullIsNull true");
        }
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsConvert false");
        }
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsConvert false");
        }
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsTableCorrelationNames true");
        }
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsDifferentTableCorrelationNames false");
        }
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsExpressionsInOrderBy true");
        }
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        boolean supportsOrderByUnrelated = this.connection.haveMinimumServerVersion("6.4");
        if (Driver.logDebug) {
            Driver.debug("supportsOrderByUnrelated " + supportsOrderByUnrelated);
        }
        return supportsOrderByUnrelated;
    }

    public boolean supportsGroupBy() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsGroupBy true");
        }
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        boolean supportsGroupByUnrelated = this.connection.haveMinimumServerVersion("6.4");
        if (Driver.logDebug) {
            Driver.debug("supportsGroupByUnrelated " + supportsGroupByUnrelated);
        }
        return supportsGroupByUnrelated;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        boolean supportsGroupByBeyondSelect = this.connection.haveMinimumServerVersion("6.4");
        if (Driver.logDebug) {
            Driver.debug("supportsGroupByUnrelated " + supportsGroupByBeyondSelect);
        }
        return supportsGroupByBeyondSelect;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        boolean supportsLikeEscapeClause = this.connection.haveMinimumServerVersion("7.1");
        if (Driver.logDebug) {
            Driver.debug("supportsLikeEscapeClause " + supportsLikeEscapeClause);
        }
        return supportsLikeEscapeClause;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsMultipleResultSets false");
        }
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsMultipleTransactions true");
        }
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsNonNullableColumns true");
        }
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsMinimumSQLGrammar TRUE");
        }
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsCoreSQLGrammar FALSE ");
        }
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsExtendedSQLGrammar FALSE");
        }
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        boolean schemas = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsANSI92EntryLevelSQL " + schemas);
        }
        return schemas;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsANSI92IntermediateSQL false ");
        }
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsANSI92FullSQL false ");
        }
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsIntegrityEnhancementFacility true ");
        }
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        boolean supportsOuterJoins = this.connection.haveMinimumServerVersion("7.1");
        if (Driver.logDebug) {
            Driver.debug("supportsOuterJoins " + supportsOuterJoins);
        }
        return supportsOuterJoins;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        boolean supportsFullOuterJoins = this.connection.haveMinimumServerVersion("7.1");
        if (Driver.logDebug) {
            Driver.debug("supportsFullOuterJoins " + supportsFullOuterJoins);
        }
        return supportsFullOuterJoins;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        boolean supportsLimitedOuterJoins = this.connection.haveMinimumServerVersion("7.1");
        if (Driver.logDebug) {
            Driver.debug("supportsFullOuterJoins " + supportsLimitedOuterJoins);
        }
        return supportsLimitedOuterJoins;
    }

    public String getSchemaTerm() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getSchemaTerm schema");
        }
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getProcedureTerm function ");
        }
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getCatalogTerm database ");
        }
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("isCatalogAtStart not implemented");
        }
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("getCatalogSeparator not implemented ");
        }
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        boolean schemas = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsSchemasInDataManipulation " + schemas);
        }
        return schemas;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        boolean schemas = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsSchemasInProcedureCalls " + schemas);
        }
        return schemas;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        boolean schemas = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsSchemasInTableDefinitions " + schemas);
        }
        return schemas;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        boolean schemas = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsSchemasInIndexDefinitions " + schemas);
        }
        return schemas;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        boolean schemas = this.connection.haveMinimumServerVersion("7.3");
        if (Driver.logDebug) {
            Driver.debug("supportsSchemasInPrivilegeDefinitions " + schemas);
        }
        return schemas;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsCatalogsInDataManipulation false");
        }
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsCatalogsInDataManipulation false");
        }
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsCatalogsInTableDefinitions false");
        }
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsCatalogsInIndexDefinitions false");
        }
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsCatalogsInPrivilegeDefinitions false");
        }
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsPositionedDelete false");
        }
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("supportsPositionedUpdate false");
        }
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return this.connection.haveMinimumServerVersion("6.5");
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return this.connection.haveMinimumServerVersion("7.1");
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return this.connection.haveMinimumServerVersion("7.1");
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxRowSize() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.1")) {
            return 0x40000000;
        }
        return 8192;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        if (this.connection.haveMinimumServerVersion("7.0")) {
            return 0;
        }
        return 16384;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8 || level == 2;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    protected static String escapeQuotes(String s) {
        StringBuffer sb = new StringBuffer();
        int length = s.length();
        int prevChar = 32;
        int prevPrevChar = 32;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\'' && (prevChar != 92 || prevChar == 92 && prevPrevChar == 92)) {
                sb.append("'");
            }
            prevPrevChar = prevChar;
            prevChar = c;
            ++i;
        }
        return sb.toString();
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String sql;
        if (this.connection.haveMinimumServerVersion("7.3")) {
            sql = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid ";
            if (schemaPattern != null && !"".equals(schemaPattern)) {
                sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
            }
            if (procedureNamePattern != null) {
                sql = sql + " AND p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
            }
            sql = sql + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME ";
        } else if (this.connection.haveMinimumServerVersion("7.1")) {
            sql = "SELECT NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE  FROM pg_proc p  LEFT JOIN pg_description d ON (p.oid=d.objoid) ";
            if (this.connection.haveMinimumServerVersion("7.2")) {
                sql = sql + " LEFT JOIN pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc') ";
            }
            if (procedureNamePattern != null) {
                sql = sql + " WHERE p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
            }
            sql = sql + " ORDER BY PROCEDURE_NAME ";
        } else {
            sql = "SELECT NULL AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, NULL AS REMARKS, 2 AS PROCEDURE_TYPE  FROM pg_proc p ";
            if (procedureNamePattern != null) {
                sql = sql + " WHERE p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
            }
            sql = sql + " ORDER BY PROCEDURE_NAME ";
        }
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String sql;
        Field[] f = new Field[13];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "PROCEDURE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "PROCEDURE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "PROCEDURE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_TYPE", 21, 2);
        f[5] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[6] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[7] = new Field(this.connection, "PRECISION", 23, 4);
        f[8] = new Field(this.connection, "LENGTH", 23, 4);
        f[9] = new Field(this.connection, "SCALE", 21, 2);
        f[10] = new Field(this.connection, "RADIX", 21, 2);
        f[11] = new Field(this.connection, "NULLABLE", 21, 2);
        f[12] = new Field(this.connection, "REMARKS", 1043, this.getMaxNameLength());
        if (this.connection.haveMinimumServerVersion("7.3")) {
            sql = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid  FROM pg_catalog.pg_proc p,pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid ";
            if (schemaPattern != null && !"".equals(schemaPattern)) {
                sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
            }
            if (procedureNamePattern != null) {
                sql = sql + " AND p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
            }
            sql = sql + " ORDER BY n.nspname, p.proname ";
        } else {
            sql = "SELECT NULL AS nspname,p.proname,p.prorettype,p.proargtypes, t.typtype,t.typrelid  FROM pg_proc p,pg_type t  WHERE p.prorettype=t.oid ";
            if (procedureNamePattern != null) {
                sql = sql + " AND p.proname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(procedureNamePattern) + "' ";
            }
            sql = sql + " ORDER BY p.proname ";
        }
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes("nspname");
            byte[] procedureName = rs.getBytes("proname");
            int returnType = rs.getInt("prorettype");
            String returnTypeType = rs.getString("typtype");
            int returnTypeRelid = rs.getInt("typrelid");
            String strArgTypes = rs.getString("proargtypes");
            StringTokenizer st = new StringTokenizer(strArgTypes);
            Vector<Integer> argTypes = new Vector<Integer>();
            while (st.hasMoreTokens()) {
                argTypes.addElement(new Integer(st.nextToken()));
            }
            if (!returnTypeType.equals("c")) {
                byte[][] tuple = new byte[][]{null, schema, procedureName, this.encoding.encode("returnValue"), this.encoding.encode(Integer.toString(5)), this.encoding.encode(Integer.toString(this.connection.getSQLType(returnType))), this.encoding.encode(this.connection.getPGType(returnType)), null, null, null, null, this.encoding.encode(Integer.toString(2)), null};
                v.addElement(tuple);
            }
            int i = 0;
            while (i < argTypes.size()) {
                int argOid = (Integer)argTypes.elementAt(i);
                byte[][] tuple = new byte[][]{null, schema, procedureName, this.encoding.encode("$" + (i + 1)), this.encoding.encode(Integer.toString(1)), this.encoding.encode(Integer.toString(this.connection.getSQLType(argOid))), this.encoding.encode(this.connection.getPGType(argOid)), null, null, null, null, this.encoding.encode(Integer.toString(2)), null};
                v.addElement(tuple);
                ++i;
            }
            if (!returnTypeType.equals("c")) continue;
            String columnsql = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a WHERE a.attrelid = " + returnTypeRelid + " ORDER BY a.attnum ";
            ResultSet columnrs = this.connection.createStatement().executeQuery(columnsql);
            while (columnrs.next()) {
                int columnTypeOid = columnrs.getInt("atttypid");
                byte[][] tuple = new byte[][]{null, schema, procedureName, columnrs.getBytes("attname"), this.encoding.encode(Integer.toString(3)), this.encoding.encode(Integer.toString(this.connection.getSQLType(columnTypeOid))), this.encoding.encode(this.connection.getPGType(columnTypeOid)), null, null, null, null, this.encoding.encode(Integer.toString(2)), null};
                v.addElement(tuple);
            }
        }
        rs.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String orderby;
        String select;
        String useSchemas;
        if (this.connection.haveMinimumServerVersion("7.3")) {
            useSchemas = "SCHEMAS";
            select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname LIKE 'pg\\\\_%' OR n.nspname = 'information_schema'  WHEN true THEN CASE \tWHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind \t\tWHEN 'r' THEN 'SYSTEM TABLE' \t\tWHEN 'v' THEN 'SYSTEM VIEW' \t\tWHEN 'i' THEN 'SYSTEM INDEX' \t\tELSE NULL \t\tEND \tWHEN n.nspname = 'pg_toast' THEN CASE c.relkind \t\tWHEN 'r' THEN 'SYSTEM TOAST TABLE' \t\tWHEN 'i' THEN 'SYSTEM TOAST INDEX' \t\tELSE NULL \t\tEND \tELSE CASE c.relkind \t\tWHEN 'r' THEN 'TEMPORARY TABLE' \t\tWHEN 'i' THEN 'TEMPORARY INDEX' \t\tELSE NULL \t\tEND \tEND  WHEN false THEN CASE c.relkind \tWHEN 'r' THEN 'TABLE' \tWHEN 'i' THEN 'INDEX' \tWHEN 'S' THEN 'SEQUENCE' \tWHEN 'v' THEN 'VIEW' \tELSE NULL \tEND  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN pg_catalog.pg_class dc ON (d.classoid=dc.oid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='pg_catalog')  WHERE c.relnamespace = n.oid ";
            if (schemaPattern != null && !"".equals(schemaPattern)) {
                select = select + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
            }
            orderby = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        } else {
            useSchemas = "NOSCHEMAS";
            String tableType = " CASE c.relname LIKE 'pg\\\\_%'  WHEN true THEN CASE c.relname LIKE 'pg\\\\_toast\\\\_%' \tWHEN true THEN CASE c.relkind \t\tWHEN 'r' THEN 'SYSTEM TOAST TABLE' \t\tWHEN 'i' THEN 'SYSTEM TOAST INDEX' \t\tELSE NULL \t\tEND \tWHEN false THEN CASE c.relname LIKE 'pg\\\\_temp\\\\_%' \t\tWHEN true THEN CASE c.relkind \t\t\tWHEN 'r' THEN 'TEMPORARY TABLE' \t\t\tWHEN 'i' THEN 'TEMPORARY INDEX' \t\t\tELSE NULL \t\t\tEND \t\tWHEN false THEN CASE c.relkind \t\t\tWHEN 'r' THEN 'SYSTEM TABLE' \t\t\tWHEN 'v' THEN 'SYSTEM VIEW' \t\t\tWHEN 'i' THEN 'SYSTEM INDEX' \t\t\tELSE NULL \t\t\tEND \t\tELSE NULL \t\tEND \tELSE NULL \tEND  WHEN false THEN CASE c.relkind \tWHEN 'r' THEN 'TABLE' \tWHEN 'i' THEN 'INDEX' \tWHEN 'S' THEN 'SEQUENCE' \tWHEN 'v' THEN 'VIEW' \tELSE NULL \tEND  ELSE NULL  END ";
            orderby = " ORDER BY TABLE_TYPE,TABLE_NAME ";
            select = this.connection.haveMinimumServerVersion("7.2") ? "SELECT NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, c.relname AS TABLE_NAME, " + tableType + " AS TABLE_TYPE, d.description AS REMARKS " + " FROM pg_class c " + " LEFT JOIN pg_description d ON (c.oid=d.objoid AND d.objsubid = 0) " + " LEFT JOIN pg_class dc ON (d.classoid = dc.oid AND dc.relname='pg_class') " + " WHERE true " : (this.connection.haveMinimumServerVersion("7.1") ? "SELECT NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, c.relname AS TABLE_NAME, " + tableType + " AS TABLE_TYPE, d.description AS REMARKS " + " FROM pg_class c " + " LEFT JOIN pg_description d ON (c.oid=d.objoid) " + " WHERE true " : "SELECT NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, c.relname AS TABLE_NAME, " + tableType + " AS TABLE_TYPE, NULL AS REMARKS " + " FROM pg_class c " + " WHERE true ");
        }
        if (types == null) {
            types = defaultTableTypes;
        }
        if (tableNamePattern != null) {
            select = select + " AND c.relname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        String sql = select;
        sql = sql + " AND (false ";
        int i = 0;
        while (i < types.length) {
            Hashtable clauses = (Hashtable)tableTypeClauses.get(types[i]);
            if (clauses != null) {
                String clause = (String)clauses.get(useSchemas);
                sql = sql + " OR ( " + clause + " ) ";
            }
            ++i;
        }
        sql = sql + ") ";
        sql = sql + orderby;
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getSchemas() throws SQLException {
        String sql = this.connection.haveMinimumServerVersion("7.3") ? "SELECT nspname AS TABLE_SCHEM FROM pg_catalog.pg_namespace WHERE nspname <> 'pg_toast' AND nspname NOT LIKE 'pg\\\\_temp\\\\_%' ORDER BY TABLE_SCHEM" : "SELECT ''::text AS TABLE_SCHEM ORDER BY TABLE_SCHEM";
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getCatalogs() throws SQLException {
        String sql = this.connection.haveMinimumServerVersion("7.3") ? "SELECT datname AS TABLE_CAT FROM pg_catalog.pg_database ORDER BY TABLE_CAT" : "SELECT datname AS TABLE_CAT FROM pg_database ORDER BY TABLE_CAT";
        return this.connection.createStatement().executeQuery(sql);
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] types = new String[tableTypeClauses.size()];
        Enumeration e = tableTypeClauses.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            types[i++] = (String)e.nextElement();
        }
        AbstractJdbc1DatabaseMetaData.sortStringArray(types);
        Field[] f = new Field[1];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, new String("TABLE_TYPE"), 1043, this.getMaxNameLength());
        i = 0;
        while (i < types.length) {
            byte[][] tuple = new byte[][]{this.encoding.encode(types[i])};
            v.addElement(tuple);
            ++i;
        }
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String sql;
        Vector<byte[][]> v = new Vector<byte[][]>();
        Field[] f = new Field[]{new Field(this.connection, "TABLE_CAT", 1043, this.getMaxNameLength()), new Field(this.connection, "TABLE_SCHEM", 1043, this.getMaxNameLength()), new Field(this.connection, "TABLE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "DATA_TYPE", 21, 2), new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "COLUMN_SIZE", 23, 4), new Field(this.connection, "BUFFER_LENGTH", 1043, this.getMaxNameLength()), new Field(this.connection, "DECIMAL_DIGITS", 23, 4), new Field(this.connection, "NUM_PREC_RADIX", 23, 4), new Field(this.connection, "NULLABLE", 23, 4), new Field(this.connection, "REMARKS", 1043, this.getMaxNameLength()), new Field(this.connection, "COLUMN_DEF", 1043, this.getMaxNameLength()), new Field(this.connection, "SQL_DATA_TYPE", 23, 4), new Field(this.connection, "SQL_DATETIME_SUB", 23, 4), new Field(this.connection, "CHAR_OCTET_LENGTH", 1043, this.getMaxNameLength()), new Field(this.connection, "ORDINAL_POSITION", 23, 4), new Field(this.connection, "IS_NULLABLE", 1043, this.getMaxNameLength())};
        if (this.connection.haveMinimumServerVersion("7.3")) {
            sql = "SELECT n.nspname,c.relname,a.attname,a.atttypid,a.attnotnull,a.atttypmod,a.attlen,a.attnum,def.adsrc,dsc.description  FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE a.attnum > 0 AND NOT a.attisdropped ";
            if (schemaPattern != null && !"".equals(schemaPattern)) {
                sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
            }
        } else {
            sql = this.connection.haveMinimumServerVersion("7.2") ? "SELECT NULL::text AS nspname,c.relname,a.attname,a.atttypid,a.attnotnull,a.atttypmod,a.attlen,a.attnum,def.adsrc,dsc.description  FROM pg_class c  JOIN pg_attribute a ON (a.attrelid=c.oid)  LEFT JOIN pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  WHERE a.attnum > 0 " : (this.connection.haveMinimumServerVersion("7.1") ? "SELECT NULL::text AS nspname,c.relname,a.attname,a.atttypid,a.attnotnull,a.atttypmod,a.attlen,a.attnum,def.adsrc,dsc.description  FROM pg_class c  JOIN pg_attribute a ON (a.attrelid=c.oid)  LEFT JOIN pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_description dsc ON (a.oid=dsc.objoid)  WHERE a.attnum > 0 " : "SELECT NULL::text AS nspname,c.relname,a.attname,a.atttypid,a.attnotnull,a.atttypmod,a.attlen,a.attnum,NULL AS adsrc,NULL AS description  FROM pg_class c, pg_attribute a  WHERE a.attrelid=c.oid AND a.attnum > 0 ");
        }
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname,relname,attnum ";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            byte[][] tuple = new byte[18][];
            int typeOid = rs.getInt("atttypid");
            tuple[0] = null;
            tuple[1] = rs.getBytes("nspname");
            tuple[2] = rs.getBytes("relname");
            tuple[3] = rs.getBytes("attname");
            tuple[4] = this.encoding.encode(Integer.toString(this.connection.getSQLType(typeOid)));
            String pgType = this.connection.getPGType(typeOid);
            tuple[5] = this.encoding.encode(pgType);
            tuple[8] = this.encoding.encode("0");
            if (pgType.equals("bpchar") || pgType.equals("varchar")) {
                int atttypmod = rs.getInt("atttypmod");
                tuple[6] = this.encoding.encode(Integer.toString(atttypmod != -1 ? atttypmod - 4 : 0));
            } else if (pgType.equals("numeric") || pgType.equals("decimal")) {
                int attypmod = rs.getInt("atttypmod") - 4;
                tuple[6] = this.encoding.encode(Integer.toString(attypmod >> 16 & 0xFFFF));
                tuple[8] = this.encoding.encode(Integer.toString(attypmod & 0xFFFF));
                tuple[9] = this.encoding.encode("10");
            } else if (pgType.equals("bit") || pgType.equals("varbit")) {
                tuple[6] = rs.getBytes("atttypmod");
                tuple[9] = this.encoding.encode("2");
            } else {
                tuple[6] = rs.getBytes("attlen");
                tuple[9] = this.encoding.encode("10");
            }
            tuple[7] = null;
            tuple[10] = this.encoding.encode(Integer.toString(rs.getBoolean("attnotnull") ? 0 : 1));
            tuple[11] = rs.getBytes("description");
            tuple[12] = rs.getBytes("adsrc");
            tuple[13] = null;
            tuple[14] = null;
            tuple[15] = tuple[6];
            tuple[16] = rs.getBytes("attnum");
            tuple[17] = this.encoding.encode(rs.getBoolean("attnotnull") ? "NO" : "YES");
            v.addElement(tuple);
        }
        rs.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String sql;
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        if (table == null) {
            table = "%";
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        f[0] = new Field(this.connection, "TABLE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "TABLE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "TABLE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "GRANTOR", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "GRANTEE", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "PRIVILEGE", 1043, this.getMaxNameLength());
        f[7] = new Field(this.connection, "IS_GRANTABLE", 1043, this.getMaxNameLength());
        if (this.connection.haveMinimumServerVersion("7.3")) {
            sql = "SELECT n.nspname,c.relname,u.usename,c.relacl,a.attname  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u, pg_catalog.pg_attribute a  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND NOT a.attisdropped ";
            if (schema != null && !"".equals(schema)) {
                sql = sql + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
            }
        } else {
            sql = "SELECT NULL::text AS nspname,c.relname,u.usename,c.relacl,a.attname FROM pg_class c, pg_user u,pg_attribute a  WHERE u.usesysid = c.relowner  AND c.oid = a.attrelid  AND a.attnum > 0  AND c.relkind = 'r' ";
        }
        sql = sql + " AND c.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(table) + "' ";
        if (columnNamePattern != null && !"".equals(columnNamePattern)) {
            sql = sql + " AND a.attname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(columnNamePattern) + "' ";
        }
        sql = sql + " ORDER BY attname ";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            byte[] schemaName = rs.getBytes("nspname");
            byte[] tableName = rs.getBytes("relname");
            byte[] column = rs.getBytes("attname");
            String owner = rs.getString("usename");
            String acl = rs.getString("relacl");
            Hashtable permissions = this.parseACL(acl, owner);
            String[] permNames = new String[permissions.size()];
            Enumeration e = permissions.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                permNames[i++] = (String)e.nextElement();
            }
            AbstractJdbc1DatabaseMetaData.sortStringArray(permNames);
            i = 0;
            while (i < permNames.length) {
                byte[] privilege = this.encoding.encode(permNames[i]);
                Vector grantees = (Vector)permissions.get(permNames[i]);
                int j = 0;
                while (j < grantees.size()) {
                    String grantee = (String)grantees.elementAt(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    byte[][] tuple = new byte[][]{null, schemaName, tableName, column, this.encoding.encode(owner), this.encoding.encode(grantee), privilege, this.encoding.encode(grantable)};
                    v.addElement(tuple);
                    ++j;
                }
                ++i;
            }
        }
        rs.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String sql;
        Field[] f = new Field[7];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "TABLE_CAT", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "TABLE_SCHEM", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "TABLE_NAME", 1043, this.getMaxNameLength());
        f[3] = new Field(this.connection, "GRANTOR", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "GRANTEE", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "PRIVILEGE", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "IS_GRANTABLE", 1043, this.getMaxNameLength());
        if (this.connection.haveMinimumServerVersion("7.3")) {
            sql = "SELECT n.nspname,c.relname,u.usename,c.relacl  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.relkind = 'r' ";
            if (schemaPattern != null && !"".equals(schemaPattern)) {
                sql = sql + " AND n.nspname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schemaPattern) + "' ";
            }
        } else {
            sql = "SELECT NULL::text AS nspname,c.relname,u.usename,c.relacl FROM pg_class c, pg_user u  WHERE u.usesysid = c.relowner  AND c.relkind = 'r' ";
        }
        if (tableNamePattern != null && !"".equals(tableNamePattern)) {
            sql = sql + " AND c.relname LIKE '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableNamePattern) + "' ";
        }
        sql = sql + " ORDER BY nspname, relname ";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            byte[] schema = rs.getBytes("nspname");
            byte[] table = rs.getBytes("relname");
            String owner = rs.getString("usename");
            String acl = rs.getString("relacl");
            Hashtable permissions = this.parseACL(acl, owner);
            String[] permNames = new String[permissions.size()];
            Enumeration e = permissions.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                permNames[i++] = (String)e.nextElement();
            }
            AbstractJdbc1DatabaseMetaData.sortStringArray(permNames);
            i = 0;
            while (i < permNames.length) {
                byte[] privilege = this.encoding.encode(permNames[i]);
                Vector grantees = (Vector)permissions.get(permNames[i]);
                int j = 0;
                while (j < grantees.size()) {
                    String grantee = (String)grantees.elementAt(j);
                    String grantable = owner.equals(grantee) ? "YES" : "NO";
                    byte[][] tuple = new byte[][]{null, schema, table, this.encoding.encode(owner), this.encoding.encode(grantee), privilege, this.encoding.encode(grantable)};
                    v.addElement(tuple);
                    ++j;
                }
                ++i;
            }
        }
        rs.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    private static void sortStringArray(String[] s) {
        int i = 0;
        while (i < s.length - 1) {
            int j = i + 1;
            while (j < s.length) {
                if (s[i].compareTo(s[j]) > 0) {
                    String tmp = s[i];
                    s[i] = s[j];
                    s[j] = tmp;
                }
                ++j;
            }
            ++i;
        }
    }

    private static Vector parseACLArray(String aclString) {
        Vector<String> acls = new Vector<String>();
        if (aclString == null || aclString.length() == 0) {
            return acls;
        }
        boolean inQuotes = false;
        int beginIndex = 1;
        int prevChar = 32;
        int i = beginIndex;
        while (i < aclString.length()) {
            char c = aclString.charAt(i);
            if (c == '\"' && prevChar != 92) {
                inQuotes = !inQuotes;
            } else if (c == ',' && !inQuotes) {
                acls.addElement(aclString.substring(beginIndex, i));
                beginIndex = i + 1;
            }
            prevChar = c;
            ++i;
        }
        acls.addElement(aclString.substring(beginIndex, aclString.length() - 1));
        int i2 = 0;
        while (i2 < acls.size()) {
            String acl = (String)acls.elementAt(i2);
            if (acl.startsWith("\"") && acl.endsWith("\"")) {
                acl = acl.substring(1, acl.length() - 1);
                acls.setElementAt(acl, i2);
            }
            ++i2;
        }
        return acls;
    }

    private void addACLPrivileges(String acl, Hashtable privileges) {
        int equalIndex = acl.lastIndexOf("=");
        String name = acl.substring(0, equalIndex);
        if (name.length() == 0) {
            name = "PUBLIC";
        }
        String privs = acl.substring(equalIndex + 1);
        int i = 0;
        while (i < privs.length()) {
            String sqlpriv;
            char c = privs.charAt(i);
            switch (c) {
                case 'a': {
                    sqlpriv = "INSERT";
                    break;
                }
                case 'r': {
                    sqlpriv = "SELECT";
                    break;
                }
                case 'w': {
                    sqlpriv = "UPDATE";
                    break;
                }
                case 'd': {
                    sqlpriv = "DELETE";
                    break;
                }
                case 'R': {
                    sqlpriv = "RULE";
                    break;
                }
                case 'x': {
                    sqlpriv = "REFERENCES";
                    break;
                }
                case 't': {
                    sqlpriv = "TRIGGER";
                    break;
                }
                case 'X': {
                    sqlpriv = "EXECUTE";
                    break;
                }
                case 'U': {
                    sqlpriv = "USAGE";
                    break;
                }
                case 'C': {
                    sqlpriv = "CREATE";
                    break;
                }
                case 'T': {
                    sqlpriv = "CREATE TEMP";
                    break;
                }
                default: {
                    sqlpriv = "UNKNOWN";
                }
            }
            Vector<String> usersWithPermission = (Vector<String>)privileges.get(sqlpriv);
            if (usersWithPermission == null) {
                usersWithPermission = new Vector<String>();
                privileges.put(sqlpriv, usersWithPermission);
            }
            usersWithPermission.addElement(name);
            ++i;
        }
    }

    protected Hashtable parseACL(String aclArray, String owner) {
        if (aclArray == null || aclArray == "") {
            aclArray = "{" + owner + "=arwdRxt}";
        }
        Vector acls = AbstractJdbc1DatabaseMetaData.parseACLArray(aclArray);
        Hashtable privileges = new Hashtable();
        int i = 0;
        while (i < acls.size()) {
            String acl = (String)acls.elementAt(i);
            this.addACLPrivileges(acl, privileges);
            ++i;
        }
        return privileges;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String from;
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "SCOPE", 21, 2);
        f[1] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[3] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_SIZE", 23, 4);
        f[5] = new Field(this.connection, "BUFFER_LENGTH", 23, 4);
        f[6] = new Field(this.connection, "DECIMAL_DIGITS", 21, 2);
        f[7] = new Field(this.connection, "PSEUDO_COLUMN", 21, 2);
        String where = "";
        if (this.connection.haveMinimumServerVersion("7.3")) {
            from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
            where = " AND ct.relnamespace = n.oid ";
            if (schema != null && !"".equals(schema)) {
                where = where + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
            }
        } else {
            from = " FROM pg_class ct, pg_class ci, pg_attribute a, pg_index i ";
        }
        String sql = "SELECT a.attname, a.atttypid " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary " + " AND ct.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(table) + "' " + where + " ORDER BY a.attnum ";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        while (rs.next()) {
            byte[][] tuple = new byte[8][];
            int columnTypeOid = rs.getInt("atttypid");
            tuple[0] = this.encoding.encode(Integer.toString(scope));
            tuple[1] = rs.getBytes("attname");
            tuple[2] = this.encoding.encode(Integer.toString(this.connection.getSQLType(columnTypeOid)));
            tuple[3] = this.encoding.encode(this.connection.getPGType(columnTypeOid));
            tuple[4] = null;
            tuple[5] = null;
            tuple[6] = null;
            tuple[7] = this.encoding.encode(Integer.toString(1));
            v.addElement(tuple);
        }
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Field[] f = new Field[8];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "SCOPE", 21, 2);
        f[1] = new Field(this.connection, "COLUMN_NAME", 1043, this.getMaxNameLength());
        f[2] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[3] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "COLUMN_SIZE", 23, 4);
        f[5] = new Field(this.connection, "BUFFER_LENGTH", 23, 4);
        f[6] = new Field(this.connection, "DECIMAL_DIGITS", 21, 2);
        f[7] = new Field(this.connection, "PSEUDO_COLUMN", 21, 2);
        byte[][] tuple = new byte[][]{null, this.encoding.encode("ctid"), this.encoding.encode(Integer.toString(this.connection.getSQLType("tid"))), this.encoding.encode("tid"), null, null, null, this.encoding.encode(Integer.toString(2))};
        v.addElement(tuple);
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String from;
        String select;
        String where = "";
        if (this.connection.haveMinimumServerVersion("7.3")) {
            select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
            from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
            where = " AND ct.relnamespace = n.oid ";
            if (schema != null && !"".equals(schema)) {
                where = where + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
            }
        } else {
            select = "SELECT NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, ";
            from = " FROM pg_class ct, pg_class ci, pg_attribute a, pg_index i ";
        }
        String sql = select + " ct.relname AS TABLE_NAME, " + " a.attname AS COLUMN_NAME, " + " a.attnum AS KEY_SEQ, " + " ci.relname AS PK_NAME " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary ";
        if (table != null && !"".equals(table)) {
            sql = sql + " AND ct.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(table) + "' ";
        }
        sql = sql + where + " ORDER BY table_name, pk_name, key_seq";
        return this.connection.createStatement().executeQuery(sql);
    }

    protected ResultSet getImportedExportedKeys(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String from;
        String select;
        Field[] f = new Field[]{new Field(this.connection, "PKTABLE_CAT", 1043, this.getMaxNameLength()), new Field(this.connection, "PKTABLE_SCHEM", 1043, this.getMaxNameLength()), new Field(this.connection, "PKTABLE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "PKCOLUMN_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "FKTABLE_CAT", 1043, this.getMaxNameLength()), new Field(this.connection, "FKTABLE_SCHEM", 1043, this.getMaxNameLength()), new Field(this.connection, "FKTABLE_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "FKCOLUMN_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "KEY_SEQ", 21, 2), new Field(this.connection, "UPDATE_RULE", 21, 2), new Field(this.connection, "DELETE_RULE", 21, 2), new Field(this.connection, "FK_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "PK_NAME", 1043, this.getMaxNameLength()), new Field(this.connection, "DEFERRABILITY", 21, 2)};
        String where = "";
        if (this.connection.haveMinimumServerVersion("7.4")) {
            String sql = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEMA, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FK_TABLE_CAT, fkn.nspname AS FKTABLE_SCHEMA, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con, information_schema._pg_keypositions() pos(n),  pg_catalog.pg_depend dep, pg_catalog.pg_class pkic  WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid  AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid  AND con.contype = 'f' AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND pkic.relkind = 'i' AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid ";
            if (primarySchema != null && !"".equals(primarySchema)) {
                sql = sql + " AND pkn.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(primarySchema) + "' ";
            }
            if (foreignSchema != null && !"".equals(foreignSchema)) {
                sql = sql + " AND fkn.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(foreignSchema) + "' ";
            }
            if (primaryTable != null && !"".equals(primaryTable)) {
                sql = sql + " AND pkc.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(primaryTable) + "' ";
            }
            if (foreignTable != null && !"".equals(foreignTable)) {
                sql = sql + " AND fkc.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(foreignTable) + "' ";
            }
            sql = primaryTable != null ? sql + " ORDER BY fkn.nspname,fkc.relname,pos.n" : sql + " ORDER BY pkn.nspname,pkc.relname,pos.n";
            return this.connection.createStatement().executeQuery(sql);
        }
        if (this.connection.haveMinimumServerVersion("7.3")) {
            select = "SELECT DISTINCT n1.nspname as pnspname,n2.nspname as fnspname, ";
            from = " FROM pg_catalog.pg_namespace n1  JOIN pg_catalog.pg_class c1 ON (c1.relnamespace = n1.oid)  JOIN pg_catalog.pg_index i ON (c1.oid=i.indrelid)  JOIN pg_catalog.pg_class ic ON (i.indexrelid=ic.oid)  JOIN pg_catalog.pg_attribute a ON (ic.oid=a.attrelid),  pg_catalog.pg_namespace n2  JOIN pg_catalog.pg_class c2 ON (c2.relnamespace=n2.oid),  pg_catalog.pg_trigger t1  JOIN pg_catalog.pg_proc p1 ON (t1.tgfoid=p1.oid),  pg_catalog.pg_trigger t2  JOIN pg_catalog.pg_proc p2 ON (t2.tgfoid=p2.oid) ";
            if (primarySchema != null && !"".equals(primarySchema)) {
                where = where + " AND n1.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(primarySchema) + "' ";
            }
            if (foreignSchema != null && !"".equals(foreignSchema)) {
                where = where + " AND n2.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(foreignSchema) + "' ";
            }
        } else {
            select = "SELECT DISTINCT NULL::text as pnspname, NULL::text as fnspname, ";
            from = " FROM pg_class c1  JOIN pg_index i ON (c1.oid=i.indrelid)  JOIN pg_class ic ON (i.indexrelid=ic.oid)  JOIN pg_attribute a ON (ic.oid=a.attrelid),  pg_class c2,  pg_trigger t1  JOIN pg_proc p1 ON (t1.tgfoid=p1.oid),  pg_trigger t2  JOIN pg_proc p2 ON (t2.tgfoid=p2.oid) ";
        }
        String sql = select + "c1.relname as prelname, " + "c2.relname as frelname, " + "t1.tgconstrname, " + "a.attnum as keyseq, " + "ic.relname as fkeyname, " + "t1.tgdeferrable, " + "t1.tginitdeferred, " + "t1.tgnargs,t1.tgargs, " + "p1.proname as updaterule, " + "p2.proname as deleterule " + from + "WHERE " + "(t1.tgrelid=c1.oid " + "AND t1.tgisconstraint " + "AND t1.tgconstrrelid=c2.oid " + "AND p1.proname LIKE 'RI\\\\_FKey\\\\_%\\\\_upd') " + "AND " + "(t2.tgrelid=c1.oid " + "AND t2.tgisconstraint " + "AND t2.tgconstrrelid=c2.oid " + "AND p2.proname LIKE 'RI\\\\_FKey\\\\_%\\\\_del') " + "AND i.indisprimary " + where;
        if (primaryTable != null) {
            sql = sql + "AND c1.relname='" + AbstractJdbc1DatabaseMetaData.escapeQuotes(primaryTable) + "' ";
        }
        if (foreignTable != null) {
            sql = sql + "AND c2.relname='" + AbstractJdbc1DatabaseMetaData.escapeQuotes(foreignTable) + "' ";
        }
        sql = sql + "ORDER BY ";
        if (primaryTable != null) {
            if (this.connection.haveMinimumServerVersion("7.3")) {
                sql = sql + "fnspname,";
            }
            sql = sql + "frelname";
        } else {
            if (this.connection.haveMinimumServerVersion("7.3")) {
                sql = sql + "pnspname,";
            }
            sql = sql + "prelname";
        }
        sql = sql + ",keyseq";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        Vector<byte[][]> tuples = new Vector<byte[][]>();
        while (rs.next()) {
            String deleteRule;
            byte[][] tuple = new byte[14][];
            tuple[1] = rs.getBytes(1);
            tuple[5] = rs.getBytes(2);
            tuple[2] = rs.getBytes(3);
            tuple[6] = rs.getBytes(4);
            String fKeyName = rs.getString(5);
            String updateRule = rs.getString(12);
            if (updateRule != null) {
                String rule = updateRule.substring(8, updateRule.length() - 4);
                int action = 3;
                if (rule == null || "noaction".equals(rule)) {
                    action = 3;
                }
                if ("cascade".equals(rule)) {
                    action = 0;
                } else if ("setnull".equals(rule)) {
                    action = 2;
                } else if ("setdefault".equals(rule)) {
                    action = 4;
                } else if ("restrict".equals(rule)) {
                    action = 1;
                }
                tuple[9] = this.encoding.encode(Integer.toString(action));
            }
            if ((deleteRule = rs.getString(13)) != null) {
                String rule = updateRule.substring(8, updateRule.length() - 4);
                int action = 3;
                if ("cascade".equals(rule)) {
                    action = 0;
                } else if ("setnull".equals(rule)) {
                    action = 2;
                } else if ("setdefault".equals(rule)) {
                    action = 4;
                }
                tuple[10] = this.encoding.encode(Integer.toString(action));
            }
            int keySequence = rs.getInt(6);
            String fkeyColumn = "";
            String pkeyColumn = "";
            String fkName = "";
            String targs = rs.getString(11);
            Vector tokens = AbstractJdbc1DatabaseMetaData.tokenize(targs, "\\000");
            if (tokens.size() > 0) {
                fkName = (String)tokens.elementAt(0);
            }
            if (fkName.startsWith("<unnamed>")) {
                fkName = targs;
            }
            int element = 4 + (keySequence - 1) * 2;
            if (tokens.size() > element) {
                fkeyColumn = (String)tokens.elementAt(element);
            }
            if (tokens.size() > ++element) {
                pkeyColumn = (String)tokens.elementAt(element);
            }
            tuple[3] = this.encoding.encode(pkeyColumn);
            tuple[7] = this.encoding.encode(fkeyColumn);
            tuple[8] = rs.getBytes(6);
            tuple[11] = this.encoding.encode(fkName);
            tuple[12] = rs.getBytes(7);
            int deferrability = 7;
            boolean deferrable = rs.getBoolean(8);
            boolean initiallyDeferred = rs.getBoolean(9);
            if (deferrable) {
                deferrability = initiallyDeferred ? 5 : 6;
            }
            tuple[13] = this.encoding.encode(Integer.toString(deferrability));
            tuples.addElement(tuple);
        }
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, tuples, "OK", 1, 0L, false));
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, catalog, schema, table);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return this.getImportedExportedKeys(catalog, schema, table, null, null, null);
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return this.getImportedExportedKeys(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
    }

    public ResultSet getTypeInfo() throws SQLException {
        Field[] f = new Field[18];
        Vector<byte[][]> v = new Vector<byte[][]>();
        f[0] = new Field(this.connection, "TYPE_NAME", 1043, this.getMaxNameLength());
        f[1] = new Field(this.connection, "DATA_TYPE", 21, 2);
        f[2] = new Field(this.connection, "PRECISION", 23, 4);
        f[3] = new Field(this.connection, "LITERAL_PREFIX", 1043, this.getMaxNameLength());
        f[4] = new Field(this.connection, "LITERAL_SUFFIX", 1043, this.getMaxNameLength());
        f[5] = new Field(this.connection, "CREATE_PARAMS", 1043, this.getMaxNameLength());
        f[6] = new Field(this.connection, "NULLABLE", 21, 2);
        f[7] = new Field(this.connection, "CASE_SENSITIVE", 16, 1);
        f[8] = new Field(this.connection, "SEARCHABLE", 21, 2);
        f[9] = new Field(this.connection, "UNSIGNED_ATTRIBUTE", 16, 1);
        f[10] = new Field(this.connection, "FIXED_PREC_SCALE", 16, 1);
        f[11] = new Field(this.connection, "AUTO_INCREMENT", 16, 1);
        f[12] = new Field(this.connection, "LOCAL_TYPE_NAME", 1043, this.getMaxNameLength());
        f[13] = new Field(this.connection, "MINIMUM_SCALE", 21, 2);
        f[14] = new Field(this.connection, "MAXIMUM_SCALE", 21, 2);
        f[15] = new Field(this.connection, "SQL_DATA_TYPE", 23, 4);
        f[16] = new Field(this.connection, "SQL_DATETIME_SUB", 23, 4);
        f[17] = new Field(this.connection, "NUM_PREC_RADIX", 23, 4);
        String sql = this.connection.haveMinimumServerVersion("7.3") ? "SELECT typname FROM pg_catalog.pg_type" : "SELECT typname FROM pg_type";
        ResultSet rs = this.connection.createStatement().executeQuery(sql);
        byte[] b9 = this.encoding.encode("9");
        byte[] b10 = this.encoding.encode("10");
        byte[] bf = this.encoding.encode("f");
        byte[] bnn = this.encoding.encode(Integer.toString(0));
        byte[] bts = this.encoding.encode(Integer.toString(3));
        while (rs.next()) {
            byte[][] tuple = new byte[18][];
            String typname = rs.getString(1);
            tuple[0] = this.encoding.encode(typname);
            tuple[1] = this.encoding.encode(Integer.toString(this.connection.getSQLType(typname)));
            tuple[2] = b9;
            tuple[6] = bnn;
            tuple[7] = bf;
            tuple[8] = bts;
            tuple[9] = bf;
            tuple[10] = bf;
            tuple[11] = bf;
            tuple[17] = b10;
            v.addElement(tuple);
        }
        rs.close();
        return (ResultSet)((Object)((BaseStatement)((Object)this.connection.createStatement())).createResultSet(f, v, "OK", 1, 0L, false));
    }

    public ResultSet getIndexInfo(String catalog, String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String from;
        String select;
        String where = "";
        if (this.connection.haveMinimumServerVersion("7.3")) {
            select = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
            from = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_index i, pg_catalog.pg_attribute a, pg_catalog.pg_am am ";
            where = " AND n.oid = ct.relnamespace ";
            if (schema != null && !"".equals(schema)) {
                where = where + " AND n.nspname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(schema) + "' ";
            }
        } else {
            select = "SELECT NULL AS TABLE_CAT, NULL AS TABLE_SCHEM, ";
            from = " FROM pg_class ct, pg_class ci, pg_index i, pg_attribute a, pg_am am ";
        }
        String sql = select + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME, " + " CASE i.indisclustered " + " WHEN true THEN " + 1 + " ELSE CASE am.amname " + "\tWHEN 'hash' THEN " + 2 + "\tELSE " + 3 + "\tEND " + " END AS TYPE, " + " a.attnum AS ORDINAL_POSITION, " + " a.attname AS COLUMN_NAME, " + " NULL AS ASC_OR_DESC, " + " ci.reltuples AS CARDINALITY, " + " ci.relpages AS PAGES, " + " NULL AS FILTER_CONDITION " + from + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + where + " AND ct.relname = '" + AbstractJdbc1DatabaseMetaData.escapeQuotes(tableName) + "' ";
        if (unique) {
            sql = sql + " AND i.indisunique ";
        }
        sql = sql + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.connection.createStatement().executeQuery(sql);
    }

    private static Vector tokenize(String input, String delimiter) {
        Vector<String> result = new Vector<String>();
        int start = 0;
        int end = input.length();
        int delimiterSize = delimiter.length();
        while (start < end) {
            int delimiterIndex = input.indexOf(delimiter, start);
            if (delimiterIndex < 0) {
                result.addElement(input.substring(start));
                break;
            }
            String token = input.substring(start, delimiterIndex);
            result.addElement(token);
            start = delimiterIndex + delimiterSize;
        }
        return result;
    }

    static {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        tableTypeClauses.put("TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'pg\\\\_%' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'pg\\\\_%' AND n.nspname <> 'information_schema'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SEQUENCE", ht);
        ht.put("SCHEMAS", "c.relkind = 'S'");
        ht.put("NOSCHEMAS", "c.relkind = 'S'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM TOAST TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM TOAST INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM VIEW", ht);
        ht.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("SYSTEM INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        ht.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        ht = new Hashtable();
        tableTypeClauses.put("TEMPORARY TABLE", ht);
        ht.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        ht.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        ht = new Hashtable();
        tableTypeClauses.put("TEMPORARY INDEX", ht);
        ht.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        ht.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        defaultTableTypes = new String[]{"TABLE", "VIEW", "INDEX", "SEQUENCE", "TEMPORARY TABLE"};
    }
}

