/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.PlainSocketImpl;
import java.net.Socket;
import java.net.SocketException;
import sun.net.ConnectionResetException;

class SocketOutputStream
extends FileOutputStream {
    private PlainSocketImpl impl = null;
    private byte[] temp = new byte[1];
    private Socket socket = null;
    private boolean closing = false;

    SocketOutputStream(PlainSocketImpl plainSocketImpl) throws IOException {
        super(plainSocketImpl.getFileDescriptor());
        this.impl = plainSocketImpl;
        this.socket = plainSocketImpl.getSocket();
    }

    private native void socketWrite0(FileDescriptor var1, byte[] var2, int var3, int var4) throws IOException;

    private void socketWrite(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0 || n < 0 | n + n2 > byArray.length) {
            if (n2 == 0) {
                return;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        FileDescriptor fileDescriptor = this.impl.acquireFD();
        try {
            this.socketWrite0(fileDescriptor, byArray, n, n2);
        }
        catch (SocketException socketException) {
            SocketException socketException2;
            if (socketException instanceof ConnectionResetException) {
                this.impl.setConnectionResetPending();
                socketException2 = new SocketException("Connection reset");
            }
            if (this.impl.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            throw socketException2;
        }
        finally {
            this.impl.releaseFD();
        }
    }

    public void write(int n) throws IOException {
        this.temp[0] = (byte)n;
        this.socketWrite(this.temp, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.socketWrite(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.socketWrite(byArray, n, n2);
    }

    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        if (this.socket != null) {
            if (!this.socket.isClosed()) {
                this.socket.close();
            }
        } else {
            this.impl.close();
        }
        this.closing = false;
    }

    protected void finalize() {
    }

    private static native void init();

    static {
        SocketOutputStream.init();
    }
}

