/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.InetSocketAddress;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtil.Debug;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;

class Acceptor {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private ServerSocket _fd;
    private int _backlog;
    private InetSocketAddress _addr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (this._traceLevels.network >= 1) {
            object = "stopping to accept tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, (String)object);
        }
        Acceptor acceptor = this;
        synchronized (acceptor) {
            object = this._fd;
            this._fd = null;
        }
        if (object != null) {
            try {
                ((ServerSocket)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void listen() {
        if (this._traceLevels.network >= 1) {
            String string = "accepting tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, string);
        }
    }

    public Transceiver accept(int n) {
        Socket socket = null;
        try {
            if (n == -1) {
                n = 0;
            } else if (n == 0) {
                n = 1;
            }
            this._fd.setSoTimeout(n);
            socket = this._fd.accept();
        }
        catch (InterruptedIOException interruptedIOException) {
            TimeoutException timeoutException = new TimeoutException();
            timeoutException.initCause(interruptedIOException);
            throw timeoutException;
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        if (this._traceLevels.network >= 1) {
            String string = "accepted tcp connection\n" + Network.fdToString(socket);
            this._logger.trace(this._traceLevels.networkCat, string);
        }
        return new Transceiver(this._instance, socket);
    }

    public void connectToSelf() {
        try {
            Socket socket = new Socket(this._addr.getAddress(), this._addr.getPort());
            socket.close();
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    Acceptor(Instance instance, String string, int n) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._backlog = 0;
        if (this._backlog <= 0) {
            this._backlog = 5;
        }
        try {
            this._addr = Network.getAddress(string, n);
            if (this._traceLevels.network >= 2) {
                String string2 = "attempting to bind to tcp socket " + this.toString();
                this._logger.trace(this._traceLevels.networkCat, string2);
            }
            this._fd = new ServerSocket(n, this._backlog, this._addr.getAddress());
            this._addr = new InetSocketAddress(this._addr.getAddress(), this._fd.getLocalPort());
        }
        catch (IOException iOException) {
            if (this._fd != null) {
                try {
                    this._fd.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this._fd = null;
            }
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        catch (RuntimeException runtimeException) {
            if (this._fd != null) {
                try {
                    this._fd.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._fd = null;
            }
            throw runtimeException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Debug.FinalizerAssert(this._fd == null);
    }
}

