/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.ContextHelper;
import Ice.ImplicitContext;
import Ice.InitializationException;
import Ice.LocalObjectImpl;
import IceInternal.BasicStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ImplicitContextI
extends LocalObjectImpl
implements ImplicitContext {
    public static ImplicitContextI create(String kind) {
        if (kind.equals("None") || kind.equals("")) {
            return null;
        }
        if (kind.equals("Shared")) {
            return new Shared();
        }
        if (kind.equals("PerThread")) {
            return new PerThread();
        }
        throw new InitializationException("'" + kind + "' is not a valid value for Ice.ImplicitContext");
    }

    public abstract void write(Map var1, BasicStream var2);

    abstract Map combine(Map var1);

    static class PerThread
    extends ImplicitContextI {
        private Map _map = Collections.synchronizedMap(new HashMap());

        PerThread() {
        }

        public Map getContext() {
            HashMap threadContext = (HashMap)this._map.get(Thread.currentThread());
            if (threadContext == null) {
                threadContext = new HashMap();
            }
            return threadContext;
        }

        public void setContext(Map context) {
            if (context == null || context.isEmpty()) {
                this._map.remove(Thread.currentThread());
            } else {
                HashMap threadContext = new HashMap(context);
                this._map.put(Thread.currentThread(), threadContext);
            }
        }

        public boolean containsKey(String key) {
            HashMap threadContext;
            if (key == null) {
                key = "";
            }
            if ((threadContext = (HashMap)this._map.get(Thread.currentThread())) == null) {
                return false;
            }
            return threadContext.containsKey(key);
        }

        public String get(String key) {
            HashMap threadContext;
            if (key == null) {
                key = "";
            }
            if ((threadContext = (HashMap)this._map.get(Thread.currentThread())) == null) {
                return "";
            }
            String val = (String)threadContext.get(key);
            if (val == null) {
                val = "";
            }
            return val;
        }

        public String put(String key, String value) {
            String oldVal;
            Thread currentThread;
            HashMap<String, String> threadContext;
            if (key == null) {
                key = "";
            }
            if (value == null) {
                value = "";
            }
            if ((threadContext = (HashMap<String, String>)this._map.get(currentThread = Thread.currentThread())) == null) {
                threadContext = new HashMap<String, String>();
                this._map.put(currentThread, threadContext);
            }
            if ((oldVal = threadContext.put(key, value)) == null) {
                oldVal = "";
            }
            return oldVal;
        }

        public String remove(String key) {
            HashMap threadContext;
            if (key == null) {
                key = "";
            }
            if ((threadContext = (HashMap)this._map.get(Thread.currentThread())) == null) {
                return null;
            }
            String val = (String)threadContext.remove(key);
            if (val == null) {
                val = "";
            }
            return val;
        }

        public void write(Map prxContext, BasicStream os) {
            HashMap threadContext = (HashMap)this._map.get(Thread.currentThread());
            if (threadContext == null || threadContext.isEmpty()) {
                ContextHelper.write(os, prxContext);
            } else if (prxContext.isEmpty()) {
                ContextHelper.write(os, threadContext);
            } else {
                Map combined = (Map)threadContext.clone();
                combined.putAll(prxContext);
                ContextHelper.write(os, combined);
            }
        }

        Map combine(Map prxContext) {
            HashMap threadContext = (HashMap)this._map.get(Thread.currentThread());
            Map combined = (Map)threadContext.clone();
            combined.putAll(prxContext);
            return combined;
        }
    }

    static class Shared
    extends ImplicitContextI {
        private HashMap _context = new HashMap();

        Shared() {
        }

        public synchronized Map getContext() {
            return (Map)this._context.clone();
        }

        public synchronized void setContext(Map context) {
            this._context.clear();
            if (context != null && !context.isEmpty()) {
                this._context.putAll(context);
            }
        }

        public synchronized boolean containsKey(String key) {
            if (key == null) {
                key = "";
            }
            return this._context.containsKey(key);
        }

        public synchronized String get(String key) {
            String val;
            if (key == null) {
                key = "";
            }
            if ((val = (String)this._context.get(key)) == null) {
                val = "";
            }
            return val;
        }

        public synchronized String put(String key, String value) {
            String oldVal;
            if (key == null) {
                key = "";
            }
            if (value == null) {
                value = "";
            }
            if ((oldVal = this._context.put(key, value)) == null) {
                oldVal = "";
            }
            return oldVal;
        }

        public synchronized String remove(String key) {
            String val;
            if (key == null) {
                key = "";
            }
            if ((val = (String)this._context.remove(key)) == null) {
                val = "";
            }
            return val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(Map prxContext, BasicStream os) {
            if (prxContext.isEmpty()) {
                Shared shared = this;
                synchronized (shared) {
                    ContextHelper.write(os, this._context);
                }
            }
            Map ctx = null;
            Shared shared = this;
            synchronized (shared) {
                ctx = this._context.isEmpty() ? prxContext : this.combine(prxContext);
            }
            ContextHelper.write(os, ctx);
        }

        synchronized Map combine(Map prxContext) {
            Map combined = (Map)this._context.clone();
            combined.putAll(prxContext);
            return combined;
        }
    }
}

