/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.ServiceInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.CommunicatorChildEditor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.ListTextField;
import IceGridGUI.Application.ParameterValuesField;
import IceGridGUI.Application.PropertiesField;
import IceGridGUI.Application.ServiceInstance;
import IceGridGUI.Application.ServiceTemplate;
import IceGridGUI.Application.ServiceTemplates;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Coordinator;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class ServiceInstanceEditor
extends CommunicatorChildEditor {
    private JComboBox _template = new JComboBox();
    private JButton _templateButton;
    private ParameterValuesField _parameters;
    private ListTextField _propertySets = new ListTextField(20);
    private PropertiesField _properties;
    static final /* synthetic */ boolean $assertionsDisabled;

    ServiceInstanceEditor() {
        AbstractAction gotoTemplate = new AbstractAction("", Utils.getIcon("/icons/16x16/goto.png")){

            public void actionPerformed(ActionEvent e) {
                TreeNode t = (TreeNode)ServiceInstanceEditor.this._template.getSelectedItem();
                if (t != null) {
                    t.getRoot().setSelectedNode(t);
                }
            }
        };
        gotoTemplate.putValue("ShortDescription", "Goto this service template");
        this._templateButton = new JButton(gotoTemplate);
        this._parameters = new ParameterValuesField(this);
        this._propertySets.getDocument().addDocumentListener(this._updateListener);
        this._propertySets.setToolTipText("Property Set References");
        this._properties = new PropertiesField(this);
    }

    ServiceInstanceDescriptor getDescriptor() {
        return (ServiceInstanceDescriptor)this._target.getDescriptor();
    }

    Utils.Resolver getDetailResolver() {
        ServiceInstance service = (ServiceInstance)this._target;
        if (service.getCoordinator().substitute()) {
            return service.getResolver();
        }
        return null;
    }

    void writeDescriptor() {
        ServiceInstanceDescriptor descriptor = this.getDescriptor();
        descriptor.template = ((ServiceTemplate)this._template.getSelectedItem()).getId();
        descriptor.parameterValues = this._parameters.getValues();
        descriptor.propertySet.references = this._propertySets.getList().toArray(new String[0]);
        descriptor.propertySet.properties = this._properties.getProperties();
    }

    boolean isSimpleUpdate() {
        ServiceInstanceDescriptor descriptor = this.getDescriptor();
        ServiceTemplate t = (ServiceTemplate)this._template.getSelectedItem();
        return descriptor.template.equals(t.getId()) && ((Object)descriptor.parameterValues).equals(this._parameters.getValues());
    }

    Communicator.ChildList getChildList() {
        return ((Communicator)this._target.getParent()).getServices();
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        builder.append("Template", (Component)this._template);
        builder.append(this._templateButton);
        builder.nextLine();
        builder.append("Parameters");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        JScrollPane scrollPane = new JScrollPane(this._parameters);
        CellConstraints cc = new CellConstraints();
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
        builder.append("Property Sets");
        builder.append((Component)this._propertySets, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._properties);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Service Properties");
    }

    void show(ServiceInstance service) {
        this.detectUpdates(false);
        this._target = service;
        if (!$assertionsDisabled && this.getDescriptor().template.length() <= 0) {
            throw new AssertionError();
        }
        ServiceInstanceDescriptor descriptor = (ServiceInstanceDescriptor)service.getDescriptor();
        Coordinator coordinator = service.getCoordinator();
        boolean isEditable = !coordinator.substitute();
        Utils.Resolver resolver = isEditable ? null : ((TreeNode)service.getParent()).getResolver();
        this._template.setEnabled(true);
        ServiceTemplates serviceTemplates = service.getRoot().getServiceTemplates();
        this._template.setModel(serviceTemplates.createComboBoxModel());
        ServiceTemplate t = (ServiceTemplate)serviceTemplates.findChild(descriptor.template);
        if (!$assertionsDisabled && t == null) {
            throw new AssertionError();
        }
        this._template.setSelectedItem(t);
        ListDataListener templateListener = new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                ServiceInstanceEditor.this.updated();
                ServiceTemplate t = (ServiceTemplate)ServiceInstanceEditor.this._template.getModel().getSelectedItem();
                TemplateDescriptor td = (TemplateDescriptor)t.getDescriptor();
                ServiceInstanceEditor.this._parameters.set(td.parameters, Editor.makeParameterValues(ServiceInstanceEditor.this._parameters.getValues(), td.parameters), td.parameterDefaults, null);
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }
        };
        this._template.getModel().addListDataListener(templateListener);
        this._template.setEnabled(isEditable);
        TemplateDescriptor td = (TemplateDescriptor)t.getDescriptor();
        this._parameters.set(td.parameters, descriptor.parameterValues, td.parameterDefaults, resolver);
        this._propertySets.setList(Arrays.asList(descriptor.propertySet.references), this.getDetailResolver());
        this._propertySets.setEditable(isEditable);
        this._properties.setProperties(descriptor.propertySet.properties, null, this.getDetailResolver(), isEditable);
        this._applyButton.setEnabled(service.isEphemeral());
        this._discardButton.setEnabled(service.isEphemeral());
        this.detectUpdates(true);
    }

    static {
        $assertionsDisabled = !ServiceInstanceEditor.class.desiredAssertionStatus();
    }
}

