/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.BadMagicException;
import Ice.CloseConnectionException;
import Ice.CloseTimeoutException;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectTimeoutException;
import Ice.Connection;
import Ice.ConnectionLostException;
import Ice.ConnectionNotValidatedException;
import Ice.ConnectionTimeoutException;
import Ice.FeatureNotSupportedException;
import Ice.ForcedCloseConnectionException;
import Ice.Identity;
import Ice.IllegalMessageSizeException;
import Ice.LocalException;
import Ice.Logger;
import Ice.NegativeSizeException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.OperationMode;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.TimeoutException;
import Ice.UnknownMessageException;
import Ice.UnknownRequestIdException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.BasicStream;
import IceInternal.ConnectionMonitor;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EventHandler;
import IceInternal.Incoming;
import IceInternal.Instance;
import IceInternal.IntMap;
import IceInternal.LocalExceptionWrapper;
import IceInternal.Outgoing;
import IceInternal.OutgoingAsync;
import IceInternal.Protocol;
import IceInternal.Reference;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import IceInternal.Transceiver;
import IceUtil.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;

public final class ConnectionI
extends EventHandler
implements Connection {
    public static final int ObjectAdapterDeactivated = 0;
    public static final int CommunicatorDestroyed = 1;
    private Thread _threadPerConnection;
    private Transceiver _transceiver;
    private final String _desc;
    private final String _type;
    private final EndpointI _endpoint;
    private ObjectAdapter _adapter;
    private ServantManager _servantManager;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private boolean _registeredWithPool;
    private int _finishedCount;
    private final ThreadPool _threadPool;
    private final boolean _warn;
    private final int _acmTimeout;
    private long _acmAbsoluteTimeoutMillis;
    private final int _compressionLevel;
    private int _nextRequestId;
    private IntMap _requests = new IntMap();
    private IntMap _asyncRequests = new IntMap();
    private LocalException _exception;
    private BasicStream _batchStream;
    private boolean _batchStreamInUse;
    private int _batchRequestNum;
    private boolean _batchRequestCompress;
    private int _dispatchCount;
    private int _state;
    private long _stateTime;
    private Object _sendMutex = new Object();
    private Incoming _incomingCache;
    private Object _incomingCacheMutex = new Object();
    private Outgoing _outgoingCache;
    private Object _outgoingCacheMutex = new Object();
    private static boolean _compressionSupported;
    private boolean _overrideCompress;
    private boolean _overrideCompressValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int ice_hash() {
        return this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this._endpoint.datagram()) {
            boolean active;
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                if (this._instance.threadPerConnection() && this._threadPerConnection != Thread.currentThread()) {
                    while (this._state == 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this._state >= 3) {
                        if (!$assertionsDisabled && this._exception == null) {
                            throw new AssertionError();
                        }
                        throw this._exception;
                    }
                    return;
                }
                if (!$assertionsDisabled && this._state != 0 && this._state != 4) {
                    throw new AssertionError();
                }
                if (this._state == 4) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                active = this._adapter != null;
            }
            try {
                DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                int timeout = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : this._endpoint.timeout();
                if (active) {
                    Object object = this._sendMutex;
                    synchronized (object) {
                        if (this._transceiver == null) {
                            if (!$assertionsDisabled && this._exception == null) {
                                throw new AssertionError();
                            }
                            throw this._exception;
                        }
                        BasicStream os = new BasicStream(this._instance);
                        os.writeBlob(Protocol.magic);
                        os.writeByte((byte)1);
                        os.writeByte((byte)0);
                        os.writeByte((byte)1);
                        os.writeByte((byte)0);
                        os.writeByte((byte)3);
                        os.writeByte((byte)0);
                        os.writeInt(14);
                        TraceUtil.traceHeader("sending validate connection", os, this._logger, this._traceLevels);
                        try {
                            this._transceiver.write(os, timeout);
                        }
                        catch (TimeoutException ex) {
                            throw new ConnectTimeoutException();
                        }
                    }
                }
                BasicStream is = new BasicStream(this._instance);
                is.resize(14, true);
                is.pos(0);
                try {
                    this._transceiver.read(is, timeout);
                }
                catch (TimeoutException ex) {
                    throw new ConnectTimeoutException();
                }
                if (!$assertionsDisabled && is.pos() != 14) {
                    throw new AssertionError();
                }
                is.pos(0);
                byte[] m = is.readBlob(4);
                if (m[0] != Protocol.magic[0] || m[1] != Protocol.magic[1] || m[2] != Protocol.magic[2] || m[3] != Protocol.magic[3]) {
                    BadMagicException ex = new BadMagicException();
                    ex.badMagic = m;
                    throw ex;
                }
                int pMajor = is.readByte();
                int pMinor = is.readByte();
                if (pMajor != 1) {
                    UnsupportedProtocolException e = new UnsupportedProtocolException();
                    e.badMajor = pMajor < 0 ? pMajor + 255 : pMajor;
                    e.badMinor = pMinor < 0 ? pMinor + 255 : pMinor;
                    e.major = 1;
                    e.minor = 0;
                    throw e;
                }
                int eMajor = is.readByte();
                int eMinor = is.readByte();
                if (eMajor != 1) {
                    UnsupportedEncodingException e = new UnsupportedEncodingException();
                    e.badMajor = eMajor < 0 ? eMajor + 255 : eMajor;
                    e.badMinor = eMinor < 0 ? eMinor + 255 : eMinor;
                    e.major = 1;
                    e.minor = 0;
                    throw e;
                }
                byte messageType = is.readByte();
                if (messageType != 3) {
                    throw new ConnectionNotValidatedException();
                }
                byte compress = is.readByte();
                int size = is.readInt();
                if (size != 14) {
                    throw new IllegalMessageSizeException();
                }
                TraceUtil.traceHeader("received validate connection", is, this._logger, this._traceLevels);
            }
            catch (LocalExceptionWrapper ex) {
                ConnectionI connectionI2 = this;
                synchronized (connectionI2) {
                    this.setState(4, ex.get());
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
            }
            catch (LocalException ex) {
                ConnectionI connectionI3 = this;
                synchronized (connectionI3) {
                    this.setState(4, ex);
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
            }
        }
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
            this.setState(2);
        }
    }

    public synchronized void activate() {
        while (this._state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setState(1);
    }

    public synchronized void hold() {
        while (this._state == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setState(2);
    }

    public synchronized void destroy(int reason) {
        switch (reason) {
            case 0: {
                this.setState(3, new ObjectAdapterDeactivatedException());
                break;
            }
            case 1: {
                this.setState(3, new CommunicatorDestroyedException());
            }
        }
    }

    public synchronized void close(boolean force) {
        if (force) {
            this.setState(4, new ForcedCloseConnectionException());
        } else {
            while (!this._requests.isEmpty() || !this._asyncRequests.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.setState(3, new CloseConnectionException());
        }
    }

    public synchronized boolean isDestroyed() {
        return this._state >= 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Thread threadPerConnection = null;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            if (this._transceiver != null || this._dispatchCount != 0 || this._threadPerConnection != null && this._threadPerConnection.isAlive()) {
                return false;
            }
            if (!$assertionsDisabled && this._state != 4) {
                throw new AssertionError();
            }
            threadPerConnection = this._threadPerConnection;
            this._threadPerConnection = null;
        }
        if (threadPerConnection != null) {
            while (true) {
                try {
                    threadPerConnection.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public synchronized void throwException() {
        if (this._exception != null) {
            if (!$assertionsDisabled && this._state < 3) {
                throw new AssertionError();
            }
            throw this._exception;
        }
    }

    public synchronized void waitUntilHolding() {
        while (this._state < 2 || this._dispatchCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        Thread threadPerConnection = null;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            while (this._state < 3 || this._dispatchCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this._transceiver != null) {
                try {
                    if (this._state != 4 && this._endpoint.timeout() >= 0) {
                        long absoluteWaitTime = this._stateTime + (long)this._endpoint.timeout();
                        long waitTime = absoluteWaitTime - System.currentTimeMillis();
                        if (waitTime > 0L) {
                            this.wait(waitTime);
                            if (System.currentTimeMillis() < absoluteWaitTime) continue;
                            this.setState(4, new CloseTimeoutException());
                            continue;
                        }
                        this.setState(4, new CloseTimeoutException());
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!$assertionsDisabled && this._state != 4) {
                throw new AssertionError();
            }
            threadPerConnection = this._threadPerConnection;
            this._threadPerConnection = null;
        }
        if (threadPerConnection != null) {
            while (true) {
                try {
                    threadPerConnection.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public synchronized void monitor() {
        if (this._state != 1) {
            return;
        }
        Iterator i = this._asyncRequests.entryIterator();
        while (i.hasNext()) {
            IntMap.Entry e = (IntMap.Entry)i.next();
            OutgoingAsync out = (OutgoingAsync)e.getValue();
            if (!out.__timedOut()) continue;
            this.setState(4, new TimeoutException());
            return;
        }
        if (this._acmTimeout > 0 && this._requests.isEmpty() && this._asyncRequests.isEmpty() && !this._batchStreamInUse && this._batchStream.isEmpty() && this._dispatchCount == 0 && System.currentTimeMillis() >= this._acmAbsoluteTimeoutMillis) {
            this.setState(3, new ConnectionTimeoutException());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(BasicStream os, Outgoing out, boolean compress) throws LocalExceptionWrapper {
        int requestId = 0;
        BasicStream stream = null;
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && out != null && this._endpoint.datagram()) {
                throw new AssertionError();
            }
            if (this._exception != null) {
                throw new LocalExceptionWrapper(this._exception, true);
            }
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._state >= 3) {
                throw new AssertionError();
            }
            if (out != null) {
                if ((requestId = this._nextRequestId++) <= 0) {
                    this._nextRequestId = 1;
                    requestId = this._nextRequestId++;
                }
                os.pos(14);
                os.writeInt(requestId);
                this._requests.put(requestId, out);
            }
            stream = this.doCompress(os, this._overrideCompress ? this._overrideCompressValue : compress);
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                TraceUtil.traceRequest("sending request", os, this._logger, this._traceLevels);
                this._transceiver.write(stream, this._endpoint.timeout());
            }
        }
        catch (LocalExceptionWrapper ex) {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex.get());
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                if (out != null) {
                    Outgoing o = (Outgoing)this._requests.remove(requestId);
                    if (o != null) {
                        if (!$assertionsDisabled && o != out) {
                            throw new AssertionError();
                        }
                        throw new LocalExceptionWrapper(this._exception, ex.retry());
                    }
                } else {
                    throw new LocalExceptionWrapper(this._exception, ex.retry());
                }
            }
        }
        catch (LocalException ex) {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex);
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                if (out != null) {
                    Outgoing o = (Outgoing)this._requests.remove(requestId);
                    if (o != null) {
                        if (!$assertionsDisabled && o != out) {
                            throw new AssertionError();
                        }
                        throw this._exception;
                    }
                } else {
                    throw this._exception;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAsyncRequest(BasicStream os, OutgoingAsync out, boolean compress) throws LocalExceptionWrapper {
        int requestId = 0;
        BasicStream stream = null;
        Object object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this._endpoint.datagram()) {
                throw new AssertionError();
            }
            if (this._exception != null) {
                throw new LocalExceptionWrapper(this._exception, true);
            }
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._state >= 3) {
                throw new AssertionError();
            }
            if ((requestId = this._nextRequestId++) <= 0) {
                this._nextRequestId = 1;
                requestId = this._nextRequestId++;
            }
            os.pos(14);
            os.writeInt(requestId);
            this._asyncRequests.put(requestId, out);
            stream = this.doCompress(os, this._overrideCompress ? this._overrideCompressValue : compress);
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
        }
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                TraceUtil.traceRequest("sending asynchronous request", os, this._logger, this._traceLevels);
                this._transceiver.write(stream, this._endpoint.timeout());
            }
        }
        catch (LocalExceptionWrapper ex) {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex.get());
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                OutgoingAsync o = (OutgoingAsync)this._asyncRequests.remove(requestId);
                if (o != null) {
                    if (!$assertionsDisabled && o != out) {
                        throw new AssertionError();
                    }
                    throw new LocalExceptionWrapper(this._exception, ex.retry());
                }
            }
        }
        catch (LocalException ex) {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex);
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                OutgoingAsync o = (OutgoingAsync)this._asyncRequests.remove(requestId);
                if (o != null) {
                    if (!$assertionsDisabled && o != out) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
            }
        }
    }

    public synchronized void prepareBatchRequest(BasicStream os) {
        while (this._batchStreamInUse && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        if (this._exception != null) {
            throw this._exception;
        }
        if (!$assertionsDisabled && this._state <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._state >= 3) {
            throw new AssertionError();
        }
        if (this._batchStream.isEmpty()) {
            try {
                this._batchStream.writeBlob(Protocol.requestBatchHdr);
            }
            catch (LocalException ex) {
                this.setState(4, ex);
                throw ex;
            }
        }
        this._batchStreamInUse = true;
        this._batchStream.swap(os);
    }

    public synchronized void finishBatchRequest(BasicStream os, boolean compress) {
        this._batchStream.swap(os);
        ++this._batchRequestNum;
        if (compress) {
            this._batchRequestCompress = true;
        }
        if (!$assertionsDisabled && !this._batchStreamInUse) {
            throw new AssertionError();
        }
        this._batchStreamInUse = false;
        this.notifyAll();
    }

    public synchronized void abortBatchRequest() {
        this._batchStream = new BasicStream(this._instance);
        this._batchRequestNum = 0;
        this._batchRequestCompress = false;
        if (!$assertionsDisabled && !this._batchStreamInUse) {
            throw new AssertionError();
        }
        this._batchStreamInUse = false;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        BasicStream stream = null;
        Object object = this;
        synchronized (object) {
            while (this._batchStreamInUse && this._exception == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._exception != null) {
                throw this._exception;
            }
            if (this._batchStream.isEmpty()) {
                return;
            }
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._state >= 3) {
                throw new AssertionError();
            }
            this._batchStream.pos(10);
            this._batchStream.writeInt(this._batchStream.size());
            this._batchStream.writeInt(this._batchRequestNum);
            stream = this.doCompress(this._batchStream, this._overrideCompress ? this._overrideCompressValue : this._batchRequestCompress);
            if (this._acmTimeout > 0) {
                this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
            }
            this._batchStreamInUse = true;
        }
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                TraceUtil.traceBatchRequest("sending batch request", this._batchStream, this._logger, this._traceLevels);
                this._transceiver.write(stream, this._endpoint.timeout());
            }
        }
        catch (LocalExceptionWrapper ex) {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex.get());
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                throw this._exception;
            }
        }
        catch (LocalException ex) {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex);
                if (!$assertionsDisabled && this._exception == null) {
                    throw new AssertionError();
                }
                throw this._exception;
            }
        }
        object = this;
        synchronized (object) {
            this._batchStream = new BasicStream(this._instance);
            this._batchRequestNum = 0;
            this._batchRequestCompress = false;
            this._batchStreamInUse = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(BasicStream os, byte compressFlag) {
        ConnectionI connectionI;
        Object object;
        BasicStream stream = null;
        try {
            object = this._sendMutex;
            synchronized (object) {
                if (this._transceiver == null) {
                    if (!$assertionsDisabled && this._exception == null) {
                        throw new AssertionError();
                    }
                    throw this._exception;
                }
                stream = this.doCompress(os, compressFlag != 0);
                TraceUtil.traceReply("sending reply", os, this._logger, this._traceLevels);
                this._transceiver.write(stream, this._endpoint.timeout());
            }
        }
        catch (LocalExceptionWrapper ex) {
            connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex.get());
            }
        }
        catch (LocalException ex) {
            connectionI = this;
            synchronized (connectionI) {
                this.setState(4, ex);
            }
        }
        object = this;
        synchronized (object) {
            if (!$assertionsDisabled && this._state <= 0) {
                throw new AssertionError();
            }
            try {
                if (--this._dispatchCount == 0) {
                    this.notifyAll();
                }
                if (this._state == 3 && this._dispatchCount == 0) {
                    this.initiateShutdown();
                }
                if (this._acmTimeout > 0) {
                    this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
                }
            }
            catch (LocalExceptionWrapper ex) {
                this.setState(4, ex.get());
            }
            catch (LocalException ex) {
                this.setState(4, ex);
            }
        }
    }

    public synchronized void sendNoResponse() {
        if (!$assertionsDisabled && this._state <= 0) {
            throw new AssertionError();
        }
        try {
            if (--this._dispatchCount == 0) {
                this.notifyAll();
            }
            if (this._state == 3 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
        }
        catch (LocalExceptionWrapper ex) {
            this.setState(4, ex.get());
        }
        catch (LocalException ex) {
            this.setState(4, ex);
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        if (this._exception != null) {
            throw this._exception;
        }
        if (!$assertionsDisabled && this._state >= 3) {
            throw new AssertionError();
        }
        this._adapter = adapter;
        if (this._adapter != null) {
            this._servantManager = ((ObjectAdapterI)this._adapter).getServantManager();
            if (this._servantManager == null) {
                this._adapter = null;
            }
        } else {
            this._servantManager = null;
        }
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    public synchronized ObjectPrx createProxy(Identity ident) {
        ConnectionI[] connections = new ConnectionI[]{this};
        Reference ref = this._instance.referenceFactory().create(ident, this._instance.getDefaultContext(), "", 0, connections);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    public boolean datagram() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        return this._endpoint.datagram();
    }

    public boolean readable() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        return true;
    }

    public boolean read(BasicStream stream) {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        return this._transceiver.read(stream, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void message(BasicStream stream, ThreadPool threadPool) {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        MessageInfo info = new MessageInfo(stream);
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            threadPool.promoteFollower();
            if (this._state != 4) {
                this.parseMessage(info);
            }
            if (this._state == 4) {
                return;
            }
        }
        if (info.outAsync != null) {
            info.outAsync.__finished(info.stream);
        }
        this.invokeAll(info.stream, info.invokeNum, info.requestId, info.compress, info.servantManager, info.adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(ThreadPool threadPool) {
        Object out;
        IntMap.Entry e;
        Iterator i;
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        threadPool.promoteFollower();
        LocalException localEx = null;
        IntMap requests = null;
        IntMap asyncRequests = null;
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            --this._finishedCount;
            if (this._finishedCount == 0 && this._state == 4) {
                Object object = this._sendMutex;
                synchronized (object) {
                    try {
                        this._transceiver.close();
                    }
                    catch (LocalException ex) {
                        localEx = ex;
                    }
                    this._transceiver = null;
                    this.notifyAll();
                }
            }
            if (this._state == 4 || this._state == 3) {
                requests = this._requests;
                this._requests = new IntMap();
                asyncRequests = this._asyncRequests;
                this._asyncRequests = new IntMap();
            }
        }
        if (requests != null) {
            i = requests.entryIterator();
            while (i.hasNext()) {
                e = (IntMap.Entry)i.next();
                out = (Outgoing)e.getValue();
                ((Outgoing)out).finished(this._exception);
            }
        }
        if (asyncRequests != null) {
            i = asyncRequests.entryIterator();
            while (i.hasNext()) {
                e = (IntMap.Entry)i.next();
                out = (OutgoingAsync)e.getValue();
                ((OutgoingAsync)out).__finished(this._exception);
            }
        }
        if (localEx != null) {
            throw localEx;
        }
    }

    public synchronized void exception(LocalException ex) {
        this.setState(4, ex);
    }

    public String type() {
        return this._type;
    }

    public int timeout() {
        return this._endpoint.timeout();
    }

    public String toString() {
        return this._toString();
    }

    public String _toString() {
        return this._desc;
    }

    public Transceiver getTransceiver() {
        return this._transceiver;
    }

    public ConnectionI(Instance instance, Transceiver transceiver, EndpointI endpoint, ObjectAdapter adapter) {
        super(instance);
        this._transceiver = transceiver;
        this._desc = ((Object)transceiver).toString();
        this._type = transceiver.type();
        this._endpoint = endpoint;
        this._adapter = adapter;
        this._logger = instance.initializationData().logger;
        this._traceLevels = instance.traceLevels();
        this._registeredWithPool = false;
        this._finishedCount = 0;
        this._warn = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._acmAbsoluteTimeoutMillis = 0L;
        this._nextRequestId = 1;
        this._batchStream = new BasicStream(instance);
        this._batchStreamInUse = false;
        this._batchRequestNum = 0;
        this._batchRequestCompress = false;
        this._dispatchCount = 0;
        this._state = 0;
        this._stateTime = System.currentTimeMillis();
        this._acmTimeout = this._endpoint.datagram() ? 0 : (this._adapter != null ? this._instance.serverACM() : this._instance.clientACM());
        int compressionLevel = this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Compression.Level", 1);
        if (compressionLevel < 1) {
            compressionLevel = 1;
        } else if (compressionLevel > 9) {
            compressionLevel = 9;
        }
        this._compressionLevel = compressionLevel;
        this._servantManager = this._adapter != null ? ((ObjectAdapterI)this._adapter).getServantManager() : null;
        try {
            if (!this._instance.threadPerConnection()) {
                this._threadPool = this._adapter != null ? ((ObjectAdapterI)this._adapter).getThreadPool() : this._instance.clientThreadPool();
            } else {
                this._threadPool = null;
                this._threadPerConnection = new ThreadPerConnection();
                this._threadPerConnection.start();
            }
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            pw.flush();
            String s = this._instance.threadPerConnection() ? "cannot create thread for connection:\n" : "cannot create thread pool for connection:\n";
            s = s + sw.toString();
            this._logger.error(s);
            try {
                this._transceiver.close();
            }
            catch (LocalException localException) {
                // empty catch block
            }
            SyscallException e = new SyscallException();
            e.initCause(ex);
            throw e;
        }
        this._overrideCompress = this._instance.defaultsAndOverrides().overrideCompress;
        this._overrideCompressValue = this._instance.defaultsAndOverrides().overrideCompressValue;
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._state == 4);
        Assert.FinalizerAssert(this._transceiver == null);
        Assert.FinalizerAssert(this._dispatchCount == 0);
        Assert.FinalizerAssert(this._threadPerConnection == null);
        super.finalize();
    }

    private void setState(int state, LocalException ex) {
        if (!$assertionsDisabled && state != 3 && state != 4) {
            throw new AssertionError();
        }
        if (this._state == state) {
            return;
        }
        if (this._exception == null) {
            this._exception = ex;
            if (!(!this._warn || this._state <= 0 || this._exception instanceof CloseConnectionException || this._exception instanceof ForcedCloseConnectionException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state == 3)) {
                this.warning("connection exception", this._exception);
            }
        }
        this.setState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        if (this._endpoint.datagram() && state == 3) {
            state = 4;
        }
        if (this._state == 0 && state == 3) {
            state = 4;
        }
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
            case 1: {
                if (this._state != 2 && this._state != 0) {
                    return;
                }
                if (this._instance.threadPerConnection()) break;
                this.registerWithPool();
                break;
            }
            case 2: {
                if (this._state != 1 && this._state != 0) {
                    return;
                }
                if (this._instance.threadPerConnection()) break;
                this.unregisterWithPool();
                break;
            }
            case 3: {
                if (this._state == 4) {
                    return;
                }
                if (this._instance.threadPerConnection()) break;
                this.registerWithPool();
                break;
            }
            case 4: {
                if (this._instance.threadPerConnection()) {
                    this._transceiver.shutdownReadWrite();
                    break;
                }
                if (this._state == 0) {
                    if (!$assertionsDisabled && this._registeredWithPool) {
                        throw new AssertionError();
                    }
                    Object object = this._sendMutex;
                    synchronized (object) {
                        try {
                            this._transceiver.close();
                        }
                        catch (LocalException ex) {
                            // empty catch block
                        }
                        this._transceiver = null;
                        break;
                    }
                }
                this.registerWithPool();
                this.unregisterWithPool();
                this._transceiver.shutdownWrite();
            }
        }
        ConnectionMonitor connectionMonitor = this._instance.connectionMonitor();
        if (connectionMonitor != null) {
            if (state == 1) {
                connectionMonitor.add(this);
            } else if (this._state == 1) {
                connectionMonitor.remove(this);
            }
        }
        this._state = state;
        this._stateTime = System.currentTimeMillis();
        this.notifyAll();
        if (this._state == 3 && this._dispatchCount == 0) {
            try {
                this.initiateShutdown();
            }
            catch (LocalExceptionWrapper ex) {
                this.setState(4, ex.get());
            }
            catch (LocalException ex) {
                this.setState(4, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateShutdown() throws LocalExceptionWrapper {
        if (!$assertionsDisabled && this._state != 3) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._dispatchCount != 0) {
            throw new AssertionError();
        }
        if (!this._endpoint.datagram()) {
            Object object = this._sendMutex;
            synchronized (object) {
                BasicStream os = new BasicStream(this._instance);
                os.writeBlob(Protocol.magic);
                os.writeByte((byte)1);
                os.writeByte((byte)0);
                os.writeByte((byte)1);
                os.writeByte((byte)0);
                os.writeByte((byte)4);
                os.writeByte(_compressionSupported ? (byte)1 : 0);
                os.writeInt(14);
                TraceUtil.traceHeader("sending close connection", os, this._logger, this._traceLevels);
                this._transceiver.write(os, this._endpoint.timeout());
            }
        }
    }

    private void registerWithPool() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        if (!this._registeredWithPool) {
            this._threadPool._register(this._transceiver.fd(), this);
            this._registeredWithPool = true;
        }
    }

    private void unregisterWithPool() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        if (this._registeredWithPool) {
            this._threadPool.unregister(this._transceiver.fd());
            this._registeredWithPool = false;
            ++this._finishedCount;
        }
    }

    private BasicStream doCompress(BasicStream uncompressed, boolean compress) {
        BasicStream cstream;
        if (_compressionSupported && compress && uncompressed.size() >= 100 && (cstream = uncompressed.compress(14, this._compressionLevel)) != null) {
            cstream.pos(9);
            cstream.writeByte((byte)2);
            cstream.pos(10);
            cstream.writeInt(cstream.size());
            uncompressed.pos(9);
            uncompressed.writeByte((byte)2);
            uncompressed.writeInt(cstream.size());
            return cstream;
        }
        uncompressed.pos(9);
        uncompressed.writeByte((byte)(_compressionSupported && compress ? 1 : 0));
        uncompressed.pos(10);
        uncompressed.writeInt(uncompressed.size());
        return uncompressed;
    }

    private void parseMessage(MessageInfo info) {
        if (!($assertionsDisabled || this._state > 0 && this._state < 4)) {
            throw new AssertionError();
        }
        if (this._acmTimeout > 0) {
            this._acmAbsoluteTimeoutMillis = System.currentTimeMillis() + (long)(this._acmTimeout * 1000);
        }
        try {
            if (!$assertionsDisabled && info.stream.pos() != info.stream.size()) {
                throw new AssertionError();
            }
            info.stream.pos(8);
            byte messageType = info.stream.readByte();
            info.compress = info.stream.readByte();
            if (info.compress == 2) {
                if (_compressionSupported) {
                    BasicStream ustream = info.stream.uncompress(14);
                    if (ustream != info.stream) {
                        info.stream = ustream;
                    }
                } else {
                    FeatureNotSupportedException ex = new FeatureNotSupportedException();
                    ex.unsupportedFeature = "Cannot uncompress compressed message: org.apache.tools.bzip2.CBZip2OutputStream was not found";
                    throw ex;
                }
            }
            info.stream.pos(14);
            switch (messageType) {
                case 4: {
                    TraceUtil.traceHeader("received close connection", info.stream, this._logger, this._traceLevels);
                    if (this._endpoint.datagram()) {
                        if (this._warn) {
                            this._logger.warning("ignoring close connection message for datagram connection:\n" + this._desc);
                        }
                        break;
                    }
                    this.setState(4, new CloseConnectionException());
                    break;
                }
                case 0: {
                    if (this._state == 3) {
                        TraceUtil.traceRequest("received request during closing\n(ignored by server, client will retry)", info.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRequest("received request", info.stream, this._logger, this._traceLevels);
                    info.requestId = info.stream.readInt();
                    info.invokeNum = 1;
                    info.servantManager = this._servantManager;
                    info.adapter = this._adapter;
                    ++this._dispatchCount;
                    break;
                }
                case 1: {
                    if (this._state == 3) {
                        TraceUtil.traceBatchRequest("received batch request during closing\n(ignored by server, client will retry)", info.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceBatchRequest("received batch request", info.stream, this._logger, this._traceLevels);
                    info.invokeNum = info.stream.readInt();
                    if (info.invokeNum < 0) {
                        info.invokeNum = 0;
                        throw new NegativeSizeException();
                    }
                    info.servantManager = this._servantManager;
                    info.adapter = this._adapter;
                    this._dispatchCount += info.invokeNum;
                    break;
                }
                case 2: {
                    TraceUtil.traceReply("received reply", info.stream, this._logger, this._traceLevels);
                    info.requestId = info.stream.readInt();
                    Outgoing out = (Outgoing)this._requests.remove(info.requestId);
                    if (out != null) {
                        out.finished(info.stream);
                        break;
                    }
                    info.outAsync = (OutgoingAsync)this._asyncRequests.remove(info.requestId);
                    if (info.outAsync == null) {
                        throw new UnknownRequestIdException();
                    }
                    break;
                }
                case 3: {
                    TraceUtil.traceHeader("received validate connection", info.stream, this._logger, this._traceLevels);
                    if (this._warn) {
                        this._logger.warning("ignoring unexpected validate connection message:\n" + this._desc);
                    }
                    break;
                }
                default: {
                    TraceUtil.traceHeader("received unknown message\n(invalid, closing connection)", info.stream, this._logger, this._traceLevels);
                    throw new UnknownMessageException();
                }
            }
        }
        catch (SocketException ex) {
            this.setState(4, ex);
        }
        catch (LocalException ex) {
            if (this._endpoint.datagram()) {
                if (this._warn) {
                    this._logger.warning("udp connection exception:\n" + ex + this._desc);
                }
            }
            this.setState(4, ex);
        }
    }

    /*
     * Exception decompiling
     */
    private void invokeAll(BasicStream stream, int invokeNum, int requestId, byte compress, ServantManager servantManager, ObjectAdapter adapter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void warning(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this._desc + "\n" + sw.toString();
        this._logger.warning(s);
    }

    private void error(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this._desc + "\n" + sw.toString();
        this._logger.error(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Incoming getIncoming(ObjectAdapter adapter, boolean response, byte compress, int requestId) {
        Incoming in = null;
        Object object = this._incomingCacheMutex;
        synchronized (object) {
            if (this._incomingCache == null) {
                in = new Incoming(this._instance, this, adapter, response, compress, requestId);
            } else {
                in = this._incomingCache;
                this._incomingCache = this._incomingCache.next;
                in.reset(this._instance, this, adapter, response, compress, requestId);
                in.next = null;
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimIncoming(Incoming in) {
        Object object = this._incomingCacheMutex;
        synchronized (object) {
            in.next = this._incomingCache;
            this._incomingCache = in;
            this._incomingCache.reclaim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outgoing getOutgoing(Reference reference, String operation, OperationMode mode, Map context, boolean compress) throws LocalExceptionWrapper {
        Outgoing out = null;
        Object object = this._outgoingCacheMutex;
        synchronized (object) {
            if (this._outgoingCache == null) {
                out = new Outgoing(this, reference, operation, mode, context, compress);
            } else {
                out = this._outgoingCache;
                this._outgoingCache = this._outgoingCache.next;
                out.reset(reference, operation, mode, context, compress);
                out.next = null;
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaimOutgoing(Outgoing out) {
        out.reclaim();
        Object object = this._outgoingCacheMutex;
        synchronized (object) {
            out.next = this._outgoingCache;
            this._outgoingCache = out;
        }
    }

    static {
        $assertionsDisabled = !ConnectionI.class.desiredAssertionStatus();
        _compressionSupported = BasicStream.compressible();
    }

    private class ThreadPerConnection
    extends Thread {
        private ThreadPerConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook != null) {
                ((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook.start();
            }
            try {
                try {
                    ConnectionI.this.run();
                }
                catch (Exception ex) {
                    ConnectionI.this.error("exception in thread per connection", ex);
                    Object var3_2 = null;
                    if (((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook != null) {
                        ((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook.stop();
                    }
                }
                Object var3_1 = null;
                if (((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook != null) {
                    ((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook.stop();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook != null) {
                    ((ConnectionI)ConnectionI.this)._instance.initializationData().threadHook.stop();
                }
                throw throwable;
            }
        }
    }

    private static class MessageInfo {
        BasicStream stream;
        int invokeNum;
        int requestId;
        byte compress;
        ServantManager servantManager;
        ObjectAdapter adapter;
        OutgoingAsync outAsync;

        MessageInfo(BasicStream stream) {
            this.stream = stream;
        }
    }
}

