/*  xxTimestamp  Get a Timestamp from the user.
    Last modified 1998-06-02

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class xxTimestamp: public xxWindow {
  friend void xxYearButtonCallback (Widget w, XtPointer client_data,
    XtPointer call_data);
  friend void xxMonthButtonCallback (Widget w, XtPointer client_data,
    XtPointer call_data);
  friend void xxDayButtonCallback (Widget w, XtPointer client_data,
    XtPointer call_data);
  friend void xxHourButtonCallback (Widget w, XtPointer client_data,
    XtPointer call_data);
  friend void xxMinuteButtonCallback (Widget w, XtPointer client_data,
    XtPointer call_data);
  friend void xxTimestampCallback (Widget w, XtPointer client_data,
    XtPointer call_data);

public:
  xxTimestamp (xxTideContext *in_xtidecontext, xxContext *context,
     void (*in_timestampcallback) (Timestamp t, void *in_ptr),
     void *in_ptr, Timestamp init, const Dstr &in_timezone);
  ~xxTimestamp();
  void dismiss();

  struct numberedbutton {
    xxContext *button;
    xxTimestamp *parent;
    unsigned number;
  };

protected:
  void *ptr;
  void (*timestampcallback) (Timestamp t, void *in_ptr);
  unsigned year, month, day, hour, minute;
  Dstr timezone;
  xxContext *yearsbutton, *yearsmenu, *gobutton, *cancelbutton,
    *monthsbutton, *monthsmenu, *daysbutton, *daysmenu, *spacelabel1,
    *hoursbutton, *hoursmenu, *minutesbutton, *minutesmenu,
    *helplabel, *spacelabel2;
  xxTimestamp::numberedbutton yearbuttons[globallastyear-globalfirstyear+1];
  xxTimestamp::numberedbutton monthbuttons[12];
  xxTimestamp::numberedbutton daybuttons[31];
  xxTimestamp::numberedbutton hourbuttons[24];
  xxTimestamp::numberedbutton minutebuttons[60];
  void update_buttons();
};
