// Migrate the extension to 1.0
function webdeveloper_migrateTo1()
{
    var toolbar = document.getElementById("webdeveloper-toolbar");

    webdeveloper_deletePreferenceBranch("webdeveloper.color");
    webdeveloper_deletePreferenceBranch("webdeveloper.edit.css");
    webdeveloper_deletePreferenceBranch("webdeveloper.tidied");
    webdeveloper_deletePreferenceBranch("webdeveloper.validator");

    // Remove the disabled preference
    if(webdeveloper_isPreferenceSet("webdeveloper.disabled"))
    {
        webdeveloper_deletePreference("webdeveloper.disabled");
    }

    // Migrate the populate form fields email
    if(webdeveloper_getStringPreference("webdeveloper.populate.form.fields.email", true) == "noemail@noemail.org")
    {
        webdeveloper_deletePreference("webdeveloper.populate.form.fields.email");
    }

    // Migrate the validate feed url
    if(webdeveloper_getStringPreference("webdeveloper.tool.2.url", true) == "http://feedvalidator.org/check.cgi?url=")
    {
        webdeveloper_deletePreference("webdeveloper.tool.2.url");
    }

    // Migrate the view speed report
    if(webdeveloper_getStringPreference("webdeveloper.tool.7.url", true) == "http://www.websiteoptimization.com/cgi-bin/wso/wso.pl?url=")
    {
        webdeveloper_deletePreference("webdeveloper.tool.7.description");
        webdeveloper_deletePreference("webdeveloper.tool.7.url");
    }

    // Migrate the tool count
    if(webdeveloper_getIntegerPreference("webdeveloper.tool.count", true) < 8)
    {
        webdeveloper_deletePreference("webdeveloper.tool.count");
    }

    toolbar.collapsed = false;
    toolbar.hidden    = false;

    document.persist("webdeveloper-toolbar", "collapsed");
    document.persist("webdeveloper-toolbar", "hidden");
}

// Parses the version number
function webdeveloper_parseVersion(version)
{
    // If the version is set
    if(version)
    {
        var splitVersion       = version.split(".");
        var parsedVersion      = splitVersion[0] + ".";
        var splitVersionLength = splitVersion.length;

        // Loop through the remaining parts of the version
        for(var i = 1; i < splitVersionLength; i++)
        {
            parsedVersion += splitVersion[i];
        }

        return parseFloat(parsedVersion);
    }
    else
    {
        return 0;
    }
}

// Check if the extension is being upgraded
function webdeveloper_upgrade()
{
    var previousVersion = webdeveloper_parseVersion(webdeveloper_getStringPreference("webdeveloper.version", true));
    var version         = webdeveloper_parseVersion("@version@");

    // If the versions do not match
    if(previousVersion != version)
    {
        // If the previous version is less than 1.0
        if(previousVersion < webdeveloper_parseVersion("1.0.1"))
        {
            webdeveloper_migrateTo1();
        }

        webdeveloper_setStringPreference("webdeveloper.version", version);
    }
}