require 'runit/testcase'
require 'runit/cui/testrunner'

require 'runit/teardownable'

class DummyTeardown
  extend RUNIT::Teardownable
  include RUNIT::Teardownable
  def dummy1
  end
  def teardown1
    "teardown1 called"
  end
  attach_teardown :teardown1, :dummy1
  def dummy2
  end
  def teardown2
    "teardown2 called"
  end
  attach_teardown :teardown2, :dummy2
  def invoke_tear(id)
    invoke_teardown(id)
  end
end

class DummyTeardown2
  extend RUNIT::Teardownable
  include RUNIT::Teardownable
  def invoke_tear(id)
    invoke_teardown(id)
  end
  def dummy1
  end
  def teardown_new
    "DummyTeardown2#teardown_new called"
  end
  attach_teardown :teardown_new, :dummy1
end

class TestTeardownable < RUNIT::TestCase
  def test_teardown_invoke_teardown
    dmteardown = DummyTeardown.new
    assert_equal("teardown1 called", dmteardown.invoke_tear(:dummy1))
  end
end

if $0 == __FILE__
  if ARGV.size == 0
    suite = TestTeardownable.suite
  else
    suite = RUNIT::TestSuite.new
    ARGV.each do |testmethod|
      suite.add(TestTeardownable.new(testmethod))
    end
  end
  RUNIT::CUI::TestRunner.run(suite)
end
