# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.api.v2010.account import AccountContext
from twilio.rest.api.v2010.account import AccountList


class V2010(Version):

    def __init__(self, domain):
        """
        Initialize the V2010 version of Api

        :returns: V2010 version of Api
        :rtype: twilio.rest.api.v2010.V2010.V2010
        """
        super(V2010, self).__init__(domain)
        self.version = '2010-04-01'
        self._accounts = None
        self._account = None

    @property
    def accounts(self):
        """
        :rtype: twilio.rest.api.v2010.account.AccountList
        """
        if self._accounts is None:
            self._accounts = AccountList(self)
        return self._accounts

    @property
    def account(self):
        """
        :returns: Account provided as the authenticating account
        :rtype: AccountContext
        """
        if self._account is None:
            self._account = AccountContext(self, self.domain.twilio.account_sid)
        return self._account

    @account.setter
    def account(self, value):
        """
        Setter to override the primary account

        :param AccountContext|AccountInstance value: account to use as primary account
        """
        self._account = value

    @property
    def addresses(self):
        """
        :rtype: twilio.rest.api.v2010.account.address.AddressList
        """
        return self.account.addresses

    @property
    def applications(self):
        """
        :rtype: twilio.rest.api.v2010.account.application.ApplicationList
        """
        return self.account.applications

    @property
    def authorized_connect_apps(self):
        """
        :rtype: twilio.rest.api.v2010.account.authorized_connect_app.AuthorizedConnectAppList
        """
        return self.account.authorized_connect_apps

    @property
    def available_phone_numbers(self):
        """
        :rtype: twilio.rest.api.v2010.account.available_phone_number.AvailablePhoneNumberCountryList
        """
        return self.account.available_phone_numbers

    @property
    def calls(self):
        """
        :rtype: twilio.rest.api.v2010.account.call.CallList
        """
        return self.account.calls

    @property
    def conferences(self):
        """
        :rtype: twilio.rest.api.v2010.account.conference.ConferenceList
        """
        return self.account.conferences

    @property
    def connect_apps(self):
        """
        :rtype: twilio.rest.api.v2010.account.connect_app.ConnectAppList
        """
        return self.account.connect_apps

    @property
    def incoming_phone_numbers(self):
        """
        :rtype: twilio.rest.api.v2010.account.incoming_phone_number.IncomingPhoneNumberList
        """
        return self.account.incoming_phone_numbers

    @property
    def keys(self):
        """
        :rtype: twilio.rest.api.v2010.account.key.KeyList
        """
        return self.account.keys

    @property
    def messages(self):
        """
        :rtype: twilio.rest.api.v2010.account.message.MessageList
        """
        return self.account.messages

    @property
    def new_keys(self):
        """
        :rtype: twilio.rest.api.v2010.account.new_key.NewKeyList
        """
        return self.account.new_keys

    @property
    def new_signing_keys(self):
        """
        :rtype: twilio.rest.api.v2010.account.new_signing_key.NewSigningKeyList
        """
        return self.account.new_signing_keys

    @property
    def notifications(self):
        """
        :rtype: twilio.rest.api.v2010.account.notification.NotificationList
        """
        return self.account.notifications

    @property
    def outgoing_caller_ids(self):
        """
        :rtype: twilio.rest.api.v2010.account.outgoing_caller_id.OutgoingCallerIdList
        """
        return self.account.outgoing_caller_ids

    @property
    def queues(self):
        """
        :rtype: twilio.rest.api.v2010.account.queue.QueueList
        """
        return self.account.queues

    @property
    def recordings(self):
        """
        :rtype: twilio.rest.api.v2010.account.recording.RecordingList
        """
        return self.account.recordings

    @property
    def signing_keys(self):
        """
        :rtype: twilio.rest.api.v2010.account.signing_key.SigningKeyList
        """
        return self.account.signing_keys

    @property
    def sip(self):
        """
        :rtype: twilio.rest.api.v2010.account.sip.SipList
        """
        return self.account.sip

    @property
    def short_codes(self):
        """
        :rtype: twilio.rest.api.v2010.account.short_code.ShortCodeList
        """
        return self.account.short_codes

    @property
    def tokens(self):
        """
        :rtype: twilio.rest.api.v2010.account.token.TokenList
        """
        return self.account.tokens

    @property
    def transcriptions(self):
        """
        :rtype: twilio.rest.api.v2010.account.transcription.TranscriptionList
        """
        return self.account.transcriptions

    @property
    def usage(self):
        """
        :rtype: twilio.rest.api.v2010.account.usage.UsageList
        """
        return self.account.usage

    @property
    def validation_requests(self):
        """
        :rtype: twilio.rest.api.v2010.account.validation_request.ValidationRequestList
        """
        return self.account.validation_requests

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010>'
