#!/www/python/bin/python

__revision__ = "$Id: test_count.py,v 1.1 2001/12/10 18:01:22 gward Exp $"

from optik import OptionParser, Option, OptionValueError, SUPPRESS_USAGE

parser = OptionParser(usage=SUPPRESS_USAGE)
parser.add_option("-v", action="count", dest="verbose")
parser.add_option("--verbose", type="int", dest="verbose")
parser.add_option("-q", "--quiet",
                   action="store_const", dest="verbose", const=0)
(values, args) = parser.parse_args([])
assert vars(values) == {'verbose': None}, vars(values)
print "ok: 1"

(values, args) = parser.parse_args(["-v"])
assert vars(values) == {'verbose': 1}, vars(values)
print "ok: 2"

(values, args) = parser.parse_args(["-vvv"])
assert vars(values) == {'verbose': 3}, vars(values)
print "ok: 3"

(values, args) = parser.parse_args(["-v", "-v", "-v"])
assert vars(values) == {'verbose': 3}, vars(values)
print "ok: 4"

(values, args) = parser.parse_args(["-vvv"])
assert vars(values) == {'verbose': 3}, vars(values)
print "ok: 5"

(values, args) = parser.parse_args(["-vvv", "--verbose=2"])
assert vars(values) == {'verbose': 2}, vars(values)
print "ok: 6"

(values, args) = parser.parse_args(["-vvv", "--verbose=2", "-q"])
assert vars(values) == {'verbose': 0}, vars(values)
print "ok: 7"

(values, args) = parser.parse_args(["-vvv", "--verbose=2", "-q", "-v"])
assert vars(values) == {'verbose': 1}, vars(values)
print "ok: 8"

parser.disable_interspersed_args()
(values, args) = parser.parse_args(["--quiet", "3", "-v"])
assert vars(values) == {'verbose': 0}, vars(values)
assert args == ["3", "-v"]
print "ok: 9"

parser.enable_interspersed_args()
(values, args) = parser.parse_args(["--quiet", "3", "-v"])
assert vars(values) == {'verbose': 1}, vars(values)
assert args == ["3"]
print "ok: 10"

try:
    (values, args) = parser.parse_args(["-q3", "-v"])
except SystemExit, err:
    assert err.args[0].endswith("no such option: -3")
    print "ok: 11"
else:
    print "not ok"

try:
    (values, args) = parser.parse_args(["--quiet=3", "-v"])
except SystemExit, err:
    assert err.args[0].endswith("--quiet option does not take a value"), \
           err.args[0]
    print "ok: 12"
else:
    print "not ok"


parser = OptionParser()
parser.add_option("-v", action="count", dest="verbose", default=0)
parser.add_option("--verbose", type="int", dest="verbose")
parser.add_option("-q", "--quiet",
                   action="store_const", dest="verbose", const=0)
(values, args) = parser.parse_args([])
assert vars(values) == {'verbose': 0}, `values.verbose`
print "ok: 13"

(values, args) = parser.parse_args(["-vvv", "--verbose=2", "-q", "-v"])
assert vars(values) == {'verbose': 1}
print "ok: 14"

# XXX would like to allow "--verbose" to be used as shorthand for
# "--verbose=1" -- need concept of an optional argument.

