from qt import QFrame, QHBoxLayout, QVBoxLayout, QTimer, SIGNAL, QFont, QString
from kdecore import i18n
from kdeui import KPushButton, KEdReplace, KTextEdit

iconName = 'findreplace'
labelText = 'KEdReplace'
docParts = ('kdeui', 'KEdReplace')
helpText = ("An example of the KEdReplace dialog.")


class MainFrame(QFrame):
    def __init__(self, parent=None):
        QFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Edit Find Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        
        layout = QVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = QHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showEdReplace)


    def showEdReplace(self):
        dlg = self.dlg = KEdReplace(self)
        self.connect(dlg, SIGNAL('done()'),
                    self.doneClicked)
        self.connect(dlg, SIGNAL('replace()'),
                    self.replaceClicked)        
        dlg.exec_loop()


    def doneClicked(self):
        print 'done replacing'

    def replaceClicked(self):
        print 'replacing: ', self.dlg.getText()
        return
        if self.dlg.get_direction():
            print '(backwards) ',
        else:
            print '(forwards) ',
        if self.dlg.case_sensitive():
            print '(case-sensitive)'
        else:
            print '(case-insensitive)'
        

        

