import cStringIO
from Ft.Server.Common.Install import Serialize
from Ft.Server.Common import ResourceTypes

def Test(tester):

    tester.startTest("Read File simple.xml")
    f = open('Server/Common/Install/simple.xml')
    pl = Serialize.Deserialize(f,refUri = 'Server/Common/Install/')
    f.close()

    tester.testDone()

    tester.startTest("Serialize")
    res = Serialize.Serialize(pl,refUri = 'Server/Common/Install')
    tester.testDone()

    tester.startTest('Compare Serialize')
    st = cStringIO.StringIO(str(res))
    npl = Serialize.Deserialize(st,refUri = 'Server/Common/Install/')
    CompareProducts(tester,pl,npl)

    tester.testDone()


def CompareProducts(tester,p1,p2):
    
    tester.compare(p1.version,p2.version)
    tester.compare(p1.name,p2.name)
    tester.compare(p1.description,p2.description)
    tester.compare(len(p1.resourceList),len(p2.resourceList))
    
    for r1,r2 in map(None,p1.resourceList,p2.resourceList):
        tester.compare(r1.resourceType,r2.resourceType)
        tester.compare(r1.path,r2.path)
        tester.compare(r1.acl,r2.acl)
        tester.compare(r1.owner,r2.owner)
        tester.compare(r1.contentUri,r2.contentUri)

        if r1.resourceType in ResourceTypes.XML_DOCUMENTS:
            tester.compare(r1.docDef,r2.docDef)

        if r1.resourceType == ResourceTypes.ResourceType.URI_REFERENCE_FILE:
            tester.compare(r1.href,r2.href)
        if r1.resourceType == ResourceTypes.ResourceType.ALIAS:
            tester.compare(r1.reference,r2.reference)
        if r1.resourceType == ResourceTypes.ResourceType.USER:
            tester.compare(r1.userName,r2.userName)
            tester.compare(r1.password,r2.password)
            tester.compare(r1.basePath,r2.basePath)
        if r1.resourceType == ResourceTypes.ResourceType.GROUP:
            tester.compare(r1.groupName,r2.groupName)
            tester.compare(r1.members,r2.members)
            tester.compare(r1.basePath,r2.basePath)

        
