########################################################################
#
# File Name:            Rule.py
#
# Documentation:        http://docs.4suite.org/4Rdf/Inference/Rule.py.html
#
"""

WWW: http://4suite.org/4RDF         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

#from Ft.Lib import Set
#import Common
import InferenceEngine

class Rule:
    def __init__(self, id_, premise, conclusion):
        self.premise = premise
        self.conclusion = conclusion
        self.id = id_


    def fire(self, infEng,context):
        if infEng.state != InferenceEngine.InferenceEngine.CHAINING:
            return

        #Add Skolem Variables to the context
        context.skolemVariables = {}
        oldFire = context.fireRules
        context.fireRules = 0
        for predicate in self.premise:
            predicate.execute(infEng, context)

        for action in self.conclusion:
            action.execute(infEng, context)

        delattr(context,'skolemVariables')
        context.fireRules = oldFire

        return

    def execute(self,infEng,context):
        infEng.rules.append(self)
        return

    def _4rdf_dump(self,indent = 0):
        iStr = '\t'*indent
        iStr2 = '\t'*(indent+1)

        rt = iStr + '<ril:rule>\n'
        rt = rt + iStr2 + '<ril:premise>\n'
        for p in self.premise:
            rt = rt + p._4rdf_dump(indent+2)
        rt = rt + iStr2 + '</ril:premise>\n'
        rt = rt + iStr2 + '<ril:conclusion>\n'
        for p in self.conclusion:
            rt = rt + p._4rdf_dump(indent+2)
        rt = rt + iStr2 + '</ril:conclusion>\n'
        rt = rt + iStr + '</ril:rule>\n'
        return rt
