/***************************************************************************
                          core.c  -  description
                             -------------------
    begin                : Mon May 13 2002
    copyright            : (C) 2002 by Net Creature
    email                :  netcreature@users.sourceforge.net
 ***************************************************************************/
/*     GPL */
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <memory.h>
#include <errno.h>
#include <netdb.h>

#include <sys/utsname.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <fcntl.h>
#include <time.h>
#include "core.h"

extern int __connect (int sock, const struct sockaddr *addr, socklen_t len);

extern int tcp_read_time_out;
extern int tcp_connect_time_out;

static const char base64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static inline void encode_base_64(char* src,char* dest,int max_len)
{
	int n,l,i;
 	l=strlen(src);
	max_len=(max_len-1)/4;
	for ( i=0;i<max_len;i++,src+=3,l-=3)
	{
		switch (l) {
		case 0:
			break;
		case 1:
			n=src[0] << 16;
			*dest++=base64[(n >> 18) & 077];
			*dest++=base64[(n >> 12) & 077];
			*dest++='=';
			*dest++='=';
			break;
		case 2:
			n=src[0] << 16 | src[1] << 8;
			*dest++=base64[(n >> 18) & 077];
			*dest++=base64[(n >> 12) & 077];
			*dest++=base64[(n >> 6) & 077];
			*dest++='=';
			break;
		default:
			n=src[0] << 16 | src[1] << 8 | src[2];
			*dest++=base64[(n >> 18) & 077];
			*dest++=base64[(n >> 12) & 077];
			*dest++=base64[(n >> 6) & 077];
			*dest++=base64[n & 077];
		}
		if (l<3) break;
	}
	*dest++=0;
}

static inline int write_n_bytes(int fd,char *buff,size_t size)
{
  int i=0,wrote=0;
  for(;;)
  {
    i=write(fd,&buff[wrote],size-wrote);
    if(i<=0)
         return i;
    wrote+=i;
    if(wrote==size)
         return wrote;
  }
}

static inline int read_line(int fd, char *buff, size_t size)
{
  int i,ready;
  struct pollfd pfd[1];

  pfd[0].fd=fd;
  pfd[0].events=POLLIN;
  for(i=0;i<size-1;i++)
  {
    pfd[0].revents=0;
    ready=poll(pfd,1,tcp_read_time_out);
    if(ready!=1 || !(pfd[0].revents&POLLIN) || 1!=read(fd,&buff[i],1))
      return -1;
    else if(buff[i]=='\n')
    {
        buff[i+1]=0;
        return (i+1);
    }
  }
  return -1;
}

static inline int read_n_bytes(int fd,char *buff, size_t size)
{
  int i,ready;
  struct pollfd pfd[1];

  pfd[0].fd=fd;
  pfd[0].events=POLLIN;
  for(i=0;i<size;i++)
  {
    pfd[0].revents=0;
    ready=poll(pfd,1,tcp_read_time_out);
    if(ready!=1 || !(pfd[0].revents&POLLIN) || 1!=read(fd,&buff[i],1))
      return -1;
  }
  return size;
}

int timed_connect(int sock, const struct sockaddr *addr, socklen_t len)
{
	int ret,value,value_len;
 	struct pollfd pfd[1];

	pfd[0].fd=sock;
	pfd[0].events=POLLOUT;	
	fcntl(sock, F_SETFL, O_NONBLOCK);
  	ret=__connect(sock, addr,  len);
//	printf("\nconnect ret=%d\n",ret);fflush(stdout);
  	if(ret==-1 && errno==EINPROGRESS)
   	{
    		ret=poll(pfd,1,tcp_connect_time_out);
//      		printf("\npoll ret=%d\n",ret);fflush(stdout);
      		if(ret==1)
        	{
           		value_len=sizeof(int);
             		getsockopt(sock,SOL_SOCKET,SO_ERROR,&value,&value_len) ;
//             		printf("\nvalue=%d\n",value);fflush(stdout);
               	if(!value)
               		ret=0;
                 	else
                  		ret=-1;
           	}
              else
              	ret=-1;
       }
       else if (ret==0)
			;		
		else
	       	ret=-1;
       	

       fcntl(sock, F_SETFL, !O_NONBLOCK);
       return ret;
}

static inline int tunnel_to(int sock, in_addr_t ip, in_port_t port, proxy_type pt,char *user,char *pass)
{
        int len;
        char buff[BUFF_SIZE];
        bzero (buff,sizeof(buff));
        switch(pt)
        {
        	case HTTP_TYPE:
         		{
             		sprintf(buff,"CONNECT %s:%d HTTP/1.0\r\nUser-Agent: "
			        "ProxyChains 1.8\r\n",
			        inet_ntoa( * (struct in_addr *) &ip),
			        ntohs(port));
           			if (user[0])
                		{
					char src[256];
     					char dst[512];
					strcpy(src,user);
					strcat(src,":");
					strcat(src,pass);
					encode_base_64(src,dst,512);
					strcat(buff,"Proxy-Authorization: Basic ");
					strcat(buff,dst);
					strcat(buff,"\r\n\r\n");
				}
    				else
					strcat(buff,"\r\n");
			
           			len=strlen(buff);

			        if(len!=send(sock,buff,len,0))
			                return SOCKET_ERROR;
			
           			bzero(buff,sizeof(buff));
                        len=0 ;
      			 // read header byte by byte.
			       while(len<BUFF_SIZE)
			       {
			                if(1==read_n_bytes(sock,buff+len,1))
			                        len++;
			                else
			                        return SOCKET_ERROR;
			                if (    len > 4     &&
		                        	buff[len-1]=='\n'  &&
			                        buff[len-2]=='\r'  &&
			                        buff[len-3]=='\n'  &&
			                        buff[len-4]=='\r'  )
		                        break;
			       }

			       // if not ok (200) or response greather than BUFF_SIZE return BLOCKED;
			       if (     (len==BUFF_SIZE)  ||
			                ! (     buff[9] =='2'         &&
			                        buff[10]=='0'        &&
			                        buff[11]=='0'         ))
                                  return BLOCKED;
			       return SUCCESS;
           		}
            	break;
            case SOCKS4_TYPE:
            	{
               		memset(buff,0,sizeof(buff));
                 		buff[0]=4; // socks version
  				buff[1]=1; // connect command
				memcpy(&buff[2],&port,2); // dest port
				memcpy(&buff[4],&ip,4); // dest host
				len=strlen(user)+1; // username
    				if(len>1)	
         				strcpy(&buff[8],user);
				if((len+8)!=write_n_bytes(sock,buff,(8+len)))
					return SOCKET_ERROR;

 				if(8!=read_n_bytes(sock,buff,8))
					return SOCKET_ERROR;
            	
				if (buff[0]!=0||buff[1]!=90)
					return BLOCKED;
     				
         			return SUCCESS;
               	}
                	break;
            case SOCKS5_TYPE:
            	{
               		if(user)
                 		{
                 			buff[0]=5;   //version
					buff[1]=2;	//nomber of methods
					buff[2]=0;   // no auth method
	    				buff[3]=2;  /// auth method -> username / password
                              if(4!=write_n_bytes(sock,buff,4))
					 	return SOCKET_ERROR;
       			}
            		else
                		{
            			buff[0]=5;   //version
					buff[1]=1;	//nomber of methods
					buff[2]=0;   // no auth method
                              if(3!=write_n_bytes(sock,buff,3))
					 	return SOCKET_ERROR;
       			}

				memset(buff,0,sizeof(buff));

				if(2!=read_n_bytes(sock,buff,2))
			 		return SOCKET_ERROR;
			
      			if (buff[0]!=5||(buff[1]!=0&&buff[1]!=2))
         			{
         				if((buff[0]==5)&&(buff[1]==0xFF))
             						return BLOCKED;
						else
							return SOCKET_ERROR;
          			}
          			
          			if (buff[1]==2)
               		{
					// authentication
					char in[2];
     					char out[515]; char* cur=out;
					int c;
     					*cur++=1; // version
					c=strlen(user);
					*cur++=c;
					strncpy(cur,user,c);
					cur+=c;
					c=strlen(pass);
					*cur++=c;
					strncpy(cur,pass,c);
					cur+=c;
					
     					if((cur-out)!=write_n_bytes(sock,out,cur-out))
					 	return SOCKET_ERROR;
     					
          				
					if(2!=read_n_bytes(sock,in,2))
			 			return SOCKET_ERROR;
					if(in[0]!=1||in[1]!=0)
       				{
						if(in[0]!=1)
      						return SOCKET_ERROR;
						else
      						return BLOCKED;
					}
				}	

     				buff[0]=5;       // version
				buff[1]=1;       // connect
				buff[2]=0;       // reserved
				buff[3]=1;       // ip v4

			 	memcpy(&buff[4],&ip,4); // dest host
				memcpy(&buff[8],&port,2); // dest port
				

			      if(10!=write_n_bytes(sock,buff,10))
					return SOCKET_ERROR;
		
			      if(4!=read_n_bytes(sock,buff,4))
					return SOCKET_ERROR;

				if (buff[0]!=5||buff[1]!=0)
			      	return SOCKET_ERROR;

			  	switch (buff[3])
			      {
					case 1: len=4;  break;
					case 4: len=16; break;
					case 3: len=0;
			  			if(1!=read_n_bytes(sock,(char*)&len,1))
			 				return SOCKET_ERROR;
        					break;
					default:
						return SOCKET_ERROR;
				}

     				if((len+2)!=read_n_bytes(sock,buff,(len+2)))
					return SOCKET_ERROR;

				return SUCCESS;
                	}
                	break;	

        }

return SOCKET_ERROR;
}



int connect_proxy_chain(
                int sock,
                in_addr_t target_ip,
                in_port_t target_port,
                proxy_data *pd,
                unsigned int proxy_count,
                chain_type ct )
{

	struct sockaddr_in addr, local_addr;
	int i,k,retcode,tcp_done,ns=-1, addr_len=0;
	
 	if(getsockname(sock ,(struct sockaddr *)&local_addr,&addr_len))
 		goto error;


        switch(ct)
        {
          case DYNAMIC_TYPE:
          		{
              		
            	        ns=-1; // always use new socket, for non-block case
				again:
			        printf("dynamic chain ..");fflush(stdout);
			        tcp_done=0;
			        // tcp connect to first availible proxy in the chain
			        for(i=0;i<proxy_count;i++)
			        {
			                if(pd[i].ps!=PLAY_STATE)
			                        continue;
			              //  if(ns==-1)
			              //  {
			                        ns=socket(PF_INET,SOCK_STREAM,0);
			                        if(ns==-1)
			                                goto error;
			/* --------------------well .... some sockets bind before us
			                        if(local_addr.sin_port)
			                                if(bind(ns ,(struct sockaddr *)&local_addr,
			                                    addr_len=sizeof(local_addr)))
			                                                goto error;
			//---------- think about it :)*/
			                //}
			                bzero(&addr,sizeof(addr));
			                addr.sin_family= AF_INET;
			                addr.sin_addr.s_addr=pd[i].ip;
			                addr.sin_port=pd[i].port;
			       //        printf("\nAdress: %s \n",inet_ntoa(addr.sin_addr));
			                if (! timed_connect ( ns ,(struct sockaddr*)&addr,sizeof(addr)))
			                {
			                        tcp_done=1;
			                        k=i;
			                        break;
			                }
			                pd[i].ps=DOWN_STATE;
			        }
			
			        if(! tcp_done && i==proxy_count)
			        {
			                errno=ECONNREFUSED; // for nmap ;)
			                goto error;
			        }
			
			        printf("..%s:%d..",
			                inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                htons(pd[i].port)
			                );fflush(stdout);
			
			        i++;  // next proxy in chain
			
			        // tunneling through the rest of chain
			        for( ;i<proxy_count;i++)
			        {
			                if(pd[i].ps!=PLAY_STATE)
			                        continue;
			                retcode=tunnel_to(ns,pd[i].ip,pd[i].port,pd[i-1].pt,pd[i-1].user,pd[i-1].pass);
			                switch(retcode)
			                {
			                        case SUCCESS:
			                                printf("..%s:%d..",
			                                       inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                                       htons(pd[i].port)
			                                        );fflush(stdout);
			                                        k=i;
			                                        continue;
			                        case BLOCKED:
			                                pd[i-1].ps=BLOCKED_STATE;
			                                printf("..access denied\n");
			                                fflush(stdout);
			                                close(ns);
			                                ns=-1;
			                                goto again;
			                        case SOCKET_ERROR:
							pd[i].ps=DOWN_STATE;
							printf("..down state\n");
			                                fflush(stdout);
                  			              close(ns);
			                                ns=-1;
			                                goto again;
			                }
			        }
			
			        //tunnel to target
			        retcode=tunnel_to(ns,target_ip,target_port,pd[i-1].pt,pd[i-1].user,pd[i-1].pass);
			        switch(retcode)
			                {
			                        case SUCCESS:
			                                printf("..%s:%d\tOK\n",
			                                inet_ntoa(*(struct in_addr*)&target_ip),
			                                htons(target_port ));fflush(stdout);
			                                break;
			                        case BLOCKED:
			                                printf("..access denied\n");fflush(stdout);
			                                pd[k].ps=BLOCKED_STATE;
			                                close(ns);
			                                ns=-1;
			                                goto again;
			                         case SOCKET_ERROR:
								printf("..target appears down\n");fflush(stdout);
								pd[k].ps=DOWN_STATE;
			                                close(ns);
			                                ns=-1;
			                                goto again;
			                }
			
			        dup2(ns,sock);  //always dup to original socket
			        return 0;
				
              	}
               break;

          case STRICT_TYPE:
          		{
              		ns=-1; // always use new socket, for non-block case
				i=0; // start from the first proxy.
    				printf("strict chain ..");fflush(stdout);
			      tcp_done=0;
			      // make socket
			      ns=socket(PF_INET,SOCK_STREAM,0);
			      if(ns==-1)
			          goto error;
             		/* --------------------well .... some sockets bind before us
			                        if(local_addr.sin_port)
			                                if(bind(ns ,(struct sockaddr *)&local_addr,
			                                    addr_len=sizeof(local_addr)))
			                                                goto error;
				//---------- think about it :)*/
               		// tcp connect to first  proxy in the chain
                 		bzero(&addr,sizeof(addr));
			      addr.sin_family= AF_INET;
			      addr.sin_addr.s_addr=pd[i].ip;
			      addr.sin_port=pd[i].port;
			      //        printf("\nAdress: %s \n",inet_ntoa(addr.sin_addr));
			      if (0!= timed_connect ( ns ,(struct sockaddr*)&addr,sizeof(addr)))
			      {
			      	printf(".. can't connect to %s:%d .... broken chain\n",
			                                       inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                                       htons(pd[i].port)
			                                        );fflush(stdout);
                              goto error;
			      }
			      printf(".. %s:%d ..",
			                                       inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                                       htons(pd[i].port)
			                                        );fflush(stdout);
                 		// tunne through the rest of chain
                   	for(i=1 ;i<proxy_count;i++)
			        {
			                retcode=tunnel_to(ns,pd[i].ip,pd[i].port,pd[i-1].pt,pd[i-1].user,pd[i-1].pass);
			                switch(retcode)
			                {
			                        case SUCCESS:
			                                printf("..%s:%d..",
			                                       inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                                       htons(pd[i].port)
			                                        );fflush(stdout);
			                                break;
			                        case BLOCKED:
			                                printf("..access denied ...  broken chain\n");
			                                fflush(stdout);
			                                close(ns);
			                                ns=-1;
			                                goto error;
			                        case SOCKET_ERROR:
							 printf("..... proxy is down, broken chain\n");
                  			              goto error;
			                }
			        }
           			  //tunnel to target
			        retcode=tunnel_to(ns,target_ip,target_port,pd[i-1].pt,pd[i-1].user,pd[i-1].pass);
			        switch(retcode)
			                {
			                        case SUCCESS:
			                                printf("..%s:%d\tOK\n",
			                                inet_ntoa(*(struct in_addr*)&target_ip),
			                                htons(target_port ));fflush(stdout);
			                                break;
			                        case BLOCKED:
			                                printf("..access denied .. broken chain\n");fflush(stdout);
			                                goto error;
			                         case SOCKET_ERROR:
							 printf("..... target is down, broken chain\n");
			                                goto error;
			                }
			
			        dup2(ns,sock);  //always dup to original socket
			        return 0;
               		
             		
              		
              	}
               break;
          case RANDOM_TYPE:
          		{
              		ns=-1; // always use new socket, for non-block case
				i=0; // start from the first proxy.
    				srand(time(NULL));
				i= 0 +(int) (proxy_count*1.0*rand()/(RAND_MAX+1.0));
				printf("random chain ..");fflush(stdout);
			      tcp_done=0;
			      // make socket
			      ns=socket(PF_INET,SOCK_STREAM,0);
			      if(ns==-1)
			          goto error;
             		/* --------------------well .... some sockets bind before us
			                        if(local_addr.sin_port)
			                                if(bind(ns ,(struct sockaddr *)&local_addr,
			                                    addr_len=sizeof(local_addr)))
			                                                goto error;
				//---------- think about it :)*/
    				// tcp connect to random  proxy in the chain
                 		bzero(&addr,sizeof(addr));
			      addr.sin_family= AF_INET;
			      addr.sin_addr.s_addr=pd[i].ip;
			      addr.sin_port=pd[i].port;
			      //        printf("\nAdress: %s \n",inet_ntoa(addr.sin_addr));
			      if (0!= timed_connect ( ns ,(struct sockaddr*)&addr,sizeof(addr)))
			      {
			      	printf(".. can't connect to %s:%d .... broken chain\n",
			                                       inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                                       htons(pd[i].port)
			                                        );fflush(stdout);
                              goto error;
			      }
         			printf(".. %s:%d ..",
			                                       inet_ntoa(*(struct in_addr*)&pd[i].ip),
			                                       htons(pd[i].port)
			                                        );fflush(stdout);
         			//tunnel to target
			        retcode=tunnel_to(ns,target_ip,target_port,pd[i].pt,pd[i].user,pd[i].pass);
			        switch(retcode)
			                {
			                        case SUCCESS:
			                                printf("..%s:%d\tOK\n",
			                                inet_ntoa(*(struct in_addr*)&target_ip),
			                                htons(target_port ));fflush(stdout);
			                                break;
			                        case BLOCKED:
			                                printf("..access denied .. broken chain\n");fflush(stdout);
			                                goto error;
			                         case SOCKET_ERROR:
							    printf("... broken chain\n");fflush(stdout);
			                                goto error;
			                }
			
			        dup2(ns,sock);  //always dup to original socket
			        return 0;
              	}
               break;
          default:
        }


error:
	errno=ECONNREFUSED;  // for nmap ;)
	return -1;
}
