// ----------------------------------------------------------------------------
//  Description      : Cheap testing framework
// ----------------------------------------------------------------------------
// (c) 1999 Andreas Kloeckner <ak@ixion.net> See COPYING for licensing issues.
// ----------------------------------------------------------------------------




#ifndef O2CPP_TEST
#define O2CPP_TEST




#include <iostream>




#define BEGIN_TEST \
int main(int argc,char *argv[]) {\
  try {
  unsigned errcount = 0,testcount = 0;


#define END_TEST \
  if (errcount) \
    cout << errcount << " out of " << testcount \
      << " test(s) failed." << endl; \
  else \
    cout << "all " << testcount << " tests passed." << endl; \
  return errcount; \
  } \
  catch (...) { cerr << "exception exit. bad." << endl; return 1; } \
}

#define PASSED { testcount++; }

#define FAILED { testcount++; errcount++; \
  cerr << "*** Test " << testcount << " failed." << endl; }

#define FAILEDEX { testcount++; errcount++; \
  cerr << "*** Test " << testcount << " failed due to an exception." << endl; }
  
#define TEST(INVARIANT) \
  try { \
    if (INVARIANT) PASSED else FAILED \
  } \
  catch (...) { FAILEDEX }




#endif
