# arr-diff [![NPM version](https://img.shields.io/npm/v/arr-diff.svg?style=flat)](https://www.npmjs.com/package/arr-diff) [![NPM downloads](https://img.shields.io/npm/dm/arr-diff.svg?style=flat)](https://npmjs.org/package/arr-diff) [![Build Status](https://img.shields.io/travis/jonschlinkert/arr-diff.svg?style=flat)](https://travis-ci.org/jonschlinkert/arr-diff)

Returns an array with only the unique values from the first array, by excluding all values from additional arrays using strict equality for comparisons.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install arr-diff --save
```

Install with [bower](http://bower.io/)

```sh
$ bower install arr-diff --save
```

## Usage

Returns the difference between the first array and additional arrays.

```js
var diff = require('arr-diff');

var a = ['a', 'b', 'c', 'd'];
var b = ['b', 'c'];

console.log(diff(a, b))
//=> ['a', 'd']
```

## Benchmarks

This library versus [array-differ](https://github.com/sindresorhus/array-differ), on May 07, 2016:

```
# benchmark/fixtures/long.js (94529 bytes)
  current x 1,246 ops/sec ±0.98% (85 runs sampled)
  array-differ x 993 ops/sec ±1.35% (87 runs sampled)

# benchmark/fixtures/med.js (708 bytes)
  current x 583,612 ops/sec ±1.24% (87 runs sampled)
  array-differ x 464,480 ops/sec ±1.42% (85 runs sampled)

# benchmark/fixtures/short.js (60 bytes)
  current x 788,823 ops/sec ±0.95% (89 runs sampled)
  array-differ x 521,483 ops/sec ±1.65% (86 runs sampled)
```

## Related projects

You might also be interested in these projects:

* [arr-flatten](https://www.npmjs.com/package/arr-flatten): Recursively flatten an array or arrays. This is the fastest implementation of array flatten. | [homepage](https://github.com/jonschlinkert/arr-flatten)
* [array-filter](https://www.npmjs.com/package/array-filter): Array#filter for older browsers. | [homepage](https://github.com/juliangruber/array-filter)
* [array-intersection](https://www.npmjs.com/package/array-intersection): Return an array with the unique values present in _all_ given arrays using strict equality… [more](https://www.npmjs.com/package/array-intersection) | [homepage](https://github.com/jonschlinkert/array-intersection)

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/arr-diff/issues/new).

## Building docs

Generate readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install verb && npm run docs
```

Or, if [verb](https://github.com/verbose/verb) is installed globally:

```sh
$ verb
```

## Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/arr-diff/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on May 07, 2016._