#!/usr/bin/ruby -w
# See the LICENSE file for copyright and distribution information

require "mkmf"

def help
  print <<HELP
"extconf.rb" configures this package to adapt to many kinds of systems.

Usage: ruby extconf.rb [OPTION]...

Configuration:
  --help                   display this help and exit
  
  --with-xslt-lib=PATH
  --with-xslt-include=PATH
  --with-xslt-dir=PATH     specify the directory name for the libxslt include 
                           files and/or library 
  
  --enable-error-handler   enables a VERY crude error handler. Error messages 
                           are appended to the class variable XML::XSLT and can
                           be accessed with the class method XML::XSLT.errors 
                           (will change in a future version)
  --disable-exslt          disables libexslt support <http://exslt.org/>
  
  --enable-debug           compile with memwatch 
                           <http://www.linkdata.se/sourcecode.html>

HELP
end

if ARGV.include?( "--help" )
  help()
  exit 0
end

if enable_config("debug", false)
  File.symlink( "debug/memwatch.h", "memwatch.h" ) if( ! File.exist?("memwatch.h") )
  File.symlink( "debug/memwatch.c", "memwatch.c" ) if( ! File.exist?("memwatch.c") )
  $CFLAGS += " -DMEMWATCH -D__DEBUG__"
end

if enable_config("error-handler", false)
  $CFLAGS += " -DUSE_ERROR_HANDLER"
end

$LIBPATH.push(Config::CONFIG['libdir'])

def crash(str)
  printf(" extconf failure: %s\n", str)
  exit 1
end

#unless have_library("z", "inflate")
#  crash("need zlib")
#else
#  $defs.push('-DHAVE_ZLIB_H')
#end

if dir_config( "xslt" ) != [nil, nil]
   inc, lib = dir_config( 'xslt' ) 
   $LDFLAGS << " -L#{lib} -lxslt -lxml2 -lz -lpthread -liconv -lm"
   $CFLAGS << " -I#{inc}"
elsif ex = find_executable( "xslt-config" )
   $LDFLAGS << ' ' + `#{ex} --libs`.chomp
   $CFLAGS << ' ' + `#{ex} --cflags`.chomp
else
  crash(<<EOL)
need libxslt.

        Install the library or try one of the following options to extconf.rb:

        --with-xslt-lib=/path/to/libxslt/lib
        --with-xslt-include=/path/to/libxslt/include
EOL
end

if enable_config("exslt", true)
  $LDFLAGS << " -lexslt"
  $CFLAGS += " -DUSE_EXSLT"
end

$CFLAGS = '-g -Wall ' + $CFLAGS

puts "compile with : "
puts "  CFLAGS = #{$CFLAGS}"
puts "  LDFLAGS = #{$LDFLAGS}"
puts

create_header()
create_makefile("xml/xslt")

######  Modify Makefile: #######
File.rename( "Makefile", "Makefile.orig" )
oldmkfl = File.open( "Makefile.orig" )
newmkfl = File.open( "Makefile", "w" )
oldmkfl.each_line{ |line|
   case(line)
   when /^all:/
      newmkfl.puts(line)
      newmkfl.puts("")        
      newmkfl.puts("test: all")            # insert the "test" target
      newmkfl.puts("\t\t@cd tests && ruby test.rb && cd ..")
      newmkfl.puts("doc: all")            # insert the "doc" target
      newmkfl.puts("\t\t@rdoc -S -t \"Ruby/XSLT Documentation\" README AUTHORS ChangeLog xslt.c")
   when /^distclean:/
      newmkfl.puts(line)
      newmkfl.puts("\t\t@-$(RM) memwatch.h memwatch.c Makefile.orig")
      newmkfl.puts("\t\t@-$(RM)r doc")
   else
      newmkfl.puts(line)
   end
}
newmkfl.close