<?xml version="1.0"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:src="http://xml.apache.org/xindice/Query"
	xmlns:ex="http://test.none"
	xsl:version="1.0">
<xsl:output
  encoding="UTF-8"
  indent="yes"
	/>

<xsl:variable name="number" select="1"/>
<xsl:variable name="string" select="'comment appelle-tu ça?'"/>
<xsl:variable name="bool" select="true()"/>
<xsl:variable name="nodes" select="nodes"/>

<xsl:template match="/">
  <table>
    <tr><th>value-of</th><th>ex:type()</th><th>ex:round-trip()</th></tr>
    <tr>
      <td><xsl:value-of select="$nodes"/></td>
      <td><xsl:value-of select="ex:type($nodes)"/></td>
      <td><xsl:apply-templates select="ex:round-trip($nodes)"/></td>
    </tr>
    <xsl:call-template name="row">
      <xsl:with-param name="value" select="$number"/>
    </xsl:call-template>
    <xsl:call-template name="row">
      <xsl:with-param name="value" select="$string"/>
    </xsl:call-template>
    <xsl:call-template name="row">
      <xsl:with-param name="value" select="$bool"/>
    </xsl:call-template>
  </table>
</xsl:template>

<xsl:template name="row">
  <xsl:param name="value"/>
  <tr>
    <td><xsl:value-of select="$value"/></td>
    <td><xsl:value-of select="ex:type($value)"/></td>
    <td><xsl:value-of select="ex:round-trip($value)"/></td>
  </tr>
</xsl:template>

<xsl:template match="node">
	<xsl:value-of select="."/>(<xsl:value-of select="@number"/>)&#10;
</xsl:template>

</xsl:stylesheet>
