=begin

= fileutils.rb

  Copyright (c) 2000,2001 Minero Aoki <aamine@loveruby.net>

  This program is free software.
  You can distribute/modify this program under the same terms of ruby.

== module FileUtils

The module which implements basic file operations.

=== Module Functions

--- FileUtils#cd( dir, *options )
--- FileUtils#cd( dir, *options ) {|dir| .... }
  Options = noop verbose

  changes current directory to DIR.

  If this method is called with block, moves to the old current
  directory after the block execution finished.

    FileUtils.cd '/', :verbose   # chdir and report it

--- FileUtils#uptodate?( newer, older_list, *options )
  Options = verbose

  returns true if NEWER is newer than all OLDERs.
  Non-exist files are older than any file.

    FileUtils.newest? 'hello.o', 'hello.c', 'hello.h' or system 'make'

--- FileUtils#mkdir( dirs, *options )
  Options = noop verbose

  makes directorie(s) DIRS.

    FileUtils.mkdir 'test'
    FileUtils.mkdir %w( tmp data )
    FileUtils.mkdir notexist', :noop  # does not create really

--- FileUtils#mkdir_p( dirs, ..., *options )
  Options = noop verbose

  makes dirctories DIRs and all its parent directories.
  For example,

    FileUtils.mkdir_p '/usr/local/bin/ruby'
  
  causes to make directories below (if it does not exist).
      * /usr
      * /usr/local
      * /usr/local/bin
      * /usr/local/bin/ruby

--- FileUtils#rmdir( dirs, *options )
  Options = noop, verbose

  removes directories DIRS.

--- FileUtils#ln( old, new, *options )
  Options = noop verbose

  makes hard link NEW which links to OLD.
  If NEW is a directory, creates link NEW/OLD.

    FileUtils.ln :verbose, 'gcc', 'cc'

--- FileUtils#ln( list, dir, *options )
  Options = noop verbose

  links DIR/OLD1 to OLD1, DIR/OLD2 to OLD2, ....

    FileUtils.ln 'cp', 'mv', 'mkdir', '/usr/bin'
    FileUtils.ln %w( cp mv mkdir ), '/usr/bin'    # same result

--- FileUtils#ln_s( new, old, *options )
  Options = force noop verbose

  makes symbolic link NEW which links to OLD.
  If last argument is a directory, links DIR/OLD1 to OLD1,
  DIR/OLD2 to OLD2, ....

    FileUtils.ln_s '/usr/bin/ruby', '/usr/local/bin/ruby'
    FileUtils.ln_s 'verylongsourcefilename.c', 'c', :force

--- FileUtils#ln_s( list, destdir, *options )
  Options = force noop verbose

  makes symbolic link dir/file1, dir/file2 ... which point to
  file1, file2 ... If DIR is not a directory, raises Errno::ENOTDIR.
  This method removes target file when :force option is set.

   FileUtils.ln_s Dir.glob('bin/*.rb'), '/home/aamine/bin'

--- FileUtils#ln_sf( src, dest, *options )
  Options = noop verbose

  same to ln_s(src,dest,:force)

--- FileUtils#cp( src, dest, *options )
  Options = preserve noop verbose

  copies a file SRC to DEST. If DEST is a directory, copies
  SRC to DEST/SRC.

    FileUtils.cp 'eval.c', 'eval.c.org'

--- FileUtils#cp( list, dir, *options )
  Options = preserve noop verbose

  copies FILE1 to DIR/FILE1, FILE2 to DIR/FILE2 ...

    FileUtils.cp 'cgi.rb', 'complex.rb', 'date.rb', '/usr/lib/ruby/1.6'
    FileUtils.cp :verbose, %w(cgi.rb complex.rb date.rb), '/usr/lib/ruby/1.6'

--- FileUtils#cp_r( src, dest, *options )
  Options = preserve noop verbose

  copies SRC to DEST. If SRC is a directory, this method copies
  its all contents recursively. If DEST is a directory, copies
  SRC to DEST/SRC.

    # installing ruby library "mylib" under the site_ruby
    FileUtils.rm_r site_ruby + '/mylib', :force
    FileUtils.cp_r 'lib/', site_ruby + '/mylib'

--- FileUtils#cp_r( list, dir, *options )
  Options = preserve noop verbose

  copies file/directory FILE1 to DIR/FILE1, FILE2 to DIR/FILE2 ...
  If FILE is a directory, copies its all contents recursively.

    FileUtils.cp_r 'mail.rb', 'field.rb', 'debug/', site_ruby + '/tmail'
    FileUtils.cp_r :noop, :verbose, Dir.glob('*.rb'), '/home/aamine/lib/ruby'

--- FileUtils#mv( src, dest, *options )
  Options = noop verbose

  moves a file SRC to DEST.
  If FILE and DEST exist on the different disk partition,
  copies it.

    FileUtils.mv 'badname.rb', 'goodname.rb'
    FileUtils.mv 'stuff.rb', 'lib/ruby', :force

--- FileUtils#mv( list, dir, *options )
  Options = noop verbose

  moves FILE1 to DIR/FILE1, FILE2 to DIR/FILE2 ...
  If FILE and DEST exist on the different disk partition,
  copies it.

    FileUtils.mv 'junk.txt', 'dust.txt', '/home/aamine/.trash/'
    FileUtils.mv Dir.glob('test*.rb'), 'T', :noop, :verbose

--- FileUtils#rm( list, *options )
  Options = force noop verbose

  remove FILEs. This method cannot remove directory.
  This method ignores all errors when :force option
  is set.

    FileUtils.rm %w( junk.txt dust.txt )
    FileUtils.rm Dir['*.so']
    FileUtils.rm 'NotExistFile', :force    # never raises exception

--- FileUtils#rm_r( list, *options )
  Options = force noop verbose

  remove FILEs. If FILE is a directory, removes its all contents
  recursively. This method ignores all errors when :force option
  is set.

    FileUtils.rm_r Dir.glob('/tmp/*')
    FileUtils.rm_r '/', :force          #  :-)

--- FileUtils#rm_rf( list, *options )
  Options = noop verbose

  same to rm_r(list,:force)

--- FileUtils#cmp( a, b, *options )
  Options = verbose

  returns true if contents of file A and B is identical.

    FileUtils.cmp 'somefile', 'somefile'  #=> true
    FileUtils.cmp '/bin/cp', '/bin/mv'    #=> maybe false.

--- FileUtils#install( src, dest, mode = <src's>, *options )
  Options = noop verbose

  If SRC is not same to DEST, copies it and changes the permittion
  mode to MODE.

    FileUtils.install 'ruby', '/usr/local/bin/ruby', 0755, :verbose
    FileUtils.install 'lib.rb', '/usr/local/lib/ruby/site_ruby', :verbose

--- FileUtils#chmod( mode, list, *options )
  Options = noop verbose

  changes permittion bits on the named FILEs to the bit pattern
  represented by MODE.

    FileUtils.chmod 0644, 'my.rb', 'your.rb'
    FileUtils.chmod 0755, 'somecommand'
    FileUtils.chmod 0755, '/usr/bin/ruby', :verbose

--- FileUtils#touch( list, *options )
  Options = noop verbose

  updates modification time of file1, file2, ...
  If fileN does not exist, creates it.

    FileUtils.touch 'main.c'; system 'make'

== module FileUtils::Verbose

This class has all methods of FileUtils module and it works as
same, but outputs messages before action. You can also pass
verbose flag to all methods.

== module FileUtils::NoWrite

This class has all methods of FileUtils module,
but never changes files/directories.

=end
