/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_SESSION_INTERNALS_H_
#define _SML_SESSION_INTERNALS_H_

#include "sml_queue_internals.h"

struct SmlSession {
	gint refCount;
	SmlProtocolVersion version;
	SmlProtocolType protocol;
	SmlSessionType sessionType;
	SmlAssembler *assembler;
	SmlBool onlyReplace;
	
	SmlSessionEventCallback eventCallback;
	void *eventCallbackUserdata;
	
	SmlSessionDataCallback dataCallback;
	void *dataCallbackUserdata;
	
	char *sessionID;
	
	SmlLocation *target;
	SmlLocation *source;
	SmlCred *cred;
	
	unsigned int incomingMaxMsgSize;
	/** This is the maximum object size we want to receive from the other side.
	 * This value will be transmitted in the <MaxObjSize> tag */
	unsigned int receivingMaxObjSize;
	
	GList *pendingReplies;
	
	unsigned long lastMessageID;
	unsigned long lastReceivedMessageID;
	unsigned long lastCommandID;
	
	GList *commands;
	SmlBool final;
	
	SmlMimeType type;
	
	SmlQueue *command_queue;
	SmlBool waiting;
	SmlBool sending;
	GList *commandStack;
	SmlBool hasCommand;
	
	SmlBool end;
	SmlBool want_end;
	
	SmlCommand *parentCommand;
	
	/* The buffer that holds the incoming item for
	 * large objects */
	SmlItem *incomingBuffer;
	
	/* The outgoing command that gets fragmented */
	SmlCommand *frag_command;
	/* How much of the item of the frag_command already
	 * got sent */
	unsigned int frag_size;
	SmlStatusReplyCb frag_callback;
	void *frag_userdata;
	
	SmlBool active;
	GMutex *dispatch_mutex;
};

struct SmlPendingStatus {
	unsigned int cmdID;
	unsigned int msgID;
	SmlStatusReplyCb callback;
	void *userdata;
};

#endif //_SML_SESSION_INTERNALS_H_
