/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/
package com.sap.dbtech.jdbcext.translators;
import java.sql.PreparedStatement;

public class ObjectTranslator extends RowSetTranslator{
  protected Object value;
  protected int targetSqlType;
  protected int scale;
  boolean scaleWasSet = false;
  boolean targetWasSet = false;
  
  public ObjectTranslator(int parameterIndex, Object x, int targetSqlType, int scale) {
    this.index = parameterIndex;
    this.value = x;
    this.targetSqlType = targetSqlType;
    this.scale  = scale;
    scaleWasSet = true;
    targetWasSet= true;
  }
  public ObjectTranslator(int parameterIndex, Object x, int targetSqlType) {
    this.index = parameterIndex;
    this.value = x;
    this.targetSqlType = targetSqlType;
    targetWasSet= true;
  }
  public ObjectTranslator(int parameterIndex, Object x) {
    this.index = parameterIndex;
    this.value = x;
  }
  public void setValue(PreparedStatement parm1) throws java.sql.SQLException {
    if (targetWasSet){
      if (scaleWasSet)
        parm1.setObject(this.index, this.value, this.targetSqlType, this.scale);
      else 
        parm1.setObject(this.index, this.value, this.targetSqlType);  
    }
    else 
      parm1.setObject(this.index, this.value);  
  }
}