/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: DefaultMenuFactory.java,v 1.4 2004/12/12 05:29:21 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;

/**
 * Provides a default implementation of {@link MenuFactory} that creates standard
 * swing menus.
 */
public class
DefaultMenuFactory
implements MenuFactory
{
   /**
    * Creates a new {@link JCheckBoxMenuItem}.
    * @return a new {@link JCheckBoxMenuItem}.
    */
   public JCheckBoxMenuItem createCheckBoxMenuItem()
   {
      return new JCheckBoxMenuItem();
   }

   /**
    * Creates a new {@link JMenu}.
    * @return a new {@link JMenu}.
    */
   public JMenu createMenu()
   {
      return new JMenu();
   }

   /**
    * Creates a new {@link JMenuItem}.
    * @return a new {@link JMenuItem}.
    */
   public JMenuItem createMenuItem()
   {
      return new JMenuItem();
   }

   /**
    * Creates a new {@link JPopupMenu}.
    * @return a new {@link JPopupMenu}.
    */
   public JPopupMenu createPopupMenu()
   {
      return new JPopupMenu();
   }

   /**
    * Creates a new {@link JRadioButtonMenuItem}.
    * @return a new {@link JRadioButtonMenuItem}.
    */
   public JRadioButtonMenuItem createRadioButtonMenuItem()
   {
      return new JRadioButtonMenuItem();
   }

   /**
    * Creates a new {@link JMenuBar}.
    * @return a new {@link JMenuBar}.
    */
   public JMenuBar createMenuBar()
   {
      return new JMenuBar();
   }
}
