%define iter( cl )
%extend cl {
    %pythoncode %{
    def __iter__(self):
        r = self.range()
        while not r.empty():
            yield r.head()
            r.removeFirst()
    %}
};
%enddef

%define range( T )
%extend wibble::Range< T > {
    %pythoncode %{
        def __iter__(self):
            i = self.begin();
            while not i == r.end():
                yield i.current()
                i = i.next()
    %}
};
%enddef

%define wrap_set( T )
%extend std::set< T > {
    %pythoncode %{
        def __iter__(self):
            i = self.begin();
            while not i == self.end():
                yield i.value()
                i.next()
    %}
};
%enddef
