#include <ept/tests/test-utils.h>
#include <ept/cache/cache.h>
#include <ept/manager.h>

namespace tut {

using namespace ept;
using namespace configuration::apt;
using namespace cache;

struct cache_apt_state_shar : common {};

TESTGRP( cache_apt_state );

template<> template<>
void to::test< 1 >() {
    cache::Package p = apt.index().packageByName("hello");
    ensure( !p.isInstalled() );
    p.editor( apt ).markInstall();
    ensure( p.markedInstall() );
    Manager m( apt );
    m.setProgressCallback( new ProgressCallback() );
    m.download();
    m.commit();
    ensure( p.isInstalled() );
}

}

#include <ept/cache/apt/state.tcc>
#include <ept/cache/apt/packages.tcc>
#include <ept/manager.tcc>
