/** -*- C++ -*-
    @file predicate/predicate.cpp
    @author Peter Rockai <me@mornfall.net>
*/

#include <ept/tests/test-utils.h>
#include <ept/predicate/predicate.h>

#include <wibble/range.h>
#include <list>

#include <ept/cache/package.h>
#include <ept/cache/entity.h>
#include <ept/cache/apt/packages.h>

#include <ept/predicate/combinators.h>
#include <ept/predicate/factory.h>

namespace tut {

using namespace wibble;
using namespace ept;
using namespace configuration::apt;

struct predicate_shar : common {};

TESTGRP( predicate );

template<> template<>
void to::test<1>()
{
    Range< cache::Entity > r = upcastRange< cache::Entity >( apt.index().range() );
    cache::Package p;
    Range< cache::Entity > fr = filteredRange(
        r, predicate::adapt< cache::Entity >( match::Package::shortDescription( "exim4" )
                                              and match::Package::shortDescription( "exim4" ) ) );
    std::vector< cache::Entity > vec;
    wibble::Range< cache::Entity > r2 = range( vec );
    fr.output( consumer( vec ) );
    while ( !r2.empty() ) {
        p = downcast< cache::Package >( r2.head() );
        ensure_equals( p.name(), "exim4-config" );
        r2 = r2.tail();
    }
}

#if 0
template<> template<>
void to::test<2>()
{
    predicate::ArgumentList l;
    l.push_back( predicate::Argument( "exim4" ) );
    predicate::Predicate< cache::Package<> > pred = predicate::map(
        predicate::predicate(
            (predicate::predicate(
                predicate::Package::shortDescription( "" ) )
             or predicate::predicate(
                 predicate::Package::name( "" ) ) ) ), l );
    wibble::Range< cache::Package<> > fr = filteredRange(
        range( c.begin(), c.end() ), pred );
    while ( !fr.empty() ) {
        cache::Package<> p = fr.head();
        // std::cerr << p.name( "" ) << std::endl;
        ensure( p.name( std::string() ).find( "exim" ) != std::string::npos
                || p.shortDescription( std::string() ).find( "exim" ) != std::string::npos );
        fr = fr.tail();
    }
}
#endif

template<> template<>
void to::test<3> ()
{
    // FIXME: I put it here just so that it's compiled
    //tagexprMatch< entity::Package >( "" );
    /*
    std::list<cache::entity::Package> v;
    std::list<cache::entity::Package>::iterator i;
    c.packages().packages( back_inserter( v ) );
    v.erase( remove_if(
                 v.begin(), v.end(),
                 not tagexprMatch< entity::Package >( "" ) ),
             v.end() );
    ensure( v.empty() );
    */
}

template<> template<>
void to::test<4>()
{
    predicate::match::Substring x( "a" ), y( "b" );
    predicate::Predicate< cache::Package > p, q, r, s;
    p = match::Package::name( "bla" );
    q = match::Package::name( "bla" );
    r = match::Package::name( "glah" );
    s = match::Package::shortDescription( "glah" );
    ensure( !(x == y) );
    ensure( x != y );
    ensure( !(p == s) );
    ensure( !(r == s) );
    ensure( p != s );
    ensure( r != s );
    ensure( p == q );
    ensure( q == p );
    ensure( !(p == r) );
    ensure( p != r );
    ensure( q != r );
    ensure( r != q );
    ensure( p == p );
}

template<> template<>
void to::test<5>()
{
    predicate::Predicate< cache::Package > p, q, r, s;
    p = match::Package::name( "a" );
    q = match::Package::name( "b" );
    r = p or q;
    s = p and q;
    ensure( remove( r, p ) == q );
    ensure( remove( r, q ) == p );
    ensure( remove( s, p ) == q );
    ensure( remove( s, q ) == p );
    s = r and s;
    ensure( remove( s, p ) == (q and q) );
}

template<> template<>
void to::test<6>()
{
    predicate::Predicate< cache::Entity > a;
    predicate::Predicate< cache::Package > b;
    a = predicate::adapt< cache::Entity >( b );
}

}

#include <ept/cache/apt/packages.tcc>
