mod_auth_gssapi
===============

Intro
-----

This module has been built as a replacement for the aging mod_auth_kerb.
Its aim is to use only GSSAPI calls and be as much as possible agnostic
of the actual mechanism used.

Dependencies
------------

A modern version of MIT's Krb5 distribution or any GSSAPI implementation
that supports the [credential store
extension](http://k5wiki.kerberos.org/wiki/Projects/Credential_Store_extensions)
is necessary to achieve full functionality. Reduced functionality is
provided without these extensions.

    krb5 (>=1.11)
    Apache (>=2.4)

### Tests

To run tests, you also need:

* The Kerberos 5 Key-Distribution-Center (`krb5-kdc` package on Debian,
  `krb5-server` on Fedora)
* Packages `mod_session`, `krb5-workstation`, `python-requests-kerberos`,
  and `python-gssapi` on Fedora
* [nss_wrapper](https://cwrap.org/nss_wrapper.html), packaged in Fedora
* [socket_wrapper](https://cwrap.org/socket_wrapper.html), packaged in Fedora

Installation
------------

    autoreconf -fi
    ./configure
    make
    make install


Configuration
-------------

Apache authentication modules are usually configured per location, see the
[mod_authn_core](https://httpd.apache.org/docs/2.4/mod/mod_authn_core.html)
documentation for the common directives

### Basic configuration

The simplest configuration scheme specifies just one directive, which is the
location of the keytab.

#### Example
    <Location /private>
        AuthType GSSAPI
        AuthName "GSSAPI Single Sign On Login"
        GssapiCredStore keytab:/etc/httpd.keytab
        Require valid-user
    </Location>

Your Apache server need read access to the keytab configured.
If your Kerberos implementation does not support the credential store
extensions you can also simply set the KRB5_KTNAME environment variable in the
Apache init script and skip the GssapiCredStore option completely.


Configuration Directives
------------------------

### GssapiSSLonly

Forces the authentication attempt to fail if the connection is not being
established over TLS

#### Example
    GssapiSSLonly On


### GssapiLocalName

Tries to map the client principal to a local name using the gss_localname()
call. This requires configuration in the /etc/krb5.conf file in order to allow
proper mapping for principals not in the default realm (for example a user
coming from a trusted realm).
See the 'auth_to_local' option in the [realms] section of krb5.conf(5)

When this options is used the resolved name is set in the REMOTE_USER variable
however the complete client principal name is also made available in the
GSS_NAME variable.

#### Example
    GssapiLocalName on


### GssapiConnectionBound

When using GSS mechanisms that require more than one round-trip to complete
authentication (like NTLMSSP) it is necessary to bind to the authentication to
the connection in order to keep the state between round-trips. With this option
enable incomplete context are store in the connection and retrieved on the next
request for continuation.

#### Example
    GssapiConnectionBound On


### GssapiSignalPersistentAuth
For clients that make use of Persistent-Auth header, send the header according
to GssapiConnectionBound setting.

#### Example
    GssapiSignalPersistentAuth On


### GssapiUseSessions

In order to avoid constant and costly re-authentication attempts for every
request, mod_auth_gssapi offers a cookie based session method to maintain
authentication across multiple requests. GSSAPI uses the mod_sessions module
to handle cookies so that module needs to be activated and configured.
GSSAPI uses a secured (encrypted + MAC-ed) payload to maintain state in the
session cookie. The session cookie lifetime depends on the lifetime of the
GSSAPI session established at authentication.
**NOTE**: It is important to correctly set the SessionCookieName option.
See the
[mod_sessions](http://httpd.apache.org/docs/current/mod/mod_session.html)
documentation for more information.

#### Example
    GssapiUseSessions On
    Session On
    SessionCookieName gssapi_session path=/private;httponly;secure;


### GssapiSessionKey

When GssapiUseSessions is enabled a key use to encrypt and MAC the session
data will be automatically generated at startup, this means session data will
become unreadable if the server is restarted or multiple servers are used and
the client is load balanced from one to another. To obviate this problem the
admin can choose to install a permanent key in the configuration so that
session data remain accessible after a restart or by multiple servers
sharing the same key.

The key must be a base64 encoded raw key of 32 bytes of length.

#### Example
    GssapiSessionKey key:VGhpcyBpcyBhIDMyIGJ5dGUgbG9uZyBzZWNyZXQhISE=


### GssapiCredStore

The GssapiCredStore option allows to specify multiple credential related
options like keytab location, client_keytab location, ccache location etc.

#### Example
    GssapiCredStore keytab:/etc/httpd.keytab
    GssapiCredStore ccache:FILE:/var/run/httpd/krb5ccache


### GssapiDelegCcacheDir

If delegation of credentials is desired credentials can be exported in a
private directory accessible by the Apache process.
The delegated credentials will be stored in a file named after the client
principal and the subprocess environment variable KRB5CCNAME will be set
to point to that file.

#### Example
    GssapiDelegCcacheDir /var/run/httpd/clientcaches

A user foo@EXAMPLE.COM delegating its credentials would cause the server to
create a ccache file named /var/run/httpd/clientcaches/foo@EXAMPLE.COM


### GssapiDelegCcacheUnique

Enables using unique ccache names for delegation.  ccache files will be placed
in GssapiDelegCcacheDir and named using the principal and a six-digit unique
suffix.

**Note:** Consuming application must delete the ccache otherwise it will
litter the filesystem if sessions are used.  An example sweeper can be found
in the contrib directory.

#### Example
    GssapiDelegCcacheUnique On

### GssapiUseS4U2Proxy

Enables the use of the s4u2Proxy Kerberos extension also known as
[constrained delegation](https://ssimo.org/blog/id_011.html)
This option allows an application running within Apache to operate on
behalf of the user against other servers by using the provided ticket
(subject to KDC authorization).
This options requires GssapiDelegCcacheDir to be set. The ccache will be
populated with the user's provided ticket which is later used as evidence
ticket by the application.

**Note:** This flag has no effect when Basic-Auth is used since user's
credentials are delegated anyway when GssapiDelegCcacheDir is set.

#### Example
    GssapiUseS4U2Proxy On
    GssapiCredStore keytab:/etc/httpd.keytab
    GssapiCredStore client_keytab:/etc/httpd.keytab
    GssapiCredStore ccache:FILE:/var/run/httpd/krb5ccache
    GssapiDelegCcacheDir /var/run/httpd/clientcaches

**NOTE:** The client keytab is necessary to allow GSSAPI to initiate via keytab
on its own. If not present an external mechanism needs to kinit with the
keytab and store a ccache in the configured ccache file.


### GssapiBasicAuth
Allows the use of Basic Auth in conjunction with Negotiate.
If the browser fails to use Negotiate it will instead fallback to Basic and
the username and password will be used to try to acquire credentials in the
module via GSSAPI. If credentials are acquired successfully then they are
validated against the server's keytab.

- **Enable with:** GssapiBasicAuth On
- **Default:** GssapiBasicAuth Off

#### Example
    <Location /gssapi>
      AuthType GSSAPI
      AuthName "Login"
      GssapiBasicAuth On
      GssapiCredStore keytab:/etc/httpd/http.keytab
      Require valid-user
    </Location>


### GssapiAllowedMech

List of allowed mechanisms. This is useful to restrict the mechanism that
can be used when credentials for multiple mechanisms are available.
By default no mechanism is set, this means all locally available mechanisms
are allowed.  The recognized mechanism names are: krb5, iakerb, ntlmssp

#### Example
    GssapiAllowedMech krb5
    GssapiAllowedMech ntlmssp


### GssapiBasicAuthMech

List of mechanisms against which Basic Auth is attempted. This is useful to
restrict the mechanisms that can be used to attempt password auth.
By default no mechanism is set, this means all locally available mechanisms
are allowed, unless GssapiAllowedMech is set, in which case those are used.
GssapiBasicAuthMech always takes precedence over GssapiAllowedMech.
The recognized mechanism names are: krb5, iakerb, ntlmssp

#### Example
    GssapiBasicAuthMech krb5


### GssapiNameAttributes

Enables the module to source Name Attributes from the client name
(authorization data associated with the established context) and exposes them
as environment variables.

Value format: ENV_VAR_NAME ATTRIBUTE_NAME

This option can be specified multiple times, once for each attribute to expose.
The Special value "json" is used to expose all attributes in a json formatted
string via the special environment variable GSS_NAME_ATTRS_JSON
The environment variable GSS_NAME_ATTR_ERROR is set with the Gssapi returned
error string in case the inquire name function fails to retrieve attributes,
and with the string "0 attributes found", if no attributes are set.

**Note**: These variables are NOT saved in the session data stored in the
cookie so they are available only on the first authenticated request when
GssapiUseSessions is used.

**Note:** It is recommended but not required to use only capital letters and
underscores for environment variable names.

#### Example
    GssapiNameAttributes json
    GssapiNameAttributes RADIUS_NAME urn:ietf:params:gss:radius-attribute_1


### GssapiNegotiateOnce

When this option is enabled the Negotiate header will not be resent if
Negotiation has already been attempted but failed.

Normally when a client fails to use Negotiate authentication, a HTTP 401
response is returned with a WWW-Authenticate: Negotiate header, implying that
the client can retry to use Negotiate with different credentials or a
different mechanism.

Consider enabling GssapiNegotiateOnce when only one single sign on mechanism
is allowed, or when GssapiBasicAuth is enabled.

**NOTE:** if the initial Negotiate attempt fails, some browsers will fallback
to other Negotiate mechanisms, prompting the user for login credentials and
reattempting negotiation. This situation can mislead users - for example if
krb5 authentication failed and no other mechanisms are allowed, a user could
be prompted for login information even though any login information provided
cannot succeed. When this occurs, some browsers will not fall back to a Basic
Auth mechanism. Enable GssapiNegotiateOnce to avoid this situation.

- **Enable with:** GssapiNegotiateOnce On
- **Default:** GssapiNegotiateOnce Off

### GssapiImpersonate

This option can be used even if AuthType GSSAPI is not used for given
Location or LocationMatch, to obtain service ticket for a user that was
already authenticated by different module.

The principal of the user is retrieved from the internal r->user
identifier which typically holds the username from the authentication
results.

Make sure the server principal is set to allow to acquire forwardable
tickets to itself from arbitrary users, for use with constrained
delegation, for example with the option +ok_to_auth_as_delegate.

- **Enable with:** GssapiImpersonate On
- **Default:** GssapiImpersonate Off
