//LabPlot : Dialog.h

#ifndef DIALOG_H
#define DIALOG_H

#include <kdialog.h>
#include <qvbox.h>
#include <kpushbutton.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qtabwidget.h>
#include <qvalidator.h>
#include <klineedit.h>
#include <klistbox.h>
#include <kcolorbutton.h>
#include <kcombobox.h>
#include <knuminput.h>
#include "Worksheet.h"

#include "inputfilter.h"
#include "binarytype.h"

#ifdef HAVE_GL
#include "qwt3d_surfaceplot.h"
#endif

class Dialog: public KDialog
{
	Q_OBJECT
public:
	Dialog(class MainWin *mw, const char *name);
	QVBox* surfaceStyle(QTabWidget *tw, bool fresh);
	QVBox* simpleStyle(QTabWidget *tw, Style *style, Symbol *symbol);
	QVBox* errorbarTab(QTabWidget *tw, Symbol *symbol);
	void saveSimpleStyle();
	void saveSurfaceStyle();
	void saveErrorbarSettings();
public slots:
	void setDestination(int v) {sheetcb->setCurrentItem(v); }		//!< set current destination for new functions
	void setFilename(QString v) { filele->setText(v); }			//!< set filename for import widget
	void setFilter(int v) { filtercb->setCurrentItem(v); }			//!< set filter for importing
	void setSimplify(bool b=true) { simplifycb->setChecked(b); }		//!< set simplify whitespaces
	void setEmpty(bool b=true) { emptycb->setChecked(b); }			//!< allow empty entries in data file
	void setImportHeader(bool b=true) { headercb->setChecked(b); }		//!< import header from data file
	void setSameXColumn(bool b=true) { samexcb->setChecked(b); }		//!< import x column from first file only
	void setSeparator(int v) { sccb->setCurrentItem(v); }			//!< set separating character
	void setSeparator(QChar v) { sccb->setCurrentText(v); }			//!< set separating character
	void setComment(int v) { commcb->setCurrentItem(v); }			//!< set comment character
	void setComment(QChar v) { commcb->setCurrentText(v); }			//!< set comment character
	void setDataRange(int v, int e) { startle->setText(QString::number(v)); endle->setText(QString::number(e)); }
										//!< set range for importing data
	void setStart(int v) {startle->setText(QString::number(v));}
	void setEnd(int v) {endle->setText(QString::number(v));}

	// binary data
	void setVars(int v) { varle->setText(QString::number(v)); }		//!< number of vars for binary data
	void setBinaryType(int t) { binarytypecb->setCurrentItem(t); }		//!< set type for binary data
	void setByteOrder(int b) { byteordercb->setCurrentItem(b); }		//!< set byte order of binary data

	void setStyle(Style *s);						//!< set Style
	void setSymbol(Symbol *s);						//!< set Symbol
protected:
	void resizeEvent(QResizeEvent *e);
	QVBox* annotateValuesTab(QTabWidget *tw, Graph *graph);
       	void importWidget(QVBox *vb,QString filename, InputFilter filter);
	void saveImportSettings();
	double getBinaryValue(QDataStream *d, BinaryType type);
	bool openColorMap(QString fn);
	void fillBrushBox(KComboBox *cb,SType t, QColor c,FType f, QColor s);
	QGroupBox *vbox, *gbox;
	class MainWin *mw;
	class Worksheet *p;
	class Spreadsheet *s;
#ifdef HAVE_GL
	Qwt3D::ColorVector cv;
#endif
	KPushButton *ok, *apply, *save, *cancel;
	KLineEdit *filele;						// used from various dialogs
	QLabel *fileinfo;
	KComboBox *cb2, *pencb, *brushcb, *sbrushcb;			// simple
	KComboBox *symbolcb, *symbolfillcb;				// simple
	KColorButton *color, *fcolor, *scolor, *sfcolor;		// simple
	QCheckBox *filled, *sortpointscb;				// simple
	KIntNumInput *boxwidth, *width, *ssize;				// simple
	QCheckBox *autobox, *ccb, *dcb, *coloredcb, *meshcb, *relativecb;	// surface
	KLineEdit *numberle, *thresholdle;					// surface
	KComboBox *dbrushcb;							// surface
	KColorButton *contourcolor;						// surface
	KLineEdit *contourwidthle;						// surface
	KComboBox *typecb, *positioncb;						// annotatetab
	KIntNumInput *distance;							// annotatetab
	KColorButton *ebarcolor, *ebarbcolor;					// errorbar
	KIntNumInput *ebarxsize, *ebarysize, *ebarwidth, *ebarbwidth;		// errorbar
	KComboBox *ebarstylecb, *ebarbstylecb, *ebarxtypecb, *ebarytypecb;	// errorbar
	QCheckBox *simplifycb, *emptycb, *headercb, *samexcb;			// importWidget
	QLabel *seplabel, *commlabel, *startlabel, *endlabel;			// importWidget
	KLineEdit *startle, *endle;						// importWidget
	KComboBox *filtercb, *sccb, *commcb;					// importWidget
	QLabel *varlabel, *binarytypelabel, *byteorderlabel;			// importWidget : binary
	KComboBox *binarytypecb, *byteordercb;					// importWidget : binary
	KLineEdit *varle;
	KComboBox *sheetcb;					// for destination selection (list dialogs+function/data dialog)
protected slots:
	void updateFileInfo();
	void selectFile();
	void fileInfo();
	void selectColormap();
	void adaptDataColors(const QString&);
	void updateFilter(int item);
	QStringList splitLine(QString line,QString sep, bool empty);
private:
	void fillSymbolBox(QColor c, FType f, QColor s, int b);
	void fillSymbolFillBox(SType t, QColor c, QColor s, int b);
private slots:
	void styleChanged();
	void symbolChanged();
};

#endif //DIALOG_H
