//LabPlot : AddGraphDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>

#ifdef HAVE_SOLARIS
#include <ieeefp.h>
#endif

#include "AddGraphDialog.h"

AddGraphDialog::AddGraphDialog(MainWin *mw, ListDialog *ld, GraphList *gl, const char *name)
	: Dialog(mw, name), ld(ld), gl(gl)
{
	setCaption(i18n("Add Graph Dialog")+i18n(" : ")+QString(name));

	QWidgetList list = mw->getWorkspace()->windowList();
	newgl = new GraphList();

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("From Worksheets"),hb);
	hb = new QHBox(vbox);
	wslv = new KListView(hb);
	wslv->setSorting(-1);
	wslv->setSelectionMode(QListView::Extended);
	wslv->setAllColumnsShowFocus(true);
	wslv->addColumn(i18n("Worksheet"));
	wslv->addColumn(i18n("Name"));
	wslv->addColumn(i18n("Type"));
	wslv->addColumn(i18n("Shown"));
	wslv->addColumn(i18n("Rows"));
	wslv->addColumn(i18n("Columns"));
	wslv->addColumn(i18n("X Range"));
	wslv->addColumn(i18n("Y Range"));

	QListViewItem *lvi = 0;
	for (unsigned int i=0; i < list.count(); i++) {
		Worksheet *w = (Worksheet *) list.at(i);

		if(w->getWidgetType() == WWORKSHEET) {
			for(unsigned int j=0; j < w->NrPlots(); j++) {
				Plot *plot = w->getPlot(j);
				TESTPTR(plot);
				GraphList *tmpgl = plot->getGraphList();
				kdDebug()<<"	Plot "<<j<<" has "<<tmpgl->Number()<<" graphs"<<endl;
				for(unsigned int k=0; k < tmpgl->Number(); k++) {
//					kdDebug()<<"	GRAPH "<<k<<endl;
					QStringList stringlist;
					stringlist += w->Title();
					switch(gl->getType(k)) {
					case GRAPH2D : {
						Graph2D *g = tmpgl->getGraph2D(k);
						newgl->addGraph2D(g);
						stringlist += g->Info();
						}; break;
					case GRAPH3D : {
						Graph3D *g = tmpgl->getGraph3D(k);
						newgl->addGraph3D(g);
						stringlist += g->Info();
						}; break;
					case GRAPH4D : {
						Graph4D *g = tmpgl->getGraph4D(k);
						newgl->addGraph4D(g);
						stringlist += g->Info();
						}; break;
					case GRAPHM : {
						GraphM *g = tmpgl->getGraphM(k);
						newgl->addGraphM(g);
						stringlist += g->Info();
						}; break;
					case GRAPHIMAGE : {
						GraphIMAGE *g = tmpgl->getGraphIMAGE(k);
						newgl->addGraphIMAGE(g);
						stringlist += g->Info();
						}; break;
					default : break;
					}
					lvi = new QListViewItem(wslv,lvi);
					for (unsigned int j = 0; j < stringlist.count(); j++)
						lvi->setText(j,stringlist[j]);
				}
			}
		}
	}

	hb = new QHBox(vbox);
	new QLabel(i18n("From Spreadsheets"),hb);
	hb = new QHBox(vbox);
	sslv = new KListView(hb);
	sslv->setSorting(-1);
	sslv->setSelectionMode(QListView::Extended);
	sslv->setAllColumnsShowFocus(true);
	sslv->addColumn(i18n("Spreadsheet"));
	sslv->addColumn(i18n("Column"));
	sslv->addColumn(i18n("Type"));
	sslv->addColumn(i18n("Format"));
	ss = (Spreadsheet **) new int[list.count()*255];	// list of spreadsheets
	scol = new int[list.count()*255];				// table of columns

	int nr_col=0;
	lvi = 0;
	for (unsigned int i=0; i < list.count(); i++) {
		Spreadsheet *w = (Spreadsheet *) list.at(i);

		if(w->getWidgetType() == WSPREADSHEET) {
			for(int j=0; j < w->Table()->numCols(); j++) {
				ss[nr_col]=w;
				scol[nr_col++]=j;
				QStringList stringlist;
				stringlist += w->Title();
				stringlist += w->columnInfo(j);
				lvi = new QListViewItem(sslv,lvi);
				for (unsigned int j = 0; j < stringlist.count(); j++)
					lvi->setText(j,stringlist[j]);
			}
		}
	}

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	save->setEnabled(false);

	// gbox>vbox here !
	setMinimumWidth(4*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void AddGraphDialog::apply_clicked() {

	///////////////////////////// add graphs from worksheets ////////////////////////
#if QT_VERSION > 0x030102
	QListViewItemIterator it(wslv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it(wslv);
#endif
	for ( ; it.current(); ++it ) {
#if QT_VERSION <= 0x030102
		if(!it.current()->isSelected())
			continue;
#endif

		int item = (int) (wslv->itemPos(it.current())/it.current()->height());
		kdDebug()<<"	Adding ITEM "<<item<<" to current plot"<<endl;

		// add from newgl to gl
		switch(newgl->getType(item)) {
		case GRAPH2D : {
			Graph2D *graph = newgl->getGraph2D(item)->Clone();
			gl->addGraph2D(graph); 
			}; break;
		case GRAPH3D : {
			Graph3D *graph = newgl->getGraph3D(item)->Clone();
			gl->addGraph3D(graph); 
			}; break;
		case GRAPH4D : {
			Graph4D *graph = newgl->getGraph4D(item)->Clone();
			gl->addGraph4D(graph); 
			}; break;
		case GRAPHM : {
			GraphM *graph = newgl->getGraphM(item)->Clone();
			gl->addGraphM(graph); 
			}; break;
		case GRAPHIMAGE : {
			GraphIMAGE *graph = newgl->getGraphIMAGE(item)->Clone();
			gl->addGraphIMAGE(graph); 
			}; break;
		default : break;
		}
	}

	///////////////// build graph from spreadsheets ////////////////////////////////
#if QT_VERSION > 0x030102
	QListViewItemIterator it2(sslv,QListViewItemIterator::Selected);
#else
	QListViewItemIterator it2(sslv);
#endif
	double *xdata=0;
	int n=0;

	// fill xdata with first graph of current plot
	Worksheet *ws = mw->activeWorksheet();
	if(ws != 0) {
		Plot *plot = ws->getPlot(ws->API());
		TESTPTR(plot);

		GraphList *tmpgl = plot->getGraphList();
		GRAPHType st = tmpgl->getType(0);
		switch(st) {
		case GRAPH2D: {
			Graph2D *g = tmpgl->getGraph2D(0);
			n = g->Number();
			xdata = new double[n];
			for(int i=0;i<n;i++)
				xdata[i]=g->Data()[i].X();
			}; break;
		case GRAPH3D: {
			Graph3D *g = tmpgl->getGraph3D(0);
			n = g->Number();
			xdata = new double[n];
			for(int i=0;i<n;i++)
				xdata[i]=g->Data()[i].X();
			}; break;
		case GRAPH4D: {
			Graph4D *g = tmpgl->getGraph4D(0);
			n = g->Number();
			xdata = new double[n];
			for(int i=0;i<n;i++)
				xdata[i]=g->Data()[i].X();
			}; break;
		default: break;
		}
	}

	// go through selected items
	for ( ; it2.current(); ++it2 ) {
#if QT_VERSION <= 0x030102
		if(!it2.current()->isSelected())
			continue;
#endif

		int item = (int) (sslv->itemPos(it2.current())/it2.current()->height());
		kdDebug()<<"	Selected ITEM "<<item<<endl;

		// search for x,y columns
		QString type = it2.current()->text(2);
		if(type.findRev("[X]") != -1) {
			kdDebug()<<"	FOUND X column of Spreadsheet "<<ss[item]->Title()<<endl;
//			kdDebug()<<"	Column"<<scol[item]<<" of this spreadsheet"<<endl;
			n = ss[item]->Table()->numRows();
			xdata = new double[n];
			for(int i=0; i < n; i++)
				xdata[i] = ss[item]->Table()->text(i,scol[item]).toDouble();
		}
		else if(type.findRev("[Y]") != -1) {
			Point *ptr = new Point[n];
			for(int i = 0; i < n; i++) {
				double x = xdata[i];
				double y = ss[item]->Table()->text(i,scol[item]).toDouble();

				if (!finite(x))	x=0;
				if (!finite(y))	y=0;

				ptr[i].setPoint(x,y);
			}

			double xmin=0, xmax=1, ymin=0, ymax=1;
			mw->calculateRanges2D(ptr,n,&xmin,&xmax,&ymin,&ymax);

			// create the new Graph
			LRange range[2];
			range[0] = LRange(xmin,xmax);
			range[1] = LRange(ymin,ymax);

			QString fun = QString(ss[item]->columnTitle(scol[item])+" ("+ss[item]->Title()+")");
			Style *style = mw->defaultStyle();
			Symbol *symbol = mw->defaultSymbol();
			Graph2D *g = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,n);
			mw->addGraph2D(g,-3);
		}
	}

	delete [] xdata;

	ld->updateList();
	mw->activeWorksheet()->updatePixmap();
}
