//LabPlot : WorksheetDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include <kconfig.h>
#include "WorksheetDialog.h"
#include "defs.h"

//! for general worksheet settings
WorksheetDialog::WorksheetDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	setCaption(i18n("Worksheet Settings")+i18n(" : ")+QString(name));
	KConfig *config = mw->Config();
	config->setGroup( "Worksheet" );

	QHBox *hb = new QHBox(vbox);
	enabletcb = new QCheckBox(i18n("enable worksheet title :"),hb);
	enabletcb->setChecked(config->readBoolEntry("TitleEnabled",true));
	titlele = new KLineEdit(config->readEntry("Title",""),hb);

	hb = new QHBox(vbox);
	new QLabel(i18n("Background Color : "),hb); 
	bgcolor = new KColorButton(config->readColorEntry("Background",&Qt::white),hb);

	hb = new QHBox(vbox);
	enablecb = new QCheckBox(i18n("enable time stamp"),hb);
	enablecb->setChecked(config->readBoolEntry("TimeStampEnabled",true));

	hb = new QHBox(vbox);
	new QLabel(i18n("Time stamp : "),hb); 
	timestample = new KLineEdit(config->readEntry("TimeStamp",""),hb);

	KPushButton *update = new KPushButton( i18n("Update time stamp"), hb );
	QObject::connect(update,SIGNAL(clicked()),SLOT(updateTimeStamp()));

	hb = new QHBox(vbox);
	new QLabel(i18n("Width : "),hb); 
	xni = new KIntNumInput(config->readNumEntry("Width",0),hb);
	xni->setRange(1,INF,1,false);
	new QLabel(i18n("Height : "),hb); 
	yni = new KIntNumInput(config->readNumEntry("Height",0),hb);
	yni->setRange(1,INF,1,false);

	updateDialog();

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void WorksheetDialog::updateDialog() {
	p = mw->activeWorksheet();

	if(p == 0)
		return;

	enabletcb->setChecked(p->TitleEnabled());
	titlele->setText(p->Title());
	bgcolor->setColor(p->Background());
	enablecb->setChecked(p->TimeStampEnabled());
	timestample->setText(p->TimeStamp().toString(Qt::TextDate));
	xni->setValue(p->size().width());
	yni->setValue(p->size().height());
}

void WorksheetDialog::updateTimeStamp() {
#if QT_VERSION > 0x030007
	timestample->setText(QDateTime::currentDateTime(Qt::LocalTime).toString(Qt::TextDate));
#else
	timestample->setText(QDateTime::currentDateTime().toString(Qt::TextDate));
#endif
}

void WorksheetDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Worksheet" );
	config->writeEntry("TitleEnabled",enabletcb->isChecked());
	config->writeEntry("Title",titlele->text());
	config->writeEntry("Background",bgcolor->color());
	config->writeEntry("TimeStampEnabled",enablecb->isChecked());
	config->writeEntry("TimeStamp",timestample->text());
	config->writeEntry("Width",xni->value());
	config->writeEntry("Height",yni->value());
}

int WorksheetDialog::apply_clicked() {
	p->setBackground(bgcolor->color());
	
	p->setTimeStamp(QDateTime::fromString(timestample->text()));
	p->setTimeStampEnabled(enablecb->isChecked());

	p->setTitle(titlele->text());
	p->setCaption(p->Title());
	p->setTitleEnabled(enabletcb->isChecked());

	p->resize(xni->value(),yni->value());

	p->updatePixmap();

	return 0;
}
