#!/bin/bash
# build LabPlot RPM package
# ./build.sh

LVERSION=1.5.1
SPEC=LabPlot.spec

export CFLAGS="-O2"
export CXXFLAGS="-O2"
################################
SRC=LabPlot-"$LVERSION".tar.bz2

if [ ! -f "$SRC" ] ; then
	echo "$SRC not found!"
	exit
fi

if [ ! -f "$SPEC" ] ; then
	echo "$SPEC not found!"
	exit
fi

echo "%_topdir /tmp/build" > ~/.rpmmacros

rm -rf /tmp/build/
mkdir -p /tmp/build/{SOURCES,SPECS,RPMS,SRPMS,BUILD} 

cp $SRC /tmp/build/SOURCES
cp $SPEC /tmp/build/SPECS

cd /tmp/build/SPECS/

rpmbuild -ba $SPEC

